/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.BackendSupport;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.model.loader.model.LazyElement;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.ConditionScope;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.ControlBlock;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Element;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.Import;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.IntersectionType;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.NamedArgumentList;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.SiteVariance;
import com.redhat.ceylon.model.typechecker.model.Specification;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedReference;
import com.redhat.ceylon.model.typechecker.model.UnionType;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.UnknownType;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ModelUtil {
    static final List<Type> NO_TYPE_ARGS = Collections.emptyList();
    static final Map<TypeParameter, Type> EMPTY_TYPE_ARG_MAP = Collections.emptyMap();
    static final Map<TypeParameter, SiteVariance> EMPTY_VARIANCE_MAP = Collections.emptyMap();

    public static boolean contains(Scope outer, Scope inner) {
        if (outer != null) {
            while (inner != null) {
                if (inner.equals(outer)) {
                    return true;
                }
                inner = inner.getScope();
            }
        }
        return false;
    }

    public static Scope getRealScope(Scope scope) {
        while (!(scope instanceof Package)) {
            if (!(scope instanceof ConditionScope)) {
                return scope;
            }
            scope = scope.getContainer();
        }
        return null;
    }

    public static ClassOrInterface getContainingClassOrInterface(Scope scope) {
        while (!(scope instanceof Package)) {
            if (scope instanceof ClassOrInterface) {
                return (ClassOrInterface)scope;
            }
            scope = scope.getContainer();
        }
        return null;
    }

    public static Declaration getContainingDeclaration(Declaration d) {
        if (d.isToplevel()) {
            return null;
        }
        Scope scope = d.getContainer();
        while (!(scope instanceof Package)) {
            if (scope instanceof Declaration) {
                return (Declaration)((Object)scope);
            }
            scope = scope.getContainer();
        }
        return null;
    }

    public static Declaration getContainingDeclarationOfScope(Scope scope) {
        while (!(scope instanceof Package)) {
            if (scope instanceof Declaration) {
                return (Declaration)((Object)scope);
            }
            scope = scope.getContainer();
        }
        return null;
    }

    public static Type getOuterClassOrInterface(Scope scope) {
        Boolean foundInner = false;
        while (!(scope instanceof Package)) {
            if (scope instanceof ClassOrInterface) {
                if (foundInner.booleanValue()) {
                    ClassOrInterface ci = (ClassOrInterface)scope;
                    return ci.getType();
                }
                foundInner = true;
            }
            scope = scope.getContainer();
        }
        return null;
    }

    public static Type appliedType(TypeDeclaration declaration, Type typeArgument) {
        if (declaration == null) {
            return null;
        }
        return declaration.appliedType(null, Collections.singletonList(typeArgument));
    }

    public static Type appliedType(TypeDeclaration declaration, Type ... typeArguments) {
        if (declaration == null) {
            return null;
        }
        return declaration.appliedType(null, Arrays.asList(typeArguments));
    }

    public static boolean isResolvable(Declaration declaration) {
        return declaration.getName() != null && !declaration.isSetter() && !declaration.isAnonymous();
    }

    public static boolean isAbstraction(Declaration d) {
        return d != null && d.isAbstraction();
    }

    public static boolean notOverloaded(Declaration d) {
        if (d == null || !d.isFunctional()) {
            return true;
        }
        return !d.isOverloaded() || d.isAbstraction();
    }

    public static boolean isOverloadedVersion(Declaration decl) {
        return decl != null && decl.isOverloaded() && !decl.isAbstraction();
    }

    static boolean hasMatchingSignature(Declaration dec, List<Type> signature, boolean variadic) {
        return ModelUtil.hasMatchingSignature(dec, signature, variadic, true);
    }

    static boolean hasMatchingSignature(Declaration dec, List<Type> signature, boolean variadic, boolean excludeAbstractClasses) {
        if (excludeAbstractClasses && dec instanceof Class && ((Class)dec).isAbstract()) {
            return false;
        }
        if (dec instanceof Functional) {
            if (dec.isAbstraction()) {
                return false;
            }
            Functional f = (Functional)((Object)dec);
            Unit unit = dec.getUnit();
            List<ParameterList> pls = f.getParameterLists();
            if (pls != null && !pls.isEmpty()) {
                ParameterList pl = pls.get(0);
                List<Parameter> params = pl.getParameters();
                int size = params.size();
                boolean hasSeqParam = pl.hasSequencedParameter();
                int sigSize = signature.size();
                if (hasSeqParam ? sigSize < --size : sigSize != size) {
                    return false;
                }
                for (int i = 0; i < size; ++i) {
                    FunctionOrValue pm = params.get(i).getModel();
                    if (pm == null) {
                        return false;
                    }
                    Type pdt = pm.appliedReference(null, NO_TYPE_ARGS).getFullType();
                    if (pdt == null) {
                        return false;
                    }
                    Type sdt = signature.get(i);
                    if (ModelUtil.matches(sdt, pdt, unit)) continue;
                    return false;
                }
                if (hasSeqParam) {
                    FunctionOrValue model = params.get(size).getModel();
                    Type pdt = model.appliedReference(null, NO_TYPE_ARGS).getFullType();
                    if (pdt == null || pdt.getTypeArgumentList().isEmpty()) {
                        return false;
                    }
                    Type ipdt = pdt.getTypeArgumentList().get(0);
                    for (int i = size; i < sigSize; ++i) {
                        Type sdt;
                        Type isdt;
                        if (!(variadic && i == sigSize - 1 ? !ModelUtil.matches(isdt = unit.getIteratedType(sdt = signature.get(i)), ipdt, unit) : !ModelUtil.matches(sdt = signature.get(i), ipdt, unit))) continue;
                        return false;
                    }
                } else if (variadic) {
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean matches(Type argType, Type paramType, Unit unit) {
        Type nt;
        if (paramType == null || argType == null) {
            return false;
        }
        Type nvt = unit.getNullType();
        if (nvt.isSubtypeOf(argType) && !nvt.isSubtypeOf(paramType)) {
            return false;
        }
        Type defParamType = unit.getDefiniteType(paramType);
        Type defArgType = unit.getDefiniteType(argType);
        if (defArgType.isSubtypeOf(nt = unit.getNullType())) {
            return true;
        }
        if (ModelUtil.isTypeUnknown(defArgType) || ModelUtil.isTypeUnknown(defParamType)) {
            return false;
        }
        return ModelUtil.erase(defArgType, unit).inherits(ModelUtil.erase(defParamType, unit)) || !ModelUtil.notUnderlyingTypesEqual(defParamType, defArgType);
    }

    private static boolean notUnderlyingTypesEqual(Type paramType, Type sigType) {
        String sut = sigType.getUnderlyingType();
        String put = paramType.getUnderlyingType();
        return sut == null || put == null || !sut.equals(put);
    }

    static boolean betterMatch(Declaration d, Declaration r, List<Type> signature) {
        if (d instanceof Functional && r instanceof Functional) {
            Functional df = (Functional)((Object)d);
            Functional rf = (Functional)((Object)r);
            List<ParameterList> dpls = df.getParameterLists();
            List<ParameterList> rpls = rf.getParameterLists();
            if (dpls != null && !dpls.isEmpty() && rpls != null && !rpls.isEmpty()) {
                ParameterList dpls0 = dpls.get(0);
                ParameterList rpls0 = rpls.get(0);
                List<Parameter> dpl = dpls0.getParameters();
                List<Parameter> rpl = rpls0.getParameters();
                int dplSize = dpl.size();
                int rplSize = rpl.size();
                boolean dhsp = dpls0.hasSequencedParameter();
                boolean rhsp = rpls0.hasSequencedParameter();
                if (!dhsp && rhsp) {
                    return true;
                }
                if (dhsp && !rhsp) {
                    return false;
                }
                if (dhsp) {
                    --dplSize;
                }
                if (rhsp) {
                    --rplSize;
                }
                if (dplSize == rplSize) {
                    Unit unit = d.getUnit();
                    for (int i = 0; i < dplSize; ++i) {
                        Type argumentType;
                        Type dplt = dpl.get(i).getModel().appliedReference(null, NO_TYPE_ARGS).getFullType();
                        Type paramType = unit.getDefiniteType(dplt);
                        Type rplt = rpl.get(i).getModel().appliedReference(null, NO_TYPE_ARGS).getFullType();
                        Type otherType = unit.getDefiniteType(rplt);
                        Type type = argumentType = signature != null && signature.size() >= i ? signature.get(i) : null;
                        if (ModelUtil.isTypeUnknown(otherType) || ModelUtil.isTypeUnknown(paramType)) {
                            return false;
                        }
                        TypeDeclaration ptd = ModelUtil.erase(paramType, unit);
                        TypeDeclaration otd = ModelUtil.erase(otherType, unit);
                        if (paramType.isExactly(otherType) && ModelUtil.supportsCoercion(ptd) && ModelUtil.hasWorseScore(ModelUtil.getCoercionScore(argumentType, paramType), ModelUtil.getCoercionScore(argumentType, otherType))) {
                            return false;
                        }
                        if (ptd.inherits(otd) || !ModelUtil.notUnderlyingTypesEqual(paramType, otherType)) continue;
                        return false;
                    }
                    if (dhsp && rhsp) {
                        int oscore;
                        Type widerArgumentType;
                        int pscore;
                        Type dplt = dpl.get(dplSize).getModel().appliedReference(null, NO_TYPE_ARGS).getFullType();
                        Type paramType = unit.getDefiniteType(dplt);
                        Type rplt = rpl.get(dplSize).getModel().appliedReference(null, NO_TYPE_ARGS).getFullType();
                        Type otherType = unit.getDefiniteType(rplt);
                        if (ModelUtil.isTypeUnknown(otherType) || ModelUtil.isTypeUnknown(paramType)) {
                            return false;
                        }
                        paramType = unit.getIteratedType(paramType);
                        if (ModelUtil.isTypeUnknown(otherType = unit.getIteratedType(otherType)) || ModelUtil.isTypeUnknown(paramType)) {
                            return false;
                        }
                        TypeDeclaration ptd = ModelUtil.erase(paramType, unit);
                        TypeDeclaration otd = ModelUtil.erase(otherType, unit);
                        if (paramType.isExactly(otherType) && ModelUtil.supportsCoercion(ptd) && ModelUtil.hasWorseScore(pscore = ModelUtil.getCoercionScore(widerArgumentType = ModelUtil.getWiderArgumentType(paramType, signature, dplSize), paramType), oscore = ModelUtil.getCoercionScore(widerArgumentType, otherType))) {
                            return false;
                        }
                        if (!ptd.inherits(otd) && ModelUtil.notUnderlyingTypesEqual(paramType, otherType)) {
                            return false;
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean supportsCoercion(TypeDeclaration decl) {
        return decl.isInteger() || decl.isFloat();
    }

    private static boolean hasWorseScore(int underlyingTypeCoercionScoreA, int underlyingTypeCoercionScoreB) {
        if (underlyingTypeCoercionScoreA != underlyingTypeCoercionScoreB) {
            if (underlyingTypeCoercionScoreA > 0 && underlyingTypeCoercionScoreB > 0) {
                if (underlyingTypeCoercionScoreA > underlyingTypeCoercionScoreB) {
                    return true;
                }
            } else {
                if (underlyingTypeCoercionScoreA > 0) {
                    return true;
                }
                if (underlyingTypeCoercionScoreA == 0) {
                    return false;
                }
                if (underlyingTypeCoercionScoreB == 0) {
                    return true;
                }
                if (underlyingTypeCoercionScoreB > 0) {
                    return false;
                }
                return underlyingTypeCoercionScoreA < underlyingTypeCoercionScoreB;
            }
        }
        return false;
    }

    private static Type getWiderArgumentType(Type paramType, List<Type> signature, int startAt) {
        if (startAt >= signature.size()) {
            return null;
        }
        TypeDeclaration decl = paramType.getDeclaration();
        Unit unit = decl.getUnit();
        if (decl.isInteger()) {
            int bestScore = 0;
            Type ret = null;
            for (int i = startAt; i < signature.size(); ++i) {
                Type argType = signature.get(i);
                String underlyingType = argType.getUnderlyingType();
                int score = 0;
                if (underlyingType == null || underlyingType.equals("long")) {
                    return argType;
                }
                if (underlyingType.equals("int")) {
                    score = 2;
                } else if (underlyingType.equals("short")) {
                    score = 1;
                }
                if (score <= bestScore) continue;
                bestScore = score;
                ret = argType;
            }
            return ret;
        }
        if (decl.equals(unit.getFloatDeclaration())) {
            boolean bestScore = false;
            Type ret = null;
            for (int i = startAt; i < signature.size(); ++i) {
                Type argType = signature.get(i);
                String underlyingType = argType.getUnderlyingType();
                boolean score = false;
                if (underlyingType == null || underlyingType.equals("double")) {
                    return argType;
                }
                if (underlyingType.equals("float")) {
                    score = true;
                }
                if (score <= bestScore) continue;
                bestScore = score;
                ret = argType;
            }
            return ret;
        }
        return null;
    }

    private static int getCoercionScore(Type argumentType, Type paramType) {
        if (argumentType == null) {
            return 0;
        }
        if (paramType.isExactly(argumentType)) {
            String aType = argumentType.getUnderlyingType();
            String pType = paramType.getUnderlyingType();
            if (aType == null && pType == null) {
                return 0;
            }
            Unit unit = argumentType.getDeclaration().getUnit();
            TypeDeclaration decl = paramType.getDeclaration();
            if (decl.isInteger()) {
                if (aType == null) {
                    aType = "long";
                }
                if (pType == null) {
                    pType = "long";
                }
                int aScore = ModelUtil.getPrimitiveScore(aType);
                int bScore = ModelUtil.getPrimitiveScore(pType);
                return aScore - bScore;
            }
            if (decl.equals(unit.getFloatDeclaration())) {
                if (aType == null) {
                    aType = "double";
                }
                if (pType == null) {
                    pType = "double";
                }
                int aScore = ModelUtil.getPrimitiveScore(aType);
                int bScore = ModelUtil.getPrimitiveScore(pType);
                return aScore - bScore;
            }
        }
        return 0;
    }

    private static int getPrimitiveScore(String underlyingType) {
        if (underlyingType.equals("long")) {
            return 2;
        }
        if (underlyingType.equals("int") || underlyingType.equals("double")) {
            return 1;
        }
        if (underlyingType.equals("short") || underlyingType.equals("float")) {
            return 0;
        }
        return 0;
    }

    static boolean strictlyBetterMatch(Declaration d, Declaration r) {
        if (d instanceof Functional && r instanceof Functional) {
            Functional fd = (Functional)((Object)d);
            Functional fr = (Functional)((Object)r);
            List<ParameterList> dpls = fd.getParameterLists();
            List<ParameterList> rpls = fr.getParameterLists();
            if (dpls != null && !dpls.isEmpty() && rpls != null && !rpls.isEmpty()) {
                ParameterList dpls0 = dpls.get(0);
                ParameterList rpls0 = rpls.get(0);
                List<Parameter> dpl = dpls0.getParameters();
                List<Parameter> rpl = rpls0.getParameters();
                int dplSize = dpl.size();
                int rplSize = rpl.size();
                boolean dhsp = dpls0.hasSequencedParameter();
                boolean rhsp = rpls0.hasSequencedParameter();
                if (!dhsp && rhsp) {
                    return true;
                }
                if (dhsp && !rhsp) {
                    return false;
                }
                if (dhsp) {
                    --dplSize;
                }
                if (rhsp) {
                    --rplSize;
                }
                if (dplSize == rplSize) {
                    boolean atLeastOneBetter = false;
                    Unit unit = d.getUnit();
                    for (int i = 0; i < dplSize; ++i) {
                        TypeDeclaration otd;
                        Type dplt = dpl.get(i).getModel().appliedReference(null, NO_TYPE_ARGS).getFullType();
                        Type paramType = unit.getDefiniteType(dplt);
                        Type rplt = rpl.get(i).getModel().appliedReference(null, NO_TYPE_ARGS).getFullType();
                        Type otherType = unit.getDefiniteType(rplt);
                        if (ModelUtil.isTypeUnknown(otherType) || ModelUtil.isTypeUnknown(paramType)) {
                            return false;
                        }
                        TypeDeclaration ptd = ModelUtil.erase(paramType, unit);
                        if (!ptd.inherits(otd = ModelUtil.erase(otherType, unit)) && ModelUtil.notUnderlyingTypesEqual(paramType, otherType)) {
                            return false;
                        }
                        if (!ptd.inherits(otd) || otd.inherits(ptd) || !ModelUtil.notUnderlyingTypesEqual(paramType, otherType)) continue;
                        atLeastOneBetter = true;
                    }
                    if (dhsp && rhsp) {
                        TypeDeclaration otd;
                        Type dplt = dpl.get(dplSize).getModel().appliedReference(null, NO_TYPE_ARGS).getFullType();
                        Type paramType = unit.getDefiniteType(dplt);
                        Type rplt = rpl.get(dplSize).getModel().appliedReference(null, NO_TYPE_ARGS).getFullType();
                        Type otherType = unit.getDefiniteType(rplt);
                        if (ModelUtil.isTypeUnknown(otherType) || ModelUtil.isTypeUnknown(paramType)) {
                            return false;
                        }
                        paramType = unit.getIteratedType(paramType);
                        if (ModelUtil.isTypeUnknown(otherType = unit.getIteratedType(otherType)) || ModelUtil.isTypeUnknown(paramType)) {
                            return false;
                        }
                        TypeDeclaration ptd = ModelUtil.erase(paramType, unit);
                        if (!ptd.inherits(otd = ModelUtil.erase(otherType, unit)) && ModelUtil.notUnderlyingTypesEqual(paramType, otherType)) {
                            return false;
                        }
                        if (ptd.inherits(otd) && !otd.inherits(ptd) && ModelUtil.notUnderlyingTypesEqual(paramType, otherType)) {
                            atLeastOneBetter = true;
                        }
                    }
                    return atLeastOneBetter;
                }
            }
        }
        return false;
    }

    public static boolean isNamed(String name, Declaration d) {
        String dname = d.getName();
        return dname != null && dname.equals(name);
    }

    static TypeDeclaration erase(Type paramType, Unit unit) {
        if (paramType.isTypeParameter()) {
            if (paramType.getSatisfiedTypes().isEmpty()) {
                Type et = paramType.getExtendedType();
                return et == null ? null : et.getDeclaration();
            }
            Type st = paramType.getSatisfiedTypes().get(0);
            return st == null ? null : st.getDeclaration();
        }
        if (paramType.isUnion()) {
            return unit.getObjectDeclaration();
        }
        if (paramType.isIntersection()) {
            List<Type> sts = paramType.getSatisfiedTypes();
            if (sts.size() == 2) {
                Type first = sts.get(0);
                Type second = sts.get(1);
                if (first != null && first.isBasic()) {
                    return ModelUtil.erase(second, unit);
                }
                if (second != null && second.isBasic()) {
                    return ModelUtil.erase(first, unit);
                }
            }
            return unit.getObjectDeclaration();
        }
        return paramType.getDeclaration();
    }

    public static boolean isNameMatching(String startingWith, Declaration d) {
        return ModelUtil.isNameMatching(startingWith, d.getName());
    }

    public static boolean isNameMatching(String startingWith, Import i) {
        return ModelUtil.isNameMatching(startingWith, i.getAlias());
    }

    public static boolean isNameMatching(String startingWith, String name) {
        int d;
        int startingWithLength;
        if (startingWith == null || startingWith.isEmpty()) {
            return true;
        }
        if (name == null || name.isEmpty()) {
            return false;
        }
        int nameLength = name.length();
        if (nameLength < (startingWithLength = startingWith.length())) {
            return false;
        }
        if (name.regionMatches(true, 0, startingWith, 0, startingWithLength)) {
            return true;
        }
        int c = startingWith.codePointAt(0);
        if (c != (d = name.codePointAt(0))) {
            return false;
        }
        int i = 1;
        int j = 1;
        while (i < startingWithLength) {
            if (j >= nameLength) {
                return false;
            }
            while (i < startingWithLength && Character.isLowerCase(c = startingWith.codePointAt(i))) {
                d = name.codePointAt(j);
                if (c == d) {
                    j += Character.charCount(d);
                    if ((i += Character.charCount(c)) >= startingWithLength) {
                        return true;
                    }
                    if (j < nameLength) continue;
                    return false;
                }
                return false;
            }
            while (j < nameLength && Character.isLowerCase(d = name.codePointAt(j))) {
                if ((j += Character.charCount(d)) < nameLength) continue;
                return false;
            }
            c = startingWith.codePointAt(i);
            d = name.codePointAt(j);
            i += Character.charCount(c);
            j += Character.charCount(d);
            if (d == c) continue;
            return false;
        }
        return true;
    }

    private static int countTypeParameters(Declaration declaration, Type receivingType) {
        int count = 0;
        boolean containsFunctionOrValueInterface = ModelUtil.containsFunctionOrValueInterface(receivingType);
        while (true) {
            if (declaration instanceof Generic) {
                Generic g = (Generic)((Object)declaration);
                count += g.getTypeParameters().size();
            }
            if (declaration.isClassOrInterfaceMember()) {
                declaration = (Declaration)((Object)declaration.getContainer());
                continue;
            }
            if (!containsFunctionOrValueInterface || (declaration = ModelUtil.getFirstGenericContainer(declaration)) == null) break;
        }
        return count;
    }

    private static Declaration getFirstGenericContainer(Declaration declaration) {
        Scope container;
        for (container = declaration.getContainer(); container != null && !(container instanceof Generic); container = container.getContainer()) {
        }
        return (Declaration)((Object)container);
    }

    private static boolean containsFunctionOrValueInterface(Type receivingType) {
        while (receivingType != null) {
            if (receivingType.isFunctionOrValueInterface()) {
                return true;
            }
            receivingType = receivingType.getQualifyingType();
        }
        return false;
    }

    public static Map<TypeParameter, Type> getTypeArgumentMap(Declaration declaration, Type receivingType, List<Type> typeArguments) {
        int count = ModelUtil.countTypeParameters(declaration, receivingType);
        if (count == 0) {
            return EMPTY_TYPE_ARG_MAP;
        }
        return ModelUtil.aggregateTypeArguments(receivingType, typeArguments, declaration, count);
    }

    private static Map<TypeParameter, Type> aggregateTypeArguments(Type receivingType, List<Type> typeArguments, Declaration declaration, int count) {
        List<TypeParameter> typeParameters = ModelUtil.getTypeParameters(declaration);
        HashMap<TypeParameter, Type> map = new HashMap<TypeParameter, Type>(count);
        if (receivingType != null) {
            if (receivingType.isIntersection()) {
                for (Type supertype : receivingType.getSatisfiedTypes()) {
                    ModelUtil.aggregateTypeArguments(map, supertype, declaration);
                }
            } else {
                ModelUtil.aggregateTypeArguments(map, receivingType, declaration);
            }
        }
        if (typeArguments != null) {
            for (int i = 0; i < typeParameters.size() && i < typeArguments.size(); ++i) {
                map.put(typeParameters.get(i), typeArguments.get(i));
            }
        }
        return map;
    }

    private static void aggregateTypeArguments(Map<TypeParameter, Type> map, Type dt, Declaration d) {
        while (dt != null) {
            Type aqt;
            if (d.isClassOrInterfaceMember()) {
                TypeDeclaration declaringType = (TypeDeclaration)d.getContainer();
                aqt = dt.getSupertype(declaringType);
                if (aqt == null) {
                    break;
                }
            } else {
                if (!dt.isFunctionOrValueInterface()) break;
                aqt = dt;
            }
            map.putAll(aqt.getTypeArguments());
            dt = aqt.getQualifyingType();
            d = aqt.getDeclaration();
        }
    }

    public static Map<TypeParameter, SiteVariance> getVarianceMap(Declaration declaration, Type receivingType, List<SiteVariance> variances) {
        if (variances == null) {
            return EMPTY_VARIANCE_MAP;
        }
        if (ModelUtil.countTypeParameters(declaration, receivingType) == 0) {
            return EMPTY_VARIANCE_MAP;
        }
        return ModelUtil.aggregateVariances(receivingType, variances, declaration);
    }

    private static Map<TypeParameter, SiteVariance> aggregateVariances(Type receivingType, List<SiteVariance> variances, Declaration declaration) {
        HashMap<TypeParameter, SiteVariance> map = new HashMap<TypeParameter, SiteVariance>();
        if (receivingType != null) {
            if (receivingType.isIntersection()) {
                for (Type supertype : receivingType.getSatisfiedTypes()) {
                    ModelUtil.aggregateVariances(map, supertype, declaration);
                }
            } else {
                ModelUtil.aggregateVariances(map, receivingType, declaration);
            }
        }
        List<TypeParameter> typeParameters = ModelUtil.getTypeParameters(declaration);
        for (int i = 0; i < typeParameters.size() && i < variances.size(); ++i) {
            SiteVariance var = variances.get(i);
            if (var == null) continue;
            map.put(typeParameters.get(i), var);
        }
        return map;
    }

    private static void aggregateVariances(Map<TypeParameter, SiteVariance> map, Type dt, Declaration d) {
        while (dt != null) {
            Type aqt;
            if (d.isClassOrInterfaceMember()) {
                TypeDeclaration declaringType = (TypeDeclaration)d.getContainer();
                aqt = dt.getSupertype(declaringType);
                if (aqt == null) {
                    break;
                }
            } else {
                if (!dt.isFunctionOrValueInterface()) break;
                aqt = dt;
            }
            map.putAll(dt.getVarianceOverrides());
            dt = aqt.getQualifyingType();
            d = aqt.getDeclaration();
        }
    }

    public static List<TypeParameter> getTypeParameters(Declaration declaration) {
        if (declaration instanceof Generic) {
            Generic g = (Generic)((Object)declaration);
            return g.getTypeParameters();
        }
        return Collections.emptyList();
    }

    static <T> List<T> list(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list.size() + 1);
        result.addAll(list);
        result.add(element);
        return result;
    }

    public static void addToUnion(List<Type> list, Type pt) {
        if (pt == null || !list.isEmpty() && pt.isExactlyNothing()) {
            return;
        }
        if (pt.isAnything()) {
            list.clear();
            list.add(pt);
        } else if (pt.isUnion()) {
            List<Type> caseTypes = pt.getCaseTypes();
            int size = caseTypes.size();
            for (int i = 0; i < size; ++i) {
                Type t = caseTypes.get(i);
                ModelUtil.addToUnion(list, t.substitute(pt));
            }
        } else if (pt.isWellDefined()) {
            boolean add = true;
            for (int i = 0; i < list.size(); ++i) {
                Type t = list.get(i);
                if (pt.isSubtypeOf(t)) {
                    add = false;
                    break;
                }
                if (!pt.isSupertypeOf(t)) continue;
                list.remove(i);
                --i;
            }
            if (add) {
                list.add(pt);
            }
        }
    }

    public static void addToIntersection(List<Type> list, Type type, Unit unit) {
        if (type == null || !list.isEmpty() && type.isAnything()) {
            return;
        }
        if (type.isExactlyNothing()) {
            list.clear();
            list.add(type);
        } else if (type.isIntersection()) {
            List<Type> satisfiedTypes = type.getSatisfiedTypes();
            int size = satisfiedTypes.size();
            for (int i = 0; i < size; ++i) {
                Type t = satisfiedTypes.get(i);
                ModelUtil.addToIntersection(list, t, unit);
            }
        } else if (type.isWellDefined()) {
            Type t;
            TypeDeclaration dec = type.getDeclaration();
            for (int i = 0; i < list.size(); ++i) {
                Type pi;
                Type t2 = list.get(i).resolveAliases();
                if (t2.isSubtypeOf(type)) {
                    return;
                }
                if (type.isSubtypeOf(t2)) {
                    list.remove(i);
                    --i;
                    continue;
                }
                if (ModelUtil.disjoint(type, t2, unit)) {
                    list.clear();
                    list.add(unit.getNothingType());
                    return;
                }
                if (!type.isClassOrInterface() || !t2.isClassOrInterface() || !t2.getDeclaration().equals(dec) || type.containsUnknowns() || t2.containsUnknowns() || (pi = ModelUtil.principalInstantiation(dec, type, t2, unit)).containsUnknowns()) continue;
                list.remove(i);
                list.add(pi);
                return;
            }
            if (list.size() > 1 && type.isSupertypeOf(t = ModelUtil.canonicalIntersection(list, unit))) {
                return;
            }
            list.add(type);
        }
    }

    private static boolean disjoint(Type p, Type q, Unit unit) {
        Type qs;
        if (q.getDeclaration().isDisjoint(p.getDeclaration())) {
            return true;
        }
        Type ps = p.resolveAliases();
        return ModelUtil.emptyMeet(ps, qs = q.resolveAliases(), unit) || ModelUtil.hasEmptyIntersectionOfInvariantInstantiations(ps, qs);
    }

    private static boolean emptyMeet(Type p, Type q, Unit unit) {
        List<Type> pal;
        Type qet;
        Type pet;
        boolean all;
        if (p == null || q == null) {
            return false;
        }
        if (p.isExactlyNothing() || q.isExactlyNothing()) {
            return true;
        }
        TypeDeclaration pd = p.getDeclaration();
        TypeDeclaration qd = q.getDeclaration();
        if (p.isTypeParameter()) {
            p = ModelUtil.canonicalIntersection(p.getSatisfiedTypes(), unit);
            pd = p.getDeclaration();
        }
        if (q.isTypeParameter()) {
            q = ModelUtil.canonicalIntersection(q.getSatisfiedTypes(), unit);
            qd = q.getDeclaration();
        }
        if (q.isIntersection()) {
            for (Type t : q.getSatisfiedTypes()) {
                if (!ModelUtil.emptyMeet(p, t, unit)) continue;
                return true;
            }
            return false;
        }
        if (p.isIntersection()) {
            for (Type t : p.getSatisfiedTypes()) {
                if (!ModelUtil.emptyMeet(q, t, unit)) continue;
                return true;
            }
            return false;
        }
        if (q.isUnion()) {
            for (Type t : q.getCaseTypes()) {
                if (ModelUtil.emptyMeet(p, t, unit)) continue;
                return false;
            }
            return true;
        }
        if (qd.getCaseTypes() != null) {
            all = true;
            for (Type t : qd.getCaseTypes()) {
                if (!t.getDeclaration().isSelfType() && ModelUtil.emptyMeet(p, t, unit)) continue;
                all = false;
                break;
            }
            if (all) {
                return true;
            }
        }
        if (p.isUnion()) {
            for (Type t : p.getCaseTypes()) {
                if (ModelUtil.emptyMeet(q, t, unit)) continue;
                return false;
            }
            return true;
        }
        if (p.getCaseTypes() != null) {
            all = true;
            for (Type t : pd.getCaseTypes()) {
                if (!t.getDeclaration().isSelfType() && ModelUtil.emptyMeet(q, t, unit)) continue;
                all = false;
                break;
            }
            if (all) {
                return true;
            }
        }
        if ((p.isClass() && q.isClass() || p.isInterface() && q.isNull() || q.isInterface() && p.isNull()) && !qd.inherits(pd) && !pd.inherits(qd)) {
            return true;
        }
        if (pd.isFinal()) {
            if (pd.getTypeParameters().isEmpty() && !q.involvesTypeParameters() && !p.isSubtypeOf(q) && !(qd instanceof UnknownType)) {
                return true;
            }
            if (q.isClassOrInterface() && !pd.inherits(qd)) {
                return true;
            }
        }
        if (qd.isFinal()) {
            if (qd.getTypeParameters().isEmpty() && !p.involvesTypeParameters() && !q.isSubtypeOf(p) && !p.isUnknown()) {
                return true;
            }
            if (p.isClassOrInterface() && !qd.inherits(pd)) {
                return true;
            }
        }
        Interface st = unit.getSequentialDeclaration();
        if (q.isClassOrInterface() && pd.inherits(st) && !qd.inherits(st) && !st.inherits(qd) || p.isClassOrInterface() && qd.inherits(st) && !pd.inherits(st) && !st.inherits(pd) && !p.involvesTypeParameters()) {
            return true;
        }
        Interface nst = unit.getSequenceDeclaration();
        if ((pd.inherits(nst) && qd.inherits(st) || qd.inherits(nst) && pd.inherits(st)) && ModelUtil.emptyMeet(pet = unit.getSequentialElementType(p), qet = unit.getSequentialElementType(q), unit)) {
            return true;
        }
        Class td = unit.getTupleDeclaration();
        if (pd.inherits(td) && qd.inherits(td)) {
            pal = p.getTypeArgumentList();
            List<Type> qal = q.getTypeArgumentList();
            if (pal.size() >= 3 && qal.size() >= 3 && (ModelUtil.emptyMeet(pal.get(1), qal.get(1), unit) || ModelUtil.emptyMeet(pal.get(2), qal.get(2), unit))) {
                return true;
            }
        }
        if (pd.inherits(td) && qd.inherits(st)) {
            pal = p.getTypeArgumentList();
            Type qet2 = unit.getSequentialElementType(q);
            if (pal.size() >= 3 && (ModelUtil.emptyMeet(pal.get(1), qet2, unit) || ModelUtil.emptyMeet(pal.get(2), unit.getSequentialType(qet2), unit))) {
                return true;
            }
        }
        if (qd.inherits(td) && pd.inherits(st)) {
            List<Type> qal = q.getTypeArgumentList();
            Type pet2 = unit.getSequentialElementType(p);
            if (qal.size() >= 3 && (ModelUtil.emptyMeet(qal.get(1), pet2, unit) || ModelUtil.emptyMeet(qal.get(2), unit.getSequentialType(pet2), unit))) {
                return true;
            }
        }
        return false;
    }

    static Type principalQualifyingType(Type p, Type q, Declaration td, Unit unit) {
        Type pqt = p.getQualifyingType();
        Type qqt = q.getQualifyingType();
        Scope tdc = td.getContainer();
        if (pqt != null && qqt != null) {
            if (tdc instanceof TypeDeclaration) {
                TypeDeclaration qtd = (TypeDeclaration)tdc;
                Type pst = pqt.getSupertype(qtd);
                Type qst = qqt.getSupertype(qtd);
                if (pst != null && qst != null) {
                    return ModelUtil.principalInstantiation(qtd, pst, qst, unit);
                }
            } else if (pqt.isExactly(qqt)) {
                return pqt;
            }
        }
        return null;
    }

    private static boolean hasEmptyIntersectionOfInvariantInstantiations(Type p, Type q) {
        List<TypeDeclaration> pstds = p.getDeclaration().getSupertypeDeclarations();
        List<TypeDeclaration> qstds = q.getDeclaration().getSupertypeDeclarations();
        HashSet<TypeDeclaration> set = new HashSet<TypeDeclaration>(pstds.size() + qstds.size());
        set.addAll(pstds);
        set.retainAll(qstds);
        for (TypeDeclaration std : pstds) {
            Type pst = null;
            Type qst = null;
            for (TypeParameter tp : std.getTypeParameters()) {
                if (!tp.isInvariant()) continue;
                if (pst == null) {
                    pst = p.getSupertype(std);
                }
                if (qst == null) {
                    qst = q.getSupertype(std);
                }
                if (pst == null || qst == null) continue;
                Type psta = pst.getTypeArguments().get(tp);
                Type qsta = qst.getTypeArguments().get(tp);
                if (psta == null || !psta.isWellDefined() || pst.involvesTypeParameters() || qsta == null || !qsta.isWellDefined() || qst.involvesTypeParameters()) continue;
                boolean psti = pst.isInvariant(tp);
                boolean pstcov = pst.isCovariant(tp);
                boolean pstcontra = pst.isContravariant(tp);
                boolean qsti = qst.isInvariant(tp);
                boolean qstcov = qst.isCovariant(tp);
                boolean qstcontra = qst.isContravariant(tp);
                if (!(psti && qsti && !psta.isExactly(qsta) || pstcov && qsti && !qsta.isSubtypeOf(psta) || qstcov && psti && !psta.isSubtypeOf(qsta) || pstcontra && qsti && !psta.isSubtypeOf(qsta)) && (!qstcontra || !psti || qsta.isSubtypeOf(psta))) continue;
                return true;
            }
        }
        return false;
    }

    public static String formatPath(List<String> path, char separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.size(); ++i) {
            String pathPart = path.get(i);
            if (pathPart.isEmpty()) continue;
            sb.append(pathPart);
            if (i >= path.size() - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static String formatPath(List<String> path) {
        return ModelUtil.formatPath(path, '.');
    }

    public static Type unionType(Type lhst, Type rhst, Unit unit) {
        ArrayList<Type> list = new ArrayList<Type>(2);
        ModelUtil.addToUnion(list, rhst);
        ModelUtil.addToUnion(list, lhst);
        UnionType ut = new UnionType(unit);
        ut.setCaseTypes(list);
        return ut.getType();
    }

    public static Type intersectionType(Type lhst, Type rhst, Unit unit) {
        Type simpleIntersection = ModelUtil.getSimpleIntersection(lhst, rhst);
        if (simpleIntersection != null) {
            return simpleIntersection;
        }
        ArrayList<Type> list = new ArrayList<Type>(2);
        ModelUtil.addToIntersection(list, rhst, unit);
        ModelUtil.addToIntersection(list, lhst, unit);
        IntersectionType it = new IntersectionType(unit);
        it.setSatisfiedTypes(list);
        return it.canonicalize().getType();
    }

    public static Type union(List<Type> types, Unit unit) {
        if (types.size() == 1) {
            return types.get(0);
        }
        UnionType ut = new UnionType(unit);
        ut.setCaseTypes(types);
        return ut.getType();
    }

    public static Type intersection(List<Type> types, Unit unit) {
        if (types.size() == 1) {
            return types.get(0);
        }
        IntersectionType it = new IntersectionType(unit);
        it.setSatisfiedTypes(types);
        return it.getType();
    }

    public static Type canonicalIntersection(List<Type> types, Unit unit) {
        if (types.size() == 1) {
            return types.get(0);
        }
        IntersectionType it = new IntersectionType(unit);
        it.setSatisfiedTypes(types);
        return it.canonicalize().getType();
    }

    private static Type getSimpleIntersection(Type a, Type b) {
        String bn;
        if (a == null || b == null) {
            return null;
        }
        TypeDeclaration ad = a.getDeclaration();
        TypeDeclaration bd = b.getDeclaration();
        if (ad == null || bd == null) {
            return null;
        }
        if (!a.isClassOrInterface()) {
            if (a.isUnion() && b.isClassOrInterface()) {
                return ModelUtil.getSimpleIntersection(b, (ClassOrInterface)bd, a);
            }
            return null;
        }
        if (!b.isClassOrInterface()) {
            if (b.isUnion()) {
                return ModelUtil.getSimpleIntersection(a, (ClassOrInterface)ad, b);
            }
            return null;
        }
        String an = ad.getQualifiedNameString();
        if (an.equals(bn = bd.getQualifiedNameString()) && ad.getTypeParameters().isEmpty() && bd.getTypeParameters().isEmpty()) {
            return a;
        }
        if (a.isAnything()) {
            return b;
        }
        if (b.isAnything()) {
            return a;
        }
        if (a.isObject()) {
            if (b.isNull() || b.isNullValue()) {
                return ad.getUnit().getNothingType();
            }
            return b;
        }
        if (b.isObject()) {
            if (a.isNull() || a.isNullValue()) {
                return bd.getUnit().getNothingType();
            }
            return a;
        }
        if (a.isNull()) {
            if (b.isNull() || b.isNullValue()) {
                return b;
            }
            return ad.getUnit().getNothingType();
        }
        if (b.isNull()) {
            if (a.isNull() || a.isNullValue()) {
                return a;
            }
            return bd.getUnit().getNothingType();
        }
        return null;
    }

    private static Type getSimpleIntersection(Type a, ClassOrInterface aDecl, Type b) {
        if (b.getCaseTypes().size() != 2) {
            return null;
        }
        boolean aIsObject = a.isObject();
        boolean aIsNull = a.isNull();
        if (!aIsObject && !aIsNull) {
            return null;
        }
        Type caseA = b.getCaseTypes().get(0);
        Type caseB = b.getCaseTypes().get(1);
        boolean isANull = caseA.isNull();
        boolean isBNull = caseB.isNull();
        if (aIsObject) {
            if (isANull) {
                return ModelUtil.simpleObjectIntersection(aDecl, caseB);
            }
            if (isBNull) {
                return ModelUtil.simpleObjectIntersection(aDecl, caseA);
            }
            return null;
        }
        if (aIsNull) {
            if (isANull) {
                return caseA;
            }
            if (isBNull) {
                return caseB;
            }
            return null;
        }
        return null;
    }

    private static Type simpleObjectIntersection(ClassOrInterface objectDecl, Type type) {
        if (type.isClassOrInterface()) {
            return type;
        }
        if (type.isTypeParameter()) {
            List<Type> satisfiedTypes = type.getSatisfiedTypes();
            if (satisfiedTypes.isEmpty()) {
                Unit unit = objectDecl.getUnit();
                ArrayList<Type> types = new ArrayList<Type>(2);
                types.add(type);
                types.add(objectDecl.getType());
                return ModelUtil.canonicalIntersection(types, unit);
            }
            for (Type sat : satisfiedTypes) {
                if (!sat.isObject()) continue;
                return type;
            }
            return null;
        }
        return null;
    }

    public static boolean isElementOfUnion(Type unionType, ClassOrInterface ci) {
        for (Type ct : unionType.getCaseTypes()) {
            if (!ct.isClassOrInterface() || !ct.getDeclaration().equals(ci)) continue;
            return true;
        }
        return false;
    }

    public static Declaration lookupMember(List<Declaration> members, String name, List<Type> signature, boolean variadic) {
        return ModelUtil.lookupMember(members, name, signature, variadic, false);
    }

    public static Declaration lookupMember(List<Declaration> members, String name, List<Type> signature, boolean variadic, boolean onlyExactMatches) {
        ArrayList<Declaration> results = null;
        Declaration result = null;
        Declaration inexactMatch = null;
        int size = members.size();
        for (int i = 0; i < size; ++i) {
            Declaration d = members.get(i);
            if (!ModelUtil.isResolvable(d) || !ModelUtil.isNamed(name, d)) continue;
            if (signature == null) {
                if (!ModelUtil.notOverloaded(d)) continue;
                return d;
            }
            if (ModelUtil.notOverloaded(d)) {
                inexactMatch = d;
            }
            if (!ModelUtil.hasMatchingSignature(d, signature, variadic)) continue;
            if (result == null) {
                result = d;
                continue;
            }
            if (results == null) {
                results = new ArrayList<Declaration>(2);
                results.add(result);
            }
            ModelUtil.addIfBetterMatch((List<Declaration>)results, d, signature);
        }
        if (results == null) {
            if (result != null) {
                return result;
            }
            return onlyExactMatches ? null : inexactMatch;
        }
        switch (results.size()) {
            case 0: {
                return onlyExactMatches ? null : inexactMatch;
            }
            case 1: {
                return (Declaration)results.get(0);
            }
        }
        return onlyExactMatches ? null : inexactMatch;
    }

    private static void addIfBetterMatch(List<Declaration> results, Declaration d, List<Type> signature) {
        boolean add = true;
        Iterator<Declaration> i = results.iterator();
        while (i.hasNext()) {
            Declaration o = i.next();
            if (ModelUtil.betterMatch(d, o, signature)) {
                i.remove();
                continue;
            }
            if (!ModelUtil.betterMatch(o, d, signature)) continue;
            add = false;
        }
        if (add) {
            results.add(d);
        }
    }

    public static Declaration findMatchingOverloadedClass(Class abstractionClass, List<Type> signature, boolean variadic) {
        ArrayList<Declaration> results = new ArrayList<Declaration>(1);
        if (!abstractionClass.isAbstraction()) {
            return abstractionClass;
        }
        for (Declaration overloaded : abstractionClass.getOverloads()) {
            if (!ModelUtil.hasMatchingSignature(overloaded, signature, variadic, false)) continue;
            ModelUtil.addIfBetterMatch(results, overloaded, signature);
        }
        if (results.size() == 1) {
            return (Declaration)results.get(0);
        }
        return abstractionClass;
    }

    public static boolean isTypeUnknown(Type type) {
        return type == null || type.getDeclaration() == null || type.containsUnknowns();
    }

    public static List<Type> getSignature(Declaration dec) {
        if (!(dec instanceof Functional)) {
            return null;
        }
        Functional fun = (Functional)((Object)dec);
        List<ParameterList> parameterLists = fun.getParameterLists();
        if (parameterLists == null || parameterLists.isEmpty()) {
            return null;
        }
        ParameterList parameterList = parameterLists.get(0);
        if (parameterList == null) {
            return null;
        }
        List<Parameter> parameters = parameterList.getParameters();
        if (parameters == null) {
            return null;
        }
        ArrayList<Type> signature = new ArrayList<Type>(parameters.size());
        Unit unit = dec.getUnit();
        for (Parameter param : parameters) {
            FunctionOrValue model = param.getModel();
            Type t = model instanceof Value ? model.getType() : (model instanceof Function ? ModelUtil.appliedType((TypeDeclaration)unit.getCallableDeclaration(), model.getType(), unit.getUnknownType()) : unit.getUnknownType());
            signature.add(t);
        }
        return signature;
    }

    public static List<Type> getSignature(Reference ref) {
        Declaration dec = ref.getDeclaration();
        if (!(dec instanceof Functional)) {
            return null;
        }
        Functional fun = (Functional)((Object)dec);
        List<ParameterList> parameterLists = fun.getParameterLists();
        if (parameterLists == null || parameterLists.isEmpty()) {
            return null;
        }
        ParameterList parameterList = parameterLists.get(0);
        if (parameterList == null) {
            return null;
        }
        List<Parameter> parameters = parameterList.getParameters();
        if (parameters == null) {
            return null;
        }
        ArrayList<Type> signature = new ArrayList<Type>(parameters.size());
        Unit unit = dec.getUnit();
        for (Parameter param : parameters) {
            TypedReference typedParameter = ref.getTypedParameter(param);
            Type t = typedParameter == null ? unit.getUnknownType() : typedParameter.getType();
            signature.add(t);
        }
        return signature;
    }

    public static boolean isCompletelyVisible(Declaration member, Type pt) {
        if (pt.isUnion()) {
            for (Type ct : pt.getCaseTypes()) {
                if (ModelUtil.isCompletelyVisible(member, ct.substitute(pt))) continue;
                return false;
            }
            return true;
        }
        if (pt.isIntersection()) {
            for (Type ct : pt.getSatisfiedTypes()) {
                if (ModelUtil.isCompletelyVisible(member, ct.substitute(pt))) continue;
                return false;
            }
            return true;
        }
        if (pt.isTypeAlias() && pt.getDeclaration().isAnonymous()) {
            return ModelUtil.isCompletelyVisible(member, pt.getExtendedType());
        }
        if (!ModelUtil.isVisible(member, pt.getDeclaration())) {
            return false;
        }
        for (Type at : pt.getTypeArgumentList()) {
            if (at == null || ModelUtil.isCompletelyVisible(member, at)) continue;
            return false;
        }
        return true;
    }

    static boolean isVisible(Declaration member, TypeDeclaration type) {
        return type instanceof TypeParameter || type.isVisible(member.getVisibleScope()) && (member.getVisibleScope() != null || !member.getUnit().getPackage().isShared() || type.getUnit().getPackage().isShared());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Type principalInstantiation(TypeDeclaration dec, Type first, Type second, Unit unit) {
        List<TypeParameter> tps = dec.getTypeParameters();
        ArrayList<Type> args = new ArrayList<Type>(tps.size());
        HashMap<TypeParameter, SiteVariance> varianceOverrides = new HashMap<TypeParameter, SiteVariance>(1);
        for (TypeParameter tp : tps) {
            Type arg;
            Type firstArg = first.getTypeArguments().get(tp);
            Type secondArg = second.getTypeArguments().get(tp);
            if (firstArg == null || secondArg == null) {
                arg = unit.getUnknownType();
            } else {
                boolean parameterized;
                boolean firstCo = first.isCovariant(tp);
                boolean secondCo = second.isCovariant(tp);
                boolean firstContra = first.isContravariant(tp);
                boolean secondContra = second.isContravariant(tp);
                boolean firstInv = !firstCo && !firstContra;
                boolean secondInv = !secondCo && !secondContra;
                boolean bl = parameterized = firstArg.involvesTypeParameters() || secondArg.involvesTypeParameters();
                if (firstContra && secondContra) {
                    arg = ModelUtil.unionType(firstArg, secondArg, unit);
                    if (!tp.isContravariant()) {
                        varianceOverrides.put(tp, SiteVariance.IN);
                    }
                } else if (firstCo && secondCo) {
                    arg = ModelUtil.intersectionType(firstArg, secondArg, unit);
                    if (!tp.isCovariant()) {
                        varianceOverrides.put(tp, SiteVariance.OUT);
                    }
                } else if (firstContra && secondInv) {
                    if (firstArg.isSubtypeOf(secondArg)) {
                        arg = secondArg;
                    } else {
                        if (!parameterized) return unit.getNothingType();
                        arg = unit.getUnknownType();
                    }
                } else if (firstCo && secondInv) {
                    if (secondArg.isSubtypeOf(firstArg)) {
                        arg = secondArg;
                    } else {
                        if (!parameterized) return unit.getNothingType();
                        arg = unit.getUnknownType();
                    }
                } else if (secondCo && firstInv) {
                    if (firstArg.isSubtypeOf(secondArg)) {
                        arg = firstArg;
                    } else {
                        if (!parameterized) return unit.getNothingType();
                        arg = unit.getUnknownType();
                    }
                } else if (secondContra && firstInv) {
                    if (secondArg.isSubtypeOf(firstArg)) {
                        arg = firstArg;
                    } else {
                        if (!parameterized) return unit.getNothingType();
                        arg = unit.getUnknownType();
                    }
                } else if (firstInv && secondInv) {
                    if (firstArg.isExactly(secondArg)) {
                        arg = firstArg;
                    } else {
                        if (!parameterized) return unit.getNothingType();
                        arg = unit.getUnknownType();
                    }
                } else {
                    arg = unit.getUnknownType();
                }
            }
            args.add(arg);
        }
        Type result = dec.appliedType(ModelUtil.principalQualifyingType(first, second, dec, unit), args);
        result.setVarianceOverrides(varianceOverrides);
        return result;
    }

    public static boolean areConsistentSupertypes(Type st1, Type st2, Unit unit) {
        List<TypeParameter> typeParameters = st1.getDeclaration().getTypeParameters();
        for (TypeParameter tp : typeParameters) {
            if (tp.isCovariant() || tp.isContravariant()) continue;
            Type ta1 = st1.getTypeArguments().get(tp);
            Type ta2 = st2.getTypeArguments().get(tp);
            if (ta1 == null || ta2 == null || ta1.isExactly(ta2)) continue;
            return false;
        }
        return !ModelUtil.intersectionType(st1, st2, unit).isNothing();
    }

    public static Type intersectionOfSupertypes(TypeDeclaration td) {
        Type extendedType = td.getExtendedType();
        List<Type> satisfiedTypes = td.getSatisfiedTypes();
        ArrayList<Type> list = new ArrayList<Type>(satisfiedTypes.size() + 1);
        if (extendedType != null) {
            list.add(extendedType);
        }
        list.addAll(satisfiedTypes);
        Unit unit = td.getUnit();
        IntersectionType it = new IntersectionType(unit);
        it.setSatisfiedTypes(list);
        return it.getType();
    }

    public static Type unionOfCaseTypes(TypeDeclaration td) {
        List<Type> caseTypes = td.getCaseTypes();
        Unit unit = td.getUnit();
        if (caseTypes == null) {
            return unit.getAnythingType();
        }
        ArrayList<Type> list = new ArrayList<Type>(caseTypes.size() + 1);
        list.addAll(caseTypes);
        UnionType it = new UnionType(unit);
        it.setCaseTypes(list);
        return it.getType();
    }

    public static int addHashForModule(int ret, Declaration decl) {
        Module module = ModelUtil.getModule(decl);
        return 37 * ret + (module != null ? module.hashCode() : 0);
    }

    public static boolean sameModule(Declaration a, Declaration b) {
        Module aMod = ModelUtil.getModule(a);
        Module bMod = ModelUtil.getModule(b);
        return aMod.equals(bMod);
    }

    public static void clearProducedTypeCache(TypeDeclaration decl) {
        Module module = ModelUtil.getModule(decl);
        if (module != null) {
            module.clearCache(decl);
        }
    }

    public static List<Declaration> getInterveningRefinements(String name, List<Type> signature, Declaration root, TypeDeclaration bottom, TypeDeclaration top) {
        boolean rootOverloaded = ModelUtil.isOverloadedVersion(root);
        ArrayList<Declaration> result = new ArrayList<Declaration>(2);
        for (TypeDeclaration std : bottom.getSupertypeDeclarations()) {
            boolean overloaded;
            TypeDeclaration td;
            Declaration refined;
            Declaration member;
            if (!std.inherits(top) || std.equals(bottom) || (member = std.getDirectMember(name, signature, false, rootOverloaded)) == null || !member.isShared() || ModelUtil.isAbstraction(member) || (refined = (td = (TypeDeclaration)member.getContainer()).getRefinedMember(name, signature, false, overloaded = rootOverloaded || ModelUtil.isOverloadedVersion(member))) == null || !refined.equals(root)) continue;
            result.add(member);
        }
        return result;
    }

    public static List<Declaration> getInheritedDeclarations(String name, TypeDeclaration bottom) {
        ArrayList<Declaration> result = new ArrayList<Declaration>(2);
        for (TypeDeclaration std : bottom.getSupertypeDeclarations()) {
            Declaration member;
            if (std.equals(bottom) || (member = std.getDirectMember(name, null, false)) == null || !member.isShared() || ModelUtil.isAbstraction(member)) continue;
            result.add(member);
        }
        return result;
    }

    public static boolean isToplevelClassConstructor(TypeDeclaration td, Declaration dec) {
        return td.isToplevel() && (dec instanceof Constructor || dec instanceof FunctionOrValue && ((FunctionOrValue)dec).getTypeDeclaration() instanceof Constructor);
    }

    public static boolean isToplevelAnonymousClass(Scope s) {
        if (s instanceof Class) {
            Class td = (Class)s;
            return td.isAnonymous() && td.isToplevel();
        }
        return false;
    }

    public static boolean isNativeHeader(Declaration dec) {
        return dec != null && dec.isNativeHeader();
    }

    public static boolean isNativeImplementation(Declaration dec) {
        return dec != null && dec.isNativeImplementation();
    }

    public static boolean isForBackend(Backends backends, Backend supported) {
        return ModelUtil.isForBackend(backends, supported.asSet());
    }

    public static boolean isForBackend(Backends backends, BackendSupport support) {
        return ModelUtil.isForBackend(backends, support.getSupportedBackends());
    }

    public static boolean isForBackend(Backends backends, Backends supported) {
        return backends.none() || supported.supports(backends);
    }

    public static List<Type> typeParametersAsArgList(Generic dec) {
        List<TypeParameter> params = dec.getTypeParameters();
        if (params.isEmpty()) {
            return NO_TYPE_ARGS;
        }
        int size = params.size();
        ArrayList<Type> paramsAsArgs = new ArrayList<Type>(size);
        for (int i = 0; i < size; ++i) {
            TypeParameter param = params.get(i);
            paramsAsArgs.add(param.getType());
        }
        return paramsAsArgs;
    }

    public static Declaration lookupMemberForBackend(List<Declaration> members, String name, Backends backends) {
        for (Declaration dec : members) {
            if (!ModelUtil.isResolvable(dec) || !ModelUtil.isNamed(name, dec)) continue;
            Backends bs = dec.getNativeBackends();
            if (bs.none()) {
                return dec;
            }
            if (!backends.supports(bs)) continue;
            return dec;
        }
        return null;
    }

    public static List<Declaration> lookupOverloadedByName(List<Declaration> members, String name) {
        List<Declaration> result = null;
        for (Declaration dec : members) {
            if (!ModelUtil.isResolvable(dec) || !ModelUtil.isNamed(name, dec)) continue;
            if (result == null) {
                result = new ArrayList<Declaration>(3);
            }
            result.add(dec);
        }
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public static Declaration getNativeHeader(Declaration dec) {
        return ModelUtil.getNativeDeclaration(dec, Backends.HEADER);
    }

    public static Declaration getNativeHeader(Scope container, String name) {
        return ModelUtil.getNativeDeclaration(container, name, Backends.HEADER);
    }

    public static Declaration getNativeDeclaration(Declaration dec, Backend backend) {
        return ModelUtil.getNativeDeclaration(dec, backend.asSet());
    }

    public static Declaration getNativeDeclaration(Declaration dec, Backends backends) {
        if (backends != null) {
            Declaration nat;
            if (dec.isNativeHeader() && !backends.header()) {
                nat = null;
                List<Declaration> overloads = dec.getOverloads();
                if (overloads != null) {
                    for (Declaration d : overloads) {
                        if ((!backends.none() || d.isNativeHeader()) && !backends.supports(d.getNativeBackends())) continue;
                        nat = d;
                        break;
                    }
                }
            } else {
                nat = ModelUtil.getNativeDeclaration(dec.getContainer(), dec.getName(), backends);
                if (dec instanceof Setter && nat instanceof Value) {
                    nat = ((Value)nat).getSetter();
                } else if (dec instanceof ClassOrInterface && nat instanceof Value) {
                    Value value = (Value)nat;
                    if (ModelUtil.isObject(value)) {
                        nat = value.getType().getDeclaration();
                    }
                } else if (dec instanceof Constructor && nat instanceof FunctionOrValue && ModelUtil.isConstructor(nat)) {
                    nat = ModelUtil.getConstructor(nat);
                }
            }
            return nat;
        }
        return dec;
    }

    public static Declaration getNativeDeclaration(Scope container, String name, Backends backends) {
        Declaration decl;
        Declaration c;
        if (container instanceof Declaration) {
            Declaration cd = (Declaration)((Object)container);
            if ((backends.header() && cd.isNativeImplementation() || !backends.header() && cd.isNativeHeader()) && (c = ModelUtil.getNativeDeclaration(cd.getContainer(), cd.getName(), backends)) != null) {
                Value v;
                if (c instanceof Value && ModelUtil.isObject(v = (Value)c)) {
                    c = v.getType().getDeclaration();
                    c = ModelUtil.getNativeDeclaration(c, backends);
                }
                container = c;
            }
        }
        if (container instanceof Class && name == null) {
            c = (Class)container;
            decl = c.getDefaultConstructorFunctionOrValue();
        } else {
            decl = container.getDirectMemberForBackend(name, backends);
        }
        return decl;
    }

    public static boolean isObject(Value value) {
        Type type = value.getType();
        return type != null && type.getDeclaration().isAnonymous();
    }

    public static boolean isImplemented(Declaration dec) {
        if (dec instanceof FunctionOrValue) {
            FunctionOrValue fov = (FunctionOrValue)dec;
            return fov.isImplemented();
        }
        if (dec instanceof Class) {
            Class coi = (Class)dec;
            if (dec.isNativeHeader()) {
                for (Declaration m : coi.getMembers()) {
                    if (ModelUtil.isImplemented(m)) continue;
                    return false;
                }
                return true;
            }
            return coi.isAbstract();
        }
        return dec instanceof Constructor || dec instanceof Interface;
    }

    public static boolean eq(Object decl, Object other) {
        if (decl == null) {
            return other == null;
        }
        return decl.equals(other);
    }

    public static boolean equal(Declaration decl, Declaration other) {
        if (decl instanceof UnionType || decl instanceof IntersectionType || other instanceof UnionType || other instanceof IntersectionType) {
            return false;
        }
        return ModelUtil.eq(decl, other);
    }

    public static boolean equalModules(Module scope, Module other) {
        return ModelUtil.eq(scope, other);
    }

    public static Module getModule(Declaration decl) {
        return decl.getUnit().getPackage().getModule();
    }

    public static Package getPackage(Declaration decl) {
        return decl.getUnit().getPackage();
    }

    public static Package getPackageContainer(Scope scope) {
        while (scope != null && !(scope instanceof Package)) {
            if (!(scope.getContainer() instanceof Scope)) {
                return null;
            }
            scope = scope.getContainer();
        }
        return (Package)scope;
    }

    public static Module getModuleContainer(Scope scope) {
        Package pkg = ModelUtil.getPackageContainer(scope);
        return pkg != null ? pkg.getModule() : null;
    }

    public static ClassOrInterface getClassOrInterfaceContainer(Element decl) {
        return ModelUtil.getClassOrInterfaceContainer(decl, true);
    }

    public static ClassOrInterface getClassOrInterfaceContainer(Element decl, boolean includingDecl) {
        if (!includingDecl) {
            if (!(decl.getContainer() instanceof Element)) {
                return null;
            }
            decl = (Element)((Object)decl.getContainer());
        }
        while (decl != null && !(decl instanceof ClassOrInterface)) {
            if (!(decl.getContainer() instanceof Element)) {
                return null;
            }
            decl = (Element)((Object)decl.getContainer());
        }
        return (ClassOrInterface)decl;
    }

    public static void setVisibleScope(Declaration model) {
        for (Scope s = model.getContainer(); s != null; s = s.getContainer()) {
            if (s instanceof Declaration) {
                if (model.isShared()) {
                    if (((Declaration)((Object)s)).isShared()) continue;
                    model.setVisibleScope(s.getContainer());
                    break;
                }
                model.setVisibleScope(s);
                break;
            }
            if (s instanceof Package) {
                if (model.isShared()) break;
                model.setVisibleScope(s);
                break;
            }
            model.setVisibleScope(s);
            break;
        }
    }

    public static boolean withinClassOrInterface(Declaration decl) {
        return decl.getContainer() instanceof ClassOrInterface;
    }

    public static boolean withinClass(Declaration decl) {
        return decl.getContainer() instanceof Class;
    }

    public static boolean isLocalToInitializer(Declaration decl) {
        return ModelUtil.withinClass(decl) && !ModelUtil.isCaptured(decl);
    }

    public static boolean isCaptured(Declaration decl) {
        return decl.isCaptured() || decl.isShared();
    }

    public static boolean isNonTransientValue(Declaration decl) {
        return decl instanceof Value && !((Value)decl).isTransient();
    }

    public static boolean isLocalNotInitializerScope(Scope scope) {
        return scope instanceof FunctionOrValue || scope instanceof Constructor || scope instanceof ControlBlock || scope instanceof NamedArgumentList || scope instanceof Specification;
    }

    public static boolean isLocalNotInitializer(Declaration decl) {
        return ModelUtil.isLocalNotInitializerScope(decl.getContainer());
    }

    public static boolean argumentSatisfiesEnumeratedConstraint(Type receiver, Declaration member, List<Type> typeArguments, Type argType, TypeParameter param) {
        List<Type> argCaseTypes;
        List<Type> caseTypes = param.getCaseTypes();
        if (caseTypes == null || caseTypes.isEmpty()) {
            return true;
        }
        for (Type ct : caseTypes) {
            Type cts = ct.appliedType(receiver, member, typeArguments, null);
            if (!argType.isSubtypeOf(cts)) continue;
            return true;
        }
        TypeDeclaration atd = argType.getDeclaration();
        if (argType.isTypeParameter() && (argCaseTypes = atd.getCaseTypes()) != null && !argCaseTypes.isEmpty()) {
            for (Type act : argCaseTypes) {
                boolean foundCase = false;
                for (Type ct : caseTypes) {
                    Type cts = ct.appliedType(receiver, member, typeArguments, null);
                    if (!act.isSubtypeOf(cts)) continue;
                    foundCase = true;
                    break;
                }
                if (foundCase) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isBooleanTrue(Declaration d) {
        return d != null && d.getQualifiedNameString().equals("ceylon.language::true");
    }

    public static boolean isBooleanFalse(Declaration d) {
        return d != null && d.getQualifiedNameString().equals("ceylon.language::false");
    }

    public static Type genericFunctionType(Generic generic, Scope scope, Declaration member, Reference reference, Unit unit) {
        List<TypeParameter> typeParameters = generic.getTypeParameters();
        TypeAlias ta = new TypeAlias();
        ta.setContainer(scope);
        ta.setName("Anonymous#" + member.getName());
        ta.setAnonymous(true);
        ta.setScope(scope);
        ta.setUnit(unit);
        ta.setExtendedType(reference.getFullType());
        ta.setTypeParameters(typeParameters);
        Type type = ta.getType();
        type.setTypeConstructor(true);
        return type;
    }

    public static boolean isConstructor(Declaration member) {
        if (member instanceof Constructor) {
            return true;
        }
        if (member instanceof FunctionOrValue) {
            FunctionOrValue fov = (FunctionOrValue)member;
            return fov.getTypeDeclaration() instanceof Constructor;
        }
        return false;
    }

    public static Constructor getConstructor(Declaration member) {
        if (member instanceof Constructor) {
            return (Constructor)member;
        }
        if (member instanceof FunctionOrValue) {
            FunctionOrValue fov = (FunctionOrValue)member;
            TypeDeclaration td = fov.getTypeDeclaration();
            if (td instanceof Constructor) {
                return (Constructor)td;
            }
            return null;
        }
        return null;
    }

    public static Class getConstructedClass(Declaration classOrCtor) {
        if (classOrCtor instanceof FunctionOrValue && ((FunctionOrValue)classOrCtor).getTypeDeclaration() instanceof Constructor) {
            classOrCtor = ((FunctionOrValue)classOrCtor).getTypeDeclaration();
        }
        if (classOrCtor instanceof Constructor) {
            return (Class)classOrCtor.getContainer();
        }
        if (classOrCtor instanceof Class) {
            return (Class)classOrCtor;
        }
        return null;
    }

    public static boolean isCeylonDeclaration(Declaration declaration) {
        if (declaration instanceof LazyElement) {
            LazyElement lazy = (LazyElement)((Object)declaration);
            return lazy.isCeylon();
        }
        return true;
    }

    public static boolean isEnumeratedConstructor(Constructor ctor) {
        return ctor != null && ctor.getParameterList() == null;
    }

    public static boolean isEnumeratedConstructor(Value value) {
        return value.getType().getDeclaration() instanceof Constructor;
    }
}

