/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.model.typechecker.model.Cancellable;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.DeclarationWithProximity;
import com.redhat.ceylon.model.typechecker.model.Element;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NamedArgumentList
extends Element
implements Scope {
    private ParameterList parameterList;
    private List<String> argumentNames = new ArrayList<String>();
    private int id;
    private List<Declaration> members = new ArrayList<Declaration>(3);

    @Override
    public boolean isToplevel() {
        return false;
    }

    @Override
    public List<Declaration> getMembers() {
        return this.members;
    }

    @Override
    public void addMember(Declaration declaration) {
        this.members.add(declaration);
    }

    public ParameterList getParameterList() {
        return this.parameterList;
    }

    public void setParameterList(ParameterList parameterList) {
        this.parameterList = parameterList;
    }

    @Override
    public Map<String, DeclarationWithProximity> getMatchingDeclarations(Unit unit, String startingWith, int proximity, Cancellable cancellable) {
        Map<String, DeclarationWithProximity> result = super.getMatchingDeclarations(unit, startingWith, proximity + 1, cancellable);
        if (this.getParameterList() != null) {
            for (Parameter p : this.getParameterList().getParameters()) {
                if (!p.getName().startsWith(startingWith) || this.getArgumentNames().contains(p.getName())) continue;
                result.put(p.getName(), new DeclarationWithProximity(p, this));
            }
        }
        return result;
    }

    public List<String> getArgumentNames() {
        return this.argumentNames;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int hashCode() {
        int ret = 17;
        ret = 31 * ret + this.getContainer().hashCode();
        ret = 31 * ret + this.id;
        return ret;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NamedArgumentList) {
            NamedArgumentList that = (NamedArgumentList)obj;
            return this.id == that.id && this.getContainer().equals(that.getContainer());
        }
        return false;
    }

    @Override
    public Backends getScopedBackends() {
        return this.getScope().getScopedBackends();
    }
}

