/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.model.typechecker.context.TypeCache;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedReference;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.UnknownType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Reference {
    private Map<TypeParameter, Type> typeArguments = ModelUtil.EMPTY_TYPE_ARG_MAP;
    private Type qualifyingType;
    private Map<TypeParameter, Type> typeArgumentsWithDefaults;

    Reference() {
    }

    public Type getQualifyingType() {
        return this.qualifyingType;
    }

    void setQualifyingType(Type qualifyingType) {
        this.qualifyingType = qualifyingType;
    }

    public abstract Declaration getDeclaration();

    public Map<TypeParameter, Type> getTypeArguments() {
        Declaration declaration = this.getDeclaration();
        if (declaration instanceof Generic) {
            if (TypeCache.isEnabled()) {
                if (this.typeArgumentsWithDefaults == null) {
                    this.typeArgumentsWithDefaults = this.getTypeArgumentsInternal(declaration);
                }
                return this.typeArgumentsWithDefaults;
            }
            return this.getTypeArgumentsInternal(declaration);
        }
        return this.typeArguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<TypeParameter, Type> getTypeArgumentsInternal(Declaration declaration) {
        Type.checkDepth();
        Type.incDepth();
        try {
            Map<TypeParameter, Type> map = Reference.fillInDefaultTypeArguments(declaration, this.typeArguments);
            return map;
        }
        finally {
            Type.decDepth();
        }
    }

    private static Map<TypeParameter, Type> fillInDefaultTypeArguments(Declaration declaration, Map<TypeParameter, Type> typeArguments) {
        Map<TypeParameter, Type> typeArgs = typeArguments;
        Generic g = (Generic)((Object)declaration);
        List<TypeParameter> typeParameters = g.getTypeParameters();
        int l = typeParameters.size();
        for (int i = 0; i < l; ++i) {
            TypeParameter tp = typeParameters.get(i);
            Type dta = tp.getDefaultTypeArgument();
            if (dta == null || typeArguments.containsKey(tp)) continue;
            if (typeArguments == typeArgs) {
                typeArgs = new HashMap<TypeParameter, Type>(typeParameters.size());
                typeArgs.putAll(typeArguments);
            }
            typeArgs.put(tp, dta.substitute(typeArgs, ModelUtil.EMPTY_VARIANCE_MAP));
        }
        return typeArgs;
    }

    void setTypeArguments(Map<TypeParameter, Type> typeArguments) {
        this.typeArguments = typeArguments;
    }

    public abstract Type getType();

    public Type getFullType() {
        return this.getFullType(this.getType());
    }

    public Type getFullType(Type wrappedType) {
        Declaration declaration = this.getDeclaration();
        if (declaration instanceof Functional) {
            Unit unit = declaration.getUnit();
            if (ModelUtil.isAbstraction(declaration)) {
                return ModelUtil.appliedType((TypeDeclaration)unit.getCallableDeclaration(), wrappedType, new UnknownType(unit).getType());
            }
            return unit.getCallableType(this, wrappedType);
        }
        return wrappedType;
    }

    public boolean isFunctional() {
        return this.getDeclaration() instanceof Functional;
    }

    public TypedReference getTypedParameter(Parameter p) {
        TypedReference ptr = new TypedReference(false, true);
        FunctionOrValue model = p.getModel();
        if (model != null) {
            ptr.setDeclaration(model);
        }
        ptr.setQualifyingType(this.getQualifyingType());
        ptr.setTypeArguments(this.getTypeArguments());
        return ptr;
    }

    public abstract String asString();
}

