/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.model.loader.model.FunctionOrValueInterface;
import com.redhat.ceylon.model.typechecker.context.TypeCache;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.DecidabilityException;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.IntersectionType;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.NothingType;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.SiteVariance;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedReference;
import com.redhat.ceylon.model.typechecker.model.UnionType;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.UnknownType;
import com.redhat.ceylon.model.typechecker.util.TypePrinter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Type
extends Reference {
    private TypeDeclaration declaration;
    private String underlyingType;
    private boolean isRaw;
    private Type resolvedAliases;
    private TypeParameter typeConstructorParameter;
    private boolean typeConstructor;
    private int hashCode;
    private Map<TypeParameter, SiteVariance> varianceOverrides = ModelUtil.EMPTY_VARIANCE_MAP;
    private int exactlyNothing;
    private static ThreadLocal<Integer> depth = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public Map<TypeParameter, SiteVariance> getVarianceOverrides() {
        return this.varianceOverrides;
    }

    public boolean isCovariant(TypeParameter param) {
        SiteVariance override = this.varianceOverrides.get(param);
        if (override == null) {
            return param.isCovariant();
        }
        return override == SiteVariance.OUT;
    }

    public boolean isContravariant(TypeParameter param) {
        SiteVariance override = this.varianceOverrides.get(param);
        if (override == null) {
            return param.isContravariant();
        }
        return override == SiteVariance.IN;
    }

    public boolean isInvariant(TypeParameter param) {
        SiteVariance override = this.varianceOverrides.get(param);
        if (override == null) {
            return param.isInvariant();
        }
        return false;
    }

    public void setVariance(TypeParameter param, SiteVariance variance) {
        if (this.varianceOverrides.isEmpty()) {
            this.varianceOverrides = new HashMap<TypeParameter, SiteVariance>();
        }
        this.varianceOverrides.put(param, variance);
    }

    public void setVarianceOverrides(Map<TypeParameter, SiteVariance> varianceOverrides) {
        this.varianceOverrides = varianceOverrides;
    }

    Type() {
    }

    @Override
    public TypeDeclaration getDeclaration() {
        return this.declaration;
    }

    void setDeclaration(TypeDeclaration declaration) {
        this.declaration = declaration;
    }

    public boolean isTypeConstructor() {
        return this.typeConstructor;
    }

    public TypeParameter getTypeConstructorParameter() {
        return this.typeConstructorParameter;
    }

    public void setTypeConstructor(boolean typeConstructor) {
        this.typeConstructor = typeConstructor;
    }

    public void setTypeConstructorParameter(TypeParameter typeConstructorParameter) {
        this.typeConstructorParameter = typeConstructorParameter;
    }

    public boolean isExactlyNothing() {
        if (this.isNothing()) {
            return true;
        }
        if (this.exactlyNothing == 0) {
            this.exactlyNothing = this.isEmptySequenceType() || this.isEmptyTupleType() ? 1 : -1;
        }
        return this.exactlyNothing > 0;
    }

    public boolean isExactly(Type type) {
        return type != null && this.resolveAliases().isExactlyInternal(type.resolveAliases());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExactlyInternal(Type type) {
        Type.checkDepth();
        Type.incDepth();
        try {
            if (this.isUnknown() || type.isUnknown()) {
                boolean bl = this == type;
                return bl;
            }
            if (this.isAnything()) {
                boolean bl = type.isAnything();
                return bl;
            }
            if (type.isAnything()) {
                boolean bl = this.isAnything();
                return bl;
            }
            if (this.isExactlyNothing()) {
                boolean bl = type.isExactlyNothing();
                return bl;
            }
            if (type.isExactlyNothing()) {
                boolean bl = this.isExactlyNothing();
                return bl;
            }
            if (this.isUnion()) {
                List<Type> cases = this.getCaseTypes();
                if (type.isUnion()) {
                    List<Type> otherCases = type.getCaseTypes();
                    if (cases.size() != otherCases.size()) {
                        boolean bl = false;
                        return bl;
                    }
                    for (Type c : cases) {
                        boolean found = false;
                        for (Type oc : otherCases) {
                            if (!c.isExactlyInternal(oc)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        boolean i$ = false;
                        return i$;
                    }
                    boolean i$ = true;
                    return i$;
                }
                if (cases.size() == 1) {
                    Type st = cases.get(0);
                    boolean i$ = st.isExactlyInternal(type);
                    return i$;
                }
                boolean st = false;
                return st;
            }
            if (this.isIntersection()) {
                List<Type> types = this.getSatisfiedTypes();
                if (type.isIntersection()) {
                    List<Type> otherTypes = type.getSatisfiedTypes();
                    if (types.size() != otherTypes.size()) {
                        boolean i$ = false;
                        return i$;
                    }
                    for (Type c : types) {
                        boolean found = false;
                        TypeDeclaration cd = c.getDeclaration();
                        for (Type oc : otherTypes) {
                            Type ocst;
                            TypeDeclaration ocd = oc.getDeclaration();
                            if (!cd.equals(ocd)) continue;
                            if (c.isExactlyInternal(oc)) {
                                found = true;
                                break;
                            }
                            Type cst = this.getSupertype(cd);
                            if (!cst.isExactly(ocst = type.getSupertype(ocd))) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        boolean i$ = false;
                        return i$;
                    }
                    boolean i$ = true;
                    return i$;
                }
                if (types.size() == 1) {
                    Type st = types.get(0);
                    boolean i$ = st.isExactlyInternal(type);
                    return i$;
                }
                boolean st = false;
                return st;
            }
            if (type.isUnion()) {
                List<Type> otherCases = type.getCaseTypes();
                if (otherCases.size() == 1) {
                    Type st = otherCases.get(0);
                    boolean i$ = this.isExactlyInternal(st);
                    return i$;
                }
                boolean st = false;
                return st;
            }
            if (type.isIntersection()) {
                List<Type> otherTypes = type.getSatisfiedTypes();
                if (otherTypes.size() == 1) {
                    Type st = otherTypes.get(0);
                    boolean i$ = this.isExactlyInternal(st);
                    return i$;
                }
                boolean st = false;
                return st;
            }
            if (this.isObject()) {
                boolean otherTypes = type.isObject();
                return otherTypes;
            }
            if (type.isObject()) {
                boolean otherTypes = this.isObject();
                return otherTypes;
            }
            if (this.isNull()) {
                boolean otherTypes = type.isNull();
                return otherTypes;
            }
            if (type.isNull()) {
                boolean otherTypes = this.isNull();
                return otherTypes;
            }
            if (type.isClass() != this.isClass() || type.isInterface() != this.isInterface() || type.isTypeParameter() != this.isTypeParameter()) {
                boolean otherTypes = false;
                return otherTypes;
            }
            if (this.isTypeConstructor() && type.isTypeConstructor()) {
                boolean otherTypes = this.isExactlyTypeConstructor(type);
                return otherTypes;
            }
            if (this.isTypeConstructor() || type.isTypeConstructor()) {
                boolean otherTypes = false;
                return otherTypes;
            }
            TypeDeclaration dec = this.getDeclaration();
            TypeDeclaration otherDec = type.getDeclaration();
            if (!otherDec.equals(dec)) {
                boolean i$ = false;
                return i$;
            }
            if (this.isTuple()) {
                boolean i$ = this.isExactlyTuple(type);
                return i$;
            }
            Type qt = this.trueQualifyingType();
            Type tqt = type.trueQualifyingType();
            if (qt == null || tqt == null) {
                if (qt != tqt) {
                    boolean found = false;
                    return found;
                }
            } else {
                if (qt.isUnknown() || tqt.isUnknown()) {
                    boolean found = false;
                    return found;
                }
                Scope odc = otherDec.getContainer();
                Scope dc = dec.getContainer();
                if (!(odc instanceof TypeDeclaration) || !(dc instanceof TypeDeclaration)) {
                    if (odc instanceof TypeDeclaration || dc instanceof TypeDeclaration) {
                        boolean i$ = false;
                        return i$;
                    }
                    if (!odc.equals(dc)) {
                        boolean i$ = false;
                        return i$;
                    }
                    if (!tqt.isExactlyInternal(qt)) {
                        boolean i$ = false;
                        return i$;
                    }
                } else {
                    TypeDeclaration totd = (TypeDeclaration)odc;
                    Type tqts = tqt.getSupertype(totd);
                    TypeDeclaration otd = (TypeDeclaration)dc;
                    Type qts = qt.getSupertype(otd);
                    if (!qts.isExactly(tqts)) {
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            boolean bl = this.isTypeArgumentListExactly(type);
            return bl;
        }
        finally {
            Type.decDepth();
        }
    }

    private boolean isEmptySequenceType() {
        Unit unit = this.getDeclaration().getUnit();
        if (unit.isSequenceType(this)) {
            Type et = unit.getSequentialElementType(this);
            return et != null && et.isExactlyNothing();
        }
        return false;
    }

    private boolean isEmptyTupleType() {
        Unit unit = this.getDeclaration().getUnit();
        if (unit.isTupleType(this)) {
            Type rest;
            Type first;
            Type elem;
            List<Type> tal = this.getTypeArgumentList();
            if (tal.size() >= 1 && (elem = tal.get(0)) != null && elem.isExactlyNothing()) {
                return true;
            }
            if (tal.size() >= 2 && (first = tal.get(1)) != null && first.isExactlyNothing()) {
                return true;
            }
            if (tal.size() >= 3 && (rest = tal.get(2)) != null && rest.isExactlyNothing()) {
                return true;
            }
        }
        return false;
    }

    private boolean isExactlyTuple(Type type) {
        Class td = this.getDeclaration().getUnit().getTupleDeclaration();
        TypeParameter elem = ((TypeDeclaration)td).getTypeParameters().get(0);
        TypeParameter first = ((TypeDeclaration)td).getTypeParameters().get(1);
        TypeParameter rest = ((TypeDeclaration)td).getTypeParameters().get(2);
        Type t1 = this;
        Type t2 = type;
        while (true) {
            Map<TypeParameter, Type> t1a = t1.getTypeArguments();
            Map<TypeParameter, Type> t2a = t2.getTypeArguments();
            Type e1 = t1a.get(elem);
            Type e2 = t2a.get(elem);
            Type f1 = t1a.get(first);
            Type f2 = t2a.get(first);
            if (e1 == null || e2 == null || f1 == null || f2 == null) {
                return false;
            }
            if (!f1.isExactlyInternal(f2) || !e1.isExactlyInternal(e2)) {
                return false;
            }
            Type r1 = t1a.get(rest);
            Type r2 = t2a.get(rest);
            if (r1 == null || r2 == null) {
                return false;
            }
            if (!r1.isTuple() || !r2.isTuple()) {
                return r1.isExactlyInternal(r2);
            }
            t1 = r1;
            t2 = r2;
        }
    }

    private boolean isTypeArgumentListExactly(Type type) {
        List<TypeParameter> typeParameters = this.getDeclaration().getTypeParameters();
        for (TypeParameter p : typeParameters) {
            boolean otherInvariant;
            Type arg = this.getTypeArguments().get(p);
            Type otherArg = type.getTypeArguments().get(p);
            if (arg == null || otherArg == null) {
                return false;
            }
            boolean contravariant = this.isContravariant(p);
            boolean covariant = this.isCovariant(p);
            boolean invariant = !covariant && !contravariant;
            boolean otherCovariant = type.isCovariant(p);
            boolean otherContravariant = type.isContravariant(p);
            boolean bl = otherInvariant = !otherCovariant && !otherContravariant;
            if (!(contravariant && otherCovariant ? !arg.isNothing() || !ModelUtil.intersectionOfSupertypes(p).isSubtypeOf(otherArg) : (covariant && otherContravariant ? !otherArg.isNothing() || !ModelUtil.intersectionOfSupertypes(p).isSubtypeOf(arg) : (contravariant && otherInvariant || invariant && otherContravariant ? !arg.isAnything() || !otherArg.isAnything() : (covariant && otherInvariant || invariant && otherCovariant ? !arg.isNothing() || !otherArg.isNothing() : !arg.isExactlyInternal(otherArg)))))) continue;
            return false;
        }
        return true;
    }

    public boolean isSupertypeOf(Type type) {
        return type.isSubtypeOf(this);
    }

    public boolean isSubtypeOf(Type type) {
        return type != null && this.resolveAliases().isSubtypeOfInternal(type.resolveAliases());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSubtypeOfInternal(Type type) {
        Type.checkDepth();
        Type.incDepth();
        try {
            if (type.isAnything()) {
                boolean bl = true;
                return bl;
            }
            if (this.isExactlyNothing()) {
                boolean bl = true;
                return bl;
            }
            if (this.isUnknown() || type.isUnknown()) {
                boolean bl = this == type;
                return bl;
            }
            if (this.isAnything()) {
                boolean bl = false;
                return bl;
            }
            if (type.isExactlyNothing()) {
                boolean bl = this.isExactlyNothing();
                return bl;
            }
            if (this.isUnion()) {
                for (Type ct : this.getInternalCaseTypes()) {
                    if (ct != null && ct.isSubtypeOfInternal(type)) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean i$ = true;
                return i$;
            }
            if (type.isUnion()) {
                for (Type ct : type.getInternalCaseTypes()) {
                    if (ct == null || !this.isSubtypeOfInternal(ct)) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean i$ = false;
                return i$;
            }
            if (type.isIntersection()) {
                for (Type ct : type.getInternalSatisfiedTypes()) {
                    if (ct == null || this.isSubtypeOfInternal(ct)) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean i$ = true;
                return i$;
            }
            if (this.isIntersection()) {
                TypeDeclaration otherDec;
                Type pst;
                if (type.isClassOrInterface() && (pst = this.getSupertype(otherDec = type.getDeclaration())) != null && pst.isSubtypeOfInternal(type)) {
                    boolean bl = true;
                    return bl;
                }
                for (Type ct : this.getInternalSatisfiedTypes()) {
                    if (ct != null && !ct.isSubtypeOfInternal(type)) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean i$ = false;
                return i$;
            }
            if (this.isTypeConstructor() && type.isTypeConstructor()) {
                boolean i$ = this.isSubtypeOfTypeConstructor(type);
                return i$;
            }
            if (this.isTypeConstructor()) {
                boolean i$ = type.isAnything() || type.isObject();
                return i$;
            }
            if (type.isTypeConstructor()) {
                boolean i$ = false;
                return i$;
            }
            if (this.isObject()) {
                boolean i$ = type.isObject();
                return i$;
            }
            if (this.isNull()) {
                boolean i$ = type.isNull();
                return i$;
            }
            if (this.isInterface() && type.isClass()) {
                boolean i$ = type.isObject();
                return i$;
            }
            if (this.isTuple() && type.isTuple()) {
                boolean i$ = this.isSubtypeOfTuple(type);
                return i$;
            }
            TypeDeclaration otherDec = type.getDeclaration();
            Type supertype = this.getSupertype(otherDec);
            if (supertype == null) {
                boolean bl = false;
                return bl;
            }
            supertype = supertype.resolveAliases();
            Type stqt = supertype.trueQualifyingType();
            Type tqt = type.trueQualifyingType();
            if (stqt == null || tqt == null) {
                if (tqt != stqt) {
                    boolean bl = false;
                    return bl;
                }
            } else {
                if (tqt.isUnknown() || stqt.isUnknown()) {
                    boolean bl = false;
                    return bl;
                }
                if (!otherDec.isMember()) {
                    if (!stqt.isSubtypeOfInternal(tqt)) {
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    TypeDeclaration totd = (TypeDeclaration)otherDec.getContainer();
                    Type tqts = tqt.getSupertype(totd);
                    if (tqts == null) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!stqt.isSubtypeOfInternal(tqts = tqts.resolveAliases())) {
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            boolean bl = Type.isTypeArgumentListAssignable(supertype, type);
            return bl;
        }
        finally {
            Type.decDepth();
        }
    }

    private boolean isSubtypeOfTuple(Type type) {
        Class td = this.getDeclaration().getUnit().getTupleDeclaration();
        TypeParameter elem = ((TypeDeclaration)td).getTypeParameters().get(0);
        TypeParameter first = ((TypeDeclaration)td).getTypeParameters().get(1);
        TypeParameter rest = ((TypeDeclaration)td).getTypeParameters().get(2);
        Type t1 = this;
        Type t2 = type;
        while (true) {
            Map<TypeParameter, Type> t1a = t1.getTypeArguments();
            Map<TypeParameter, Type> t2a = t2.getTypeArguments();
            Type e1 = t1a.get(elem);
            Type e2 = t2a.get(elem);
            Type f1 = t1a.get(first);
            Type f2 = t2a.get(first);
            if (e1 == null || e2 == null || f1 == null || f2 == null) {
                return false;
            }
            if (!f1.isSubtypeOfInternal(f2) || !e1.isSubtypeOfInternal(e2)) {
                return false;
            }
            Type r1 = t1a.get(rest);
            Type r2 = t2a.get(rest);
            if (r1 == null || r2 == null) {
                return false;
            }
            if (!r1.isTuple() || !r2.isTuple()) {
                return r1.isSubtypeOfInternal(r2);
            }
            t1 = r1;
            t2 = r2;
        }
    }

    private static boolean isTypeArgumentListAssignable(Type supertype, Type type) {
        List<TypeParameter> typeParameters = type.getDeclaration().getTypeParameters();
        for (TypeParameter tp : typeParameters) {
            Type arg = supertype.getTypeArguments().get(tp);
            Type otherArg = type.getTypeArguments().get(tp);
            if (arg == null || otherArg == null) {
                return false;
            }
            if (!(type.isCovariant(tp) ? (supertype.isContravariant(tp) ? !tp.getType().isSubtypeOf(otherArg) : !arg.isSubtypeOfInternal(otherArg)) : (type.isContravariant(tp) ? (supertype.isCovariant(tp) ? !otherArg.isNothing() : !otherArg.isSubtypeOfInternal(arg)) : supertype.isCovariant(tp) && !arg.isNothing() || supertype.isContravariant(tp) && !arg.isAnything() || !arg.isExactlyInternal(otherArg)))) continue;
            return false;
        }
        return true;
    }

    private Type trueQualifyingType() {
        return this.getDeclaration().isStaticallyImportable() ? null : this.getQualifyingType();
    }

    private boolean isExactlyTypeConstructor(Type type) {
        TypeDeclaration otherDec;
        TypeDeclaration dec = this.getDeclaration();
        if (dec.equals(otherDec = type.getDeclaration())) {
            return true;
        }
        TypeParameter typeConstructorParam = this.getTypeConstructorParameter();
        Type qualifyingType = this.getQualifyingType();
        Type otherQualifyingType = type.getQualifyingType();
        if (typeConstructorParam == null) {
            Type otherAppliedType;
            List<Type> paramsAsArgs = ModelUtil.typeParametersAsArgList(otherDec);
            Type appliedType = dec.appliedType(qualifyingType, paramsAsArgs);
            return appliedType.isExactly(otherAppliedType = otherDec.appliedType(otherQualifyingType, paramsAsArgs)) && this.hasExactSameUpperBounds(type, paramsAsArgs);
        }
        List<Type> paramsAsArgs = ModelUtil.typeParametersAsArgList(typeConstructorParam);
        Type appliedType = dec.appliedType(qualifyingType, paramsAsArgs);
        Type otherAppliedType = otherDec.appliedType(otherQualifyingType, paramsAsArgs);
        return appliedType.isExactly(otherAppliedType);
    }

    private boolean isSubtypeOfTypeConstructor(Type type) {
        TypeDeclaration otherDec;
        TypeDeclaration dec = this.getDeclaration();
        if (dec.equals(otherDec = type.getDeclaration())) {
            return true;
        }
        Type qualifyingType = this.getQualifyingType();
        Type otherQualifyingType = type.getQualifyingType();
        TypeParameter typeConstructorParam = this.getTypeConstructorParameter();
        if (typeConstructorParam == null) {
            Type otherAppliedType;
            List<Type> paramsAsArgs = ModelUtil.typeParametersAsArgList(otherDec);
            Type appliedType = dec.appliedType(qualifyingType, paramsAsArgs);
            return appliedType.isSubtypeOf(otherAppliedType = otherDec.appliedType(otherQualifyingType, paramsAsArgs)) && this.acceptsUpperBounds(type, paramsAsArgs);
        }
        List<Type> paramsAsArgs = ModelUtil.typeParametersAsArgList(typeConstructorParam);
        Type appliedType = dec.appliedType(qualifyingType, paramsAsArgs);
        Type otherAppliedType = otherDec.appliedType(otherQualifyingType, paramsAsArgs);
        return appliedType.isSubtypeOf(otherAppliedType);
    }

    private boolean acceptsUpperBounds(Type type, List<Type> paramsAsArgs) {
        TypeParameter param;
        int i;
        int otherSize;
        TypeDeclaration declaration = this.getDeclaration();
        TypeDeclaration otherDeclaration = type.getDeclaration();
        List<TypeParameter> typeParameters = declaration.getTypeParameters();
        List<TypeParameter> otherTypeParameters = otherDeclaration.getTypeParameters();
        int size = typeParameters.size();
        if (size < (otherSize = otherTypeParameters.size())) {
            return false;
        }
        int required = 0;
        for (i = 0; i < size && !(param = typeParameters.get(i)).isDefaulted(); ++i) {
            ++required;
        }
        if (required > otherSize) {
            return false;
        }
        for (i = 0; i < size && i < otherSize; ++i) {
            Type enumBound;
            Type bound;
            param = typeParameters.get(i);
            TypeParameter otherParam = otherTypeParameters.get(i);
            Map<TypeParameter, Type> otherArgs = ModelUtil.getTypeArgumentMap(otherDeclaration, null, paramsAsArgs);
            Map<TypeParameter, Type> args = ModelUtil.getTypeArgumentMap(declaration, null, paramsAsArgs);
            Map<TypeParameter, SiteVariance> none = ModelUtil.EMPTY_VARIANCE_MAP;
            Type otherBound = ModelUtil.intersectionOfSupertypes(otherParam).substitute(otherArgs, none);
            if (!otherBound.isSubtypeOf(bound = ModelUtil.intersectionOfSupertypes(param).substitute(args, none))) {
                return false;
            }
            Type otherEnumBound = ModelUtil.unionOfCaseTypes(otherParam).substitute(otherArgs, none);
            if (otherEnumBound.isSubtypeOf(enumBound = ModelUtil.unionOfCaseTypes(param).substitute(args, none))) continue;
            return false;
        }
        return true;
    }

    private boolean hasExactSameUpperBounds(Type type, List<Type> paramsAsArgs) {
        TypeParameter param;
        int i;
        int otherSize;
        TypeDeclaration declaration = this.getDeclaration();
        TypeDeclaration otherDeclaration = type.getDeclaration();
        List<TypeParameter> typeParameters = declaration.getTypeParameters();
        List<TypeParameter> otherTypeParameters = otherDeclaration.getTypeParameters();
        int size = typeParameters.size();
        if (size != (otherSize = otherTypeParameters.size())) {
            return false;
        }
        int required = 0;
        int otherRequired = 0;
        for (i = 0; i < size && !(param = typeParameters.get(i)).isDefaulted(); ++i) {
            ++required;
        }
        for (i = 0; i < otherSize && !(param = otherTypeParameters.get(i)).isDefaulted(); ++i) {
            ++otherRequired;
        }
        if (required != otherRequired) {
            return false;
        }
        for (i = 0; i < size && i < otherSize; ++i) {
            Type enumBound;
            Type bound;
            param = typeParameters.get(i);
            TypeParameter otherParam = otherTypeParameters.get(i);
            Map<TypeParameter, Type> otherArgs = ModelUtil.getTypeArgumentMap(otherDeclaration, null, paramsAsArgs);
            Map<TypeParameter, Type> args = ModelUtil.getTypeArgumentMap(declaration, null, paramsAsArgs);
            Map<TypeParameter, SiteVariance> none = ModelUtil.EMPTY_VARIANCE_MAP;
            Type otherBound = ModelUtil.intersectionOfSupertypes(otherParam).substitute(otherArgs, none);
            if (!otherBound.isExactly(bound = ModelUtil.intersectionOfSupertypes(param).substitute(args, none))) {
                return false;
            }
            Type otherEnumBound = ModelUtil.unionOfCaseTypes(otherParam).substitute(otherArgs, none);
            if (otherEnumBound.isExactly(enumBound = ModelUtil.unionOfCaseTypes(param).substitute(args, none))) continue;
            return false;
        }
        return true;
    }

    public Type minus(Type pt) {
        return this.resolveAliases().minusInternal(pt.resolveAliases());
    }

    public Type eliminateNull() {
        Unit unit;
        TypeDeclaration dec = this.getDeclaration();
        if (dec.inherits((unit = dec.getUnit()).getNullDeclaration())) {
            return unit.getNothingType();
        }
        if (this.isUnion()) {
            List<Type> caseTypes = this.getCaseTypes();
            ArrayList<Type> types = new ArrayList<Type>(caseTypes.size());
            for (Type ct : caseTypes) {
                ModelUtil.addToUnion(types, ct.eliminateNull());
            }
            return ModelUtil.union(types, unit);
        }
        return this;
    }

    public Type shallowMinus(Type pt) {
        TypeDeclaration dec = this.getDeclaration();
        Unit unit = dec.getUnit();
        if (this.isSubtypeOf(pt)) {
            return unit.getNothingType();
        }
        if (this.isUnion()) {
            List<Type> caseTypes = this.getCaseTypes();
            ArrayList<Type> types = new ArrayList<Type>(caseTypes.size());
            for (Type ct : caseTypes) {
                ModelUtil.addToUnion(types, ct.shallowMinus(pt));
            }
            return ModelUtil.union(types, unit);
        }
        return this;
    }

    private Type minusInternal(Type pt) {
        TypeDeclaration dec = this.getDeclaration();
        Unit unit = dec.getUnit();
        if (pt.coversInternal(this)) {
            return unit.getNothingType();
        }
        Type ucts = this.getUnionOfCases();
        if (ucts.isUnion()) {
            List<Type> cts = ucts.getCaseTypes();
            ArrayList<Type> types = new ArrayList<Type>(cts.size());
            for (Type ct : cts) {
                ModelUtil.addToUnion(types, ct.minus(pt));
            }
            Type type = ModelUtil.union(types, unit);
            return type.coversInternal(this) ? this : type;
        }
        if (this.isIntersection()) {
            List<Type> cts = ucts.getSatisfiedTypes();
            ArrayList<Type> types = new ArrayList<Type>(cts.size());
            for (Type ct : cts) {
                ModelUtil.addToIntersection(types, ct.minus(pt), unit);
            }
            Type type = ModelUtil.canonicalIntersection(types, unit);
            return type.coversInternal(this) ? this : type;
        }
        if (this.isTypeParameter()) {
            Type upperBoundsMinus = ModelUtil.intersectionOfSupertypes(dec).minusInternal(pt);
            Type type = ModelUtil.intersectionType(upperBoundsMinus, this, unit);
            return type.coversInternal(this) ? this : type;
        }
        return this;
    }

    public Type substitute(Type source) {
        return this.substitute(source.getTypeArguments(), source.getVarianceOverrides());
    }

    public Type substitute(TypedReference source) {
        Type receiver = source.getQualifyingType();
        return this.substitute(source.getTypeArguments(), receiver == null ? null : receiver.collectVarianceOverrides(), source.isCovariant(), source.isContravariant());
    }

    public Type substitute(Map<TypeParameter, Type> substitutions, Map<TypeParameter, SiteVariance> overrides) {
        return this.substitute(substitutions, overrides, true, false);
    }

    private Type substitute(Map<TypeParameter, Type> substitutions, Map<TypeParameter, SiteVariance> overrides, boolean covariant, boolean contravariant) {
        if (!substitutions.isEmpty()) {
            Type type = this;
            if (overrides != null) {
                type = Type.applyVarianceOverrides(this, covariant, contravariant, overrides);
            }
            return new Substitution(substitutions, overrides).substitute(type, covariant, contravariant);
        }
        return this;
    }

    private Type substituteFromSubtype(Type source) {
        return this.substituteFromSubtype(source.getTypeArguments(), source.getVarianceOverrides());
    }

    private Type substituteFromSubtype(Map<TypeParameter, Type> substitutions, Map<TypeParameter, SiteVariance> overrides) {
        if (!substitutions.isEmpty()) {
            Type type = this;
            if (overrides != null) {
                type = Type.applyVarianceOverrides(this, true, false, overrides);
            }
            return new SupertypeSubstitution(substitutions, overrides).substitute(type, true, false);
        }
        return this;
    }

    public Reference getTypedReference(Declaration member, List<Type> typeArguments) {
        if (member instanceof TypeDeclaration) {
            TypeDeclaration td = (TypeDeclaration)member;
            return this.getTypeMember(td, typeArguments);
        }
        TypedDeclaration td = (TypedDeclaration)member;
        return this.getTypedMember(td, typeArguments);
    }

    public TypedReference getTypedMember(TypedDeclaration member, List<Type> typeArguments) {
        return this.getTypedMember(member, typeArguments, false);
    }

    public TypedReference getTypedMember(TypedDeclaration member, List<Type> typeArguments, boolean assigned) {
        TypeDeclaration type = (TypeDeclaration)member.getContainer();
        Type declaringType = this.getSupertype(type);
        TypedReference ptr = new TypedReference(!assigned, assigned);
        ptr.setDeclaration(member);
        ptr.setQualifyingType(declaringType);
        Map<TypeParameter, Type> map = ModelUtil.getTypeArgumentMap(member, declaringType, typeArguments);
        ptr.setTypeArguments(map);
        return ptr;
    }

    public Type getTypeMember(TypeDeclaration member, List<Type> typeArguments) {
        TypeDeclaration type = (TypeDeclaration)member.getContainer();
        Type declaringType = this.getSupertype(type);
        return member.appliedType(declaringType, typeArguments);
    }

    public Type appliedType(Type receiver, Declaration member, List<Type> typeArguments, List<SiteVariance> variances) {
        Type receivingType;
        if (receiver == null) {
            receivingType = null;
        } else {
            TypeDeclaration type = (TypeDeclaration)member.getContainer();
            receivingType = receiver.getSupertype(type);
        }
        Map<TypeParameter, Type> typeArgMap = ModelUtil.getTypeArgumentMap(member, receivingType, typeArguments);
        Map<TypeParameter, SiteVariance> varianceMap = ModelUtil.getVarianceMap(member, receivingType, variances);
        return new Substitution(typeArgMap, varianceMap).substitute(this, true, false);
    }

    @Override
    public Type getType() {
        return this;
    }

    public List<Type> getSupertypes() {
        if (this.isUnion() || this.isNothing()) {
            throw new UnsupportedOperationException("getSupertypes() not defined for union types or Nothing");
        }
        return this.getSupertypes(new ArrayList<Type>(5));
    }

    private List<Type> getSupertypes(List<Type> list) {
        if (this.isWellDefined() && Type.addToSupertypes(this, list)) {
            Type extendedType = this.getExtendedType();
            if (extendedType != null && !extendedType.isNothing() && !extendedType.isUnion()) {
                extendedType.getSupertypes(list);
            }
            List<Type> satisfiedTypes = this.getSatisfiedTypes();
            int l = satisfiedTypes.size();
            for (int i = 0; i < l; ++i) {
                Type satisfiedType = satisfiedTypes.get(i);
                if (satisfiedType == null || satisfiedType.isNothing() || satisfiedType.isUnion()) continue;
                satisfiedType.getSupertypes(list);
            }
        }
        return list;
    }

    private static boolean addToSupertypes(Type st, List<Type> list) {
        for (Type et : list) {
            TypeDeclaration etd;
            TypeDeclaration std = st.getDeclaration();
            if (!std.equals(etd = et.getDeclaration()) || !st.isExactlyInternal(et)) continue;
            return false;
        }
        list.add(st);
        return true;
    }

    public Type getSupertype(TypeDeclaration dec) {
        TypeCache cache;
        if (dec == null) {
            return null;
        }
        if (this.isNothing()) {
            return null;
        }
        boolean canCache = this.canCacheSupertype(dec);
        if (canCache && (cache = dec.getUnit().getCache()).containsKey(this, dec)) {
            return cache.get(this, dec);
        }
        while (dec.isAlias()) {
            Type et = dec.getExtendedType();
            if (et == null) {
                return null;
            }
            dec = et.getDeclaration();
            if (dec != null) continue;
            return null;
        }
        Type superType = this.isSimpleSupertypeLookup(dec) ? (this.getDeclaration().inherits(dec) ? dec.getType() : null) : this.getSupertype(new SupertypeCriteria(dec));
        if (canCache) {
            TypeCache cache2 = dec.getUnit().getCache();
            cache2.put(this, dec, superType);
        }
        return superType;
    }

    private boolean canCacheSupertype(TypeDeclaration dec) {
        boolean complexType = dec instanceof UnionType || dec instanceof IntersectionType;
        return !complexType && !this.hasUnderlyingType() && this.collectVarianceOverrides().isEmpty() && TypeCache.isEnabled();
    }

    private boolean isSimpleSupertypeLookup(TypeDeclaration dec) {
        return dec instanceof ClassOrInterface && !this.isUnion() && !this.isIntersection() && dec.getTypeParameters().isEmpty() && !dec.isClassOrInterfaceMember() && this.getQualifyingType() == null;
    }

    private boolean hasUnderlyingType() {
        if (this.getUnderlyingType() != null) {
            return true;
        }
        List<Type> tal = this.getTypeArgumentList();
        int size = tal.size();
        for (int i = 0; i < size; ++i) {
            Type ta = tal.get(i);
            if (ta == null || !ta.hasUnderlyingType()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getSupertype(Criteria c) {
        Type.checkDepth();
        Type.incDepth();
        try {
            if (c.satisfies(this.getDeclaration())) {
                Type type = this.qualifiedByDeclaringType();
                return type;
            }
            if (this.isWellDefined()) {
                Type result = this.getPrincipalInstantiation(c);
                if ((result = this.getPrincipalInstantiationFromCases(c, result)) == null || result.isNothing()) {
                    Type type = null;
                    return type;
                }
                Type type = result;
                return type;
            }
            Type type = null;
            return type;
        }
        finally {
            Type.decDepth();
        }
    }

    private Type getPrincipalInstantiationFromCases(Criteria c, Type result) {
        Type candidateResult;
        TypeDeclaration stc;
        List<Type> caseTypes;
        if (this.isUnion() && (caseTypes = this.getInternalCaseTypes()) != null && !caseTypes.isEmpty() && (stc = this.findCommonSuperclass(c, caseTypes)) != null && (candidateResult = this.getCommonSupertype(caseTypes, stc)) != null && (result == null || candidateResult.isSubtypeOfInternal(result))) {
            result = candidateResult;
        }
        return result;
    }

    private TypeDeclaration findCommonSuperclass(Criteria c, List<Type> types) {
        TypeDeclaration result = null;
        TypeDeclaration td = types.get(0).getDeclaration();
        for (TypeDeclaration std : td.getSupertypeDeclarations()) {
            if (!(std instanceof ClassOrInterface) || !c.satisfies(std)) continue;
            for (Type ct : types) {
                if (ct.getDeclaration().inherits(std)) continue;
                std = null;
                break;
            }
            if (std == null) continue;
            if (result == null) {
                result = std;
                continue;
            }
            if (std.inherits(result)) {
                result = std;
                continue;
            }
            if (result.inherits(std)) continue;
            result = null;
            break;
        }
        return result;
    }

    public static void resetDepth(int initial) {
        depth.set(initial);
    }

    static void checkDepth() {
        if (depth.get() > 100) {
            throw new DecidabilityException();
        }
    }

    static void decDepth() {
        depth.set(depth.get() - 1);
    }

    static void incDepth() {
        depth.set(depth.get() + 1);
    }

    private Type getPrincipalInstantiation(Criteria c) {
        Type possibleResult;
        Type result = null;
        Type lowerBound = null;
        Type extendedType = this.getInternalExtendedType();
        if (extendedType != null && (possibleResult = extendedType.getSupertype(c)) != null) {
            result = possibleResult;
            lowerBound = possibleResult;
        }
        List<Type> satisfiedTypes = this.getInternalSatisfiedTypes();
        int size = satisfiedTypes.size();
        for (int i = 0; i < size; ++i) {
            Type satisfiedType = satisfiedTypes.get(i);
            Type possibleResult2 = satisfiedType.getSupertype(c);
            if (possibleResult2 == null) continue;
            if (result == null) {
                result = possibleResult2;
                lowerBound = possibleResult2;
                continue;
            }
            if (result.isSubtypeOf(possibleResult2)) continue;
            if (possibleResult2.isSubtypeOf(lowerBound)) {
                result = possibleResult2;
                lowerBound = possibleResult2;
                continue;
            }
            TypeDeclaration rd = result.getDeclaration();
            TypeDeclaration prd = possibleResult2.getDeclaration();
            TypeDeclaration d = null;
            if (rd.equals(prd)) {
                d = rd;
            }
            Unit unit = this.getDeclaration().getUnit();
            if (d != null) {
                result = ModelUtil.principalInstantiation(d, possibleResult2, result, unit);
                continue;
            }
            if (c.isMemberLookup() && !satisfiedTypes.isEmpty()) {
                ArrayList<Type> types = new ArrayList<Type>(2);
                types.add(lowerBound);
                types.add(possibleResult2);
                lowerBound = ModelUtil.intersection(types, unit);
                List<Type> lbsts = lowerBound.getSatisfiedTypes();
                ArrayList<Type> caseTypes = new ArrayList<Type>(lbsts.size());
                caseTypes.addAll(lbsts);
                result = ModelUtil.union(caseTypes, unit).getSupertype(c);
                if (result != null) continue;
                return unit.getUnknownType();
            }
            return unit.getUnknownType();
        }
        return result;
    }

    private Type qualifiedByDeclaringType() {
        Type qt = this.getQualifyingType();
        if (qt == null) {
            return this;
        }
        TypeDeclaration declaration = this.getDeclaration();
        if (!declaration.isMember()) {
            return this;
        }
        Type pt = new Type();
        pt.setDeclaration(declaration);
        TypeDeclaration dtd = (TypeDeclaration)declaration.getContainer();
        Type declaringType = qt.getSupertype(dtd);
        pt.setQualifyingType(declaringType);
        Map<TypeParameter, Type> tam = ModelUtil.getTypeArgumentMap(declaration, declaringType, this.getTypeArgumentList());
        pt.setTypeArguments(tam);
        pt.setVarianceOverrides(this.getVarianceOverrides());
        return pt;
    }

    private Type getCommonSupertype(List<Type> caseTypes, TypeDeclaration dec) {
        Type outerType;
        List<TypeParameter> typeParameters = dec.getTypeParameters();
        ArrayList<Type> args = new ArrayList<Type>(typeParameters.size());
        HashMap<TypeParameter, SiteVariance> variances = new HashMap<TypeParameter, SiteVariance>();
        for (TypeParameter tp : typeParameters) {
            Type result;
            ArrayList<Type> union;
            Unit unit = this.getDeclaration().getUnit();
            if (tp.isCovariant()) {
                union = new ArrayList<Type>(caseTypes.size());
                for (Type pt : caseTypes) {
                    if (pt == null) {
                        return null;
                    }
                    if (pt.isNothing()) continue;
                    Type st = pt.getSupertype(dec);
                    if (st == null) {
                        return null;
                    }
                    ModelUtil.addToUnion(union, st.getTypeArguments().get(tp));
                }
                result = ModelUtil.union(union, unit);
            } else if (tp.isContravariant()) {
                ArrayList<Type> intersection = new ArrayList<Type>(caseTypes.size());
                for (Type pt : caseTypes) {
                    if (pt == null) {
                        return null;
                    }
                    if (pt.isNothing()) continue;
                    Type st = pt.getSupertype(dec);
                    if (st == null) {
                        return null;
                    }
                    Type arg = st.getTypeArguments().get(tp);
                    ModelUtil.addToIntersection(intersection, arg, unit);
                }
                result = ModelUtil.canonicalIntersection(intersection, unit);
            } else {
                union = new ArrayList(caseTypes.size());
                ArrayList<Type> intersection = new ArrayList<Type>(caseTypes.size());
                boolean covariant = false;
                boolean contravariant = false;
                for (Type pt : caseTypes) {
                    if (pt == null) {
                        return null;
                    }
                    if (pt.isNothing()) continue;
                    Type st = pt.getSupertype(dec);
                    if (st == null) {
                        return null;
                    }
                    Type arg = st.getTypeArguments().get(tp);
                    if (st.isCovariant(tp)) {
                        covariant = true;
                        ModelUtil.addToUnion(union, arg);
                        continue;
                    }
                    if (st.isContravariant(tp)) {
                        contravariant = true;
                        ModelUtil.addToIntersection(intersection, arg, unit);
                        continue;
                    }
                    ModelUtil.addToUnion(union, arg);
                    ModelUtil.addToIntersection(intersection, arg, unit);
                }
                Type utt = ModelUtil.union(union, unit);
                Type itt = ModelUtil.intersection(intersection, unit);
                if (!covariant && !contravariant) {
                    if (utt.isExactly(itt)) {
                        result = utt;
                    } else {
                        result = utt;
                        variances.put(tp, SiteVariance.OUT);
                    }
                } else if (covariant && !contravariant) {
                    result = utt;
                    variances.put(tp, SiteVariance.OUT);
                } else if (contravariant && !covariant) {
                    result = itt;
                    variances.put(tp, SiteVariance.IN);
                } else {
                    Type upperBound;
                    result = upperBound = ModelUtil.intersectionOfSupertypes(tp);
                    variances.put(tp, SiteVariance.OUT);
                }
            }
            if (tp.isTypeConstructor()) {
                result.setTypeConstructor(true);
                result.setTypeConstructorParameter(tp);
            }
            args.add(result);
        }
        if (dec.isMember() && !dec.isStaticallyImportable()) {
            TypeDeclaration outer = (TypeDeclaration)dec.getContainer();
            ArrayList<Type> list = new ArrayList<Type>(caseTypes.size());
            for (Type ct : caseTypes) {
                if (ct == null) {
                    return null;
                }
                List<Type> intersectedTypes = ct.isIntersection() ? ct.getSatisfiedTypes() : Collections.singletonList(ct);
                for (Type it : intersectedTypes) {
                    if (!it.getDeclaration().isMember()) continue;
                    Type st = it.getQualifyingType().getSupertype(outer);
                    list.add(st);
                }
            }
            outerType = this.getCommonSupertype(list, outer);
        } else {
            outerType = null;
        }
        Type candidateResult = dec.appliedType(outerType, args);
        candidateResult.setVarianceOverrides(variances);
        for (Type pt : caseTypes) {
            if (pt.isSubtypeOf(candidateResult)) continue;
            return null;
        }
        return candidateResult;
    }

    public List<Type> getTypeArgumentList() {
        List<TypeParameter> tps = this.getDeclaration().getTypeParameters();
        if (tps.isEmpty()) {
            return ModelUtil.NO_TYPE_ARGS;
        }
        return this.getTypeArgumentListInternal();
    }

    private List<Type> getTypeArgumentListInternal() {
        TypeDeclaration dec = this.getDeclaration();
        List<TypeParameter> tps = dec.getTypeParameters();
        int size = tps.size();
        ArrayList<Type> argList = new ArrayList<Type>(size);
        Map<TypeParameter, Type> args = this.getTypeArguments();
        for (int i = 0; i < size; ++i) {
            TypeParameter tp = tps.get(i);
            Type arg = args.get(tp);
            if (arg == null) {
                arg = dec.getUnit().getUnknownType();
            }
            argList.add(arg);
        }
        return argList;
    }

    public List<TypeDeclaration> checkDecidability() {
        ArrayList<TypeDeclaration> errors = new ArrayList<TypeDeclaration>();
        List<TypeParameter> typeParameters = this.getDeclaration().getTypeParameters();
        Map<TypeParameter, Type> typeArguments = this.getTypeArguments();
        for (TypeParameter tp : typeParameters) {
            Type pt = typeArguments.get(tp);
            if (pt == null) continue;
            pt.checkDecidability(tp.isCovariant(), tp.isContravariant(), errors);
        }
        return errors;
    }

    private void checkDecidability(boolean covariant, boolean contravariant, List<TypeDeclaration> errors) {
        block11: {
            if (this.isTypeParameter()) break block11;
            if (this.isUnion()) {
                for (Type ct : this.getCaseTypes()) {
                    ct.checkDecidability(covariant, contravariant, errors);
                }
            } else if (this.isIntersection()) {
                for (Type ct : this.getSatisfiedTypes()) {
                    ct.checkDecidability(covariant, contravariant, errors);
                }
            } else {
                TypeDeclaration declaration = this.getDeclaration();
                for (TypeParameter tp : declaration.getTypeParameters()) {
                    Type pt;
                    if (!covariant && tp.isContravariant() && !errors.contains(declaration)) {
                        errors.add(declaration);
                    }
                    if ((pt = this.getTypeArguments().get(tp)) == null) continue;
                    if (tp.isCovariant()) {
                        pt.checkDecidability(covariant, contravariant, errors);
                        continue;
                    }
                    if (tp.isContravariant()) {
                        if (covariant | contravariant) {
                            pt.checkDecidability(!covariant, !contravariant, errors);
                            continue;
                        }
                        pt.checkDecidability(covariant, contravariant, errors);
                        continue;
                    }
                    pt.checkDecidability(false, false, errors);
                }
            }
        }
    }

    public List<TypeParameter> checkVariance(boolean covariant, boolean contravariant, Declaration declaration) {
        ArrayList<TypeParameter> errors = new ArrayList<TypeParameter>(3);
        this.checkVariance(covariant, contravariant, declaration, errors);
        return errors;
    }

    private static boolean isTrulyCovariant(TypeParameter tp) {
        Scope container = tp.getContainer();
        if (container instanceof TypeParameter) {
            TypeParameter tcp = (TypeParameter)container;
            if (Type.isTrulyCovariant(tcp)) {
                return tp.isCovariant();
            }
            if (Type.isTrulyContravariant(tcp)) {
                return tp.isContravariant();
            }
            return false;
        }
        return tp.isCovariant();
    }

    private static boolean isTrulyContravariant(TypeParameter tp) {
        Scope container = tp.getContainer();
        if (container instanceof TypeParameter) {
            TypeParameter tcp = (TypeParameter)container;
            if (Type.isTrulyCovariant(tcp)) {
                return tp.isContravariant();
            }
            if (Type.isTrulyContravariant(tcp)) {
                return tp.isCovariant();
            }
            return false;
        }
        return tp.isContravariant();
    }

    private void checkVariance(boolean covariant, boolean contravariant, Declaration declaration, List<TypeParameter> errors) {
        block12: {
            TypeDeclaration dec;
            block11: {
                dec = this.getDeclaration();
                if (!this.isTypeParameter()) break block11;
                TypeParameter tp = (TypeParameter)dec;
                Declaration parameterizedDec = tp.getDeclaration();
                if (parameterizedDec.equals(declaration) || (covariant || !Type.isTrulyCovariant(tp)) && (contravariant || !Type.isTrulyContravariant(tp))) break block12;
                errors.add(tp);
                break block12;
            }
            if (this.isUnion()) {
                for (Type ct : this.getCaseTypes()) {
                    ct.checkVariance(covariant, contravariant, declaration, errors);
                }
            } else if (this.isIntersection()) {
                for (Type ct : this.getSatisfiedTypes()) {
                    ct.checkVariance(covariant, contravariant, declaration, errors);
                }
            } else {
                Type qt = this.getQualifyingType();
                if (qt != null) {
                    qt.checkVariance(covariant, contravariant, declaration, errors);
                }
                for (TypeParameter tp : dec.getTypeParameters()) {
                    Type pt = this.getTypeArguments().get(tp);
                    if (pt == null) continue;
                    if (this.isCovariant(tp)) {
                        pt.checkVariance(covariant, contravariant, declaration, errors);
                        continue;
                    }
                    if (this.isContravariant(tp)) {
                        if (covariant | contravariant) {
                            pt.checkVariance(!covariant, !contravariant, declaration, errors);
                            continue;
                        }
                        pt.checkVariance(covariant, contravariant, declaration, errors);
                        continue;
                    }
                    pt.checkVariance(false, false, declaration, errors);
                }
            }
        }
    }

    public boolean isWellDefined() {
        List<TypeParameter> tps = this.getDeclaration().getTypeParameters();
        Type qt = this.getQualifyingType();
        if (qt != null && !qt.isWellDefined()) {
            return false;
        }
        List<Type> tas = this.getTypeArgumentList();
        for (int i = 0; i < tps.size(); ++i) {
            Type at = tas.get(i);
            TypeParameter tp = tps.get(i);
            if ((tp.isDefaulted() || at != null) && (at == null || at.isWellDefined())) continue;
            return false;
        }
        return true;
    }

    public boolean containsUnknowns() {
        block7: {
            block8: {
                block6: {
                    if (this.isUnknown()) {
                        return true;
                    }
                    if (!this.isUnion()) break block6;
                    for (Type ct : this.getCaseTypes()) {
                        if (!ct.containsUnknowns()) continue;
                        return true;
                    }
                    break block7;
                }
                if (!this.isIntersection()) break block8;
                for (Type st : this.getSatisfiedTypes()) {
                    if (!st.containsUnknowns()) continue;
                    return true;
                }
                break block7;
            }
            if (this.isNothing()) {
                return false;
            }
            Type qt = this.getQualifyingType();
            if (qt != null && qt.containsUnknowns()) {
                return true;
            }
            if (this.isTypeConstructor()) break block7;
            for (Type at : this.getTypeArgumentList()) {
                if (at != null && !at.containsUnknowns()) continue;
                return true;
            }
        }
        return false;
    }

    public String getFirstUnknownTypeError() {
        return this.getFirstUnknownTypeError(false);
    }

    public String getFirstUnknownTypeError(boolean includeSuperTypes) {
        if (this.isUnknown()) {
            TypeDeclaration dec = this.getDeclaration();
            UnknownType ut = (UnknownType)dec;
            UnknownType.ErrorReporter errorReporter = ut.getErrorReporter();
            return errorReporter == null ? null : errorReporter.getMessage();
        }
        if (this.isUnion()) {
            for (Type ct : this.getCaseTypes()) {
                String error = ct.getFirstUnknownTypeError(includeSuperTypes);
                if (error == null) continue;
                return error;
            }
        } else if (this.isIntersection()) {
            for (Type st : this.getSatisfiedTypes()) {
                String error = st.getFirstUnknownTypeError(includeSuperTypes);
                if (error == null) continue;
                return error;
            }
        } else {
            Type qt;
            String error;
            if (this.isNothing()) {
                return null;
            }
            if (includeSuperTypes) {
                Type et = this.getExtendedType();
                if (et != null && (error = et.getFirstUnknownTypeError(includeSuperTypes)) != null) {
                    return error;
                }
                for (Type st : this.getSatisfiedTypes()) {
                    String error2 = st.getFirstUnknownTypeError(includeSuperTypes);
                    if (error2 == null) continue;
                    return error2;
                }
            }
            if ((qt = this.getQualifyingType()) != null && (error = qt.getFirstUnknownTypeError(includeSuperTypes)) != null) {
                return error;
            }
            List<Type> tas = this.getTypeArgumentList();
            for (Type at : tas) {
                String error3;
                if (at == null || (error3 = at.getFirstUnknownTypeError(false)) == null) continue;
                return error3;
            }
        }
        return null;
    }

    public boolean involvesDeclaration(Declaration d) {
        if (d instanceof TypeDeclaration) {
            return this.involvesDeclaration((TypeDeclaration)d);
        }
        return false;
    }

    public boolean involvesDeclaration(TypeDeclaration td) {
        return this.involvesDeclaration(td, new ArrayList<Type>());
    }

    private boolean involvesDeclaration(TypeDeclaration td, List<Type> visited) {
        if (this.isUnknown()) {
            return false;
        }
        if (this.isUnion()) {
            for (Type ct : this.getCaseTypes()) {
                if (!ct.involvesDeclaration(td, visited)) continue;
                return true;
            }
        } else if (this.isIntersection()) {
            for (Type st : this.getSatisfiedTypes()) {
                if (!st.involvesDeclaration(td, visited)) continue;
                return true;
            }
        } else {
            if (this.isNothing()) {
                return false;
            }
            if (visited.contains(this)) {
                return false;
            }
            visited.add(this);
            if (this.getDeclaration().equals(td)) {
                return true;
            }
            Type qt = this.getQualifyingType();
            if (qt != null && qt.involvesDeclaration(td, visited)) {
                return true;
            }
            List<Type> tas = this.getTypeArgumentList();
            for (Type at : tas) {
                if (at != null && !at.involvesDeclaration(td, visited)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean occursInvariantly(TypeParameter tp) {
        return this.occursInvariantly(tp, true, false);
    }

    private boolean occursInvariantly(TypeParameter tp, boolean covariant, boolean contravariant) {
        if (this.isUnknown()) {
            return false;
        }
        if (this.isUnion()) {
            for (Type ct : this.getCaseTypes()) {
                if (!ct.occursInvariantly(tp, covariant, contravariant)) continue;
                return true;
            }
        } else if (this.isIntersection()) {
            for (Type st : this.getSatisfiedTypes()) {
                if (!st.occursInvariantly(tp, covariant, contravariant)) continue;
                return true;
            }
        } else {
            if (this.isNothing()) {
                return false;
            }
            TypeDeclaration dec = this.getDeclaration();
            if (!covariant && !contravariant && dec.equals(tp)) {
                return true;
            }
            Type qt = this.getQualifyingType();
            if (qt != null && qt.occursInvariantly(tp, covariant, contravariant)) {
                return true;
            }
            List<TypeParameter> tps = dec.getTypeParameters();
            List<Type> tas = this.getTypeArgumentList();
            for (int i = 0; i < tps.size() && i < tas.size(); ++i) {
                boolean contra;
                boolean co;
                TypeParameter itp = tps.get(i);
                Type at = tas.get(i);
                if (at == null) continue;
                if (!covariant && !contravariant) {
                    co = false;
                    contra = false;
                } else if (this.isCovariant(itp)) {
                    co = covariant;
                    contra = contravariant;
                } else if (this.isContravariant(itp)) {
                    co = !covariant;
                    contra = !contravariant;
                } else {
                    co = false;
                    contra = false;
                }
                if (!at.occursInvariantly(tp, co, contra)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean occursCovariantly(TypeParameter tp) {
        return this.occursCovariantly(tp, true);
    }

    private boolean occursCovariantly(TypeParameter tp, boolean covariant) {
        if (this.isUnknown()) {
            return false;
        }
        if (this.isUnion()) {
            for (Type ct : this.getCaseTypes()) {
                if (!ct.occursCovariantly(tp, covariant)) continue;
                return true;
            }
        } else if (this.isIntersection()) {
            for (Type st : this.getSatisfiedTypes()) {
                if (!st.occursCovariantly(tp, covariant)) continue;
                return true;
            }
        } else {
            if (this.isNothing()) {
                return false;
            }
            TypeDeclaration dec = this.getDeclaration();
            if (covariant && dec.equals(tp)) {
                return true;
            }
            Type qt = this.getQualifyingType();
            if (qt != null && qt.occursCovariantly(tp, covariant)) {
                return true;
            }
            List<TypeParameter> tps = dec.getTypeParameters();
            List<Type> tas = this.getTypeArgumentList();
            for (int i = 0; i < tps.size() && i < tas.size(); ++i) {
                TypeParameter itp = tps.get(i);
                Type at = tas.get(i);
                if (at == null || this.isInvariant(itp)) continue;
                boolean co = covariant;
                if (this.isContravariant(itp)) {
                    boolean bl = co = !co;
                }
                if (!at.occursCovariantly(tp, co)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean occursContravariantly(TypeParameter tp) {
        return this.occursContravariantly(tp, true);
    }

    private boolean occursContravariantly(TypeParameter tp, boolean covariant) {
        if (this.isUnknown()) {
            return false;
        }
        if (this.isUnion()) {
            for (Type ct : this.getCaseTypes()) {
                if (!ct.occursContravariantly(tp, covariant)) continue;
                return true;
            }
        } else if (this.isIntersection()) {
            for (Type st : this.getSatisfiedTypes()) {
                if (!st.occursContravariantly(tp, covariant)) continue;
                return true;
            }
        } else {
            if (this.isNothing()) {
                return false;
            }
            TypeDeclaration dec = this.getDeclaration();
            if (!covariant && dec.equals(tp)) {
                return true;
            }
            Type qt = this.getQualifyingType();
            if (qt != null && qt.occursContravariantly(tp, covariant)) {
                return true;
            }
            List<TypeParameter> tps = dec.getTypeParameters();
            List<Type> tas = this.getTypeArgumentList();
            for (int i = 0; i < tps.size() && i < tas.size(); ++i) {
                TypeParameter itp = tps.get(i);
                Type at = tas.get(i);
                if (at == null || this.isInvariant(itp)) continue;
                boolean co = covariant;
                if (this.isContravariant(itp)) {
                    boolean bl = co = !co;
                }
                if (!at.occursContravariantly(tp, co)) continue;
                return true;
            }
        }
        return false;
    }

    private List<Type> getInternalSatisfiedTypes() {
        TypeDeclaration dec = this.getDeclaration();
        List<Type> sts = dec.getSatisfiedTypes();
        if (this.getTypeArguments().isEmpty()) {
            return sts;
        }
        ArrayList<Type> satisfiedTypes = new ArrayList<Type>(sts.size());
        for (Type st : sts) {
            satisfiedTypes.add(st.substituteFromSubtype(this));
        }
        return satisfiedTypes;
    }

    private Type getInternalExtendedType() {
        TypeDeclaration dec = this.getDeclaration();
        Type et = dec.getExtendedType();
        if (et == null) {
            return null;
        }
        if (this.getTypeArguments().isEmpty()) {
            return et;
        }
        return et.substituteFromSubtype(this);
    }

    private List<Type> getInternalCaseTypes() {
        TypeDeclaration dec = this.getDeclaration();
        List<Type> cts = dec.getCaseTypes();
        if (cts == null) {
            return null;
        }
        if (this.getTypeArguments().isEmpty()) {
            return cts;
        }
        ArrayList<Type> caseTypes = new ArrayList<Type>(cts.size());
        for (Type ct : cts) {
            caseTypes.add(ct.substituteFromSubtype(this));
        }
        return caseTypes;
    }

    public List<Type> getSatisfiedTypes() {
        TypeDeclaration dec = this.getDeclaration();
        List<Type> sts = dec.getSatisfiedTypes();
        if (this.getTypeArguments().isEmpty()) {
            return sts;
        }
        ArrayList<Type> satisfiedTypes = new ArrayList<Type>(sts.size());
        int l = sts.size();
        for (int i = 0; i < l; ++i) {
            Type st = sts.get(i);
            satisfiedTypes.add(st.substitute(this));
        }
        return satisfiedTypes;
    }

    public Type getExtendedType() {
        TypeDeclaration dec = this.getDeclaration();
        Type et = dec.getExtendedType();
        if (et == null) {
            return null;
        }
        if (this.getTypeArguments().isEmpty()) {
            return et;
        }
        return et.substitute(this);
    }

    public List<Type> getCaseTypes() {
        TypeDeclaration dec = this.getDeclaration();
        List<Type> cts = dec.getCaseTypes();
        if (cts == null) {
            return null;
        }
        if (this.getTypeArguments().isEmpty()) {
            return cts;
        }
        ArrayList<Type> caseTypes = new ArrayList<Type>(cts.size());
        for (Type ct : cts) {
            caseTypes.add(ct.substitute(this));
        }
        return caseTypes;
    }

    public String toString() {
        String result = this.asString();
        return this.isTypeConstructor() ? result + " (type constructor)" : result + " (type)";
    }

    @Override
    public String asString() {
        return this.asString(null);
    }

    public String asString(Unit unit) {
        return TypePrinter.DEFAULT.print(this, unit);
    }

    public String asSourceCodeString(Unit unit) {
        return TypePrinter.ESCAPED.print(this, unit);
    }

    public String asString(boolean abbreviate) {
        return this.asString(abbreviate, null);
    }

    public String asString(boolean abbreviate, Unit unit) {
        return new TypePrinter(abbreviate).print(this, unit);
    }

    private String qualifiedName() {
        StringBuilder ptn = new StringBuilder();
        if (this.isTypeConstructor()) {
            return this.asString();
        }
        Type qt = this.getQualifyingType();
        TypeDeclaration declaration = this.getDeclaration();
        if (qt != null) {
            ptn.append(qt.asQualifiedString()).append(".").append(declaration.getName());
        } else {
            ptn.append(declaration.getQualifiedNameString());
        }
        if (!this.getTypeArgumentList().isEmpty()) {
            ptn.append("<");
            boolean first = true;
            for (Type t : this.getTypeArgumentList()) {
                if (first) {
                    first = false;
                } else {
                    ptn.append(",");
                }
                if (t == null) {
                    ptn.append("unknown");
                    continue;
                }
                ptn.append(t.asQualifiedString());
            }
            ptn.append(">");
        }
        return ptn.toString();
    }

    public String asQualifiedString() {
        TypeDeclaration declaration = this.getDeclaration();
        if (declaration == null) {
            return null;
        }
        if (this.isUnion()) {
            StringBuilder name = new StringBuilder();
            boolean first = true;
            for (Type pt : this.getCaseTypes()) {
                if (first) {
                    first = false;
                } else {
                    name.append("|");
                }
                if (pt == null) {
                    name.append("unknown");
                    continue;
                }
                name.append(pt.asQualifiedString());
            }
            return name.toString();
        }
        if (this.isIntersection()) {
            StringBuilder name = new StringBuilder();
            boolean first = true;
            for (Type pt : this.getSatisfiedTypes()) {
                if (first) {
                    first = false;
                } else {
                    name.append("&");
                }
                if (pt == null) {
                    name.append("unknown");
                    continue;
                }
                name.append(pt.asQualifiedString());
            }
            return name.toString();
        }
        return this.qualifiedName();
    }

    public Type getUnionOfCases() {
        Unit unit = this.getDeclaration().getUnit();
        if (this.isIntersection()) {
            List<Type> sts = this.getSatisfiedTypes();
            ArrayList<Type> list = new ArrayList<Type>(sts.size());
            for (Type st : sts) {
                ModelUtil.addToIntersection(list, st.getUnionOfCases(), unit);
            }
            return ModelUtil.canonicalIntersection(list, unit);
        }
        List<Type> cts = this.getCaseTypes();
        if (cts == null) {
            return this.narrowToUpperBounds();
        }
        ArrayList<Type> list = new ArrayList<Type>(cts.size());
        for (Type ct : cts) {
            if (ct.isExactly(this)) {
                return this;
            }
            ModelUtil.addToUnion(list, ct.narrowToUpperBounds().getUnionOfCases());
        }
        return ModelUtil.union(list, unit);
    }

    Type narrowToUpperBounds() {
        TypeDeclaration declaration;
        List<TypeParameter> params;
        if (this.isClassOrInterface() && !(params = (declaration = this.getDeclaration()).getTypeParameters()).isEmpty()) {
            List<Type> args = this.getTypeArgumentList();
            ArrayList<Type> bounded = new ArrayList<Type>(args.size());
            boolean found = false;
            int s1 = params.size();
            int s2 = args.size();
            for (int i = 0; i < s1 && i < s2; ++i) {
                Type bound;
                TypeParameter tp = params.get(i);
                Type arg = args.get(i);
                if (this.isCovariant(tp) && !arg.isSubtypeOf(bound = ModelUtil.intersectionOfSupertypes(tp).substitute(this))) {
                    arg = bound;
                    found = true;
                }
                bounded.add(arg);
            }
            if (found) {
                Type type = declaration.appliedType(this.getQualifyingType(), bounded);
                type.setVarianceOverrides(this.getVarianceOverrides());
                return type;
            }
        }
        return this;
    }

    public void setUnderlyingType(String underlyingType) {
        this.underlyingType = underlyingType;
        if (this.resolvedAliases != null && this.resolvedAliases != this) {
            this.resolvedAliases.setUnderlyingType(underlyingType);
        }
    }

    public String getUnderlyingType() {
        return this.underlyingType;
    }

    public boolean covers(Type st) {
        return this.resolveAliases().coversInternal(st.resolveAliases());
    }

    private boolean coversInternal(Type type) {
        Type stu;
        Type uoc = type.getUnionOfCases();
        if (uoc.isSubtypeOfInternal(this)) {
            return true;
        }
        if (uoc.isUnion()) {
            for (Type ct : uoc.getCaseTypes()) {
                if (this.coversInternal(ct)) continue;
                return false;
            }
            return true;
        }
        TypeDeclaration dec = type.getDeclaration();
        Type et = type.getExtendedType();
        Unit unit = dec.getUnit();
        if (et != null && (stu = et.getUnionOfCases()).isUnion() && ModelUtil.intersectionType(stu, type, unit).isSubtypeOf(this)) {
            return true;
        }
        for (Type st : type.getSatisfiedTypes()) {
            Type stu2 = st.getUnionOfCases();
            if (!stu2.isUnion() || !ModelUtil.intersectionType(stu2, type, unit).isSubtypeOf(this)) continue;
            return true;
        }
        return false;
    }

    public Type withoutUnderlyingType() {
        Type pt = new Type();
        pt.setDeclaration(this.getDeclaration());
        pt.setQualifyingType(this.getQualifyingType());
        pt.setTypeArguments(this.getTypeArguments());
        pt.setVarianceOverrides(this.getVarianceOverrides());
        pt.setTypeConstructor(this.isTypeConstructor());
        pt.setTypeConstructorParameter(this.getTypeConstructorParameter());
        return pt;
    }

    public boolean isRaw() {
        return this.isRaw;
    }

    public void setRaw(boolean isRaw) {
        this.isRaw = isRaw;
        if (this.resolvedAliases != null && this.resolvedAliases != this) {
            this.resolvedAliases.setRaw(isRaw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type resolveAliases() {
        if (this.resolvedAliases == null) {
            Type.checkDepth();
            if (!this.isTuple()) {
                Type.incDepth();
            }
            try {
                this.resolvedAliases = this.resolveAliasesInternal();
            }
            finally {
                if (!this.isTuple()) {
                    Type.decDepth();
                }
            }
            this.resolvedAliases.resolvedAliases = this.resolvedAliases;
            if (this.resolvedAliases != this) {
                this.resolvedAliases.underlyingType = this.underlyingType;
                this.resolvedAliases.isRaw = this.isRaw;
            }
        }
        return this.resolvedAliases;
    }

    private Type resolveAliasesInternal() {
        List<Type> aliasedArgs;
        TypeDeclaration dec = this.getDeclaration();
        Unit unit = dec.getUnit();
        if (this.isClassOrInterface() && this.getQualifyingType() == null && !dec.isAlias() && dec.getTypeParameters().isEmpty()) {
            return this;
        }
        if (this.isTypeConstructor()) {
            return this;
        }
        if (this.isUnion()) {
            List<Type> caseTypes = this.getCaseTypes();
            ArrayList<Type> list = new ArrayList<Type>(caseTypes.size());
            for (Type pt : caseTypes) {
                ModelUtil.addToUnion(list, pt.resolveAliases());
            }
            return ModelUtil.union(list, unit);
        }
        if (this.isIntersection()) {
            List<Type> satisfiedTypes = this.getSatisfiedTypes();
            ArrayList<Type> list = new ArrayList<Type>(satisfiedTypes.size());
            for (Type pt : satisfiedTypes) {
                ModelUtil.addToIntersection(list, pt.resolveAliases(), unit);
            }
            return ModelUtil.canonicalIntersection(list, unit);
        }
        Type qt = this.getQualifyingType();
        Type aliasedQualifyingType = qt == null ? null : qt.resolveAliases();
        List<Type> args = this.getTypeArgumentList();
        if (args.isEmpty()) {
            aliasedArgs = ModelUtil.NO_TYPE_ARGS;
        } else {
            aliasedArgs = new ArrayList<Type>(args.size());
            for (Type arg : args) {
                Type aliasedArg = arg == null ? null : arg.resolveAliases();
                aliasedArgs.add(aliasedArg);
            }
        }
        if (dec.isAlias()) {
            Type et = dec.getExtendedType();
            if (et == null) {
                return unit.getUnknownType();
            }
            return et.resolveAliases().substitute(ModelUtil.getTypeArgumentMap(dec, aliasedQualifyingType, aliasedArgs), this.getVarianceOverrides());
        }
        Type result = dec.appliedType(aliasedQualifyingType, aliasedArgs);
        result.setVarianceOverrides(this.getVarianceOverrides());
        return result;
    }

    public boolean involvesTypeParameters() {
        if (this.isTypeParameter()) {
            return true;
        }
        if (this.isUnion()) {
            for (Type ct : this.getCaseTypes()) {
                if (!ct.involvesTypeParameters()) continue;
                return true;
            }
        } else if (this.isIntersection()) {
            for (Type st : this.getSatisfiedTypes()) {
                if (!st.involvesTypeParameters()) continue;
                return true;
            }
        } else {
            for (Type at : this.getTypeArgumentList()) {
                if (at == null || !at.involvesTypeParameters()) continue;
                return true;
            }
            Type qt = this.getQualifyingType();
            if (qt != null && qt.involvesTypeParameters()) {
                return true;
            }
        }
        return false;
    }

    public boolean involvesTypeParameters(Generic g) {
        return this.involvesTypeParameters(g.getTypeParameters());
    }

    public boolean involvesTypeParameters(Collection<TypeParameter> params) {
        TypeDeclaration d = this.getDeclaration();
        if (this.isTypeParameter()) {
            if (params.contains(d)) {
                return true;
            }
        } else if (this.isUnion()) {
            for (Type ct : this.getCaseTypes()) {
                if (!ct.involvesTypeParameters(params)) continue;
                return true;
            }
        } else if (this.isIntersection()) {
            for (Type st : this.getSatisfiedTypes()) {
                if (!st.involvesTypeParameters(params)) continue;
                return true;
            }
        } else {
            for (Type at : this.getTypeArgumentList()) {
                if (at == null || !at.involvesTypeParameters(params)) continue;
                return true;
            }
            Type qt = this.getQualifyingType();
            if (qt != null && qt.involvesTypeParameters(params)) {
                return true;
            }
        }
        return false;
    }

    private Set<TypeDeclaration> extend(TypeDeclaration td, Set<TypeDeclaration> visited) {
        HashSet<TypeDeclaration> set = new HashSet<TypeDeclaration>(visited);
        set.add(td);
        return set;
    }

    private List<TypeDeclaration> extend(TypeDeclaration td, List<TypeDeclaration> results) {
        if (!results.contains(td)) {
            results.add(td);
        }
        return results;
    }

    public List<TypeDeclaration> isRecursiveTypeAliasDefinition(Set<TypeDeclaration> visited) {
        TypeDeclaration dec = this.getDeclaration();
        if (dec.isAlias()) {
            List<TypeDeclaration> l;
            if (visited.contains(dec)) {
                return new ArrayList<TypeDeclaration>(Collections.singletonList(dec));
            }
            Type et = dec.getExtendedType();
            if (et != null && !(l = et.isRecursiveTypeAliasDefinition(this.extend(dec, visited))).isEmpty()) {
                return this.extend(dec, l);
            }
            for (Type bt : dec.getBrokenSupertypes()) {
                List<TypeDeclaration> l2 = bt.isRecursiveTypeAliasDefinition(this.extend(dec, visited));
                if (l2.isEmpty()) continue;
                return this.extend(dec, l2);
            }
        } else if (this.isUnion()) {
            for (Type ct : this.getCaseTypes()) {
                List<TypeDeclaration> l = ct.isRecursiveTypeAliasDefinition(visited);
                if (l.isEmpty()) continue;
                return l;
            }
        } else if (this.isIntersection()) {
            for (Type st : this.getSatisfiedTypes()) {
                List<TypeDeclaration> l = st.isRecursiveTypeAliasDefinition(visited);
                if (l.isEmpty()) continue;
                return l;
            }
        } else {
            List<TypeDeclaration> l;
            for (Type at : this.getTypeArgumentList()) {
                List<TypeDeclaration> l3;
                if (at == null || (l3 = at.isRecursiveTypeAliasDefinition(visited)).isEmpty()) continue;
                return l3;
            }
            Type qt = this.getQualifyingType();
            if (qt != null && !(l = qt.isRecursiveTypeAliasDefinition(visited)).isEmpty()) {
                return l;
            }
        }
        return Collections.emptyList();
    }

    public List<TypeDeclaration> isRecursiveRawTypeDefinition(Set<TypeDeclaration> visited) {
        TypeDeclaration dec = this.getDeclaration();
        if (dec.isAlias()) {
            List<TypeDeclaration> l;
            if (visited.contains(dec)) {
                return new ArrayList<TypeDeclaration>(Collections.singletonList(dec));
            }
            Type et = dec.getExtendedType();
            if (et != null && !(l = et.isRecursiveRawTypeDefinition(this.extend(dec, visited))).isEmpty()) {
                return this.extend(dec, l);
            }
            for (Type bt : dec.getBrokenSupertypes()) {
                List<TypeDeclaration> l2 = bt.isRecursiveRawTypeDefinition(this.extend(dec, visited));
                if (l2.isEmpty()) continue;
                return this.extend(dec, l2);
            }
        } else if (this.isUnion()) {
            for (Type ct : this.getCaseTypes()) {
                List<TypeDeclaration> l = ct.isRecursiveRawTypeDefinition(visited);
                if (l.isEmpty()) continue;
                return l;
            }
        } else if (this.isIntersection()) {
            for (Type st : this.getSatisfiedTypes()) {
                List<TypeDeclaration> l = st.isRecursiveRawTypeDefinition(visited);
                if (l.isEmpty()) continue;
                return l;
            }
        } else {
            List<TypeDeclaration> l;
            List<TypeDeclaration> i;
            if (visited.contains(dec)) {
                return new ArrayList<TypeDeclaration>(Collections.singletonList(dec));
            }
            Type et = dec.getExtendedType();
            if (et != null && !(i = et.isRecursiveRawTypeDefinition(this.extend(dec, visited))).isEmpty()) {
                i.add(0, dec);
                return i;
            }
            for (Type bt : dec.getBrokenSupertypes()) {
                l = bt.isRecursiveRawTypeDefinition(this.extend(dec, visited));
                if (l.isEmpty()) continue;
                return this.extend(dec, l);
            }
            for (Type st : this.getSatisfiedTypes()) {
                l = st.isRecursiveRawTypeDefinition(this.extend(dec, visited));
                if (l.isEmpty()) continue;
                return this.extend(dec, l);
            }
        }
        return Collections.emptyList();
    }

    public boolean isUnknown() {
        return this.getDeclaration() instanceof UnknownType;
    }

    public boolean isNothing() {
        return this.getDeclaration() instanceof NothingType;
    }

    public boolean isUnion() {
        return this.getDeclaration() instanceof UnionType;
    }

    public boolean isIntersection() {
        return this.getDeclaration() instanceof IntersectionType;
    }

    public boolean isClassOrInterface() {
        return this.getDeclaration() instanceof ClassOrInterface;
    }

    public boolean isFunctionOrValueInterface() {
        return this.getDeclaration() instanceof FunctionOrValueInterface;
    }

    public boolean isClass() {
        return this.getDeclaration() instanceof Class;
    }

    public boolean isInterface() {
        return this.getDeclaration() instanceof Interface;
    }

    public boolean isTypeParameter() {
        return this.getDeclaration() instanceof TypeParameter;
    }

    public boolean isTypeAlias() {
        return this.getDeclaration() instanceof TypeAlias;
    }

    public boolean isAnything() {
        return this.getDeclaration().isAnything();
    }

    public boolean isObject() {
        return this.getDeclaration().isObject();
    }

    public boolean isNull() {
        return this.getDeclaration().isNull();
    }

    public boolean isNullValue() {
        return this.getDeclaration().isNullValue();
    }

    public boolean isBasic() {
        return this.getDeclaration().isBasic();
    }

    public boolean isBoolean() {
        return this.getDeclaration().isBoolean();
    }

    public boolean isString() {
        return this.getDeclaration().isString();
    }

    public boolean isCharacter() {
        return this.getDeclaration().isCharacter();
    }

    public boolean isFloat() {
        return this.getDeclaration().isFloat();
    }

    public boolean isInteger() {
        return this.getDeclaration().isInteger();
    }

    public boolean isByte() {
        return this.getDeclaration().isByte();
    }

    public boolean isIterable() {
        return this.getDeclaration().isIterable();
    }

    public boolean isSequence() {
        return this.getDeclaration().isSequence();
    }

    public boolean isSequential() {
        return this.getDeclaration().isSequential();
    }

    public boolean isRange() {
        return this.getDeclaration().isRange();
    }

    public boolean isEmpty() {
        return this.getDeclaration().isEmpty();
    }

    public boolean isEmptyValue() {
        return this.getDeclaration().isEmptyValue();
    }

    public boolean isTuple() {
        return this.getDeclaration().isTuple();
    }

    public boolean isEntry() {
        return this.getDeclaration().isEntry();
    }

    public int getMemoisedHashCode() {
        if (this.hashCode == 0) {
            int ret = 17;
            Type qualifyingType = this.getQualifyingType();
            ret = 37 * ret + (qualifyingType != null ? qualifyingType.hashCode() : 0);
            TypeDeclaration declaration = this.getDeclaration();
            ret = 37 * ret + declaration.hashCodeForCache();
            Map<TypeParameter, Type> typeArguments = this.getTypeArguments();
            if (!typeArguments.isEmpty()) {
                List<TypeParameter> typeParameters = declaration.getTypeParameters();
                int l = typeParameters.size();
                for (int i = 0; i < l; ++i) {
                    TypeParameter typeParameter = typeParameters.get(i);
                    Type typeArgument = typeArguments.get(typeParameter);
                    ret = 37 * ret + (typeArgument != null ? typeArgument.hashCode() : 0);
                }
            }
            this.hashCode = ret = 37 * ret + this.varianceOverrides.hashCode();
        }
        return this.hashCode;
    }

    private Map<TypeParameter, SiteVariance> collectVarianceOverrides() {
        Map<TypeParameter, SiteVariance> qualifyingOverrides;
        Type qt = this.getQualifyingType();
        Map<TypeParameter, SiteVariance> map = qualifyingOverrides = qt == null ? ModelUtil.EMPTY_VARIANCE_MAP : qt.collectVarianceOverrides();
        if (this.varianceOverrides.isEmpty()) {
            return qualifyingOverrides;
        }
        if (qualifyingOverrides.isEmpty()) {
            return this.varianceOverrides;
        }
        HashMap<TypeParameter, SiteVariance> overrides = new HashMap<TypeParameter, SiteVariance>(this.varianceOverrides);
        overrides.putAll(qualifyingOverrides);
        return overrides;
    }

    private static Type applyVarianceOverrides(Type type, boolean covariant, boolean contravariant, Map<TypeParameter, SiteVariance> overrides) {
        if (overrides.isEmpty()) {
            return type;
        }
        TypeDeclaration dec = type.getDeclaration();
        Unit unit = dec.getUnit();
        if (type.isTypeParameter()) {
            SiteVariance siteVariance = overrides.get(dec);
            if (contravariant && siteVariance == SiteVariance.OUT) {
                return unit.getNothingType();
            }
            if (covariant && siteVariance == SiteVariance.IN) {
                TypeParameter tp = (TypeParameter)dec;
                List<Type> bounds = tp.getSatisfiedTypes();
                ArrayList<Type> list = new ArrayList<Type>(bounds.size() + 1);
                for (Type bound : bounds) {
                    if (bound.occursCovariantly(tp)) continue;
                    Type applied = Type.applyVarianceOverrides(bound, covariant, contravariant, overrides);
                    ModelUtil.addToIntersection(list, applied, unit);
                }
                return ModelUtil.canonicalIntersection(list, unit);
            }
            return type;
        }
        if (type.isUnion()) {
            ArrayList<Type> list = new ArrayList<Type>();
            for (Type ut : type.getCaseTypes()) {
                ModelUtil.addToUnion(list, Type.applyVarianceOverrides(ut, covariant, contravariant, overrides));
            }
            return ModelUtil.union(list, unit);
        }
        if (type.isIntersection()) {
            ArrayList<Type> list = new ArrayList<Type>();
            for (Type it : type.getSatisfiedTypes()) {
                ModelUtil.addToIntersection(list, Type.applyVarianceOverrides(it, covariant, contravariant, overrides), unit);
            }
            return ModelUtil.canonicalIntersection(list, unit);
        }
        List<Type> args = type.getTypeArgumentList();
        List<TypeParameter> params = dec.getTypeParameters();
        if (params.isEmpty()) {
            return type;
        }
        ArrayList<Type> resultArgs = new ArrayList<Type>(args.size());
        HashMap<TypeParameter, SiteVariance> varianceResults = new HashMap<TypeParameter, SiteVariance>(type.getVarianceOverrides());
        for (int i = 0; i < args.size(); ++i) {
            Type resultArg;
            Type arg = args.get(i);
            if (arg == null) {
                resultArgs.add(null);
                continue;
            }
            TypeDeclaration argDec = arg.getDeclaration();
            TypeParameter param = params.get(i);
            if (type.isCovariant(param)) {
                resultArgs.add(Type.applyVarianceOverrides(arg, covariant, contravariant, overrides));
                continue;
            }
            if (type.isContravariant(param)) {
                resultArgs.add(Type.applyVarianceOverrides(arg, !covariant, !contravariant, overrides));
                continue;
            }
            if (contravariant) {
                if (arg.isTypeParameter() && overrides.containsKey(argDec)) {
                    return unit.getNothingType();
                }
            } else if (covariant && arg.isTypeParameter() && overrides.containsKey(argDec)) {
                varianceResults.put(param, overrides.get(argDec));
                resultArgs.add(arg);
                continue;
            }
            if ((resultArg = Type.applyVarianceOverrides(arg, covariant, contravariant, overrides)).isNothing()) {
                return resultArg;
            }
            resultArgs.add(resultArg);
            if (!arg.involvesTypeParameters(overrides.keySet())) continue;
            varianceResults.put(param, SiteVariance.OUT);
        }
        Type result = dec.appliedType(type.getQualifyingType(), resultArgs);
        result.setVarianceOverrides(varianceResults);
        result.setUnderlyingType(type.getUnderlyingType());
        return result;
    }

    public int hashCode() {
        return this.getMemoisedHashCode();
    }

    public boolean equals(Object obj) {
        TypeDeclaration bDecl;
        Type qB;
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Type)) {
            return false;
        }
        Type other = (Type)obj;
        Type qA = this.getQualifyingType();
        if (!(qA == (qB = other.getQualifyingType()) || qA != null && qB != null && qA.equals(qB))) {
            return false;
        }
        TypeDeclaration aDecl = this.getDeclaration();
        if (!aDecl.equalsForCache(bDecl = other.getDeclaration())) {
            return false;
        }
        Map<TypeParameter, Type> typeArgumentsA = this.getTypeArguments();
        Map<TypeParameter, Type> typeArgumentsB = other.getTypeArguments();
        if (typeArgumentsA.size() != typeArgumentsB.size()) {
            return false;
        }
        if (!typeArgumentsA.isEmpty()) {
            List<TypeParameter> typeParametersA = aDecl.getTypeParameters();
            int l = typeParametersA.size();
            for (int i = 0; i < l; ++i) {
                Type typeArgumentB;
                TypeParameter typeParameter = typeParametersA.get(i);
                Type typeArgumentA = typeArgumentsA.get(typeParameter);
                if (typeArgumentA == (typeArgumentB = typeArgumentsB.get(typeParameter)) || typeArgumentA != null && typeArgumentB != null && typeArgumentA.equals(typeArgumentB)) continue;
                return false;
            }
        }
        return this.getVarianceOverrides().equals(other.getVarianceOverrides());
    }

    @Override
    public Type getFullType(Type wrappedType) {
        return super.getFullType(wrappedType);
    }

    public void collectDeclarations(Collection<TypeDeclaration> results) {
        block7: {
            TypeDeclaration d = this.getDeclaration();
            if (d instanceof UnknownType) break block7;
            if (d instanceof UnionType) {
                for (Type t : d.getCaseTypes()) {
                    t.collectDeclarations(results);
                }
            } else if (d instanceof IntersectionType) {
                for (Type t : d.getSatisfiedTypes()) {
                    t.collectDeclarations(results);
                }
            } else {
                results.add(d);
                for (Type t : this.getTypeArgumentList()) {
                    t.collectDeclarations(results);
                }
            }
        }
    }

    private static class SupertypeSubstitution
    extends Substitution {
        private SupertypeSubstitution(Map<TypeParameter, Type> substitutions, Map<TypeParameter, SiteVariance> overrides) {
            super(substitutions, overrides);
        }

        @Override
        void addTypeToUnion(Type ct, boolean covariant, boolean contravariant, List<Type> types) {
            types.add(ct);
        }

        @Override
        void addTypeToIntersection(Type st, boolean covariant, boolean contravariant, List<Type> types, Unit unit) {
            types.add(st);
        }
    }

    private static class Substitution {
        Map<TypeParameter, Type> substitutions;
        Map<TypeParameter, SiteVariance> overrides;

        private Substitution(Map<TypeParameter, Type> substitutions, Map<TypeParameter, SiteVariance> overrides) {
            this.substitutions = substitutions;
            this.overrides = overrides;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Type substitute(Type type, boolean covariant, boolean contravariant) {
            Type.checkDepth();
            try {
                Type type2;
                TypeDeclaration dec;
                Type.incDepth();
                TypeDeclaration ptd = type.getDeclaration();
                Unit unit = ptd.getUnit();
                if (type.isUnion()) {
                    List<Type> cts = type.getCaseTypes();
                    ArrayList<Type> types = new ArrayList<Type>(cts.size());
                    for (Type ct : cts) {
                        if (ct == null) continue;
                        this.addTypeToUnion(this.substitute(ct, covariant, contravariant), covariant, contravariant, types);
                    }
                    Type i$ = ModelUtil.union(types, unit);
                    return i$;
                }
                if (type.isIntersection()) {
                    List<Type> sts = type.getSatisfiedTypes();
                    ArrayList<Type> types = new ArrayList<Type>(sts.size());
                    for (Type st : sts) {
                        if (st == null) continue;
                        this.addTypeToIntersection(this.substitute(st, covariant, contravariant), covariant, contravariant, types, unit);
                    }
                    Type type3 = ModelUtil.canonicalIntersection(types, unit);
                    return type3;
                }
                if (type.isTypeParameter()) {
                    TypeParameter tp = (TypeParameter)ptd;
                    Type sub = this.substitutions.get(tp);
                    if (sub == null) {
                        if (!tp.isTypeConstructor()) {
                            Type type4 = type;
                            return type4;
                        }
                    } else {
                        if (type.isTypeConstructor()) {
                            Type type5 = sub;
                            return type5;
                        }
                        if (tp.getTypeParameters().isEmpty()) {
                            Type type6 = sub;
                            return type6;
                        }
                        Type type7 = this.substitutedAppliedTypeConstructor(type, sub, tp, covariant, contravariant, unit);
                        return type7;
                    }
                    dec = tp;
                } else {
                    dec = ptd;
                }
                if (type.isTypeConstructor()) {
                    type2 = this.substitutedTypeConstructor(type, covariant, contravariant);
                    return type2;
                }
                type2 = this.substitutedType(dec, type, covariant, contravariant);
                return type2;
            }
            finally {
                Type.decDepth();
            }
        }

        private Type substitutedAppliedTypeConstructor(Type type, Type sub, TypeParameter typeConstructorParameter, boolean covariant, boolean contravariant, Unit unit) {
            List<Type> tal = type.getTypeArgumentList();
            List<TypeParameter> tpl = typeConstructorParameter.getTypeParameters();
            ArrayList<Type> sta = new ArrayList<Type>(tal.size());
            for (int i = 0; i < tal.size() && i < tpl.size(); ++i) {
                Type ta = tal.get(i);
                TypeParameter itp = tpl.get(i);
                boolean co = false;
                boolean contra = false;
                if (type.isContravariant(itp)) {
                    co = contravariant;
                    contra = covariant;
                } else if (type.isCovariant(itp)) {
                    co = covariant;
                    contra = contravariant;
                }
                sta.add(ta.substitute(this.substitutions, this.overrides, co, contra));
            }
            return this.substituteIntoTypeConstructors(sub, sta, covariant, contravariant, unit, type);
        }

        private Type substituteIntoTypeConstructors(Type sub, List<Type> args, boolean covariant, boolean contravariant, Unit unit, Type tc) {
            if (sub.isUnion()) {
                ArrayList<Type> list = new ArrayList<Type>();
                for (Type ct : sub.getCaseTypes()) {
                    ModelUtil.addToUnion(list, this.substituteIntoTypeConstructors(ct, args, covariant, contravariant, unit, tc));
                }
                return ModelUtil.union(list, unit);
            }
            if (sub.isIntersection()) {
                ArrayList<Type> list = new ArrayList<Type>();
                for (Type st : sub.getSatisfiedTypes()) {
                    ModelUtil.addToIntersection(list, this.substituteIntoTypeConstructors(st, args, covariant, contravariant, unit, tc), unit);
                }
                return ModelUtil.canonicalIntersection(list, unit);
            }
            Type sqt = sub.getQualifyingType();
            Type qt = sqt == null ? null : this.substitute(sqt, covariant, contravariant);
            Type result = sub.getDeclaration().appliedType(qt, args);
            this.substituteVarianceOverridesInTypeConstructor(tc, result);
            return result;
        }

        private void substituteVarianceOverridesInTypeConstructor(Type typeConstructor, Type result) {
            TypeDeclaration sd = result.getDeclaration();
            HashMap<TypeParameter, SiteVariance> map = new HashMap<TypeParameter, SiteVariance>();
            map.putAll(result.getVarianceOverrides());
            List<TypeParameter> sdtps = sd.getTypeParameters();
            List<TypeParameter> tctps = typeConstructor.getDeclaration().getTypeParameters();
            for (int i = 0; i < tctps.size() && i < sdtps.size(); ++i) {
                TypeParameter tctp = tctps.get(i);
                TypeParameter sdtp = sdtps.get(i);
                SiteVariance var = typeConstructor.getVarianceOverrides().get(tctp);
                if (var == null) continue;
                map.put(sdtp, var);
            }
            result.setVarianceOverrides(map);
        }

        void addTypeToUnion(Type ct, boolean covariant, boolean contravariant, List<Type> types) {
            ModelUtil.addToUnion(types, ct);
        }

        void addTypeToIntersection(Type st, boolean covariant, boolean contravariant, List<Type> types, Unit unit) {
            ModelUtil.addToIntersection(types, st, unit);
        }

        private Type substitutedType(TypeDeclaration dec, Type type, boolean covariant, boolean contravariant) {
            Type result;
            Type receiverType = type.getQualifyingType();
            if (receiverType != null) {
                receiverType = this.substitute(receiverType, covariant, contravariant);
                List<Type> typeArgumentList = type.getTypeArgumentList();
                ArrayList<Type> args = new ArrayList<Type>();
                int s = typeArgumentList.size();
                for (int i = 0; i < s; ++i) {
                    args.add(this.substitute(typeArgumentList.get(i), covariant, contravariant));
                }
                result = dec.appliedType(receiverType, args);
            } else {
                result = new Type();
                result.setDeclaration(dec);
                Map<TypeParameter, Type> typeArguments = type.getTypeArguments();
                HashMap<TypeParameter, Type> typeArgs = new HashMap<TypeParameter, Type>(typeArguments.size());
                for (Map.Entry<TypeParameter, Type> e : typeArguments.entrySet()) {
                    this.substituteTypeArgument(typeArgs, type, covariant, contravariant, e.getKey(), e.getValue());
                }
                result.setTypeArguments(typeArgs);
            }
            result.setTypeConstructor(type.isTypeConstructor());
            result.setTypeConstructorParameter(type.getTypeConstructorParameter());
            result.setVarianceOverrides(type.getVarianceOverrides());
            result.setUnderlyingType(type.getUnderlyingType());
            return result;
        }

        private void substituteTypeArgument(Map<TypeParameter, Type> typeArgs, Type type, boolean covariant, boolean contravariant, TypeParameter tp, Type arg) {
            if (arg != null) {
                boolean co = false;
                boolean contra = false;
                if (type.isContravariant(tp)) {
                    co = contravariant;
                    contra = covariant;
                } else if (type.isCovariant(tp)) {
                    co = covariant;
                    contra = contravariant;
                }
                typeArgs.put(tp, this.substitute(arg, co, contra));
            }
        }

        private Type substitutedTypeConstructor(Type type, boolean covariant, boolean contravariant) {
            TypeDeclaration dec = type.getDeclaration();
            if (dec.isAlias() && this.substitutions != null) {
                Unit unit = dec.getUnit();
                Type et = dec.getExtendedType();
                if (et == null) {
                    return unit.getUnknownType();
                }
                TypeAlias ta = new TypeAlias();
                ta.setAnonymous(dec.isAnonymous());
                ta.setName(dec.getName());
                ta.setExtendedType(et.substitute(this.substitutions, this.overrides, covariant, contravariant));
                ta.setScope(dec.getScope());
                ta.setContainer(dec.getContainer());
                ta.setUnit(unit);
                ArrayList<TypeParameter> tps = new ArrayList<TypeParameter>();
                for (TypeParameter tp : dec.getTypeParameters()) {
                    TypeParameter stp = new TypeParameter();
                    stp.setName(tp.getName());
                    stp.setScope(tp.getScope());
                    stp.setContainer(tp.getContainer());
                    stp.setUnit(tp.getUnit());
                    stp.setDeclaration(ta);
                    List<Type> sts = tp.getSatisfiedTypes();
                    ArrayList<Type> ssts = new ArrayList<Type>(sts.size());
                    for (Type st : sts) {
                        ssts.add(st.substitute(this.substitutions, this.overrides, covariant, contravariant));
                    }
                    stp.setSatisfiedTypes(ssts);
                    List<Type> cts = tp.getCaseTypes();
                    if (cts != null) {
                        ArrayList<Type> scts = new ArrayList<Type>(cts.size());
                        for (Type ct : cts) {
                            scts.add(ct.substitute(this.substitutions, this.overrides, covariant, contravariant));
                        }
                        stp.setCaseTypes(scts);
                    }
                    tps.add(stp);
                }
                ta.setTypeParameters(tps);
                Type result = ta.getType();
                Type qt = type.getQualifyingType();
                if (qt != null) {
                    result.setQualifyingType(qt.substitute(this.substitutions, this.overrides, covariant, contravariant));
                }
                result.setTypeConstructor(true);
                result.setTypeConstructorParameter(type.getTypeConstructorParameter());
                return result;
            }
            return type;
        }
    }

    static interface Criteria {
        public boolean satisfies(TypeDeclaration var1);

        public boolean isMemberLookup();
    }

    private static final class SupertypeCriteria
    implements Criteria {
        private TypeDeclaration dec;

        private SupertypeCriteria(TypeDeclaration dec) {
            this.dec = dec;
        }

        @Override
        public boolean satisfies(TypeDeclaration type) {
            return !(type instanceof UnionType) && !(type instanceof IntersectionType) && type.equals(this.dec);
        }

        @Override
        public boolean isMemberLookup() {
            return false;
        }
    }
}

