/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedReference;
import java.util.List;
import java.util.Objects;

public abstract class TypedDeclaration
extends Declaration {
    private static final int UNCHECKED_NULL = 2048;
    private static final int UNBOXED_KNOWN = 4096;
    private static final int UNBOXED = 8192;
    private static final int TYPE_ERASED = 16384;
    private static final int UNTRUSTED_TYPE = 32768;
    private static final int DYNAMIC = 65536;
    private Type type;
    private TypedDeclaration originalDeclaration;

    public boolean isDynamicallyTyped() {
        return (this.flags & 0x10000) != 0;
    }

    public void setDynamicallyTyped(boolean dynamicallyTyped) {
        this.flags = dynamicallyTyped ? (this.flags |= 0x10000) : (this.flags &= 0xFFFEFFFF);
    }

    public TypeDeclaration getTypeDeclaration() {
        if (this.type == null) {
            return null;
        }
        return this.type.getDeclaration();
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type t) {
        this.type = t;
    }

    public TypedReference appliedTypedReference(Type qualifyingType, List<Type> typeArguments) {
        return this.appliedTypedReference(qualifyingType, typeArguments, false);
    }

    public TypedReference appliedTypedReference(Type qualifyingType, List<Type> typeArguments, boolean assignment) {
        TypedReference ptr = new TypedReference(!assignment, assignment);
        ptr.setDeclaration(this);
        ptr.setQualifyingType(qualifyingType);
        ptr.setTypeArguments(ModelUtil.getTypeArgumentMap(this, qualifyingType, typeArguments));
        return ptr;
    }

    public TypedReference getTypedReference() {
        TypedReference ptr = new TypedReference(true, false);
        ptr.setQualifyingType(this.getMemberContainerType());
        ptr.setDeclaration(this);
        ptr.setTypeArguments(this.getTypeParametersAsArguments());
        return ptr;
    }

    @Override
    public Reference appliedReference(Type pt, List<Type> typeArguments) {
        return this.appliedTypedReference(pt, typeArguments);
    }

    @Override
    public final Reference getReference() {
        return this.getTypedReference();
    }

    @Override
    public boolean isMember() {
        return this.getContainer() instanceof ClassOrInterface;
    }

    public boolean isVariable() {
        return false;
    }

    public boolean isLate() {
        return false;
    }

    public TypedDeclaration getOriginalDeclaration() {
        return this.originalDeclaration;
    }

    public void setOriginalDeclaration(TypedDeclaration originalDeclaration) {
        this.originalDeclaration = originalDeclaration;
    }

    public Boolean getUnboxed() {
        if ((this.flags & 0x1000) == 0) {
            return null;
        }
        return (this.flags & 0x2000) != 0;
    }

    public void setUnboxed(Boolean value) {
        if (value == null) {
            this.flags &= 0xFFFFEFFF;
        } else {
            this.flags |= 0x1000;
            this.flags = value.booleanValue() ? (this.flags |= 0x2000) : (this.flags &= 0xFFFFDFFF);
        }
    }

    public Boolean getTypeErased() {
        return (this.flags & 0x4000) != 0;
    }

    public void setTypeErased(Boolean typeErased) {
        this.flags = typeErased.booleanValue() ? (this.flags |= 0x4000) : (this.flags &= 0xFFFFBFFF);
    }

    public Boolean getUntrustedType() {
        return (this.flags & 0x8000) != 0;
    }

    public void setUntrustedType(Boolean untrustedType) {
        this.flags = untrustedType.booleanValue() ? (this.flags |= 0x8000) : (this.flags &= 0xFFFF7FFF);
    }

    public boolean hasUncheckedNullType() {
        return (this.flags & 0x800) != 0;
    }

    public void setUncheckedNullType(boolean uncheckedNullType) {
        this.flags = uncheckedNullType ? (this.flags |= 0x800) : (this.flags &= 0xFFFFF7FF);
    }

    @Override
    protected int hashCodeForCache() {
        int ret = 17;
        Scope container = this.getContainer();
        if (container instanceof Declaration) {
            Declaration dec = (Declaration)((Object)container);
            ret = 37 * ret + dec.hashCodeForCache();
        } else {
            ret = 37 * ret + container.hashCode();
        }
        String qualifier = this.getQualifier();
        ret = 37 * ret + (qualifier == null ? 0 : qualifier.hashCode());
        ret = 37 * ret + Objects.hashCode(this.getName());
        return ret;
    }

    @Override
    protected boolean equalsForCache(Object o) {
        Declaration dec;
        if (o == null || !(o instanceof TypedDeclaration)) {
            return false;
        }
        TypedDeclaration b = (TypedDeclaration)o;
        Scope container = this.getContainer();
        if (container instanceof Declaration ? !(dec = (Declaration)((Object)container)).equalsForCache(b.getContainer()) : !container.equals(b.getContainer())) {
            return false;
        }
        if (!Objects.equals(this.getQualifier(), b.getQualifier())) {
            return false;
        }
        return Objects.equals(this.getName(), b.getName());
    }

    public boolean isSelfCaptured() {
        return false;
    }
}

