/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.Reference;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import java.util.List;
import java.util.Map;

public class TypedReference
extends Reference {
    private TypedDeclaration declaration;
    private final boolean covariant;
    private final boolean contravariant;

    TypedReference(boolean covariant, boolean contravariant) {
        this.covariant = covariant;
        this.contravariant = contravariant;
    }

    @Override
    public TypedDeclaration getDeclaration() {
        return this.declaration;
    }

    void setDeclaration(TypedDeclaration declaration) {
        this.declaration = declaration;
    }

    @Override
    public Type getType() {
        TypedDeclaration declaration = this.getDeclaration();
        if (declaration == null) {
            return null;
        }
        Type type = declaration.getType();
        return type == null ? null : type.substitute(this);
    }

    public boolean isContravariant() {
        return this.contravariant;
    }

    public boolean isCovariant() {
        return this.covariant;
    }

    public String toString() {
        return this.asString() + " (typed reference)";
    }

    @Override
    public String asString() {
        Generic g;
        List<TypeParameter> tps;
        TypedDeclaration dec = this.getDeclaration();
        StringBuilder name = new StringBuilder();
        Type type = this.getQualifyingType();
        if (type != null) {
            name.append(type.asString()).append(".");
        }
        name.append(dec.getName());
        if (dec instanceof Generic && !(tps = (g = (Generic)((Object)dec)).getTypeParameters()).isEmpty()) {
            name.append("<");
            Map<TypeParameter, Type> args = this.getTypeArguments();
            int l = tps.size();
            for (int i = 0; i < l; ++i) {
                TypeParameter tp;
                Type arg;
                if (i != 0) {
                    name.append(",");
                }
                if ((arg = args.get(tp = tps.get(i))) == null) {
                    name.append("unknown");
                    continue;
                }
                name.append(arg.asString());
            }
            name.append(">");
        }
        return name.toString();
    }
}

