/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.model;

import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.Type;

public class Value
extends FunctionOrValue
implements Scope {
    private static final int VARIABLE = 0x400000;
    private static final int TRANSIENT = 0x800000;
    private static final int LATE = 0x1000000;
    private static final int ENUM_VALUE = 0x2000000;
    private static final int SPECIFIED_IN_FOR_ELSE = 0x4000000;
    private static final int INFERRED = 0x8000000;
    private static final int SELF_CAPTURED = 0x10000000;
    private Setter setter;

    public Setter getSetter() {
        return this.setter;
    }

    public void setSetter(Setter setter) {
        this.setter = setter;
    }

    @Override
    public boolean isVariable() {
        return (this.flags & 0x400000) != 0 || this.setter != null;
    }

    public void setVariable(boolean variable) {
        this.flags = variable ? (this.flags |= 0x400000) : (this.flags &= 0xFFBFFFFF);
    }

    @Override
    public boolean isTransient() {
        return (this.flags & 0x800000) != 0;
    }

    public void setTransient(boolean trans) {
        this.flags = trans ? (this.flags |= 0x800000) : (this.flags &= 0xFF7FFFFF);
    }

    @Override
    public boolean isLate() {
        return (this.flags & 0x1000000) != 0;
    }

    public void setLate(boolean late) {
        this.flags = late ? (this.flags |= 0x1000000) : (this.flags &= 0xFEFFFFFF);
    }

    public boolean isEnumValue() {
        return (this.flags & 0x2000000) != 0;
    }

    public void setEnumValue(boolean enumValue) {
        this.flags = enumValue ? (this.flags |= 0x2000000) : (this.flags &= 0xFDFFFFFF);
    }

    public boolean isSpecifiedInForElse() {
        return (this.flags & 0x4000000) != 0;
    }

    public void setSpecifiedInForElse(boolean assignedInFor) {
        this.flags = assignedInFor ? (this.flags |= 0x4000000) : (this.flags &= 0xFBFFFFFF);
    }

    @Override
    public boolean isSelfCaptured() {
        return (this.flags & 0x10000000) != 0;
    }

    public void setSelfCaptured(boolean selfCaptured) {
        this.flags = selfCaptured ? (this.flags |= 0x10000000) : (this.flags &= 0xEFFFFFFF);
    }

    public boolean isInferred() {
        return (this.flags & 0x8000000) != 0;
    }

    public void setInferred(boolean inferred) {
        this.flags = inferred ? (this.flags |= 0x8000000) : (this.flags &= 0xF7FFFFFF);
    }

    @Override
    public Backends getScopedBackends() {
        return super.getScopedBackends();
    }

    @Override
    public String toString() {
        Type type = this.getType();
        if (type == null) {
            return "value " + this.toStringName();
        }
        return "value " + this.toStringName() + " => " + type.asString();
    }
}

