/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.model.typechecker.util;

import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.Unit;
import java.util.List;

public class TypePrinter {
    public static final TypePrinter DEFAULT = new TypePrinter(true, true, false, true, false);
    public static final TypePrinter ESCAPED = new TypePrinter(true, true, false, true, true);
    private final boolean printAbbreviated;
    private final boolean printTypeParameters;
    private final boolean printTypeParameterDetail;
    private final boolean printQualifyingType;
    private final boolean printQualifier;
    private final boolean printFullyQualified;
    private final boolean escapeLowercased;

    public TypePrinter() {
        this(false, false, false, false, false, false, false);
    }

    public TypePrinter(boolean printAbbreviated) {
        this(printAbbreviated, true, false, true, false);
    }

    public TypePrinter(boolean printAbbreviated, boolean printTypeParameters, boolean printTypeParameterDetail, boolean printQualifyingType, boolean escapeLowercased) {
        this(printAbbreviated, printTypeParameters, printTypeParameterDetail, printQualifyingType, escapeLowercased, false, false);
    }

    public TypePrinter(boolean printAbbreviated, boolean printTypeParameters, boolean printTypeParameterDetail, boolean printQualifyingType, boolean escapeLowercased, boolean printFullyQualified, boolean printQualifier) {
        this.printAbbreviated = printAbbreviated;
        this.printTypeParameters = printTypeParameters;
        this.printTypeParameterDetail = printTypeParameterDetail;
        this.printQualifyingType = printQualifyingType;
        this.escapeLowercased = escapeLowercased;
        this.printFullyQualified = printFullyQualified;
        this.printQualifier = printQualifier;
    }

    protected boolean printAbbreviated() {
        return this.printAbbreviated;
    }

    protected boolean printTypeParameters() {
        return this.printTypeParameters;
    }

    protected boolean printTypeParameterDetail() {
        return this.printTypeParameterDetail;
    }

    protected boolean printQualifyingType() {
        return this.printQualifyingType;
    }

    protected boolean printQualifier() {
        return this.printQualifier;
    }

    protected boolean printFullyQualified() {
        return this.printFullyQualified;
    }

    protected String lt() {
        return "<";
    }

    protected String gt() {
        return ">";
    }

    protected String amp() {
        return "&";
    }

    public String print(Type pt, Unit unit) {
        StringBuilder name;
        if (pt == null) {
            return "unknown";
        }
        if (this.printAbbreviated() && !pt.isTypeAlias()) {
            String elemTypes;
            Unit u = pt.getDeclaration().getUnit();
            if (TypePrinter.abbreviateOptional(pt)) {
                Type dt = pt.eliminateNull();
                String dtn = this.print(dt, unit);
                if (this.isPrimitiveAbbreviatedType(dt)) {
                    return dtn + "?";
                }
                return this.lt() + dtn + this.gt() + "?";
            }
            if (TypePrinter.abbreviateEmpty(pt)) {
                return "[]";
            }
            if (this.abbreviateHomoTuple(pt)) {
                Type et = u.getSequentialElementType(pt);
                String etn = this.print(et, unit);
                int len = u.getHomogeneousTupleLength(pt);
                if (this.isPrimitiveAbbreviatedType(et)) {
                    return etn + "[" + len + "]";
                }
                return "<" + etn + ">[" + len + "]";
            }
            if (TypePrinter.abbreviateSequential(pt)) {
                Type it = u.getIteratedType(pt);
                String etn = this.print(it, unit);
                if (this.isPrimitiveAbbreviatedType(it)) {
                    return etn + "[]";
                }
                return this.lt() + etn + this.gt() + "[]";
            }
            if (TypePrinter.abbreviateSequence(pt)) {
                Type it = u.getIteratedType(pt);
                String etn = this.print(it, unit);
                if (this.isPrimitiveAbbreviatedType(it) || it.isUnion() || it.isIntersection()) {
                    return "[" + etn + "+]";
                }
                return "[" + this.lt() + etn + this.gt() + "+]";
            }
            if (TypePrinter.abbreviateIterable(pt)) {
                String many;
                Type it = u.getIteratedType(pt);
                Type nt = pt.getTypeArgumentList().get(1);
                String itn = this.print(it, unit);
                String string = many = nt.isNothing() ? "+" : "*";
                if (this.isPrimitiveAbbreviatedType(it) || it.isUnion() || it.isIntersection()) {
                    return "{" + itn + many + "}";
                }
                return "{" + this.lt() + itn + this.gt() + many + "}";
            }
            if (TypePrinter.abbreviateEntry(pt)) {
                Type kt = u.getKeyType(pt);
                Type vt = u.getValueType(pt);
                return this.print(kt, unit) + "-" + this.gt() + this.print(vt, unit);
            }
            if (TypePrinter.abbreviateCallable(pt)) {
                List<Type> tal = pt.getTypeArgumentList();
                Type rt = tal.get(0);
                Type at = tal.get(1);
                if (TypePrinter.abbreviateCallableArg(at)) {
                    String paramTypes = this.getTupleElementTypeNames(at, unit);
                    if (rt != null && paramTypes != null) {
                        String rtn = this.print(rt, unit);
                        if (!this.isPrimitiveAbbreviatedType(rt)) {
                            rtn = this.lt() + rtn + this.gt();
                        }
                        return rtn + "(" + paramTypes + ")";
                    }
                } else if (rt != null && at != null) {
                    String rtn = this.print(rt, unit);
                    String atn = this.print(at, unit);
                    if (!this.isPrimitiveAbbreviatedType(at)) {
                        atn = this.lt() + atn + this.gt();
                    }
                    if (!this.isPrimitiveAbbreviatedType(rt)) {
                        rtn = this.lt() + rtn + this.gt();
                    }
                    return rtn + "(*" + atn + ")";
                }
            }
            if (TypePrinter.abbreviateTuple(pt) && (elemTypes = this.getTupleElementTypeNames(pt, unit)) != null) {
                return "[" + elemTypes + "]";
            }
        }
        if (pt.isUnion()) {
            name = new StringBuilder();
            boolean first = true;
            for (Type caseType : pt.getCaseTypes()) {
                if (first) {
                    first = false;
                } else {
                    name.append("|");
                }
                if (caseType == null) {
                    name.append("unknown");
                    continue;
                }
                if (this.printAbbreviated() && TypePrinter.abbreviateEntry(caseType)) {
                    name.append(this.lt()).append(this.print(caseType, unit)).append(this.gt());
                    continue;
                }
                name.append(this.print(caseType, unit));
            }
            return name.toString();
        }
        if (pt.isIntersection()) {
            name = new StringBuilder();
            boolean first = true;
            for (Type satisfiedType : pt.getSatisfiedTypes()) {
                if (first) {
                    first = false;
                } else {
                    name.append(this.amp());
                }
                if (satisfiedType == null) {
                    name.append("unknown");
                    continue;
                }
                if (this.printAbbreviated() && TypePrinter.abbreviateEntry(satisfiedType) || satisfiedType.isUnion()) {
                    name.append(this.lt()).append(this.print(satisfiedType, unit)).append(this.gt());
                    continue;
                }
                name.append(this.print(satisfiedType, unit));
            }
            return name.toString();
        }
        if (pt.isTypeParameter()) {
            name = new StringBuilder();
            TypeParameter tp = (TypeParameter)pt.getDeclaration();
            if (this.printTypeParameterDetail() && tp.isContravariant()) {
                name.append("in ");
            }
            if (this.printTypeParameterDetail() && tp.isCovariant()) {
                name.append("out ");
            }
            name.append(this.getSimpleProducedTypeName(pt, unit));
            if (this.printTypeParameterDetail() && tp.isDefaulted()) {
                Type dta = tp.getDefaultTypeArgument();
                if (dta == null) {
                    name.append("=");
                } else {
                    name.append(" = ").append(this.print(dta, unit));
                }
            }
            return name.toString();
        }
        TypeDeclaration declaration = pt.getDeclaration();
        if (declaration.isAlias() && declaration.isAnonymous()) {
            StringBuilder name2 = new StringBuilder();
            if (pt.isTypeConstructor()) {
                name2.append(this.lt());
                TypeParameter tpc = pt.getTypeConstructorParameter();
                List<TypeParameter> params = (tpc == null ? declaration : tpc).getTypeParameters();
                for (TypeParameter tp : params) {
                    if (name2.length() > this.lt().length()) {
                        name2.append(", ");
                    }
                    if (tp.isCovariant()) {
                        name2.append("out ");
                    }
                    if (tp.isContravariant()) {
                        name2.append("in ");
                    }
                    this.printDeclaration(name2, tp, this.printFullyQualified(), unit);
                }
                name2.append(this.gt());
                this.appendConstraintsString(pt, name2, unit);
                name2.append(" =").append(this.gt()).append(" ");
            }
            Type aliasedType = declaration.getExtendedType().substitute(pt);
            name2.append(this.print(aliasedType, unit));
            return name2.toString();
        }
        return this.getSimpleProducedTypeName(pt, unit);
    }

    private boolean abbreviateHomoTuple(Type pt) {
        if (pt.isTuple()) {
            Unit unit = pt.getDeclaration().getUnit();
            return unit.getHomogeneousTupleLength(pt) > 1;
        }
        return false;
    }

    public static boolean abbreviateEntry(Type pt) {
        if (pt.isEntry() && pt.getTypeArgumentList().size() == 2) {
            Unit unit = pt.getDeclaration().getUnit();
            Type kt = unit.getKeyType(pt);
            Type vt = unit.getValueType(pt);
            return kt != null && vt != null && !kt.isEntry() && !vt.isEntry();
        }
        return false;
    }

    public static boolean abbreviateEmpty(Type pt) {
        return pt.isEmpty();
    }

    public static boolean abbreviateOptional(Type pt) {
        if (pt.isUnion()) {
            TypeDeclaration dec = pt.getDeclaration();
            Unit unit = dec.getUnit();
            Class nd = unit.getNullDeclaration();
            return pt.getCaseTypes().size() == 2 && ModelUtil.isElementOfUnion(pt, nd);
        }
        return false;
    }

    public static boolean abbreviateTuple(Type pt) {
        return pt.isTuple() && TypePrinter.isTupleTypeWellformed(pt);
    }

    public static boolean abbreviateCallable(Type pt) {
        if (pt.isInterface()) {
            Unit unit;
            Interface callableDeclaration;
            TypeDeclaration dec = pt.getDeclaration();
            return dec.equals(callableDeclaration = (unit = dec.getUnit()).getCallableDeclaration()) && pt.getTypeArgumentList().size() == 2 && pt.getTypeArgumentList().get(0) != null;
        }
        return false;
    }

    private static boolean abbreviateCallableArg(Type at) {
        if (at.isUnion()) {
            List<Type> caseTypes = at.getCaseTypes();
            return caseTypes.size() == 2 && TypePrinter.abbreviateEmpty(caseTypes.get(0)) && TypePrinter.abbreviateCallableArg(caseTypes.get(1));
        }
        return TypePrinter.abbreviateEmpty(at) || TypePrinter.abbreviateSequence(at) || TypePrinter.abbreviateSequential(at) || TypePrinter.abbreviateTuple(at);
    }

    public static boolean abbreviateSequence(Type pt) {
        if (pt.isSequence()) {
            Unit unit = pt.getDeclaration().getUnit();
            Type et = unit.getIteratedType(pt);
            return et != null;
        }
        return false;
    }

    public static boolean abbreviateSequential(Type pt) {
        if (pt.isSequential()) {
            Unit unit = pt.getDeclaration().getUnit();
            Type et = unit.getIteratedType(pt);
            return et != null;
        }
        return false;
    }

    public static boolean abbreviateIterable(Type pt) {
        if (pt.isIterable()) {
            Type at;
            Unit unit = pt.getDeclaration().getUnit();
            Type et = unit.getIteratedType(pt);
            List<Type> typeArgs = pt.getTypeArgumentList();
            if (et != null && typeArgs.size() == 2 && (at = typeArgs.get(1)) != null) {
                return at.isNothing() || at.isNull();
            }
        }
        return false;
    }

    private static boolean isTupleTypeWellformed(Type args) {
        if (args == null || args.getTypeArgumentList().size() < 3) {
            return false;
        }
        Unit unit = args.getDeclaration().getUnit();
        List<Type> elemtypes = unit.getTupleElementTypes(args);
        if (unit.isTupleLengthUnbounded(args)) {
            int lastIndex = elemtypes.size() - 1;
            Type last = elemtypes.get(lastIndex);
            elemtypes.set(lastIndex, unit.getSequentialElementType(last));
        }
        if (elemtypes == null) {
            return false;
        }
        Type t = ModelUtil.union(elemtypes, unit);
        Type typeArg = args.getTypeArgumentList().get(0);
        if (typeArg == null) {
            return false;
        }
        return t.isExactly(typeArg);
    }

    private String getTupleElementTypeNames(Type args, Unit unit) {
        if (args != null) {
            List<Type> cts;
            Unit u = args.getDeclaration().getUnit();
            boolean defaulted = false;
            if (args.isUnion() && (cts = args.getCaseTypes()).size() == 2) {
                Type rc;
                Type lc = cts.get(0);
                if (lc.isEmpty()) {
                    args = cts.get(1);
                    defaulted = true;
                }
                if ((rc = cts.get(1)).isEmpty()) {
                    args = cts.get(0);
                    defaulted = true;
                }
            }
            if (args.isClassOrInterface()) {
                if (args.isTuple()) {
                    List<Type> tal = args.getTypeArgumentList();
                    if (tal.size() >= 3) {
                        Type first = tal.get(1);
                        Type rest = tal.get(2);
                        if (first != null && rest != null) {
                            String argtype = this.print(first, unit);
                            if (rest.isEmpty()) {
                                return defaulted ? argtype + "=" : argtype;
                            }
                            String argtypes = this.getTupleElementTypeNames(rest, unit);
                            if (argtypes != null) {
                                return defaulted ? argtype + "=, " + argtypes : argtype + ", " + argtypes;
                            }
                        }
                    }
                } else {
                    String elemtype;
                    Type elementType;
                    if (args.isEmpty()) {
                        return defaulted ? "=" : "";
                    }
                    if (!defaulted && args.isSequential()) {
                        elementType = u.getIteratedType(args);
                        if (elementType != null) {
                            elemtype = this.print(elementType, unit);
                            if (this.isPrimitiveAbbreviatedType(elementType)) {
                                return elemtype + "*";
                            }
                            return this.lt() + elemtype + this.gt() + "*";
                        }
                    } else if (!defaulted && args.isSequence() && (elementType = u.getIteratedType(args)) != null) {
                        elemtype = this.print(elementType, unit);
                        if (this.isPrimitiveAbbreviatedType(elementType)) {
                            return elemtype + "+";
                        }
                        return this.lt() + elemtype + this.gt() + "+";
                    }
                }
            }
        }
        return null;
    }

    private boolean isPrimitiveAbbreviatedType(Type pt) {
        if (pt.isIntersection()) {
            return false;
        }
        if (pt.isUnion()) {
            return TypePrinter.abbreviateOptional(pt);
        }
        return !TypePrinter.abbreviateEntry(pt);
    }

    protected String getSimpleProducedTypeName(Type pt, Unit unit) {
        Type qt;
        StringBuilder ptn = new StringBuilder();
        boolean fullyQualified = this.printFullyQualified();
        if (this.printQualifyingType() && (qt = pt.getQualifyingType()) != null && qt.getDeclaration().isNamed()) {
            boolean isComplex;
            boolean bl = isComplex = qt.isIntersection() || qt.isUnion();
            if (isComplex) {
                ptn.append(this.lt());
            }
            ptn.append(this.print(qt, unit));
            if (isComplex) {
                ptn.append(this.gt());
            }
            ptn.append(".");
            fullyQualified = false;
        }
        TypeDeclaration ptd = pt.getDeclaration();
        this.printDeclaration(ptn, ptd, fullyQualified, unit);
        List<Type> args = pt.getTypeArgumentList();
        List<TypeParameter> params = ptd.getTypeParameters();
        if (!pt.isTypeConstructor() && this.printTypeParameters() && !args.isEmpty()) {
            ptn.append(this.lt());
            boolean first = true;
            for (int i = 0; i < args.size() && i < params.size(); ++i) {
                Type t = args.get(i);
                TypeParameter p = params.get(i);
                if (first) {
                    first = false;
                } else {
                    ptn.append(",");
                }
                if (t == null) {
                    ptn.append("unknown");
                    continue;
                }
                if (!p.isCovariant() && pt.isCovariant(p)) {
                    ptn.append("out ");
                }
                if (!p.isContravariant() && pt.isContravariant(p)) {
                    ptn.append("in ");
                }
                ptn.append(this.print(t, unit));
            }
            ptn.append(this.gt());
        }
        return ptn.toString();
    }

    private void printDeclaration(StringBuilder ptn, Declaration declaration, boolean fullyQualified, Unit unit) {
        String qualifier;
        if (fullyQualified && !(declaration instanceof TypeParameter)) {
            Scope container;
            for (container = declaration.getContainer(); container != null && !(container instanceof Package) && !(container instanceof Declaration); container = container.getContainer()) {
            }
            if (container != null) {
                if (container instanceof Package) {
                    String qname = container.getQualifiedNameString();
                    if (!qname.isEmpty()) {
                        ptn.append(qname).append("::");
                    }
                } else {
                    this.printDeclaration(ptn, (Declaration)((Object)container), fullyQualified, unit);
                    ptn.append(".");
                }
            }
        }
        if (this.printQualifier() && (qualifier = declaration.getQualifier()) != null) {
            ptn.append(qualifier);
        }
        ptn.append(this.getSimpleDeclarationName(declaration, unit));
    }

    protected String getSimpleDeclarationName(Declaration declaration, Unit unit) {
        int firstCodePoint;
        String name = declaration.getName(unit);
        if (this.escapeLowercased && !Character.isUpperCase(firstCodePoint = name.codePointAt(0))) {
            name = "\\I" + name;
        }
        return name;
    }

    private void appendConstraintsString(Type pt, StringBuilder result, Unit unit) {
        TypeParameter tpc = pt.getTypeConstructorParameter();
        List<TypeParameter> params = tpc == null ? pt.getDeclaration().getTypeParameters() : tpc.getTypeParameters();
        for (TypeParameter tp : params) {
            boolean first;
            boolean hasUpperBounds;
            List<Type> sts = tp.getSatisfiedTypes();
            List<Type> cts = tp.getCaseTypes();
            boolean hasEnumeratedBounds = cts != null && !cts.isEmpty();
            boolean bl = hasUpperBounds = !sts.isEmpty();
            if (!hasUpperBounds && !hasEnumeratedBounds) continue;
            result.append(" given ");
            this.printDeclaration(result, tp, this.printFullyQualified(), unit);
            if (hasEnumeratedBounds) {
                result.append(" of ");
                first = true;
                for (Type ct : cts) {
                    if (first) {
                        first = false;
                    } else {
                        result.append("|");
                    }
                    result.append(this.print(ct, unit));
                }
            }
            if (!hasUpperBounds) continue;
            result.append(" satisfies ");
            first = true;
            for (Type st : sts) {
                if (first) {
                    first = false;
                } else {
                    result.append(this.amp());
                }
                result.append(this.print(st, unit));
            }
        }
    }
}

