/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.browse;

import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.cmr.ceylon.RepoUsingTool;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.common.tools.ModuleSpec;
import com.redhat.ceylon.tools.browse.CeylonBrowseMessages;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Summary(value="Open module documentation in the browser")
public class CeylonBrowseTool
extends RepoUsingTool {
    private List<ModuleSpec> modules;

    public CeylonBrowseTool() {
        super(CeylonBrowseMessages.RESOURCE_BUNDLE);
    }

    @Argument(argumentName="module", multiplicity="+")
    public void setModules(List<String> modules) {
        this.modules = ModuleSpec.parseEachList(modules, new ModuleSpec.Option[0]);
    }

    @Override
    public void initialize(CeylonTool tool) {
    }

    @Override
    public void run() throws Exception {
        for (ModuleSpec module : this.modules) {
            ArrayList<ModuleVersionDetails> versions = new ArrayList<ModuleVersionDetails>(this.getModuleVersions(this.getRepositoryManager(), module.getName(), module.getVersion(), ModuleQuery.Type.ALL, null, null, null, null));
            Collections.sort(versions);
            if (versions.isEmpty()) {
                String err = this.getModuleNotFoundErrorMessage(this.getRepositoryManager(), module.getName(), module.getVersion());
                this.errorAppend(err);
                this.errorNewline();
                continue;
            }
            ModuleVersionDetails mvd = (ModuleVersionDetails)versions.get(versions.size() - 1);
            this.browseDoc(mvd);
        }
    }

    private void browseDoc(ModuleVersionDetails mvd) throws IOException {
        if (mvd.getOrigin() == null) {
            this.errorMsg("error.noOrigin", this.getModuleAndVersion(mvd));
            return;
        }
        URI uri = mvd.isRemote() ? this.parseRemoteUri(mvd) : this.parseLocalUri(mvd);
        if (uri != null) {
            try {
                Desktop.getDesktop().browse(uri);
                this.msg("info.browseDoc", this.getModuleAndVersion(mvd), uri);
                this.newline();
            }
            catch (Exception e) {
                this.errorMsg("error.unableToOpenBrowser", this.getModuleAndVersion(mvd), uri);
            }
        }
    }

    private URI parseLocalUri(ModuleVersionDetails mvd) throws IOException {
        Path path = Paths.get(mvd.getOrigin(), mvd.getModule().replace('.', File.separatorChar), mvd.getVersion(), "module-doc", "api", "index.html");
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            this.errorMsg("error.noIndex", path);
            return null;
        }
        return path.toUri();
    }

    private URI parseRemoteUri(ModuleVersionDetails mvd) throws IOException {
        String origin = mvd.getOrigin();
        if (origin.startsWith("The Herd (") && origin.endsWith(")")) {
            origin = origin.substring(10, origin.length() - 1);
        }
        if (!origin.endsWith("/")) {
            origin = origin + "/";
        }
        try {
            URL url = new URL(new URL(origin), mvd.getModule().replace('.', '/') + "/" + mvd.getVersion() + "/module-doc/api/index.html");
            return url.toURI();
        }
        catch (Exception e) {
            this.errorMsg("error.unableToParseUri", this.getModuleAndVersion(mvd), e.getMessage());
            return null;
        }
    }

    private String getModuleAndVersion(ModuleVersionDetails mvd) {
        return mvd.getModule() + "/" + mvd.getVersion();
    }
}

