/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.classpath;

import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.tools.moduleloading.ModuleLoadingTool;
import java.io.File;
import java.util.SortedSet;

@Summary(value="Prints a classpath suitable for passing to Java tools to run a given Ceylon module")
@Description(value="Will print a classpath for a given Ceylon module, suitable for use with Java tools to run a given Ceylon module outside of the regular JBoss Modules container used in `ceylon run`.")
public class CeylonClasspathTool
extends ModuleLoadingTool {
    private String moduleNameOptVersion;
    private boolean force;

    @Argument(argumentName="module", multiplicity="1")
    public void setModule(String module) {
        this.moduleNameOptVersion = module;
    }

    @Option(longName="force")
    @Description(value="Force generation of classpath with multiple versions of the same module.")
    public void setForce(boolean force) {
        this.force = force;
    }

    @Override
    public void run() throws Exception {
        String module = ModuleUtil.moduleName(this.moduleNameOptVersion);
        String version2 = this.checkModuleVersionsOrShowSuggestions(this.getRepositoryManager(this.upgradeDist), module, ModuleUtil.moduleVersion(this.moduleNameOptVersion), ModuleQuery.Type.JVM, 8, 0, null, null, null);
        if (version2 == null) {
            return;
        }
        this.loadModule(module, version2);
        if (!this.force) {
            this.errorOnConflictingModule(module, version2);
        }
        boolean once = true;
        for (ArtifactResult entry : this.loadedModules.values()) {
            File file;
            if (entry == null || (file = entry.artifact()) == null) continue;
            SortedSet versions = (SortedSet)this.loadedModuleVersions.get(entry.name());
            if (version2 != null && !versions.isEmpty() && entry.version() != null && !entry.version().equals(versions.last())) continue;
            if (once) {
                once = false;
            } else {
                this.append(File.pathSeparator);
            }
            this.append(file.getAbsolutePath());
        }
        this.flush();
    }

    @Override
    public void initialize(CeylonTool mainTool) throws Exception {
    }
}

