/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.copy;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.ceylon.CeylonUtils;
import com.redhat.ceylon.cmr.ceylon.ModuleCopycat;
import com.redhat.ceylon.cmr.ceylon.OutputRepoUsingTool;
import com.redhat.ceylon.common.BooleanUtil;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.common.tools.ModuleSpec;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.tools.copy.CeylonCopyMessages;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;

@Summary(value="Copies modules from one module repository to another")
@Description(value="Copies a module or a set of modules from one repository to another. If set for recursive copying it will also copy all the module's dependencies and their dependencies until the entire module tree has been copied.")
@RemainingSections(value="## Repositories\n\nRepositories like those specified with the `--rep` or `--out` options can be file paths, HTTP urls to remote servers or can be names of repositories when prepended with a `+` symbol. These names refer to repositories defined in the configuration file or can be any of the following predefined names `+SYSTEM`, `+CACHE`, `+LOCAL`, `+USER`, `+REMOTE` or `+MAVEN`. For more information see http://ceylon-lang.org/documentation/1.2/reference/repository/tools")
public class CeylonCopyTool
extends OutputRepoUsingTool {
    private List<ModuleSpec> modules;
    private boolean withDependencies;
    private Boolean jvm;
    private Boolean js;
    private Boolean docs;
    private Boolean src;
    private Boolean scripts;
    private Boolean all;

    public CeylonCopyTool() {
        super(CeylonCopyMessages.RESOURCE_BUNDLE);
    }

    @Argument(argumentName="module", multiplicity="+")
    public void setModules(List<String> modules) {
        this.setModuleSpecs(ModuleSpec.parseEachList(modules, new ModuleSpec.Option[0]));
    }

    public void setModuleSpecs(List<ModuleSpec> modules) {
        this.modules = modules;
    }

    @Option(longName="with-dependencies", shortName=114)
    @Description(value="Recursively copy all dependencies")
    public void setWithDependencies(boolean withDependencies) {
        this.withDependencies = withDependencies;
    }

    @Option
    @Description(value="Include artifacts compiled for the JVM (`.car` and `.jar`) (default: `true`)")
    public void setJvm(boolean jvm) {
        this.jvm = jvm;
    }

    @Option
    @Description(value="Include artifacts compiled for JavaScript (`.js` and `-model.js`) (default: `true`)")
    public void setJs(boolean js) {
        this.js = js;
    }

    @Option
    @Description(value="Include documentation (default: `false`)")
    public void setDocs(boolean docs) {
        this.docs = docs;
    }

    @Option
    @Description(value="Include sources (default: `false`)")
    public void setSrc(boolean src) {
        this.src = src;
    }

    @Option
    @Description(value="Include scripts (default: `false`)")
    public void setScripts(boolean scripts) {
        this.scripts = scripts;
    }

    @Option
    @Description(value="Include everything (equivalent to `--jvm`, `--js`, `--docs`, `--src`, `--scripts`) (default: `false`)")
    public void setAll(boolean all) {
        this.all = all;
    }

    @Override
    @Option(shortName=100)
    @OptionArgument(argumentName="flags")
    @Description(value="Produce verbose output. If no `flags` are given then be verbose about everything, otherwise just be verbose about the flags which are present. Allowed flags include: `all`, `loader`, `files`.")
    public void setVerbose(String verbose) {
        this.verbose = verbose;
    }

    @Override
    protected boolean needsSystemRepo() {
        return false;
    }

    @Override
    protected boolean doNotReadFromOutputRepo() {
        return true;
    }

    @Override
    public void initialize(CeylonTool mainTool) {
    }

    @Override
    public void run() throws Exception {
        boolean defaults;
        LinkedHashSet<String> artifacts = new LinkedHashSet<String>();
        boolean bl = defaults = this.js == null && this.jvm == null && this.src == null && this.scripts == null && this.docs == null && this.all == null;
        if (BooleanUtil.isTrue(this.all)) {
            artifacts.addAll(Arrays.asList(ArtifactContext.allSuffixes()));
        }
        if (BooleanUtil.isTrue(this.js) || defaults) {
            artifacts.add(".js");
            artifacts.add("-model.js");
            artifacts.add("module-resources");
        } else if (BooleanUtil.isFalse(this.js)) {
            artifacts.remove(".js");
            artifacts.remove("-model.js");
            artifacts.remove("module-resources");
        }
        if (BooleanUtil.isTrue(this.jvm) || defaults) {
            artifacts.add(".car");
            artifacts.add(".jar");
            artifacts.add("module.properties");
            artifacts.add("module.xml");
        } else if (BooleanUtil.isFalse(this.jvm)) {
            artifacts.remove(".car");
            artifacts.remove(".jar");
            artifacts.remove("module.properties");
            artifacts.remove("module.xml");
        }
        if (BooleanUtil.isTrue(this.src)) {
            artifacts.add(".src");
        } else if (BooleanUtil.isFalse(this.src)) {
            artifacts.remove(".src");
        }
        if (BooleanUtil.isTrue(this.scripts)) {
            artifacts.add(".scripts.zip");
        } else if (BooleanUtil.isFalse(this.scripts)) {
            artifacts.remove(".scripts.zip");
        }
        if (BooleanUtil.isTrue(this.docs)) {
            artifacts.add("module-doc");
        } else if (BooleanUtil.isFalse(this.docs)) {
            artifacts.remove("module-doc");
        }
        ArrayList<ArtifactContext> acs = new ArrayList<ArtifactContext>();
        String[] artifactsArray = new String[artifacts.size()];
        artifacts.toArray(artifactsArray);
        for (ModuleSpec module : this.modules) {
            if (module != ModuleSpec.DEFAULT_MODULE && !module.isVersioned()) {
                String version2 = this.checkModuleVersionsOrShowSuggestions(this.getRepositoryManager(), module.getName(), null, ModuleQuery.Type.ALL, null, null, null, null);
                module = new ModuleSpec(module.getName(), version2);
            }
            ArtifactContext ac = new ArtifactContext(module.getName(), module.getVersion(), artifactsArray);
            ac.setIgnoreDependencies(!this.withDependencies);
            ac.setForceOperation(true);
            acs.add(ac);
        }
        final boolean logArtifacts = this.verbose != null && (this.verbose.contains("all") || this.verbose.contains("files"));
        ModuleCopycat copier = new ModuleCopycat(this.getRepositoryManager(), this.getOutputRepositoryManager(), this.log, new ModuleCopycat.CopycatFeedback(){

            @Override
            public boolean beforeCopyModule(ArtifactContext ac, int count, int max) throws IOException {
                String module = ModuleUtil.makeModuleName(ac.getName(), ac.getVersion());
                CeylonCopyTool.this.msg("copying.module", module, count + 1, max).flush();
                return true;
            }

            @Override
            public void afterCopyModule(ArtifactContext ac, int count, int max, boolean copied) throws IOException {
                if (!logArtifacts) {
                    CeylonCopyTool.this.append(") ").msg(copied ? "copying.ok" : "copying.skipped", new Object[0]).newline().flush();
                }
            }

            @Override
            public boolean beforeCopyArtifact(ArtifactContext ac, ArtifactResult ar, int count, int max) throws IOException {
                if (logArtifacts) {
                    if (count == 0) {
                        CeylonCopyTool.this.append(" -- ");
                        CeylonCopyTool.this.append(ar.repositoryDisplayString());
                        CeylonCopyTool.this.newline().flush();
                    }
                    CeylonCopyTool.this.append("    ").msg("copying.artifact", ar.artifact().getName(), count + 1, max).flush();
                } else {
                    if (count > 0) {
                        CeylonCopyTool.this.append(", ");
                    } else {
                        CeylonCopyTool.this.append(" (");
                    }
                    String name = ArtifactContext.getSuffixFromFilename(ar.artifact().getName());
                    if (name.startsWith(".") || name.startsWith("-")) {
                        name = name.substring(1);
                    } else if ("module-doc".equals(name)) {
                        name = "doc";
                    }
                    CeylonCopyTool.this.append(name);
                }
                return true;
            }

            @Override
            public void afterCopyArtifact(ArtifactContext ac, ArtifactResult ar, int count, int max, boolean copied) throws IOException {
                if (logArtifacts) {
                    CeylonCopyTool.this.append(" ").msg(copied ? "copying.ok" : "copying.skipped", new Object[0]).newline().flush();
                }
            }

            @Override
            public void notFound(ArtifactContext ac) throws IOException {
                String err = CeylonCopyTool.this.getModuleNotFoundErrorMessage(CeylonCopyTool.this.getRepositoryManager(), ac.getName(), ac.getVersion());
                CeylonCopyTool.this.errorAppend(err);
                CeylonCopyTool.this.errorNewline();
            }
        });
        copier.copyModules(acs);
    }

    @Override
    protected CeylonUtils.CeylonRepoManagerBuilder createRepositoryManagerBuilder(boolean forInput) {
        return this.createRepositoryManagerBuilderNoOut(forInput);
    }
}

