/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.importjar;

import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleSearchResult;
import com.redhat.ceylon.cmr.ceylon.LegacyImporter;
import com.redhat.ceylon.cmr.ceylon.OutputRepoUsingTool;
import com.redhat.ceylon.common.Messages;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Hidden;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tool.ToolUsageError;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.common.tools.ModuleSpec;
import com.redhat.ceylon.model.cmr.RepositoryException;
import com.redhat.ceylon.tools.importjar.ImportJarException;
import com.redhat.ceylon.tools.importjar.ImportJarMessages;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Summary(value="Imports a jar file into a Ceylon module repository")
@Description(value="Imports the given `<jar-file>` using the module name and version given by `<module>` into the repository named by the `--out` option.\n\n`<module>` is a module name and version separated with a slash, for example `com.example.foobar/1.2.0`.\n\n`<jar-file>` is the name of the Jar file to import.\n\n`<source-jar-file>` is an optional name of a Jar file containing the sources for the Jar file to import.\n")
@RemainingSections(value="## Descriptors\n\nWhen the import-jar tool analyses the <jar-file> and complains about missing dependencies a module descriptor file should be provided. The name of this file can be provided using the `--descriptor` option or, when left out, the tool will look for `<jar-file>.module.properties` or `<jar-file>.module.xml`. \n\nThe format of these `.properties` or `.xml` files is documented online: http://www.ceylon-lang.org/documentation/1.1/reference/structure/module/#legacy_modules \n\nIf the option `--update-descriptor` is given the tool will try to update the given descriptor file with the available information (for now this only works for the `.properties` files). If the file didn't exist yet it will be created.\n\nIf the option `--source-jar-file` is given the tool will try to include the source jar into the module as well, including a SHA1 of that source jar.\n\n## Repositories\n\nRepositories like those specified with the `--rep` or `--out` options can be file paths, HTTP urls to remote servers or can be names of repositories when prepended with a `+` symbol. These names refer to repositories defined in the configuration file or can be any of the following predefined names `+SYSTEM`, `+CACHE`, `+LOCAL`, `+USER`, `+REMOTE` or `+MAVEN`. For more information see http://ceylon-lang.org/documentation/1.2/reference/repository/tools")
public class CeylonImportJarTool
extends OutputRepoUsingTool {
    private ModuleSpec module;
    private File jarFile;
    private File sourceJarFile;
    private File descriptor;
    private boolean updateDescriptor;
    private boolean force;
    private boolean dryRun;
    private boolean showClasses;
    private boolean showSuggestions;
    private boolean allowCars;
    private boolean ignoreAnnotations;
    private List<String> missingDependenciesPackages;
    private Map<String, List<String>> parsedMissingDependenciesPackages;

    public CeylonImportJarTool() {
        super(ImportJarMessages.RESOURCE_BUNDLE);
    }

    @OptionArgument(longName="missing-dependency-packages")
    @Description(value="Specifies which packages a missing dependency contains. Can be specified multiple times. Format: `module-name/module-version=package-wildcard(,package-wildcard)*`, where `package-wildcard` supports `*`, `**` and `?` wildcards.")
    public void setMissingDependencyPackages(List<String> missingDependencyPackages) {
        this.missingDependenciesPackages = missingDependencyPackages;
    }

    @OptionArgument(argumentName="file")
    @Description(value="Specify a module.xml or module.properties file to be used as the module descriptor")
    public void setDescriptor(File descriptor) {
        this.descriptor = descriptor;
    }

    @Argument(argumentName="module", multiplicity="1", order=0)
    public void setModuleSpec(String module) {
        this.setModuleSpec(ModuleSpec.parse(module, ModuleSpec.Option.VERSION_REQUIRED, ModuleSpec.Option.DEFAULT_MODULE_PROHIBITED));
    }

    public void setModuleSpec(ModuleSpec module) {
        this.module = module;
    }

    @Argument(argumentName="jar-file", multiplicity="1", order=1)
    public void setFile(File jarFile) {
        this.jarFile = jarFile;
    }

    @Argument(argumentName="source-jar-file", multiplicity="?", order=2)
    public void setSourceJarFile(File sourceJarFile) {
        this.sourceJarFile = sourceJarFile;
    }

    @Option(longName="update-descriptor")
    @Description(value="Whenever possible will create or adjust the descriptor file with the necessary definitions.")
    public void setUpdateDescriptor(boolean updateDescriptor) {
        this.updateDescriptor = updateDescriptor;
    }

    @Option(longName="force")
    @Description(value="Skips sanity checks and forces publication of the JAR.")
    public void setForce(boolean force) {
        this.force = force;
    }

    @Option(longName="ignore-annotations")
    @Description(value="Do not check annotations for imports (default: `false`).")
    public void setIgnoreAnnotations(boolean ignoreAnnotations) {
        this.ignoreAnnotations = ignoreAnnotations;
    }

    @Hidden
    @Option(longName="allow-cars")
    @Description(value="Allows importing car files [for tests only].")
    public void setAllowCars(boolean allowCars) {
        this.allowCars = allowCars;
    }

    @Option(longName="dry-run")
    @Description(value="Performs all the sanity checks but does not publish the JAR.")
    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    @Option(longName="show-classes")
    @Description(value="Shows all external classes that are not declared as imports instead of their packages only.")
    public void setShowClasses(boolean showClasses) {
        this.showClasses = showClasses;
    }

    @Option(longName="show-suggestions")
    @Description(value="Shows suggestions for modules based on missing package names (this can take a long time).")
    public void setShowSuggestions(boolean showSuggestions) {
        this.showSuggestions = showSuggestions;
    }

    @Override
    protected boolean needsSystemRepo() {
        return false;
    }

    @Override
    public void initialize(CeylonTool mainTool) {
        File f = this.assertJar(this.jarFile, "error.jarFile", "error.jarFile.notJar");
        if (this.sourceJarFile != null) {
            this.assertJar(this.sourceJarFile, "error.sourceJarFile", "error.sourceJarFile.notJar");
        }
        if (this.descriptor == null) {
            String baseName = f.getName().substring(0, f.getName().length() - 4);
            File desc = new File(f.getParentFile(), baseName + ".module.xml");
            if (!desc.isFile()) {
                desc = new File(f.getParentFile(), baseName + ".module.properties");
                if (desc.isFile() || this.updateDescriptor) {
                    this.descriptor = desc;
                }
            } else {
                this.descriptor = desc;
            }
        }
        if (this.descriptor != null) {
            this.checkReadableFile(this.applyCwd(this.descriptor), "error.descriptorFile", !this.updateDescriptor);
            if (!this.descriptor.toString().toLowerCase().endsWith(".xml") && !this.descriptor.toString().toLowerCase().endsWith(".properties")) {
                throw new ImportJarException("error.descriptorFile.badSuffix", new Object[]{this.descriptor}, null);
            }
        }
        if (this.missingDependenciesPackages != null) {
            this.parsedMissingDependenciesPackages = new HashMap<String, List<String>>();
            for (String spec : this.missingDependenciesPackages) {
                int moduleSeparator = spec.indexOf(61);
                if (moduleSeparator == -1) {
                    throw new ImportJarException("error.missingDependenciesPackages.badSyntax", new Object[]{spec}, null);
                }
                String moduleSpec = spec.substring(0, moduleSeparator);
                String packagesSpec = spec.substring(moduleSeparator + 1);
                if (moduleSpec.isEmpty() || packagesSpec.isEmpty()) {
                    throw new ImportJarException("error.missingDependenciesPackages.badSyntax", new Object[]{spec}, null);
                }
                LinkedList<String> packages = new LinkedList<String>();
                for (String pkg : packagesSpec.split(",")) {
                    if (pkg.isEmpty()) {
                        throw new ImportJarException("error.missingDependenciesPackages.badSyntax", new Object[]{spec}, null);
                    }
                    packages.add(pkg);
                }
                if (packages.isEmpty()) {
                    throw new ImportJarException("error.missingDependenciesPackages.badSyntax", new Object[]{spec}, null);
                }
                this.parsedMissingDependenciesPackages.put(moduleSpec, packages);
            }
        }
    }

    private File assertJar(File aJarFile, String errorResource1, String errorResource2) {
        File aJarFileWithCwd = this.applyCwd(aJarFile);
        this.checkReadableFile(aJarFileWithCwd, errorResource1, true);
        String fileName = aJarFileWithCwd.getName().toLowerCase();
        if (!(fileName.endsWith(".jar") || this.allowCars && fileName.endsWith(".car"))) {
            throw new ImportJarException(errorResource2, new Object[]{aJarFile.toString()}, null);
        }
        return aJarFileWithCwd;
    }

    private void checkReadableFile(File f, String keyPrefix, boolean required) {
        if (f.exists()) {
            if (f.isDirectory()) {
                throw new ImportJarException(keyPrefix + ".isDirectory", new Object[]{f.toString()}, null);
            }
            if (!f.canRead()) {
                throw new ImportJarException(keyPrefix + ".notReadable", new Object[]{f.toString()}, null);
            }
        } else if (required) {
            throw new ImportJarException(keyPrefix + ".doesNotExist", new Object[]{f.toString()}, null);
        }
    }

    private LegacyImporter createImporter() {
        LegacyImporter importer = new LegacyImporter(this.module.getName(), this.module.getVersion(), this.applyCwd(this.jarFile), this.applyCwd(this.sourceJarFile), this.getOutputRepositoryManager(), this.getRepositoryManager(), this.log, new LegacyImporter.ImporterFeedback(){

            @Override
            public void beforeDependencies() throws IOException {
                CeylonImportJarTool.this.msg("info.checkingDependencies", new Object[0]).newline();
            }

            @Override
            public void beforeDependency(ModuleDependencyInfo dep) throws IOException {
                CeylonImportJarTool.this.append("    ").append(dep).append(" ... [");
            }

            @Override
            public void dependency(LegacyImporter.DependencyResults result, ModuleDependencyInfo dep) throws IOException {
                switch (result) {
                    case DEP_OK: {
                        CeylonImportJarTool.this.msg("info.ok", new Object[0]);
                        break;
                    }
                    case DEP_OK_UNUSED: {
                        CeylonImportJarTool.this.msg("info.okButUnused", new Object[0]);
                        break;
                    }
                    case DEP_MARK_SHARED: {
                        CeylonImportJarTool.this.msg("error.markShared", new Object[0]);
                        break;
                    }
                    case DEP_NOT_FOUND: {
                        CeylonImportJarTool.this.msg("info.notFound", new Object[0]);
                        break;
                    }
                    case DEP_CHECK_FAILED: {
                        CeylonImportJarTool.this.msg("error.checkFailed", new Object[0]);
                        break;
                    }
                    case DEP_JDK: {
                        CeylonImportJarTool.this.append("    ").append(dep.getName());
                        if (dep.isExport()) {
                            CeylonImportJarTool.this.append(" ... [shared]");
                        }
                        CeylonImportJarTool.this.newline();
                    }
                }
            }

            @Override
            public void dependencyError(LegacyImporter.DependencyErrors error, ModuleDependencyInfo dep) {
                switch (error) {
                    case DEPERR_INVALID_MODULE_DEFAULT: {
                        throw new ImportJarException("error.descriptorFile.invalid.module.default");
                    }
                    case DEPERR_INVALID_MODULE_NAME: {
                        throw new ImportJarException("error.descriptorFile.invalid.module", new Object[]{dep.getName()}, null);
                    }
                    case DEPERR_INVALID_MODULE_VERSION: {
                        throw new ImportJarException("error.descriptorFile.invalid.module.version", new Object[]{dep.getVersion()}, null);
                    }
                }
            }

            @Override
            public void afterDependency(ModuleDependencyInfo dep) throws IOException {
                CeylonImportJarTool.this.append("]").newline();
            }

            @Override
            public void afterDependencies() {
            }

            @Override
            public void beforeJdkModules() throws IOException {
                CeylonImportJarTool.this.msg("info.declare.jdk.imports", new Object[0]).newline();
            }

            @Override
            public void afterJdkModules() {
            }

            @Override
            public void beforePackages() throws IOException {
                CeylonImportJarTool.this.msg("info.declare.module.imports", new Object[0]).newline();
                if (!CeylonImportJarTool.this.showSuggestions) {
                    CeylonImportJarTool.this.msg("info.try.suggestions", new Object[0]).newline();
                }
            }

            @Override
            public void packageName(String pkg, boolean shared) throws IOException {
                CeylonImportJarTool.this.append("    ").append(pkg);
                if (shared) {
                    CeylonImportJarTool.this.append(" ... [shared]");
                }
                CeylonImportJarTool.this.newline();
            }

            @Override
            public void afterPackages() {
            }

            @Override
            public void beforeClasses() throws IOException {
                CeylonImportJarTool.this.msg("info.declare.class.imports", new Object[0]).newline();
            }

            @Override
            public void className(String cls, boolean shared) throws IOException {
                CeylonImportJarTool.this.append("    ").append(cls);
                if (shared) {
                    CeylonImportJarTool.this.append(" ... [shared]");
                }
                CeylonImportJarTool.this.newline();
            }

            @Override
            public void afterClasses() {
            }

            @Override
            public ModuleDependencyInfo suggestions(String pkg, Set<ModuleSearchResult.ModuleDetails> suggestions) throws IOException {
                ModuleDependencyInfo dep = null;
                if (!suggestions.isEmpty()) {
                    CeylonImportJarTool.this.append(", ");
                    if (suggestions.size() > 1) {
                        CeylonImportJarTool.this.msg("info.try.importing.multiple", new Object[0]);
                        for (ModuleSearchResult.ModuleDetails md : suggestions) {
                            CeylonImportJarTool.this.newline();
                            String modver = md.getName() + "/" + md.getLastVersion().getVersion();
                            CeylonImportJarTool.this.append("        ").append(modver);
                            dep = new ModuleDependencyInfo(md.getName(), md.getLastVersion().getVersion(), false, true);
                        }
                    } else {
                        ModuleSearchResult.ModuleDetails md = suggestions.iterator().next();
                        String modver = md.getName() + "/" + md.getLastVersion().getVersion();
                        CeylonImportJarTool.this.msg("info.try.importing", modver);
                        dep = new ModuleDependencyInfo(md.getName(), md.getLastVersion().getVersion(), false, true);
                    }
                }
                return dep;
            }
        });
        return importer;
    }

    @Override
    public void run() throws Exception {
        LegacyImporter importer = this.createImporter().moduleDescriptor(this.applyCwd(this.descriptor)).missingDependenciesPackages(this.parsedMissingDependenciesPackages);
        importer.setIgnoreAnnotations(this.ignoreAnnotations);
        if (!this.force || this.updateDescriptor) {
            try {
                importer.loadModuleDescriptor();
            }
            catch (ImportJarException x) {
                throw x;
            }
            catch (Exception x) {
                String key = "error.descriptorFile.invalid.";
                key = this.descriptor.getName().endsWith(".xml") ? key + "xml" : key + "properties";
                throw new ImportJarException(key, new Object[]{this.descriptor.getPath(), x.getMessage()}, x);
            }
            if (!this.showClasses) {
                importer.listPackages(this.showSuggestions);
            } else {
                importer.listClasses();
            }
        }
        boolean hasErrors = importer.hasErrors();
        if (importer.hasProblems()) {
            if (this.updateDescriptor && this.descriptor != null) {
                if (!this.dryRun) {
                    importer.updateModuleDescriptor();
                }
            } else {
                hasErrors = true;
            }
        }
        if (!hasErrors || this.force) {
            if (!hasErrors) {
                if (this.force && !this.updateDescriptor) {
                    this.msg("info.forcedUpdate", new Object[0]);
                } else {
                    this.msg("info.noProblems", new Object[0]);
                }
            } else {
                this.msg("error.problemsFoundForced", new Object[0]);
            }
            if (!this.dryRun) {
                this.msg("info.noProblems.publishing", new Object[0]).newline();
                try {
                    importer.publish();
                }
                catch (RepositoryException x) {
                    throw new ImportJarException("error.failedWriteArtifact", new Object[]{this.module, x.getLocalizedMessage()}, x);
                }
                catch (Exception x) {
                    throw new ImportJarException("error.failedWriteArtifact", new Object[]{this.module, x.getLocalizedMessage()}, x);
                }
                String repoString = this.getOutputRepositoryManager().getRepositoriesDisplayString().toString();
                this.msg("info.published", this.module.toString(), repoString.substring(1, repoString.length() - 1));
            }
        } else {
            String msgKey = !this.updateDescriptor && this.descriptor == null ? "error.problemsFoundSuggest" : "error.problemsFound";
            throw new ToolUsageError(Messages.msg(ImportJarMessages.RESOURCE_BUNDLE, msgKey, new Object[0]));
        }
        this.append(".").newline();
    }
}

