/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.info;

import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.api.ModuleSearchResult;
import com.redhat.ceylon.cmr.api.ModuleVersionArtifact;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.cmr.api.ModuleVersionQuery;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.api.VersionComparator;
import com.redhat.ceylon.cmr.ceylon.RepoUsingTool;
import com.redhat.ceylon.common.Versions;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.ParsedBy;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.StandardArgumentParsers;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.common.tools.ModuleSpec;
import com.redhat.ceylon.tools.info.CeylonInfoMessages;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

@Summary(value="Prints information about modules in repositories")
@Description(value="When passed a search query like `*foo*` it will look at all the modules in all repositories and see if the word `foo` appears anywhere in the name, description, version, license or any other field in the module's descriptor and print their names. \n\nWhen passed a partial module name like `com.acme.foo*` it will look at all the modules in all the repositories and see if their names start with `com.acme.foo` and print their names.\n\nWhen passed a complete module name like `com.acme.foobar` it will print the list of available versions for that module, with the module repository in which each version was found. Versions marked with `*` are not currently available on the local file system but will be downloaded on-demand from remote servers.\n\nWhen passed a complete module name and version like `com.acme.foobar/1.0` it will print information about the contents of a module archive, its description, its licence and its dependencies")
@RemainingSections(value="## EXAMPLE\n\nFirst list the available modules in the 'ceylon' namespace:\n\n    ceylon info 'ceylon.*'\n\nNext list the versions of a module:\n\n    ceylon info ceylon.collection\n\nThen view information for a particular version:\n\n    ceylon info ceylon.collection/1.2.0\n\n")
public class CeylonInfoTool
extends RepoUsingTool {
    private static final int INFINITE_DEPTH = -1;
    private List<ModuleSpec> modules;
    private boolean showVersions;
    private boolean showDependencies;
    private Incompatible showIncompatible = Incompatible.auto;
    private boolean showFullDescription;
    private String showType;
    private int depth = 1;
    private String findMember;
    private String findPackage;
    private boolean showNames;
    private boolean exactMatch;
    private boolean requireAll;
    private boolean printOverrides;
    private Formatting formatting;
    private List<File> sourceFolders = DefaultToolOptions.getCompilerSourceDirs();
    private Integer jvmBinaryMajor = null;
    private Integer jvmBinaryMinor = null;
    private Integer jsBinaryMajor = null;
    private Integer jsBinaryMinor = null;
    private ModuleQuery.Type queryType = ModuleQuery.Type.ALL;

    public CeylonInfoTool() {
        super(CeylonInfoMessages.RESOURCE_BUNDLE);
    }

    @Override
    protected boolean includeJDK() {
        return true;
    }

    @Override
    protected List<File> getSourceDirs() {
        return this.sourceFolders;
    }

    @OptionArgument(longName="src", argumentName="dir")
    @ParsedBy(value=StandardArgumentParsers.PathArgumentParser.class)
    @Description(value="A directory containing Ceylon and/or Java source code (default: `./source`)")
    public void setSourceFolders(List<File> sourceFolders) {
        this.sourceFolders = sourceFolders;
    }

    @Argument(argumentName="module", multiplicity="+")
    public void setModules(List<String> modules) {
        this.setModuleSpecs(ModuleSpec.parseEachList(modules, new ModuleSpec.Option[0]));
    }

    public void setModuleSpecs(List<ModuleSpec> modules) {
        this.modules = modules;
    }

    @Option(longName="show-versions")
    @Description(value="Show the versions when searching for modules")
    public void setShowVersions(boolean showVersions) {
        this.showVersions = showVersions;
    }

    @Option(longName="print-overrides")
    @Description(value="Print a usable module overrides file when there are duplicate versions, selecting the latest versions")
    public void setPrintOverrides(boolean printOverrides) {
        this.printOverrides = printOverrides;
    }

    @Option(longName="show-dependencies")
    @Description(value="Show the dependencies whenever versions are shown")
    public void setShowDependencies(boolean showDependencies) {
        this.showDependencies = showDependencies;
    }

    @OptionArgument(argumentName="mode")
    @Description(value="Also show versions incompatible with the current Ceylon installation. allowed values are: 'yes', 'no' and 'auto'")
    public void setShowIncompatible(Incompatible showIncompatible) {
        this.showIncompatible = showIncompatible;
    }

    @Option(longName="show-full-description")
    @Description(value="Shows the full description for module details")
    public void setShowFullDescription(boolean showFullDescription) {
        this.showFullDescription = showFullDescription;
    }

    @Option(longName="require-all")
    @Description(value="Only show those results that have all the requested artifact types")
    public void setRequireAll(boolean requireAll) {
        this.requireAll = requireAll;
    }

    @OptionArgument(argumentName="type")
    @Description(value="The artifact types to show information for. Allowed values include: `all`, `jvm`, `car`, `jar`, `js`, `src`, `code`, `ceylon` (default is `all`).")
    public void setShowType(String showType) {
        this.showType = showType;
    }

    @Description(value="The depth of the dependency tree to show, or `all` for the full tree. (Allowed values: any positive integer or `all`, default: `1`)")
    @OptionArgument(argumentName="depth")
    public void setDependencyDepth(String depth) {
        if ("all".equals(depth)) {
            this.setDependencyDepth(-1);
        } else {
            this.setDependencyDepth(Integer.parseInt(depth));
        }
    }

    public void setDependencyDepth(int depth) {
        if (depth != -1 && depth < 0) {
            throw new IllegalArgumentException(CeylonInfoMessages.msg("illegal.depth", new Object[0]));
        }
        this.depth = depth;
    }

    @OptionArgument(argumentName="member-name")
    @Description(value="Shows only those modules that contain members whose name match the given argument.")
    public void setFindMember(String findMember) {
        this.findMember = findMember;
    }

    @OptionArgument(argumentName="package-name")
    @Description(value="Shows only those modules that contain packages whose name match the given argument.")
    public void setFindPackage(String findPackage) {
        this.findPackage = findPackage;
    }

    @Option(longName="show-names")
    @Description(value="Show the matching items when using the `find-member` or `find-package` option")
    public void setShowNames(boolean showNames) {
        this.showNames = showNames;
    }

    @Option(longName="exact-match")
    @Description(value="Only returns exact matches when using the `find-member` or `find-package` option")
    public void setExactMatch(boolean exactMatch) {
        this.exactMatch = exactMatch;
    }

    @OptionArgument(argumentName="formatting")
    @Description(value="Set the output formatting to use, can be `simple` or `fancy`")
    public void setFormatting(Formatting formatting) {
        this.formatting = formatting;
    }

    @Override
    protected boolean needsSystemRepo() {
        return false;
    }

    @Override
    public void initialize(CeylonTool mainTool) {
        if (this.showType != null) {
            if ("car".equalsIgnoreCase(this.showType)) {
                this.queryType = ModuleQuery.Type.CAR;
            } else if ("jar".equalsIgnoreCase(this.showType)) {
                this.queryType = ModuleQuery.Type.JAR;
            } else if ("jvm".equalsIgnoreCase(this.showType)) {
                this.queryType = ModuleQuery.Type.JVM;
            } else if ("js".equalsIgnoreCase(this.showType)) {
                this.queryType = ModuleQuery.Type.JS;
            } else if ("src".equalsIgnoreCase(this.showType)) {
                this.queryType = ModuleQuery.Type.SRC;
            } else if ("all".equalsIgnoreCase(this.showType)) {
                this.queryType = ModuleQuery.Type.ALL;
            } else if ("code".equalsIgnoreCase(this.showType)) {
                this.queryType = ModuleQuery.Type.CODE;
            } else if ("ceylon".equalsIgnoreCase(this.showType)) {
                this.queryType = ModuleQuery.Type.CEYLON_CODE;
            } else {
                throw new IllegalArgumentException(CeylonInfoMessages.msg("illegal.type", this.showType));
            }
        }
        if (this.findMember != null && "src".equalsIgnoreCase(this.showType)) {
            throw new IllegalArgumentException(CeylonInfoMessages.msg("incompatible.query.and.find", new Object[0]));
        }
        if (this.findMember != null && this.findPackage != null) {
            throw new IllegalArgumentException(CeylonInfoMessages.msg("incompatible.find.options", new Object[0]));
        }
        if (this.formatting == null) {
            this.formatting = System.console() != null ? Formatting.fancy : Formatting.simple;
        }
    }

    @Override
    public void run() throws Exception {
        if (this.showIncompatible != Incompatible.yes) {
            if (this.queryType.includes(".car")) {
                this.jvmBinaryMajor = 8;
                this.jvmBinaryMinor = 0;
            }
            if (this.queryType.includes(".js")) {
                this.jsBinaryMajor = 9;
                this.jsBinaryMinor = 0;
            }
        }
        String msgkey = this.showIncompatible == Incompatible.no ? "module.not.found.compat" : "module.not.found";
        for (ModuleSpec module : this.modules) {
            String name = module.getName();
            if (!module.isVersioned() && (name.startsWith("*") || name.endsWith("*"))) {
                Collection<ModuleSearchResult.ModuleDetails> modules = this.getModules(this.getRepositoryManager(), name, this.queryType, this.jvmBinaryMajor, this.jvmBinaryMinor, this.jsBinaryMajor, this.jsBinaryMinor);
                if (modules.isEmpty()) {
                    String err = name.startsWith("*") || name.endsWith("*") ? CeylonInfoMessages.msg("no.match", name) : this.getModuleNotFoundErrorMessage(this.getRepositoryManager(), module.getName(), module.getVersion(), msgkey);
                    this.errorAppend(err);
                    this.errorNewline();
                    continue;
                }
                this.outputModules(module, modules);
                continue;
            }
            Collection<ModuleVersionDetails> versions = this.getModuleVersions(this.getRepositoryManager(), module.getName(), module.getVersion(), this.queryType, this.jvmBinaryMajor, this.jvmBinaryMinor, this.jsBinaryMajor, this.jsBinaryMinor);
            if (versions.isEmpty()) {
                ModuleVersionDetails fromSource = this.getVersionFromSource(name);
                if (fromSource != null) {
                    versions = Arrays.asList(fromSource);
                } else {
                    if (this.showIncompatible == Incompatible.auto && (this.jvmBinaryMajor != null || this.jvmBinaryMinor != null || this.jsBinaryMajor != null || this.jsBinaryMinor != null)) {
                        versions = this.getModuleVersions(this.getRepositoryManager(), module.getName(), module.getVersion(), this.queryType, null, null, null, null);
                    }
                    if (versions.isEmpty()) {
                        String err = this.getModuleNotFoundErrorMessage(this.getRepositoryManager(), module.getName(), module.getVersion(), msgkey);
                        this.errorAppend(err);
                        this.errorNewline();
                        continue;
                    }
                }
            }
            if (module.getVersion() == null || module.getVersion().isEmpty() || versions.size() > 1) {
                this.outputVersions(module, versions);
                continue;
            }
            this.outputDetails(module, versions.iterator().next());
        }
    }

    private Collection<ModuleSearchResult.ModuleDetails> getModules(RepositoryManager repoMgr, String name, ModuleQuery.Type type, Integer jvmBinaryMajor, Integer jvmBinaryMinor, Integer jsBinaryMajor, Integer jsBinaryMinor) {
        String queryString = name;
        if (queryString.startsWith("*")) {
            queryString = queryString.substring(1);
        }
        if (queryString.endsWith("*")) {
            queryString = queryString.substring(0, queryString.length() - 1);
        }
        ModuleVersionQuery query = this.getModuleVersionQuery(queryString, null, type, jvmBinaryMajor, jvmBinaryMinor, jsBinaryMajor, jsBinaryMinor);
        ModuleSearchResult result = !name.startsWith("*") || name.equals("*") ? repoMgr.completeModules(query) : repoMgr.searchModules(query);
        return result.getResults();
    }

    @Override
    protected ModuleVersionQuery getModuleVersionQuery(String name, String version2, ModuleQuery.Type type, Integer jvmBinaryMajor, Integer jvmBinaryMinor, Integer jsBinaryMajor, Integer jsBinaryMinor) {
        ModuleVersionQuery query = super.getModuleVersionQuery(name, version2, type, jvmBinaryMajor, jvmBinaryMinor, jsBinaryMajor, jsBinaryMinor);
        if (this.findMember != null) {
            query.setMemberName(this.findMember);
        }
        if (this.findPackage != null) {
            query.setMemberName(this.findPackage);
            query.setMemberSearchPackageOnly(true);
        }
        query.setMemberSearchExact(this.exactMatch);
        if (this.requireAll) {
            query.setRetrieval(ModuleQuery.Retrieval.ALL);
        }
        return query;
    }

    private void outputModules(ModuleSpec query, Collection<ModuleSearchResult.ModuleDetails> modules) throws IOException {
        if (this.formatting == Formatting.fancy) {
            if (this.findMember != null) {
                this.msg("module.query.member", query.getName(), this.findMember).newline();
            } else if (this.findPackage != null) {
                this.msg("module.query.package", query.getName(), this.findPackage).newline();
            } else {
                this.msg("module.query", query.getName()).newline();
            }
        }
        this.outputModules(modules);
    }

    private void outputModules(Collection<ModuleSearchResult.ModuleDetails> modules) throws IOException {
        for (ModuleSearchResult.ModuleDetails module : modules) {
            this.outputModule(module);
        }
    }

    private void outputModule(ModuleSearchResult.ModuleDetails module) throws IOException {
        String prefix;
        String string = prefix = this.formatting == Formatting.fancy ? "    " : "";
        if (this.formatting == Formatting.fancy || !this.showVersions && !this.showNames) {
            this.append(prefix).append(module.getName()).newline();
        }
        if (this.showVersions) {
            this.outputVersions(module.getName(), module.getVersions(), prefix + prefix);
        } else if (this.showNames) {
            this.outputNames(module.getName(), module.getLastVersion(), prefix + prefix);
        }
    }

    private void outputVersions(ModuleSpec module, Collection<ModuleVersionDetails> versions) throws IOException {
        String prefix;
        String string = prefix = this.formatting == Formatting.fancy ? "    " : "";
        if (this.formatting == Formatting.fancy) {
            if (this.findMember != null) {
                this.msg("version.query.member", module.getName(), this.findMember).newline();
            } else if (this.findPackage != null) {
                this.msg("version.query.package", module.getName(), this.findPackage).newline();
            } else {
                this.msg("version.query", module.getName()).newline();
            }
        }
        this.outputVersions(module.getName(), versions, prefix);
    }

    private void outputVersions(String moduleName, Collection<ModuleVersionDetails> versions, String prefix) throws IOException {
        String namePrefix = this.formatting == Formatting.fancy ? prefix + "    " : "";
        for (ModuleVersionDetails version2 : versions) {
            if (this.formatting == Formatting.fancy || !this.showDependencies && !this.showNames) {
                this.append(prefix);
                if (this.formatting == Formatting.simple) {
                    this.append(moduleName).append("/");
                }
                this.append(version2.getVersion());
                if (this.formatting == Formatting.fancy) {
                    this.append(" - ").append(version2.getOrigin());
                    if (this.hasOnlyIncompatibleBinaries(version2)) {
                        this.append(" ");
                        this.msg("label.incompatible.version", new Object[0]);
                    }
                    if (version2.isRemote()) {
                        this.append(" ");
                        this.msg("label.remote", new Object[0]);
                    }
                }
                this.newline();
            }
            if (this.showDependencies) {
                if (this.formatting == Formatting.fancy || !version2.getDependencies().isEmpty()) {
                    for (ModuleDependencyInfo dep : version2.getDependencies()) {
                        if (this.formatting == Formatting.fancy) {
                            this.append(prefix).append("    ").append(dep);
                        } else {
                            this.append(moduleName).append("/").append(version2.getVersion()).append(" ").append(dep.getModuleName());
                        }
                        this.newline();
                    }
                } else {
                    this.append(moduleName).append("/").append(version2.getVersion()).newline();
                }
            }
            if (!this.showNames) continue;
            this.outputNames(moduleName, version2, namePrefix);
        }
    }

    private boolean hasOnlyIncompatibleBinaries(ModuleVersionDetails version2) {
        boolean hasBinaries = false;
        for (ModuleVersionArtifact at : version2.getArtifactTypes()) {
            if (at.getSuffix().equals(".car")) {
                if (Versions.isJvmBinaryVersionSupported(at.getMajorBinaryVersion(), at.getMinorBinaryVersion())) {
                    return false;
                }
                hasBinaries = true;
            }
            if (!at.getSuffix().equals(".js")) continue;
            if (Versions.isJvmBinaryVersionSupported(at.getMajorBinaryVersion(), at.getMinorBinaryVersion())) {
                return false;
            }
            hasBinaries = true;
        }
        return hasBinaries;
    }

    private void outputNames(String moduleName, ModuleVersionDetails version2, String prefix) throws IOException {
        for (String member : version2.getMembers()) {
            if (this.formatting == Formatting.fancy) {
                this.append(prefix).append(member).newline();
                continue;
            }
            this.append(moduleName);
            if (this.showVersions) {
                this.append("/").append(version2.getVersion());
            }
            this.append("::").append(member).newline();
        }
    }

    private void outputDetails(ModuleSpec module, ModuleVersionDetails version2) throws IOException {
        this.msg("module.name", new Object[0]).append(module.getName()).newline();
        this.msg("module.version", new Object[0]).append(version2.getVersion()).newline();
        this.outputArtifacts(version2.getArtifactTypes());
        this.msg("module.available", new Object[0]).msg(version2.isRemote() ? "available.remote" : "available.local", new Object[0]).newline();
        if (version2.getOrigin() != null) {
            this.msg("module.origin", new Object[0]).append(version2.getOrigin()).newline();
        }
        if (version2.getDoc() != null) {
            String docs = version2.getDoc();
            if (!this.showFullDescription) {
                docs = this.summary(version2.getDoc());
            }
            this.msg("module.description", new Object[0]).append(docs).newline();
        }
        if (version2.getLicense() != null) {
            this.msg("module.license", new Object[0]).append(version2.getLicense()).newline();
        }
        if (version2.getAuthors() != null && !version2.getAuthors().isEmpty()) {
            this.outputAuthors(version2.getAuthors());
        }
        if (!version2.getDependencies().isEmpty()) {
            this.msg("module.dependencies.tree", this.depth == -1 ? "\u221e" : String.valueOf(this.depth)).newline();
            TreeMap<String, SortedSet<String>> names = new TreeMap<String, SortedSet<String>>();
            this.recurseDependencies(version2, names, 0);
            if (this.depth != 1) {
                this.newline();
                this.msg("module.dependencies.flat", this.depth == -1 ? "\u221e" : String.valueOf(this.depth)).newline();
                this.listDependencies(names);
            }
            this.listDependencyConflictsIfAny(names);
        }
    }

    private void listDependencyConflictsIfAny(SortedMap<String, SortedSet<String>> names) throws IOException {
        boolean hasNoDuplicate = true;
        StringBuilder overridesFile = null;
        if (this.printOverrides) {
            overridesFile = new StringBuilder();
            overridesFile.append("<overrides>\n");
        }
        for (Map.Entry<String, SortedSet<String>> entry : names.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            if (hasNoDuplicate) {
                hasNoDuplicate = false;
                this.newline();
                this.msg("module.dependencies.conflicts", this.depth == -1 ? "\u221e" : String.valueOf(this.depth)).newline();
            }
            this.append("  ");
            this.append(entry.getKey());
            if (entry.getValue().size() > 1) {
                this.append(": ");
                boolean first = true;
                for (String v : entry.getValue()) {
                    if (first) {
                        first = false;
                    } else {
                        this.append(", ");
                    }
                    this.append(v);
                }
                if (this.printOverrides) {
                    overridesFile.append(" <set");
                    String name = entry.getKey();
                    if (name.contains(":")) {
                        int p = name.indexOf(58);
                        String groupId = name.substring(0, p);
                        String artifactId = name.substring(p + 1);
                        overridesFile.append(" groupId=\"").append(groupId).append("\" artifactId=\"").append(artifactId).append("\"");
                    } else {
                        overridesFile.append(" module=\"").append(name).append("\"");
                    }
                    overridesFile.append(" version=\"").append(entry.getValue().last()).append("\"/>\n");
                }
            }
            this.newline();
        }
        if (this.printOverrides && !hasNoDuplicate) {
            overridesFile.append("</overrides>\n");
            this.newline();
            this.msg("module.dependencies.overrides", new Object[0]).newline();
            this.newline();
            this.append(overridesFile.toString());
        }
    }

    private void listDependencies(SortedMap<String, SortedSet<String>> names) throws IOException {
        for (Map.Entry<String, SortedSet<String>> entry : names.entrySet()) {
            this.append("  ");
            this.append(entry.getKey());
            if (entry.getValue().size() > 1) {
                this.append(": ");
                boolean first = true;
                for (String v : entry.getValue()) {
                    if (first) {
                        first = false;
                    } else {
                        this.append(", ");
                    }
                    this.append(v);
                }
            } else {
                this.append("/");
                this.append(entry.getValue().first());
            }
            this.newline();
        }
    }

    private String summary(String doc) {
        StringBuilder result = new StringBuilder();
        String[] lines = doc.split("\n");
        for (int i = 0; i < lines.length && i < 5; ++i) {
            result.append(lines[i]).append('\n');
        }
        if (lines.length > 5) {
            result.append("...").append('\n');
        }
        return result.toString();
    }

    private void outputAuthors(NavigableSet<String> authors) throws IOException {
        this.msg("module.authors", new Object[0]);
        boolean first = true;
        for (String author : authors) {
            if (!first) {
                this.append(", ");
            }
            this.append(author);
            first = false;
        }
        this.newline();
    }

    private RepoUsingTool outputArtifacts(Set<ModuleVersionArtifact> types) throws IOException {
        if (!types.isEmpty()) {
            this.msg("module.artifacts", new Object[0]);
            boolean skipComma = true;
            boolean js = false;
            boolean docs = false;
            for (ModuleVersionArtifact type : types) {
                int minor;
                if (!skipComma) {
                    this.append(", ");
                }
                String suffix = type.getSuffix();
                int major = type.getMajorBinaryVersion() != null ? type.getMajorBinaryVersion() : 0;
                int n = minor = type.getMinorBinaryVersion() != null ? type.getMinorBinaryVersion() : 0;
                if (suffix.equalsIgnoreCase(".car")) {
                    this.append("JVM (#");
                    this.append(major);
                    if (minor != 0) {
                        this.append(".");
                        this.append(minor);
                    }
                    if (!Versions.isJvmBinaryVersionSupported(major, minor)) {
                        this.append(" ");
                        this.msg("label.incompatible.version", new Object[0]);
                    }
                    this.append(")");
                } else if (suffix.equalsIgnoreCase(".jar")) {
                    this.append("JVM (legacy)");
                } else if (suffix.equalsIgnoreCase(".js") || suffix.equalsIgnoreCase("-model.js")) {
                    if (js) {
                        skipComma = true;
                        continue;
                    }
                    this.append("JavaScript (#");
                    this.append(major);
                    if (minor != 0) {
                        this.append(".");
                        this.append(minor);
                    }
                    if (!Versions.isJsBinaryVersionSupported(major, minor)) {
                        this.append(" ");
                        this.msg("label.incompatible.version", new Object[0]);
                    }
                    this.append(")");
                    js = true;
                } else if (suffix.equalsIgnoreCase("module-resources")) {
                    this.append("JS Resources");
                } else if (suffix.equalsIgnoreCase("module-doc")) {
                    if (docs) {
                        skipComma = true;
                        continue;
                    }
                    this.append("Documentation");
                    docs = true;
                } else if (suffix.equalsIgnoreCase(".scripts.zip")) {
                    this.append("Script Plugins");
                } else if (suffix.equalsIgnoreCase(".src")) {
                    this.append("Sources");
                } else if (suffix.startsWith(".")) {
                    this.append(suffix.substring(1).toUpperCase());
                } else {
                    this.append(type);
                }
                skipComma = false;
            }
            this.newline();
        }
        return this;
    }

    private void recurseDependencies(ModuleVersionDetails version2, Map<String, SortedSet<String>> names, int depth) throws IOException {
        for (ModuleDependencyInfo dep : version2.getDependencies()) {
            this.dependency(dep, names, depth + 1);
        }
    }

    private void dependency(ModuleDependencyInfo dep, Map<String, SortedSet<String>> names, int depth) throws IOException {
        Collection<ModuleVersionDetails> versions;
        boolean recurse;
        for (int ii = 0; ii < depth; ++ii) {
            this.append("  ");
        }
        this.append(dep);
        SortedSet<String> seenVersions = names.get(dep.getName());
        boolean bl = recurse = this.depth == -1 || depth < this.depth;
        if (seenVersions != null) {
            if (seenVersions.size() == 1 && seenVersions.first().equals(dep.getVersion())) {
                this.append(" (already imported)");
            } else {
                this.append(" (already imported other version)");
            }
            recurse = false;
        } else {
            seenVersions = new TreeSet<String>(VersionComparator.INSTANCE);
            names.put(dep.getName(), seenVersions);
        }
        seenVersions.add(dep.getVersion());
        this.newline();
        if (recurse && !"ceylon.language".equals(dep.getName()) && !(versions = this.getModuleVersions(dep.getName(), dep.getVersion(), this.queryType, this.jvmBinaryMajor, this.jvmBinaryMinor, this.jsBinaryMajor, this.jsBinaryMinor)).isEmpty()) {
            this.recurseDependencies(versions.iterator().next(), names, depth + 1);
        }
    }

    public static enum Incompatible {
        yes,
        no,
        auto;

    }

    public static enum Formatting {
        simple,
        fancy;

    }
}

