/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.jigsaw;

import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.common.Messages;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tool.ToolUsageError;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.tools.moduleloading.ModuleLoadingTool;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.SortedSet;

@Summary(value="Tools to interop with Java 9 (Jigsaw) modules")
@Description(value="There is currently one mode of action:\n\n- `create-mlib`: Generates an mlib folder suitable for Java 9 tools to run a given Ceylon module\n\nThe list of modules specified can have their versions set, but if missing we will try to find the\nversion from the current source path. If the list of modules is omitted, we will use the list of\nmodules found in the current source path.")
public class CeylonJigsawTool
extends ModuleLoadingTool {
    private String moduleNameOptVersion;
    private boolean force;
    private Mode mode;
    private File out = new File("mlib");

    @Argument(order=0, argumentName="mode", multiplicity="1")
    public void setMode(Mode mode) {
        this.mode = mode;
    }

    @Argument(order=1, argumentName="module", multiplicity="1")
    public void setModule(String module) {
        this.moduleNameOptVersion = module;
    }

    @Description(value="Folder in which to place the resulting jars (defaults to `mlib`).")
    @OptionArgument(argumentName="out")
    public void setOutputFolder(File out) {
        this.out = out;
    }

    @Option(longName="force")
    @Description(value="Force generation of mlib folder with multiple versions of the same module.")
    public void setForce(boolean force) {
        this.force = force;
    }

    @Override
    public void run() throws Exception {
        String module = ModuleUtil.moduleName(this.moduleNameOptVersion);
        String version2 = this.checkModuleVersionsOrShowSuggestions(this.getRepositoryManager(), module, ModuleUtil.moduleVersion(this.moduleNameOptVersion), ModuleQuery.Type.JVM, 8, 0, null, null, null);
        if (version2 == null) {
            return;
        }
        this.loadModule(module, version2);
        if (!this.force) {
            this.errorOnConflictingModule(module, version2);
        }
        if (!this.out.exists() && !this.out.mkdir()) {
            throw new ToolUsageError(Messages.msg(this.bundle, "jigsaw.folder.error", this.out));
        }
        for (ArtifactResult entry : this.loadedModules.values()) {
            File file;
            if (entry == null || (file = entry.artifact()) == null) continue;
            SortedSet versions = (SortedSet)this.loadedModuleVersions.get(entry.name());
            if (version2 != null && !versions.isEmpty() && entry.version() != null && !entry.version().equals(versions.last())) continue;
            this.append(file.getAbsolutePath());
            this.newline();
            String name = file.getName();
            if (name.endsWith(".car")) {
                name = name.substring(0, name.length() - 4) + ".jar";
            }
            Files.copy(file.toPath(), new File(this.out, name).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        this.flush();
    }

    @Override
    public void initialize(CeylonTool mainTool) throws Exception {
    }

    public static enum Mode {
        create_mlib;

    }
}

