/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.moduleloading;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.api.VersionComparator;
import com.redhat.ceylon.cmr.ceylon.RepoUsingTool;
import com.redhat.ceylon.common.Messages;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.ToolUsageError;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.ImportType;
import com.redhat.ceylon.model.cmr.JDKUtils;
import com.redhat.ceylon.tools.moduleloading.ModuleLoadingMessages;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public abstract class ModuleLoadingTool
extends RepoUsingTool {
    protected Map<String, ArtifactResult> loadedModules = new HashMap<String, ArtifactResult>();
    protected Map<String, SortedSet<String>> loadedModuleVersions = new HashMap<String, SortedSet<String>>();
    protected boolean upgradeDist = true;

    public ModuleLoadingTool() {
        super(ModuleLoadingMessages.RESOURCE_BUNDLE);
    }

    @Option
    @Description(value="Downgrade which were compiled with a more recent version of the distribution to the version of that module present in this distribution (1.2.2). This might fail with a linker error at runtime. For example if the module depended on an API present in the more recent version, but absent from 1.2.2. Allowed arguments are upgrade, downgrade or abort. Default: upgrade")
    public void setLinkWithCurrentDistribution(boolean downgradeDist) {
        this.upgradeDist = !downgradeDist;
    }

    protected String moduleVersion(String moduleNameOptVersion) throws IOException {
        return this.checkModuleVersionsOrShowSuggestions(this.getRepositoryManager(), ModuleUtil.moduleName(moduleNameOptVersion), ModuleUtil.moduleVersion(moduleNameOptVersion), ModuleQuery.Type.JVM, 8, 0, null, null);
    }

    protected boolean loadModule(String moduleName, String moduleVersion) throws IOException {
        return this.loadModule(moduleName, moduleVersion, false);
    }

    protected boolean loadModule(String moduleName, String moduleVersion, boolean optional) throws IOException {
        boolean success = false;
        if (moduleVersion != null) {
            success = true;
            success &= this.internalLoadModule("ceylon.language", "1.2.2", false);
            success &= this.internalLoadModule("com.redhat.ceylon.common", "1.2.2", false);
            success &= this.internalLoadModule("com.redhat.ceylon.model", "1.2.2", false);
            success &= this.internalLoadModule("com.redhat.ceylon.module-resolver", "1.2.2", false);
            success &= this.internalLoadModule(moduleName, moduleVersion, false);
        }
        return success;
    }

    protected boolean shouldExclude(String moduleName, String version2) {
        if (JDKUtils.jdk.providesVersion(JDKUtils.JDK.JDK9.version)) {
            moduleName = JDKUtils.getJava9ModuleName(moduleName, version2);
        }
        return JDKUtils.isJDKModule(moduleName) || JDKUtils.isOracleJDKModule(moduleName);
    }

    private boolean internalLoadModule(String name, String version2, boolean optional) throws IOException {
        String key = name + "/" + version2;
        if (this.loadedModules.containsKey(key)) {
            return true;
        }
        if (this.shouldExclude(name, version2)) {
            this.loadedModules.put(key, null);
            return true;
        }
        SortedSet<String> loadedVersions = this.loadedModuleVersions.get(name);
        if (loadedVersions == null) {
            loadedVersions = new TreeSet<String>(VersionComparator.INSTANCE);
            this.loadedModuleVersions.put(name, loadedVersions);
        }
        loadedVersions.add(version2);
        RepositoryManager repositoryManager = this.getRepositoryManager(this.upgradeDist);
        ArtifactContext artifactContext = new ArtifactContext(name, version2, ".car", ".jar");
        ArtifactResult result = repositoryManager.getArtifactResult(artifactContext);
        if (!(optional || result != null && result.artifact() != null && result.artifact().exists())) {
            String err = this.getModuleNotFoundErrorMessage(repositoryManager, name, version2);
            this.errorAppend(err);
            this.errorNewline();
            return false;
        }
        this.loadedModules.put(key, result);
        if (result != null) {
            for (ArtifactResult dep : result.dependencies()) {
                this.internalLoadModule(dep.name(), dep.version(), dep.importType() == ImportType.OPTIONAL);
            }
        }
        return true;
    }

    protected void errorOnConflictingModule(String module, String version2) throws IOException {
        boolean duplicate = false;
        for (Map.Entry<String, SortedSet<String>> entry : this.loadedModuleVersions.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            duplicate = true;
            this.printDuplicateModuleErrorMessage(entry.getKey(), entry.getValue());
        }
        if (duplicate) {
            throw new ToolUsageError(Messages.msg(this.bundle, "module.conflict.error", module, version2));
        }
    }

    private void printDuplicateModuleErrorMessage(String name, SortedSet<String> versions) throws IOException {
        StringBuilder err = new StringBuilder();
        boolean first = true;
        for (String version2 : versions) {
            if (first) {
                first = false;
            } else {
                err.append(", ");
            }
            err.append(version2);
        }
        this.errorMsg("module.duplicate.error", name, err, versions.last());
    }
}

