/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.new_;

import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Tool;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.tools.new_.Copy;
import com.redhat.ceylon.tools.new_.Environment;
import com.redhat.ceylon.tools.new_.Messages;
import com.redhat.ceylon.tools.new_.Variable;
import java.io.File;
import java.io.IOException;
import java.util.List;

public abstract class Project
implements Tool {
    private File directory;

    public abstract List<Variable> getVariables();

    public abstract List<Copy> getResources(Environment var1);

    @Argument(argumentName="dir", multiplicity="?", order=1)
    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public File getDirectory() {
        return this.directory;
    }

    void mkBaseDir(File cwd) throws IOException {
        if (this.directory != null) {
            File actualDir = FileUtil.applyCwd(cwd, this.directory);
            if (actualDir.exists() && !actualDir.isDirectory()) {
                throw new IOException(Messages.msg("path.exists.and.not.dir", this.directory));
            }
            if (!actualDir.exists() && !FileUtil.mkdirs(actualDir)) {
                throw new IOException(Messages.msg("could.not.mkdir", this.directory));
            }
        }
    }

    @Override
    public void initialize(CeylonTool mainTool) {
    }

    @Override
    public final void run() throws Exception {
        throw new RuntimeException();
    }
}

