/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.new_;

import com.redhat.ceylon.tools.new_.Environment;
import com.redhat.ceylon.tools.new_.Messages;
import com.redhat.ceylon.tools.new_.Template;
import com.redhat.ceylon.tools.new_.Variable;
import com.redhat.ceylon.tools.new_.VariableValidator;
import com.redhat.ceylon.tools.new_.VariableValue;
import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;

class PromptedValue
implements VariableValue {
    private final String key;
    private final String defaultValue;
    private final VariableValidator validator;

    public PromptedValue(String key) {
        this(key, null, null);
    }

    public PromptedValue(String key, String defaultValue) {
        this(key, null, defaultValue);
    }

    public PromptedValue(String key, VariableValidator validator) {
        this(key, validator, null);
    }

    public PromptedValue(String key, VariableValidator validator, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.validator = validator;
        if (validator != null && defaultValue != null && !validator.isValid(defaultValue)) {
            throw new RuntimeException("Default value " + defaultValue + " is not valid");
        }
    }

    protected String getDefaultValue() {
        return this.defaultValue;
    }

    protected String getDefault(Environment env) {
        if (this.defaultValue == null) {
            return this.defaultValue;
        }
        Template template = new Template(this.defaultValue);
        return template.eval(env);
    }

    protected String getPrompt(String projectName, Environment env, String dv) {
        String p = Messages.msg(projectName + ".prompt." + this.key, new Object[0]).trim();
        if (dv != null) {
            p = p + " [" + dv + "]";
        }
        p = p + ": ";
        return p;
    }

    @Override
    public String getValue(String projectName, Environment env) {
        String readLine;
        String value;
        do {
            readLine = null;
            String dv = this.getDefault(env);
            String prompt = this.getPrompt(projectName, env, dv);
            if (System.console() != null) {
                Console console = System.console();
                if (console == null) {
                    throw new RuntimeException(Messages.msg("no.console", new Object[0]));
                }
                readLine = console.readLine(prompt, new Object[0]);
            } else {
                System.out.print(prompt);
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                try {
                    readLine = reader.readLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (readLine == null) {
                throw new RuntimeException(Messages.msg("exit", new Object[0]));
            }
            if (!readLine.isEmpty() || dv == null) continue;
            readLine = dv;
        } while ((value = this.parseValue(readLine)) == null);
        return value;
    }

    protected String parseValue(String readLine) {
        return this.validator == null || this.validator.isValid(readLine) ? readLine : null;
    }

    protected List<Variable> subvars(String value) {
        return Collections.emptyList();
    }
}

