/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.p2;

import com.redhat.ceylon.common.tools.ModuleSpec;
import com.redhat.ceylon.tools.p2.CeylonP2Tool;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

class ModuleInfo {
    private static final String[] PropertyNames = new String[]{"Bundle-Name", "Bundle-Vendor", "Bundle-Description", "Bundle-DocUrl"};
    final String name;
    final String version;
    final File jar;
    Attributes osgiAttributes;
    String osgiVersion;

    public ModuleInfo(String name, String version2, File jar) throws IOException {
        this.name = name;
        this.version = version2;
        this.jar = jar;
        this.loadOsgiVersion();
    }

    private void loadOsgiVersion() throws IOException {
        JarFile jarFile = new JarFile(this.jar);
        Manifest manifest = jarFile.getManifest();
        this.osgiVersion = this.version;
        if (manifest != null) {
            String tmp;
            this.osgiAttributes = manifest.getMainAttributes();
            if (this.osgiAttributes != null && (tmp = this.osgiAttributes.getValue("Bundle-Version")) != null) {
                this.osgiVersion = tmp;
            }
        }
        jarFile.close();
        this.osgiVersion = CeylonP2Tool.fixOsgiVersion(this.osgiVersion);
    }

    public List<ModuleSpec> getExportedPackages() {
        String value = this.osgiAttributes.getValue("Export-Package");
        LinkedList<ModuleSpec> ret = new LinkedList<ModuleSpec>();
        if (value != null) {
            for (String pkg : value.split(",")) {
                String[] details = pkg.split(";");
                String name = details[0];
                String version2 = "";
                for (int i = 1; i < details.length; ++i) {
                    if (!details[i].startsWith("version=")) continue;
                    version2 = this.unquote(details[i].substring(8));
                    break;
                }
                ret.add(new ModuleSpec(name, version2));
            }
        }
        return ret;
    }

    private String unquote(String quotedVersion) {
        if (quotedVersion == null || quotedVersion.isEmpty()) {
            return quotedVersion;
        }
        char first = quotedVersion.charAt(0);
        char last = quotedVersion.charAt(quotedVersion.length() - 1);
        if (first == '\"' && last == '\"') {
            return quotedVersion.substring(1, quotedVersion.length() - 1);
        }
        if (first == '\'' && last == '\'') {
            return quotedVersion.substring(1, quotedVersion.length() - 1);
        }
        return quotedVersion;
    }

    public List<ModuleSpec> getImportedPackages() {
        String value = this.osgiAttributes.getValue("Import-Package");
        LinkedList<ModuleSpec> ret = new LinkedList<ModuleSpec>();
        if (value != null) {
            for (String pkg : value.split(",")) {
                String[] details = pkg.split(";");
                String name = details[0];
                String version2 = "";
                for (int i = 1; i < details.length; ++i) {
                    if (!details[i].startsWith("version=")) continue;
                    version2 = this.unquote(details[i].substring(8));
                    break;
                }
                ret.add(new ModuleSpec(name, version2));
            }
        }
        return ret;
    }

    public List<ModuleSpec> getImportedModules() {
        String value = this.osgiAttributes.getValue("Require-Bundle");
        LinkedList<ModuleSpec> ret = new LinkedList<ModuleSpec>();
        if (value != null) {
            for (String pkg : value.split(",")) {
                String[] details = pkg.split(";");
                String name = details[0];
                if (CeylonP2Tool.skipModule(name)) continue;
                String version2 = "";
                for (int i = 1; i < details.length; ++i) {
                    if (!details[i].startsWith("bundle-version=")) continue;
                    version2 = this.unquote(details[i].substring(15));
                    break;
                }
                ret.add(new ModuleSpec(name, version2));
            }
        }
        return ret;
    }

    public String getAttribute(String name) {
        return this.osgiAttributes.getValue(name);
    }

    public SortedMap<String, String> getOsgiProperties() {
        TreeMap<String, String> ret = new TreeMap<String, String>();
        for (String name : PropertyNames) {
            String attribute = this.getAttribute(name);
            if (attribute == null) continue;
            ret.put(name, attribute);
        }
        return ret;
    }
}

