/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.plugin;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.ceylon.OutputRepoUsingTool;
import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.cmr.impl.ShaSigner;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.Messages;
import com.redhat.ceylon.common.OSUtil;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.ParsedBy;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.StandardArgumentParsers;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tool.ToolError;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.common.tools.ModuleSpec;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.tools.plugin.CeylonPluginMessages;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Summary(value="Manages Ceylon command-line plugins")
@Description(value="There are four modes of action:\n\n- `list`: will list the scripts installed\n- `install`: installs the scripts for the modules listed on the command line. The scripts must either be packed in a\nrepository, or found in the current script folders\n- `uninstall`: uninstalls the scripts for the modules listed on the command line\n- `pack`: packs the scripts for the modules listed on the command line and publishes them to the specified output repository\n\nThe list of modules specified can have their versions set, but if missing we will try to find the\nversion from the current source path. If the list of modules is omitted, we will use the list of\nmodules found in the current source path.")
@RemainingSections(value="##EXAMPLE\n\nThe following would list the plugins currently installed:\n\n    ceylon plugin list\n\nThe following would install the ceylon.build plugins:\n\n    ceylon plugin install ceylon.build.engine\n")
public class CeylonPluginTool
extends OutputRepoUsingTool {
    private List<ModuleSpec> modules;
    private List<File> scriptFolders = DefaultToolOptions.getCompilerScriptDirs();
    private List<File> sourceFolders = DefaultToolOptions.getCompilerSourceDirs();
    private boolean force;
    private boolean system;
    private boolean local;
    private Mode mode;

    public CeylonPluginTool() {
        super(CeylonPluginMessages.RESOURCE_BUNDLE);
    }

    @Argument(order=1, argumentName="module", multiplicity="*")
    public void setModules(List<String> modules) {
        this.setModuleSpecs(ModuleSpec.parseEachList(modules, new ModuleSpec.Option[0]));
    }

    public void setModuleSpecs(List<ModuleSpec> modules) {
        this.modules = modules;
    }

    @Argument(order=0, argumentName="mode", multiplicity="1")
    public void setMode(Mode mode) {
        this.mode = mode;
    }

    @Option(shortName=102)
    @Description(value="Force installation even if a previous version exists")
    public void setForce(boolean force) {
        this.force = force;
    }

    @Option
    @Description(value="Install to or uninstall from the system folder")
    public void setSystem(boolean system) {
        this.system = system;
    }

    @Option
    @Description(value="Install to or uninstall from a local folder")
    public void setLocal(boolean local) {
        this.local = local;
    }

    @OptionArgument(shortName=115, longName="src", argumentName="dirs")
    @ParsedBy(value=StandardArgumentParsers.PathArgumentParser.class)
    @Description(value="A directory containing Ceylon and/or Java/JavaScript source code (default: `./source`)")
    public void setSrcFolders(List<File> sourceFolders) {
        this.sourceFolders = sourceFolders;
    }

    @OptionArgument(longName="source", argumentName="dirs")
    @ParsedBy(value=StandardArgumentParsers.PathArgumentParser.class)
    @Description(value="An alias for `--src` (default: `./source`)")
    public void setSourceFolders(List<File> source) {
        this.setSrcFolders(source);
    }

    @OptionArgument(shortName=120, longName="script", argumentName="dirs")
    @ParsedBy(value=StandardArgumentParsers.PathArgumentParser.class)
    @Description(value="A directory containing your module documentation (default: `./script`)")
    public void setScriptFolders(List<File> scriptFolders) {
        this.scriptFolders = scriptFolders;
    }

    @Override
    protected List<File> getSourceDirs() {
        return this.sourceFolders;
    }

    @Override
    public void run() throws Exception {
        if (this.modules == null) {
            this.modules = new ArrayList<ModuleSpec>();
        }
        boolean errorIfMissing = true;
        if (this.mode != Mode.list) {
            if (this.modules.isEmpty()) {
                this.modules.addAll(this.getSourceModules(this.applyCwd(this.sourceFolders)));
                errorIfMissing = false;
            }
            if (this.modules.isEmpty()) {
                throw new CeylonPluginException("error.no.module.specified", this.sourceFolders);
            }
        }
        boolean worked = false;
        switch (this.mode) {
            case pack: {
                RepositoryManager outputRepositoryManager = this.getOutputRepositoryManager();
                for (ModuleSpec module : this.modules) {
                    worked |= this.addScripts(outputRepositoryManager, module, errorIfMissing);
                }
                break;
            }
            case install: {
                RepositoryManager repositoryManager = this.getRepositoryManager();
                for (ModuleSpec module : this.modules) {
                    worked |= this.installScripts(repositoryManager, module, errorIfMissing);
                }
                break;
            }
            case uninstall: {
                for (ModuleSpec module : this.modules) {
                    worked |= this.uninstallScripts(module, errorIfMissing);
                }
                break;
            }
            case list: {
                this.listScripts();
                worked = true;
            }
        }
        if (!worked) {
            throw new CeylonPluginException("error.no.script.found", new Object[0]);
        }
        this.flush();
    }

    private void listScripts() throws IOException {
        ArrayList<String> scripts = new ArrayList<String>();
        File systemDir = new File(FileUtil.getSystemConfigDir(), "bin");
        this.listScripts(systemDir, "system", scripts);
        File defUserDir = new File(FileUtil.getDefaultUserDir(), "bin");
        this.listScripts(defUserDir, "user", scripts);
        File localDir = this.applyCwd(new File(".ceylon", "bin"));
        this.listScripts(localDir, "local", scripts);
        Collections.sort(scripts);
        for (String script : scripts) {
            this.append(script);
            this.newline();
        }
    }

    private void listScripts(File dir, String location, List<String> scripts) throws IOException {
        File[] children = dir.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isDirectory()) {
                    File[] modfiles;
                    for (File f : modfiles = child.listFiles()) {
                        if (!this.isScript(f) && !this.isPlugin(f)) continue;
                        scripts.add(this.scriptName(f) + " (from " + location + " module '" + child.getName() + "')");
                    }
                    continue;
                }
                if (!this.isScript(child) && !this.isPlugin(child)) continue;
                scripts.add(this.scriptName(child));
            }
        }
    }

    private boolean isScript(File f) {
        if (f.isFile() && f.getName().startsWith("ceylon-") && f.canExecute()) {
            boolean isWinScript = OSUtil.isWindows() && f.getName().toLowerCase().endsWith(".bat");
            boolean isUnixScript = !OSUtil.isWindows() && !f.getName().toLowerCase().endsWith(".bat");
            return isWinScript || isUnixScript;
        }
        return false;
    }

    private boolean isPlugin(File f) {
        return f.isFile() && f.getName().startsWith("ceylon-") && f.getName().endsWith(".plugin");
    }

    private String scriptName(File f) {
        String name = f.getName().substring(7);
        if (name.toLowerCase().endsWith(".bat")) {
            name = name.substring(0, name.length() - 4);
        } else if (name.toLowerCase().endsWith(".plugin")) {
            name = name.substring(0, name.length() - 7);
        }
        return name;
    }

    private boolean installScripts(RepositoryManager repositoryManager, ModuleSpec module, boolean errorIfMissing) throws IOException {
        File moduleScriptDir;
        String version2 = module.getVersion();
        if ((version2 == null || version2.isEmpty()) && !module.getName().equals("default") && (version2 = this.checkModuleVersionsOrShowSuggestions(this.getRepositoryManager(), module.getName(), null, ModuleQuery.Type.ALL, null, null, null, null)) == null) {
            return false;
        }
        File zipSource = null;
        List<File> existingScriptFolders = null;
        if (this.isSourceModule(module.getName(), version2, this.applyCwd(this.sourceFolders))) {
            existingScriptFolders = this.findExistingScriptFolders(module.getName(), errorIfMissing);
            if (existingScriptFolders.isEmpty()) {
                return false;
            }
        } else {
            ArtifactContext context = new ArtifactContext(module.getName(), version2, ".scripts.zip");
            ArtifactResult result = repositoryManager.getArtifactResult(context);
            if (result == null) {
                String err = this.getModuleNotFoundErrorMessage(repositoryManager, module.getName(), version2);
                this.errorAppend(err);
                this.errorNewline();
                return false;
            }
            zipSource = result.artifact();
        }
        if ((moduleScriptDir = this.getModuleScriptDir(module)).exists()) {
            if (this.force) {
                FileUtil.delete(moduleScriptDir);
            } else {
                this.errorMsg("error.module.already.installed", module.getName(), moduleScriptDir);
                return false;
            }
        }
        if (!FileUtil.mkdirs(moduleScriptDir)) {
            this.errorMsg("error.unable.create.dest.dir", moduleScriptDir);
            return false;
        }
        if (zipSource != null) {
            this.extractScripts(zipSource, moduleScriptDir);
        } else {
            this.copyScripts(existingScriptFolders, moduleScriptDir);
        }
        this.msg("success.installed", module.getName(), moduleScriptDir);
        this.newline();
        return true;
    }

    private boolean uninstallScripts(ModuleSpec module, boolean errorIfMissing) throws IOException {
        File moduleScriptDir = this.getModuleScriptDir(module);
        if (moduleScriptDir.exists()) {
            FileUtil.delete(moduleScriptDir);
            this.msg("success.uninstalled", module.getName(), moduleScriptDir);
            this.newline();
            return true;
        }
        if (errorIfMissing) {
            this.errorMsg("error.no.script.installed.for.module", module.getName(), moduleScriptDir);
        }
        return false;
    }

    private File getModuleScriptDir(ModuleSpec module) {
        if (this.system) {
            File file = FileUtil.getSystemConfigDir();
        }
        File installDir = this.local ? new File(".ceylon") : FileUtil.getDefaultUserDir();
        File binDir = new File(installDir, "bin");
        File moduleScriptDir = new File(binDir, module.getName());
        return moduleScriptDir;
    }

    private void extractScripts(File zip, File dir) throws IOException {
        try {
            IOUtils.extractArchive(zip, dir);
        }
        catch (IOUtils.UnzipException x) {
            switch (x.failure) {
                case CannotCreateDestination: {
                    throw new RuntimeException(CeylonPluginMessages.msg("error.unable.create.dest.dir", x.dir));
                }
                case CopyError: {
                    throw new RuntimeException(CeylonPluginMessages.msg("error.unable.extract.entry", x.entryName, zip.getAbsolutePath()), x.getCause());
                }
                case DestinationNotDirectory: {
                    throw new RuntimeException(CeylonPluginMessages.msg("error.not.dir.dest.dir", x.dir));
                }
            }
            throw x;
        }
        Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attributes) throws IOException {
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    path.toFile().setExecutable(true);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void copyScripts(List<File> existingScriptFolders, File moduleScriptDir) throws IOException {
        for (File root : existingScriptFolders) {
            FileUtil.copyAll(root, moduleScriptDir);
        }
    }

    private boolean addScripts(RepositoryManager outputRepositoryManager, ModuleSpec module, boolean errorIfMissing) throws IOException {
        String version2;
        List<File> existingScriptFolders = this.findExistingScriptFolders(module.getName(), errorIfMissing);
        if (existingScriptFolders.isEmpty()) {
            return false;
        }
        if (!module.getName().equals("default")) {
            ModuleVersionDetails mvd = this.getVersionFromSource(module.getName());
            if (mvd == null) {
                this.errorMsg("error.no.script.version", module.getName());
                return false;
            }
            version2 = mvd.getVersion();
        } else {
            version2 = null;
        }
        ArtifactContext artifactScriptsZip = new ArtifactContext(module.getName(), version2, ".scripts.zip");
        IOUtils.ZipRoot[] roots = new IOUtils.ZipRoot[existingScriptFolders.size()];
        int d = 0;
        for (File scriptFolder : existingScriptFolders) {
            roots[d] = new IOUtils.ZipRoot(scriptFolder, "");
        }
        File scriptZipFile = IOUtils.zipFolders(roots);
        File scriptZipSha1File = ShaSigner.sign(scriptZipFile, this.log, this.verbose != null);
        if (!this.repositoryRemoveArtifact(outputRepositoryManager, artifactScriptsZip)) {
            return true;
        }
        if (!this.repositoryRemoveArtifact(outputRepositoryManager, artifactScriptsZip.getSha1Context())) {
            return true;
        }
        if (!this.repositoryPutArtifact(outputRepositoryManager, artifactScriptsZip, scriptZipFile)) {
            return true;
        }
        if (!this.repositoryPutArtifact(outputRepositoryManager, artifactScriptsZip.getSha1Context(), scriptZipSha1File)) {
            return true;
        }
        scriptZipFile.delete();
        scriptZipSha1File.delete();
        this.msg("success.packed", module.getName());
        this.newline();
        return true;
    }

    private List<File> findExistingScriptFolders(String moduleName, boolean errorIfMissing) throws IOException {
        String scriptPath = moduleName.replace('.', File.separatorChar);
        ArrayList<File> existingScriptFolders = new ArrayList<File>(this.scriptFolders.size());
        for (File scriptFolder : this.scriptFolders) {
            File moduleScriptFolder = new File(this.applyCwd(scriptFolder), scriptPath);
            if (!moduleScriptFolder.exists() || !FileUtil.containsFile(moduleScriptFolder)) continue;
            existingScriptFolders.add(moduleScriptFolder);
        }
        if (errorIfMissing && existingScriptFolders.isEmpty()) {
            this.errorMsg("error.no.script.found.for.module", moduleName, this.scriptFolders, scriptPath);
        }
        return existingScriptFolders;
    }

    private boolean repositoryRemoveArtifact(RepositoryManager outputRepository, ArtifactContext artifactContext) throws IOException {
        try {
            outputRepository.removeArtifact(artifactContext);
            return true;
        }
        catch (Exception e) {
            this.errorMsg("error.failed.remove.artifact", artifactContext, e.getLocalizedMessage());
            return false;
        }
    }

    private boolean repositoryPutArtifact(RepositoryManager outputRepository, ArtifactContext artifactContext, File content) throws IOException {
        try {
            outputRepository.putArtifact(artifactContext, content);
            return true;
        }
        catch (Exception e) {
            this.errorMsg("error.failed.write.artifact", artifactContext, e.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public void initialize(CeylonTool mainTool) throws Exception {
        if (this.system && this.local) {
            throw new IllegalArgumentException(Messages.msg(this.bundle, "conflicting.destinations", new Object[0]));
        }
        if (this.mode == Mode.pack) {
            for (ModuleSpec module : this.modules) {
                if (!module.isVersioned()) continue;
                throw new IllegalArgumentException(Messages.msg(this.bundle, "invalid.module.or.file", module.getName()));
            }
        }
    }

    public static enum Mode {
        pack,
        list,
        install,
        uninstall;

    }

    public static class CeylonPluginException
    extends ToolError {
        public CeylonPluginException(String msgKey, Exception cause, Object ... args) {
            super(CeylonPluginMessages.msg(msgKey, args), cause);
        }

        public CeylonPluginException(String msgKey, Object ... args) {
            super(CeylonPluginMessages.msg(msgKey, args));
        }
    }
}

