/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.tools.version;

import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.CeylonBaseTool;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.ParsedBy;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.StandardArgumentParsers;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.common.tools.ModuleSpec;
import com.redhat.ceylon.compiler.typechecker.TypeChecker;
import com.redhat.ceylon.compiler.typechecker.TypeCheckerBuilder;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnits;
import com.redhat.ceylon.compiler.typechecker.parser.CeylonLexer;
import com.redhat.ceylon.compiler.typechecker.parser.CeylonParser;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.tools.version.CeylonVersionMessages;
import java.io.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenRewriteStream;

@Summary(value="Shows and updates version numbers in module descriptors")
@Description(value="If `--set` is present then update the module versions, otherwise show the module versions.\n\nIf `--dependencies` is present then show the versions of module imports of the given module(s).\n\n`<modules>` specifies the module names (excluding versions) of the modules to show or whose versions should be updated. If unspecified then all modules are shown/updated.\n\n**Note:** Other modules may also be updated unless the `--no-update-dependencies` option is used, even if they're not listed in `<modules>`\n\n")
@RemainingSections(value="## Examples\n\nListing the versions of all the modules in the ceylon SDK:\n\n    ceylon version\n\nListing the version of ceylon.collection, and modules that depend on it\n\n    ceylon version --dependencies ceylon.collection\n\nUpdating the version of ceylon.collection, and the modules that depend on it\n\n    ceylon version --set 1.0.1 ceylon.collection")
public class CeylonVersionTool
extends CeylonBaseTool {
    private Appendable out = System.out;
    private String newVersion;
    private List<ModuleSpec> modules;
    private List<File> sourceFolders = DefaultToolOptions.getCompilerSourceDirs();
    private String encoding = System.getProperty("file.encoding");
    private boolean dependencies = false;
    private boolean noUpdateDependencies = false;
    private Confirm confirm = Confirm.all;

    public void setOut(Appendable out) {
        this.out = out;
    }

    @OptionArgument(longName="src", argumentName="dir")
    @ParsedBy(value=StandardArgumentParsers.PathArgumentParser.class)
    @Description(value="A directory containing Ceylon and/or Java source code (default: `./source`)")
    public void setSourceFolders(List<File> sourceFolders) {
        this.sourceFolders = sourceFolders;
    }

    @OptionArgument(longName="source", argumentName="dirs")
    @ParsedBy(value=StandardArgumentParsers.PathArgumentParser.class)
    @Description(value="An alias for `--src` (default: `./source`)")
    public void setSource(List<File> source) {
        this.setSourceFolders(source);
    }

    @OptionArgument
    @Description(value="The new version number to set.If unspecified then module versions are shown and not updated.")
    public void setSet(String newVersion) {
        this.newVersion = newVersion;
    }

    @OptionArgument(argumentName="charset")
    @Description(value="Used with `--set`, sets the encoding used for reading and writing the `module.ceylon` files (default: platform-specific).")
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Option
    @Description(value="Do not update of the version in module imports of the target module(s) in other modules in the given `--src` directories. For example:\n\n    ceylon version --set 1.1 ceylon.collection\n\nwould update the version of ceylon.collection to 1.1 and update the module import version of all dependent modules in the given `--src` directories which depended on `ceylon.collection` __even if those modules are not listed as `<modules>`__.\n\nWhereas:\n\n    ceylon version --set 1.1 --no-update-dependencies ceylon.collection\n\nwould just update the version of `ceylon.collection` to 1.1, leaving dependent modules depending on the old version.")
    public void setNoUpdateDependencies(boolean noUpdateDependencies) {
        this.noUpdateDependencies = noUpdateDependencies;
    }

    @Option
    @Description(value="Display modules who depend on the given module. Only used when displaying modules, not when setting a new version.")
    public void setDependencies(boolean dependencies) {
        this.dependencies = dependencies;
    }

    @OptionArgument(argumentName="option")
    @Description(value="Used with `--set`, determines which updates require confirmation.\n\n* `--confirm=all` requires confirmation on the console for each update performed.\n* `--confirm=dependencies` means that confirmation is only required when updating versions appearing in module imports; module versions are updated without confirmation.\n* `--confirm=none` prevents any confirmation.\n\n(default: `all`).")
    public void setConfirm(Confirm confirm) {
        this.confirm = confirm;
    }

    @Argument(argumentName="modules", multiplicity="*")
    public void setModules(List<String> modules) {
        this.setModuleSpecs(ModuleSpec.parseEachList(modules, ModuleSpec.Option.VERSION_PROHIBITED));
    }

    public void setModuleSpecs(List<ModuleSpec> modules) {
        this.modules = modules;
    }

    @Override
    public void initialize(CeylonTool mainTool) {
    }

    @Override
    public void run() throws IOException, RecognitionException {
        TypeCheckerBuilder tcb = new TypeCheckerBuilder();
        for (File path : this.sourceFolders) {
            tcb.addSrcDirectory(this.applyCwd(path));
        }
        TypeChecker tc = tcb.getTypeChecker();
        PhasedUnits pus = tc.getPhasedUnits();
        pus.visitModules();
        ArrayList<Module> moduleList = new ArrayList<Module>(pus.getModuleSourceMapper().getCompiledModules());
        Collections.sort(moduleList, new Comparator<Module>(){

            @Override
            public int compare(Module m1, Module m2) {
                if (CeylonVersionTool.this.match(m1) && !CeylonVersionTool.this.match(m2)) {
                    return -1;
                }
                if (!CeylonVersionTool.this.match(m1) && CeylonVersionTool.this.match(m2)) {
                    return 1;
                }
                int cmp = m1.getNameAsString().compareToIgnoreCase(m2.getNameAsString());
                if (cmp == 0) {
                    cmp = m1.getVersion().compareTo(m2.getVersion());
                }
                return cmp;
            }
        });
        HashMap<String, String> updatedModuleVersions = new HashMap<String, String>();
        for (Module module : moduleList) {
            boolean isMatch = this.match(module);
            if (this.newVersion == null) {
                this.output(module, isMatch);
                continue;
            }
            if (!isMatch || this.updateModuleVersion(module, updatedModuleVersions)) continue;
            return;
        }
        if (this.newVersion != null && !this.noUpdateDependencies) {
            for (Module module : moduleList) {
                if (this.updateModuleImports(module, updatedModuleVersions)) continue;
                return;
            }
        }
    }

    private boolean updateModuleVersion(Module module, Map<String, String> updatedModuleVersions) throws IOException, RecognitionException {
        String v;
        String moduleDescriptorPath = module.getUnit().getFullPath();
        CeylonLexer lexer = new CeylonLexer(new ANTLRFileStream(moduleDescriptorPath, this.encoding));
        TokenRewriteStream tokenStream = new TokenRewriteStream(lexer);
        CeylonParser parser = new CeylonParser(tokenStream);
        Tree.CompilationUnit cu = parser.compilationUnit();
        String string = v = this.confirm == Confirm.dependencies ? this.newVersion : this.confirm("update.module.version", module.getNameAsString(), module.getVersion(), this.newVersion);
        if (v == null) {
            return false;
        }
        if (!v.isEmpty()) {
            updatedModuleVersions.put(module.getNameAsString(), v);
            this.updateModuleVersion(moduleDescriptorPath, tokenStream, cu, v);
        }
        return true;
    }

    private boolean updateModuleImports(Module module, Map<String, String> updatedModuleVersions) throws IOException, RecognitionException {
        String moduleDescriptorPath = module.getUnit().getFullPath();
        CeylonLexer lexer = new CeylonLexer(new ANTLRFileStream(moduleDescriptorPath, this.encoding));
        TokenRewriteStream tokenStream = new TokenRewriteStream(lexer);
        CeylonParser parser = new CeylonParser(tokenStream);
        Tree.CompilationUnit cu = parser.compilationUnit();
        List<Tree.ImportModule> moduleImports = this.findUpdatedImport(cu, updatedModuleVersions);
        for (Tree.ImportModule moduleImport : moduleImports) {
            String v;
            String importedModuleName = this.getModuleName(moduleImport);
            String newVersion = updatedModuleVersions.get(importedModuleName);
            if (newVersion == null) {
                newVersion = this.newVersion;
            }
            if ((v = this.confirm("update.dependency.version", importedModuleName, module.getNameAsString(), module.getVersion(), newVersion)) == null) {
                return false;
            }
            if (v.isEmpty()) continue;
            this.updateImportVersion(moduleDescriptorPath, tokenStream, moduleImport, v);
        }
        return true;
    }

    private void output(Module module, boolean isMatch) throws IOException, RecognitionException {
        if (isMatch) {
            this.outputVersion(module);
        } else if (this.dependencies) {
            String moduleDescriptorPath = module.getUnit().getFullPath();
            CeylonLexer lexer = new CeylonLexer(new ANTLRFileStream(moduleDescriptorPath, this.encoding));
            CommonTokenStream tokenStream = new CommonTokenStream(lexer);
            CeylonParser parser = new CeylonParser(tokenStream);
            Tree.CompilationUnit cu = parser.compilationUnit();
            List<Tree.ImportModule> moduleImports = this.findImport(cu);
            for (Tree.ImportModule moduleImport : moduleImports) {
                this.outputDependency(module, moduleImport);
            }
        }
    }

    private void outputVersion(Module module) throws IOException {
        this.out.append(CeylonVersionMessages.msg("output.module", module.getNameAsString(), module.getVersion())).append(System.lineSeparator());
    }

    private void outputDependency(Module module, Tree.ImportModule moduleImport) throws IOException {
        String version2 = moduleImport.getVersion().getText();
        version2 = version2.substring(1, version2.length() - 1);
        this.out.append(CeylonVersionMessages.msg("output.dependency", module.getNameAsString(), module.getVersion(), this.getModuleName(moduleImport), version2)).append(System.lineSeparator());
    }

    private boolean match(Module module) {
        return this.match(module.getNameAsString());
    }

    private boolean match(String moduleName) {
        if (this.modules == null || this.modules.isEmpty()) {
            return true;
        }
        for (ModuleSpec spec : this.modules) {
            if (!spec.getName().equals(moduleName)) continue;
            return true;
        }
        return false;
    }

    private void updateImportVersion(String moduleDescriptorPath, TokenRewriteStream tokenStream, Tree.ImportModule moduleImport, String version2) throws IOException {
        tokenStream.replace(moduleImport.getVersion().getToken(), (Object)("\"" + version2 + "\""));
        this.write(moduleDescriptorPath, tokenStream);
    }

    private void updateModuleVersion(String moduleDescriptorPath, TokenRewriteStream tokenStream, Tree.CompilationUnit cu, String version2) throws IOException {
        tokenStream.replace(cu.getModuleDescriptors().get(0).getVersion().getToken(), (Object)("\"" + version2 + "\""));
        this.write(moduleDescriptorPath, tokenStream);
    }

    private void write(String moduleDescriptorPath, TokenRewriteStream tokenStream) throws IOException, UnsupportedEncodingException, FileNotFoundException {
        File target = new File(moduleDescriptorPath);
        File temp = File.createTempFile("ceylon-module-", ".tmp", target.getParentFile());
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(temp), this.encoding);){
            writer.append(tokenStream.toString());
        }
        catch (IOException e) {
            temp.delete();
        }
        Files.move(temp.toPath(), target.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
    }

    private List<Tree.ImportModule> findImport(Tree.CompilationUnit cu) {
        LinkedList<Tree.ImportModule> dependsOnTarget = new LinkedList<Tree.ImportModule>();
        for (Tree.ImportModule importModule : cu.getModuleDescriptors().get(0).getImportModuleList().getImportModules()) {
            String name = this.getModuleName(importModule);
            if (!this.match(name)) continue;
            dependsOnTarget.add(importModule);
        }
        return dependsOnTarget;
    }

    private List<Tree.ImportModule> findUpdatedImport(Tree.CompilationUnit cu, Map<String, String> updatedModules) {
        LinkedList<Tree.ImportModule> dependsOnTarget = new LinkedList<Tree.ImportModule>();
        for (Tree.ImportModule importModule : cu.getModuleDescriptors().get(0).getImportModuleList().getImportModules()) {
            String name = this.getModuleName(importModule);
            if (!updatedModules.containsKey(name)) continue;
            dependsOnTarget.add(importModule);
        }
        return dependsOnTarget;
    }

    private String getModuleName(Tree.ImportModule importModule) {
        String name;
        if (importModule.getQuotedLiteral() != null) {
            name = importModule.getQuotedLiteral().getText();
            name = name.substring(1, name.length() - 1);
        } else {
            StringBuilder sb = new StringBuilder();
            for (Tree.Identifier namePart : importModule.getImportPath().getIdentifiers()) {
                sb.append(namePart.getText()).append('.');
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            name = sb.toString();
        }
        return name;
    }

    private String confirm(String msgKey, Object ... args) throws IOException {
        if (this.confirm == Confirm.none) {
            return this.newVersion;
        }
        String version2 = this.newVersion;
        Console console = System.console();
        while (true) {
            args[args.length - 1] = version2;
            console.printf("%s", CeylonVersionMessages.msg(msgKey, args));
            String ch = console.readLine();
            if (ch.equals(CeylonVersionMessages.msg("mnemonic.yes", new Object[0]))) {
                return version2;
            }
            if (ch.equals(CeylonVersionMessages.msg("mnemonic.help", new Object[0]))) {
                this.out.append(CeylonVersionMessages.msg("help", new Object[0])).append(System.lineSeparator());
                continue;
            }
            if (ch.equals(CeylonVersionMessages.msg("mnemonic.quit", new Object[0]))) {
                return null;
            }
            if (ch.equals(CeylonVersionMessages.msg("mnemonic.all", new Object[0]))) {
                this.confirm = Confirm.none;
                return version2;
            }
            if (ch.equals(CeylonVersionMessages.msg("mnemonic.no", new Object[0]))) {
                return "";
            }
            if (!ch.equals(CeylonVersionMessages.msg("mnemonic.edit", new Object[0]))) continue;
            console.printf(CeylonVersionMessages.msg("prompt.version", new Object[0]), new Object[0]);
            version2 = console.readLine();
        }
    }

    static enum Confirm {
        none,
        all,
        dependencies;

    }
}

