/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.io.IOException;
import java.io.OutputStream;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexWriterImpl;
import org.jboss.jandex.IndexWriterV1;
import org.jboss.jandex.IndexWriterV2;
import org.jboss.jandex.UnsupportedVersion;

public final class IndexWriter {
    private final OutputStream out;

    public IndexWriter(OutputStream out) {
        this.out = out;
    }

    public int write(Index index) throws IOException {
        return this.write(index, 6);
    }

    @Deprecated
    public int write(Index index, byte version2) throws IOException {
        return this.write(index, version2 & 0xFF);
    }

    public int write(Index index, int version2) throws IOException {
        IndexWriterImpl writer = this.getWriter(version2);
        if (writer == null) {
            throw new UnsupportedVersion("Version: " + version2);
        }
        return writer.write(index, version2);
    }

    private IndexWriterImpl getWriter(int version2) {
        if (version2 >= 1 && version2 <= 3) {
            return new IndexWriterV1(this.out);
        }
        if (version2 >= 6 && version2 <= 6) {
            return new IndexWriterV2(this.out);
        }
        return null;
    }
}

