/*
 * Decompiled with CFR 0.152.
 */
package ceylon.interop.java;

import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.Destroyable;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.SharedAnnotation$annotation$;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Jpa;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import java.io.Serializable;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="A Ceylon [[Destroyable]] that adapts an instance of Java's \n[[AutoCloseable]], allowing it to be used as a resource in\nthe `try` construct.\n\n    try (inputStream = CeylonDestroyable(FileInputStream(file)) {\n        Integer byte = inputStream.resource.read();\n        ...\n    }\n    \n**Note**: Since Ceylon 1.2.1 it is possible to use \n[[java.lang::AutoCloseable]] directly in a Ceylon `try` statement:\n\n    try (inputStream = FileInputStream(file)) {\n        ...\n    }\n")
@SharedAnnotation$annotation$
@SatisfiedTypes(value={"ceylon.language::Destroyable"})
@TypeParameters(value={@TypeParameter(value="Resource", variance=Variance.NONE, satisfies={"java.lang::AutoCloseable"}, caseTypes={})})
public class CeylonDestroyable<Resource extends AutoCloseable>
implements ReifiedType,
Destroyable,
Serializable {
    @Ignore
    private final TypeDescriptor $reified$Resource;
    @Ignore
    private final Resource resource;

    @Jpa
    @Ignore
    protected CeylonDestroyable(@Ignore TypeDescriptor $reified$Resource) {
        this.$reified$Resource = $reified$Resource;
        this.resource = null;
    }

    public CeylonDestroyable(@Ignore TypeDescriptor $reified$Resource, @Name(value="resource") @TypeInfo(value="Resource", erased=true) @SharedAnnotation$annotation$ Resource resource) {
        this.$reified$Resource = $reified$Resource;
        this.resource = resource;
    }

    @SharedAnnotation$annotation$
    @TypeInfo(value="Resource", erased=true)
    public final Resource getResource() {
        return this.resource;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final Object destroy(@Name(value="exception") @TypeInfo(value="ceylon.language::Throwable?") @Nullable Throwable exception) {
        try {
            this.getResource().close();
        }
        catch (Exception e) {
            Throwable exception$1 = exception;
            if (exception$1 != null) {
                Throwable exception$2 = exception$1;
                throw exception$2;
            }
            Throwable exception$3 = exception;
            throw e;
        }
        return null;
    }

    @Ignore
    public TypeDescriptor $getType$() {
        return TypeDescriptor.klass(CeylonDestroyable.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Resource});
    }
}

