/*
 * Decompiled with CFR 0.152.
 */
package ceylon.interop.java;

import ceylon.collection.ListMutator;
import ceylon.collection.MutableList;
import ceylon.interop.java.CeylonList;
import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Category;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Enumerable;
import ceylon.language.Finished;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.Range;
import ceylon.language.Sequential;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.Tuple;
import ceylon.language.measure_;
import ceylon.language.span_;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.FunctionalParameter;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Jpa;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="A Ceylon [[MutableList]] that wraps a [[java.util::List]].\n\nIf the given [[list]] contains null elements, an optional\n[[Element]] type must be explicitly specified, for example:\n\n    CeylonMutableList<String?>(javaStringList)\n\nIf a non-optional `Element` type is specified, an\n[[AssertionError]] will occur whenever a null value is\nencountered while iterating the list.")
@SharedAnnotation$annotation$
@SatisfiedTypes(value={"ceylon.collection::MutableList<Element>"})
@TypeParameters(value={@TypeParameter(value="Element", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={})})
@Class(extendsType="ceylon.interop.java::CeylonList<Element>")
public class CeylonMutableList<Element>
extends CeylonList<Element>
implements MutableList<Element> {
    @Ignore
    private final TypeDescriptor $reified$Element;
    @Ignore
    protected final MutableList.impl<Element> $ceylon$collection$MutableList$this$;
    @Ignore
    protected final ListMutator.impl<Element> $ceylon$collection$ListMutator$this$;
    @Ignore
    private final List<Element> list;

    @Jpa
    @Ignore
    protected CeylonMutableList(@Ignore TypeDescriptor $reified$Element) {
        super($reified$Element);
        this.$reified$Element = $reified$Element;
        this.$ceylon$collection$ListMutator$this$ = new ListMutator.impl($reified$Element, (ListMutator)this);
        this.$ceylon$collection$MutableList$this$ = new MutableList.impl($reified$Element, (MutableList)this);
        this.list = null;
    }

    public CeylonMutableList(@Ignore TypeDescriptor $reified$Element, @Name(value="list") @TypeInfo(value="java.util::List<Element>") @NonNull List<Element> list) {
        super($reified$Element, list);
        this.$reified$Element = $reified$Element;
        this.list = list;
        this.$ceylon$collection$MutableList$this$ = new MutableList.impl($reified$Element, (MutableList)this);
        this.$ceylon$collection$ListMutator$this$ = new ListMutator.impl($reified$Element, (ListMutator)this);
    }

    @Ignore
    public MutableList.impl<Element> $ceylon$collection$MutableList$impl() {
        return this.$ceylon$collection$MutableList$this$;
    }

    @Ignore
    public Element deleteFirst() {
        return (Element)this.$ceylon$collection$MutableList$this$.deleteFirst();
    }

    @Ignore
    public Element deleteLast() {
        return (Element)this.$ceylon$collection$MutableList$this$.deleteLast();
    }

    @Ignore
    public Object move(long i, long j) {
        return this.$ceylon$collection$MutableList$this$.move(i, j);
    }

    @Ignore
    public Object swap(long i, long j) {
        return this.$ceylon$collection$MutableList$this$.swap(i, j);
    }

    @Ignore
    public ListMutator.impl<? super Element> $ceylon$collection$ListMutator$impl() {
        return this.$ceylon$collection$ListMutator$this$;
    }

    @Ignore
    public Object addAll(Iterable<? extends Element, ? extends Object> elements) {
        return this.$ceylon$collection$ListMutator$this$.addAll(elements);
    }

    @Ignore
    public Object insertAll(long index, Iterable<? extends Element, ? extends Object> elements) {
        return this.$ceylon$collection$ListMutator$this$.insertAll(index, elements);
    }

    @Ignore
    public long removeAll(Iterable<? extends Element, ? extends Object> elements) {
        return this.$ceylon$collection$ListMutator$this$.removeAll(elements);
    }

    @TypeInfo(value="java.util::List<Element>")
    @NonNull
    private final List<Element> getList$priv$() {
        return this.list;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final Object add(@Name(value="element") @TypeInfo(value="Element") Element element) {
        return Boolean.instance((boolean)this.getList$priv$().add(element));
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final Object set(@Name(value="index") long index, @Name(value="element") @TypeInfo(value="Element") Element element) {
        Element $ceylontmp$op$0 = element;
        this.getList$priv$().set(Util.toInt((long)index), $ceylontmp$op$0);
        return $ceylontmp$op$0;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final Object insert(@Name(value="index") long index, @Name(value="element") @TypeInfo(value="Element") Element element) {
        this.getList$priv$().add((int)index, element);
        return null;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final long remove(@Name(value="element") @TypeInfo(value="Element") Element element) {
        long size = this.getList$priv$().size();
        this.getList$priv$().removeAll(Collections.singleton(element));
        return size - (long)this.getList$priv$().size();
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element delete(@Name(value="index") long index) {
        return this.getList$priv$().remove((int)index);
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final Object clear() {
        this.getList$priv$().clear();
        return null;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean removeFirst(@Name(value="element") @TypeInfo(value="Element") Element element) {
        return this.getList$priv$().remove(element);
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean removeLast(@Name(value="element") @TypeInfo(value="Element") Element element) {
        ceylon.language.Iterator i$iterator$$7;
        Sequential iterable$3 = ((Sequential)measure_.measure((TypeDescriptor)Integer.$TypeDescriptor$, (Enumerable)Integer.instance((long)0L), (long)this.getSize())).getReversed();
        boolean isTuple$4 = iterable$3 instanceof Tuple && ((Tuple)iterable$3).$getArray$() != null;
        Object elem$2 = null;
        int i$5 = 0;
        int length$6 = isTuple$4 ? (int)iterable$3.getSize() : 0;
        ceylon.language.Iterator iterator = i$iterator$$7 = isTuple$4 ? null : iterable$3.iterator();
        while (isTuple$4 ? i$5 < length$6 : !((elem$2 = i$iterator$$7.next()) instanceof Finished)) {
            Object e$12;
            if (isTuple$4) {
                elem$2 = iterable$3.getFromFirst((long)i$5++);
            }
            long i = ((Integer)elem$2).longValue();
            List<Element> $ceylontmp$list$10 = this.getList$priv$();
            int $ceylontmp$index$11 = Util.toInt((long)i);
            Object e$9 = $ceylontmp$index$11 >= 0 && $ceylontmp$index$11 < $ceylontmp$list$10.size() ? (Object)$ceylontmp$list$10.get($ceylontmp$index$11) : null;
            if (e$9 == null || !(e$12 = e$9).equals(element)) continue;
            this.getList$priv$().remove((int)i);
            return true;
        }
        return false;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element findAndRemoveFirst(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") @NonNull Callable<? extends Boolean> selecting) {
        Iterator<Element> it = this.getList$priv$().iterator();
        while (((Iterator)Util.checkNull(it)).hasNext()) {
            Object item = ((Iterator)Util.checkNull(it)).next();
            if (!((Boolean)selecting.$call$(Util.checkNull(item))).booleanValue()) continue;
            ((Iterator)Util.checkNull(it)).remove();
            return (Element)item;
        }
        return null;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element findAndRemoveLast(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") @NonNull Callable<? extends Boolean> selecting) {
        ListIterator<Element> it = this.getList$priv$().listIterator(this.getList$priv$().size());
        while (((ListIterator)Util.checkNull(it)).hasPrevious()) {
            Object item = ((ListIterator)Util.checkNull(it)).previous();
            if (!((Boolean)selecting.$call$(Util.checkNull(item))).booleanValue()) continue;
            ((ListIterator)Util.checkNull(it)).remove();
            return (Element)item;
        }
        return null;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final long removeWhere(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") @NonNull Callable<? extends Boolean> selecting) {
        long count = 0L;
        Iterator<Element> it = this.getList$priv$().iterator();
        while (((Iterator)Util.checkNull(it)).hasNext()) {
            if (!((Boolean)selecting.$call$(Util.checkNull(((Iterator)Util.checkNull(it)).next()))).booleanValue()) continue;
            ((Iterator)Util.checkNull(it)).remove();
            ++count;
        }
        return count;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final Object deleteMeasure(@Name(value="from") long from, @Name(value="length") long length) {
        Iterator<Element> iterator = this.getList$priv$().iterator();
        long i = 0L;
        Object measure = measure_.measure((TypeDescriptor)Integer.$TypeDescriptor$, (Enumerable)Integer.instance((long)from), (long)length);
        while (((Iterator)Util.checkNull(iterator)).hasNext()) {
            ((Iterator)Util.checkNull(iterator)).next();
            Integer $ceylontmp$17 = Integer.instance((long)i);
            if (((Category)measure).contains((Object)$ceylontmp$17)) {
                ((Iterator)Util.checkNull(iterator)).remove();
            }
            ++i;
        }
        return null;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final Object deleteSpan(@Name(value="from") long from, @Name(value="to") long to) {
        Iterator<Element> iterator = this.getList$priv$().iterator();
        long i = 0L;
        Range span = span_.span((TypeDescriptor)Integer.$TypeDescriptor$, (Enumerable)Integer.instance((long)from), (Enumerable)Integer.instance((long)to));
        while (((Iterator)Util.checkNull(iterator)).hasNext()) {
            ((Iterator)Util.checkNull(iterator)).next();
            Integer $ceylontmp$19 = Integer.instance((long)i);
            if (span.contains((Object)$ceylontmp$19)) {
                ((Iterator)Util.checkNull(iterator)).remove();
            }
            ++i;
        }
        return null;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final long prune() {
        Iterator<Element> iterator = this.getList$priv$().iterator();
        long removed = 0L;
        while (((Iterator)Util.checkNull(iterator)).hasNext()) {
            if (((Iterator)Util.checkNull(iterator)).next() != null) continue;
            ++removed;
            ((Iterator)Util.checkNull(iterator)).remove();
        }
        return removed;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final long replace(@Name(value="element") @TypeInfo(value="Element") Element element, @Name(value="replacement") @TypeInfo(value="Element") Element replacement) {
        long count = 0L;
        boolean start$22 = false;
        long length$23 = this.getSize();
        for (long i$24 = 0L; i$24 < length$23; ++i$24) {
            Object e$29;
            long i = i$24 + 0L;
            List<Element> $ceylontmp$list$27 = this.getList$priv$();
            int $ceylontmp$index$28 = Util.toInt((long)i);
            Object e$26 = $ceylontmp$index$28 >= 0 && $ceylontmp$index$28 < $ceylontmp$list$27.size() ? (Object)$ceylontmp$list$27.get($ceylontmp$index$28) : null;
            if (e$26 == null || !(e$29 = e$26).equals(element)) continue;
            this.getList$priv$().set(Util.toInt((long)i), replacement);
            ++count;
        }
        return count;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final Object infill(@Name(value="replacement") @TypeInfo(value="Element") Element replacement) {
        boolean start$31 = false;
        long length$32 = this.getSize();
        for (long i$33 = 0L; i$33 < length$32; ++i$33) {
            long i = i$33 + 0L;
            List<Element> $ceylontmp$list$35 = this.getList$priv$();
            int $ceylontmp$index$36 = Util.toInt((long)i);
            if (($ceylontmp$index$36 >= 0 && $ceylontmp$index$36 < $ceylontmp$list$35.size() ? $ceylontmp$list$35.get($ceylontmp$index$36) : null) != null) continue;
            this.getList$priv$().set(Util.toInt((long)i), replacement);
        }
        return null;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean replaceFirst(@Name(value="element") @TypeInfo(value="Element") Element element, @Name(value="replacement") @TypeInfo(value="Element") Element replacement) {
        boolean start$38 = false;
        long length$39 = this.getSize();
        for (long i$40 = 0L; i$40 < length$39; ++i$40) {
            Object e$45;
            long i = i$40 + 0L;
            List<Element> $ceylontmp$list$43 = this.getList$priv$();
            int $ceylontmp$index$44 = Util.toInt((long)i);
            Object e$42 = $ceylontmp$index$44 >= 0 && $ceylontmp$index$44 < $ceylontmp$list$43.size() ? (Object)$ceylontmp$list$43.get($ceylontmp$index$44) : null;
            if (e$42 == null || !(e$45 = e$42).equals(element)) continue;
            this.getList$priv$().set(Util.toInt((long)i), replacement);
            return true;
        }
        return false;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final boolean replaceLast(@Name(value="element") @TypeInfo(value="Element") Element element, @Name(value="replacement") @TypeInfo(value="Element") Element replacement) {
        ceylon.language.Iterator i$iterator$$52;
        Sequential iterable$48 = ((Sequential)measure_.measure((TypeDescriptor)Integer.$TypeDescriptor$, (Enumerable)Integer.instance((long)0L), (long)this.getSize())).getReversed();
        boolean isTuple$49 = iterable$48 instanceof Tuple && ((Tuple)iterable$48).$getArray$() != null;
        Object elem$47 = null;
        int i$50 = 0;
        int length$51 = isTuple$49 ? (int)iterable$48.getSize() : 0;
        ceylon.language.Iterator iterator = i$iterator$$52 = isTuple$49 ? null : iterable$48.iterator();
        while (isTuple$49 ? i$50 < length$51 : !((elem$47 = i$iterator$$52.next()) instanceof Finished)) {
            Object e$57;
            if (isTuple$49) {
                elem$47 = iterable$48.getFromFirst((long)i$50++);
            }
            long i = ((Integer)elem$47).longValue();
            List<Element> $ceylontmp$list$55 = this.getList$priv$();
            int $ceylontmp$index$56 = Util.toInt((long)i);
            Object e$54 = $ceylontmp$index$56 >= 0 && $ceylontmp$index$56 < $ceylontmp$list$55.size() ? (Object)$ceylontmp$list$55.get($ceylontmp$index$56) : null;
            if (e$54 == null || !(e$57 = e$54).equals(element)) continue;
            this.getList$priv$().set(Util.toInt((long)i), replacement);
            return true;
        }
        return false;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element findAndReplaceFirst(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") @NonNull Callable<? extends Boolean> selecting, @Name(value="replacement") @TypeInfo(value="Element") Element replacement) {
        boolean start$59 = false;
        long length$60 = this.getSize();
        for (long i$61 = 0L; i$61 < length$60; ++i$61) {
            Element element$66;
            long i = i$61 + 0L;
            List<Element> $ceylontmp$list$64 = this.getList$priv$();
            int $ceylontmp$index$65 = Util.toInt((long)i);
            Element element$63 = $ceylontmp$index$65 >= 0 && $ceylontmp$index$65 < $ceylontmp$list$64.size() ? (Element)$ceylontmp$list$64.get($ceylontmp$index$65) : null;
            if (element$63 == null || !((Boolean)selecting.$call$(element$66 = element$63)).booleanValue()) continue;
            this.getList$priv$().set(Util.toInt((long)i), replacement);
            return element$66;
        }
        return null;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="Element?")
    @Nullable
    public final Element findAndReplaceLast(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") @NonNull Callable<? extends Boolean> selecting, @Name(value="replacement") @TypeInfo(value="Element") Element replacement) {
        ceylon.language.Iterator i$iterator$$73;
        Sequential iterable$69 = ((Sequential)measure_.measure((TypeDescriptor)Integer.$TypeDescriptor$, (Enumerable)Integer.instance((long)0L), (long)this.getSize())).getReversed();
        boolean isTuple$70 = iterable$69 instanceof Tuple && ((Tuple)iterable$69).$getArray$() != null;
        Object elem$68 = null;
        int i$71 = 0;
        int length$72 = isTuple$70 ? (int)iterable$69.getSize() : 0;
        ceylon.language.Iterator iterator = i$iterator$$73 = isTuple$70 ? null : iterable$69.iterator();
        while (isTuple$70 ? i$71 < length$72 : !((elem$68 = i$iterator$$73.next()) instanceof Finished)) {
            Element element$78;
            if (isTuple$70) {
                elem$68 = iterable$69.getFromFirst((long)i$71++);
            }
            long i = ((Integer)elem$68).longValue();
            List<Element> $ceylontmp$list$76 = this.getList$priv$();
            int $ceylontmp$index$77 = Util.toInt((long)i);
            Element element$75 = $ceylontmp$index$77 >= 0 && $ceylontmp$index$77 < $ceylontmp$list$76.size() ? (Element)$ceylontmp$list$76.get($ceylontmp$index$77) : null;
            if (element$75 == null || !((Boolean)selecting.$call$(element$78 = element$75)).booleanValue()) continue;
            this.getList$priv$().set(Util.toInt((long)i), replacement);
            return element$78;
        }
        return null;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    public final long replaceWhere(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(Element)") @NonNull Callable<? extends Boolean> selecting, @Name(value="replacement") @TypeInfo(value="Element") Element replacement) {
        long count = 0L;
        boolean start$80 = false;
        long length$81 = this.getSize();
        for (long i$82 = 0L; i$82 < length$81; ++i$82) {
            Object element$87;
            long i = i$82 + 0L;
            List<Element> $ceylontmp$list$85 = this.getList$priv$();
            int $ceylontmp$index$86 = Util.toInt((long)i);
            Object element$84 = $ceylontmp$index$86 >= 0 && $ceylontmp$index$86 < $ceylontmp$list$85.size() ? $ceylontmp$list$85.get($ceylontmp$index$86) : null;
            if (element$84 == null || !((Boolean)selecting.$call$(element$87 = element$84)).booleanValue()) continue;
            this.getList$priv$().set(Util.toInt((long)i), replacement);
            ++count;
        }
        return count;
    }

    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public final Object truncate(@Name(value="size") long size) {
        Iterator<Element> iterator = this.getList$priv$().iterator();
        long i = 0L;
        while (((Iterator)Util.checkNull(iterator)).hasNext()) {
            ((Iterator)Util.checkNull(iterator)).next();
            if (i >= size) {
                ((Iterator)Util.checkNull(iterator)).remove();
            }
            ++i;
        }
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @TypeInfo(value="ceylon.collection::MutableList<Element>")
    @NonNull
    public final MutableList<Element> $clone() {
        return new CeylonMutableList<Element>(this.$reified$Element, new ArrayList<Element>(this.getList$priv$()));
    }

    @Override
    @Ignore
    public TypeDescriptor $getType$() {
        return TypeDescriptor.klass(CeylonMutableList.class, (TypeDescriptor[])new TypeDescriptor[]{this.$reified$Element});
    }
}

