/*
 * Decompiled with CFR 0.152.
 */
package annotator;

import annotations.Annotation;
import annotations.el.ABlock;
import annotations.el.AClass;
import annotations.el.ADeclaration;
import annotations.el.AElement;
import annotations.el.AExpression;
import annotations.el.AField;
import annotations.el.AMethod;
import annotations.el.AScene;
import annotations.el.ATypeElement;
import annotations.el.ATypeElementWithType;
import annotations.el.AnnotationDef;
import annotations.el.DefException;
import annotations.el.ElementVisitor;
import annotations.el.LocalLocation;
import annotations.io.ASTIndex;
import annotations.io.ASTPath;
import annotations.io.ASTRecord;
import annotations.io.DebugWriter;
import annotations.io.IndexFileParser;
import annotations.io.IndexFileWriter;
import annotations.util.coll.VivifyingMap;
import annotator.Source;
import annotator.find.AnnotationInsertion;
import annotator.find.CastInsertion;
import annotator.find.ConstructorInsertion;
import annotator.find.Criteria;
import annotator.find.GenericArrayLocationCriterion;
import annotator.find.Insertion;
import annotator.find.Insertions;
import annotator.find.NewInsertion;
import annotator.find.ReceiverInsertion;
import annotator.find.TreeFinder;
import annotator.find.TypedInsertion;
import annotator.scanner.LocalVariableScanner;
import annotator.specification.IndexFileSpecification;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.main.CommandLine;
import com.sun.tools.javac.tree.JCTree;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import plume.FileIOException;
import plume.Option;
import plume.OptionGroup;
import plume.Options;
import plume.Pair;
import plume.UtilMDE;
import type.DeclaredType;
import type.Type;

public class Main {
    @OptionGroup(value="General options")
    @Option(value="-d <directory> Directory in which output files are written")
    public static String outdir = "annotated/";
    @Option(value="-i Overwrite original source files")
    public static boolean in_place = false;
    @Option(value="-a Abbreviate annotation names")
    public static boolean abbreviate = true;
    @Option(value="-c Insert annotations in comments")
    public static boolean comments = false;
    @Option(value="-o Omit given annotation")
    public static String omit_annotation;
    @Option(value="Suppress warnings about disallowed insertions")
    public static boolean nowarn;
    @Option(value="Convert JAIFs to AST Path format")
    public static boolean convert_jaifs;
    @Option(value="-h Print usage information and exit")
    public static boolean help;
    @OptionGroup(value="Debugging options")
    @Option(value="-v Verbose (print progress information)")
    public static boolean verbose;
    @Option(value="Debug (print debug information)")
    public static boolean debug;
    @Option(value="Print error stack")
    public static boolean print_error_stack;
    private static ElementVisitor<Void, AElement> classFilter;

    private static AScene filteredScene(AScene scene) {
        AScene filtered = new AScene();
        filtered.packages.putAll(scene.packages);
        filtered.imports.putAll(scene.imports);
        for (Map.Entry entry : scene.classes.entrySet()) {
            String key = (String)entry.getKey();
            AClass clazz0 = (AClass)entry.getValue();
            AClass clazz1 = filtered.classes.vivify(key);
            clazz0.accept(classFilter, clazz1);
        }
        filtered.prune();
        return filtered;
    }

    private static ATypeElement findInnerTypeElement(Tree t, ASTRecord rec, ADeclaration decl, Type type, Insertion ins) {
        ASTPath astPath = rec.astPath;
        GenericArrayLocationCriterion galc = ins.getCriteria().getGenericArrayLocation();
        assert (astPath != null && galc != null);
        List<TypeAnnotationPosition.TypePathEntry> tpes = galc.getLocation();
        for (TypeAnnotationPosition.TypePathEntry tpe : tpes) {
            ASTPath.ASTEntry entry;
            switch (tpe.tag) {
                case ARRAY: {
                    if (!astPath.isEmpty() && (entry = astPath.get(-1)).getTreeKind() == Tree.Kind.NEW_ARRAY && entry.childSelectorIs("type")) {
                        entry = new ASTPath.ASTEntry(Tree.Kind.NEW_ARRAY, "type", entry.getArgument() + 1);
                        break;
                    }
                    entry = new ASTPath.ASTEntry(Tree.Kind.ARRAY_TYPE, "type");
                    break;
                }
                case INNER_TYPE: {
                    entry = new ASTPath.ASTEntry(Tree.Kind.MEMBER_SELECT, "expression");
                    break;
                }
                case TYPE_ARGUMENT: {
                    entry = new ASTPath.ASTEntry(Tree.Kind.PARAMETERIZED_TYPE, "typeArgument", tpe.arg);
                    break;
                }
                case WILDCARD: {
                    entry = new ASTPath.ASTEntry(Tree.Kind.UNBOUNDED_WILDCARD, "bound");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown type tag " + (Object)((Object)tpe.tag));
                }
            }
            astPath = astPath.extend(entry);
        }
        return decl.insertAnnotations.vivify(astPath);
    }

    private static void convertInsertion(String pkg, JCTree.JCCompilationUnit tree, ASTRecord rec, Insertion ins, AScene scene, Multimap<Insertion, Annotation> insertionSources) {
        block30: {
            Collection<Annotation> annos;
            block29: {
                annos = insertionSources.get(ins);
                if (rec != null) break block29;
                if (!ins.getCriteria().isOnPackage()) break block30;
                for (Annotation anno : annos) {
                    ((AElement)scene.packages.get((Object)pkg)).tlAnnotationsHere.add(anno);
                }
                break block30;
            }
            if (scene != null && rec.className != null) {
                int n;
                AClass clazz = scene.classes.vivify(rec.className);
                ADeclaration decl = null;
                if (ins.getCriteria().onBoundZero() && !rec.astPath.get((n = rec.astPath.size()) - 1).childSelectorIs("bound")) {
                    ASTPath astPath = ASTPath.empty();
                    for (int i = 0; i < n; ++i) {
                        astPath = astPath.extend(rec.astPath.get(i));
                    }
                    astPath = astPath.extend(new ASTPath.ASTEntry(Tree.Kind.TYPE_PARAMETER, "bound", 0));
                    rec = rec.replacePath(astPath);
                }
                if (rec.methodName == null) {
                    decl = rec.varName == null ? clazz : (ADeclaration)clazz.fields.vivify(rec.varName);
                } else {
                    AMethod meth = clazz.methods.vivify(rec.methodName);
                    if (rec.varName == null) {
                        decl = meth;
                    } else {
                        try {
                            int i = Integer.parseInt(rec.varName);
                            decl = i < 0 ? meth.receiver : meth.parameters.vivify(i);
                        }
                        catch (NumberFormatException e) {
                            Tree leaf;
                            TreePath path = ASTIndex.getTreePath(tree, rec);
                            JCTree.JCVariableDecl varTree = null;
                            JCTree.JCMethodDecl methTree = null;
                            JCTree.JCClassDecl classTree = null;
                            block9: while (path != null) {
                                leaf = path.getLeaf();
                                switch (leaf.getKind()) {
                                    case VARIABLE: {
                                        varTree = (JCTree.JCVariableDecl)leaf;
                                        continue block9;
                                    }
                                    case METHOD: {
                                        methTree = (JCTree.JCMethodDecl)leaf;
                                        continue block9;
                                    }
                                    case ANNOTATION: 
                                    case CLASS: 
                                    case ENUM: 
                                    case INTERFACE: {
                                        break block9;
                                    }
                                    default: {
                                        path = path.getParentPath();
                                        continue block9;
                                    }
                                }
                            }
                            while (path != null) {
                                leaf = path.getLeaf();
                                Tree.Kind kind = leaf.getKind();
                                if (kind == Tree.Kind.METHOD) {
                                    methTree = (JCTree.JCMethodDecl)leaf;
                                    int i = LocalVariableScanner.indexOfVarTree(path, varTree, rec.varName);
                                    int m3 = methTree.getStartPosition();
                                    int a = varTree.getStartPosition();
                                    int b = varTree.getEndPosition(tree.endPositions);
                                    LocalLocation loc = new LocalLocation(i, a - m3, b - a);
                                    decl = meth.body.locals.vivify(loc);
                                    break;
                                }
                                if (ASTPath.isClassEquiv(kind)) {
                                    classTree = (JCTree.JCClassDecl)leaf;
                                    break;
                                }
                                path = path.getParentPath();
                            }
                        }
                    }
                }
                if (decl != null) {
                    AElement el;
                    if (rec.astPath.isEmpty()) {
                        el = decl;
                    } else if (ins.getKind() == Insertion.Kind.CAST) {
                        ATypeElementWithType elem = decl.insertTypecasts.vivify(rec.astPath);
                        elem.setType(((CastInsertion)ins).getType());
                        el = elem;
                    } else {
                        el = decl.insertAnnotations.vivify(rec.astPath);
                    }
                    for (Annotation anno : annos) {
                        el.tlAnnotationsHere.add(anno);
                    }
                    if (ins instanceof TypedInsertion) {
                        TypedInsertion ti = (TypedInsertion)ins;
                        if (!rec.astPath.isEmpty()) {
                            // empty if block
                        }
                        for (Insertion inner : ti.getInnerTypeInsertions()) {
                            Tree t = ASTIndex.getNode(tree, rec);
                            if (t == null) continue;
                            ATypeElement elem = Main.findInnerTypeElement(t, rec, decl, ti.getType(), inner);
                            for (Annotation a : insertionSources.get(inner)) {
                                elem.tlAnnotationsHere.add(a);
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws IOException {
        String[] file_args;
        if (verbose) {
            System.out.printf("insert-annotations-to-source (%s)", "Annotation File Utilities v3.6.45");
        }
        Options options = new Options("Main [options] { jaif-file | java-file | @arg-file } ...\n(Contents of argfiles are expanded into the argument list.)", Main.class);
        try {
            String[] cl_args = CommandLine.parse(args);
            file_args = options.parse_or_usage(cl_args);
        }
        catch (IOException ex) {
            System.err.println(ex);
            System.err.println("(For non-argfile beginning with \"@\", use \"@@\" for initial \"@\".");
            System.err.println("Alternative for filenames: indicate directory, e.g. as './@file'.");
            System.err.println("Alternative for flags: use '=', as in '-o=@Deprecated'.)");
            file_args = null;
            System.exit(1);
        }
        DebugWriter dbug = new DebugWriter();
        DebugWriter verb = new DebugWriter();
        DebugWriter both = dbug.or(verb);
        dbug.setEnabled(debug);
        verb.setEnabled(verbose);
        TreeFinder.warn.setEnabled(!nowarn);
        TreeFinder.stak.setEnabled(print_error_stack);
        TreeFinder.dbug.setEnabled(debug);
        Criteria.dbug.setEnabled(debug);
        if (help) {
            options.print_usage();
            System.exit(0);
        }
        if (in_place && outdir != "annotated/") {
            options.print_usage("The --outdir and --in-place options are mutually exclusive.");
            System.exit(1);
        }
        if (file_args.length < 2) {
            options.print_usage("Supplied %d arguments, at least 2 needed%n", file_args.length);
            System.exit(1);
        }
        Insertions insertions = new Insertions();
        ArrayList<String> javafiles = new ArrayList<String>();
        HashMap insertionIndex = new HashMap();
        HashMap<Insertion, String> insertionOrigins = new HashMap<Insertion, String>();
        HashMap<String, AScene> scenes = new HashMap<String, AScene>();
        IndexFileParser.setAbbreviate(abbreviate);
        for (String arg : file_args) {
            if (arg.endsWith(".java")) {
                javafiles.add(arg);
                continue;
            }
            if (arg.endsWith(".jaif") || arg.endsWith(".jann")) {
                IndexFileSpecification spec = new IndexFileSpecification(arg);
                try {
                    List<Insertion> parsedSpec = spec.parse();
                    AScene scene = spec.getScene();
                    Collections.sort(parsedSpec, new Comparator<Insertion>(){

                        @Override
                        public int compare(Insertion i1, Insertion i2) {
                            ASTPath p1 = i1.getCriteria().getASTPath();
                            ASTPath p2 = i2.getCriteria().getASTPath();
                            return p1 == null ? (p2 == null ? 0 : -1) : (p2 == null ? 1 : p1.compareTo(p2));
                        }
                    });
                    if (convert_jaifs) {
                        scenes.put(arg, Main.filteredScene(scene));
                        for (Insertion insertion : parsedSpec) {
                            insertionOrigins.put(insertion, arg);
                        }
                        if (!insertionIndex.containsKey(arg)) {
                            insertionIndex.put(arg, LinkedHashMultimap.create());
                        }
                        ((Multimap)insertionIndex.get(arg)).putAll(spec.insertionSources());
                    }
                    both.debug("Read %d annotations from %s%n", parsedSpec.size(), arg);
                    if (omit_annotation != null) {
                        ArrayList<Insertion> filtered = new ArrayList<Insertion>(parsedSpec.size());
                        for (Insertion insertion : parsedSpec) {
                            if (omit_annotation.equals(insertion.getText())) continue;
                            filtered.add(insertion);
                        }
                        parsedSpec = filtered;
                        both.debug("After filtering: %d annotations from %s%n", parsedSpec.size(), arg);
                    }
                    insertions.addAll(parsedSpec);
                    continue;
                }
                catch (RuntimeException e) {
                    if (e.getCause() != null && e.getCause() instanceof FileNotFoundException) {
                        System.err.println("File not found: " + arg);
                        System.exit(1);
                        continue;
                    }
                    throw e;
                }
                catch (FileIOException e) {
                    System.err.println("Error while parsing annotation file " + arg + " at line " + (e.lineNumber + 1) + ":");
                    if (e.getMessage() != null) {
                        System.err.println('\t' + e.getMessage());
                    }
                    if (e.getCause() != null && e.getCause().getMessage() != null) {
                        System.err.println('\t' + e.getCause().getMessage());
                    }
                    if (print_error_stack) {
                        e.printStackTrace();
                    }
                    System.exit(1);
                    continue;
                }
            }
            throw new Error("Unrecognized file extension: " + arg);
        }
        if (dbug.isEnabled()) {
            dbug.debug("%d insertions, %d .java files%n", insertions.size(), javafiles.size());
            dbug.debug("Insertions:%n", new Object[0]);
            for (Insertion insertion : insertions) {
                dbug.debug("  %s%n", insertion);
            }
        }
        for (String javafilename : javafiles) {
            Source src;
            verb.debug("Processing %s%n", javafilename);
            File javafile = new File(javafilename);
            File unannotated = new File(javafilename + ".unannotated");
            if (in_place && unannotated.exists()) {
                verb.debug("Renaming %s to %s%n", unannotated, javafile);
                boolean success = unannotated.renameTo(javafile);
                if (!success) {
                    throw new Error(String.format("Failed renaming %s to %s", unannotated, javafile));
                }
            }
            String fileSep = System.getProperty("file.separator");
            String fileLineSep = System.getProperty("line.separator");
            try {
                fileLineSep = UtilMDE.inferLineSeparator(javafilename);
                src = new Source(javafilename);
                verb.debug("Parsed %s%n", javafilename);
            }
            catch (Source.CompilerException e) {
                e.printStackTrace();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            LinkedHashSet<String> imports = new LinkedHashSet<String>();
            boolean bl = false;
            String pkg = "";
            for (CompilationUnitTree compilationUnitTree : src.parse()) {
                JCTree.JCCompilationUnit tree = (JCTree.JCCompilationUnit)compilationUnitTree;
                ExpressionTree pkgExp = compilationUnitTree.getPackageName();
                pkg = pkgExp == null ? "" : pkgExp.toString();
                TreeFinder finder = new TreeFinder(tree);
                SetMultimap<Pair<Integer, ASTPath>, Insertion> positions = finder.getPositions(tree, insertions);
                if (convert_jaifs) {
                    SetMultimap<ASTRecord, Insertion> astInsertions = finder.getPaths();
                    for (Map.Entry entry : astInsertions.asMap().entrySet()) {
                        ASTRecord rec = (ASTRecord)entry.getKey();
                        for (Insertion ins : entry.getValue()) {
                            if (ins.getCriteria().getASTPath() != null) continue;
                            String arg = (String)insertionOrigins.get(ins);
                            AScene scene = (AScene)scenes.get(arg);
                            Multimap insertionSources = (Multimap)insertionIndex.get(arg);
                            if (!insertionSources.containsKey(ins)) continue;
                            Main.convertInsertion(pkg, tree, rec, ins, scene, insertionSources);
                        }
                    }
                    continue;
                }
                if (both.isEnabled()) {
                    System.err.printf("getPositions returned %d positions in tree for %s%n", positions.size(), javafilename);
                }
                Set positionKeysUnsorted = positions.keySet();
                TreeSet<Pair<Integer, ASTPath>> positionKeysSorted = new TreeSet<Pair<Integer, ASTPath>>(new Comparator<Pair<Integer, ASTPath>>(){

                    @Override
                    public int compare(Pair<Integer, ASTPath> p1, Pair<Integer, ASTPath> p2) {
                        int c = Integer.compare((Integer)p2.a, (Integer)p1.a);
                        if (c == 0) {
                            c = p2.b == null ? (p1.b == null ? 0 : -1) : (p1.b == null ? 1 : ((ASTPath)p2.b).compareTo((ASTPath)p1.b));
                        }
                        return c;
                    }
                });
                positionKeysSorted.addAll(positionKeysUnsorted);
                for (Pair pair : positionKeysSorted) {
                    boolean receiverInserted = false;
                    boolean newInserted = false;
                    boolean constructorInserted = false;
                    TreeSet<String> seen = new TreeSet<String>();
                    ArrayList<Insertion> toInsertList = new ArrayList<Insertion>(positions.get(pair));
                    Collections.reverse(toInsertList);
                    dbug.debug("insertion pos: %d%n", pair.a);
                    assert ((Integer)pair.a >= 0) : "pos is negative: " + pair.a + " " + toInsertList.get(0) + " " + javafilename;
                    for (Insertion iToInsert : toInsertList) {
                        String precedingTextPlusChar;
                        String trailingWhitespace = "";
                        boolean gotSeparateLine = false;
                        int pos = (Integer)pair.a;
                        if (iToInsert.getSeparateLine()) {
                            int indentation = 0;
                            while (pos - indentation != 0 && (src.charAt(pos - indentation - 1) == ' ' || src.charAt(pos - indentation - 1) == '\t')) {
                                ++indentation;
                            }
                            if (pos - indentation == 0 || src.charAt(pos - indentation - 1) == '\f' || src.charAt(pos - indentation - 1) == '\n' || src.charAt(pos - indentation - 1) == '\r') {
                                trailingWhitespace = fileLineSep + src.substring(pos - indentation, pos);
                                gotSeparateLine = true;
                            }
                        }
                        int precedingChar = pos != 0 ? src.charAt(pos - 1) : 0;
                        if (iToInsert.getKind() == Insertion.Kind.ANNOTATION) {
                            AnnotationInsertion ai = (AnnotationInsertion)iToInsert;
                            if (ai.isGenerateBound()) {
                                try {
                                    String s22 = src.substring(pos, pos + 9);
                                    if ("Object & ".equals(s22)) {
                                        ai.setGenerateBound(false);
                                        precedingChar = 46;
                                    }
                                }
                                catch (StringIndexOutOfBoundsException s22) {
                                    // empty catch block
                                }
                            }
                            if (ai.isGenerateExtends()) {
                                try {
                                    String s3 = src.substring(pos, pos + 9);
                                    if (" extends ".equals(s3)) {
                                        ai.setGenerateExtends(false);
                                        pos += 8;
                                    }
                                }
                                catch (StringIndexOutOfBoundsException s3) {}
                            }
                        } else if (iToInsert.getKind() == Insertion.Kind.CAST) {
                            ((CastInsertion)iToInsert).setOnArrayLiteral(src.charAt(pos) == '{');
                        } else if (iToInsert.getKind() == Insertion.Kind.RECEIVER) {
                            ReceiverInsertion ri = (ReceiverInsertion)iToInsert;
                            ri.setAnnotationsOnly(receiverInserted);
                            receiverInserted = true;
                        } else if (iToInsert.getKind() == Insertion.Kind.NEW) {
                            NewInsertion ni = (NewInsertion)iToInsert;
                            ni.setAnnotationsOnly(newInserted);
                            newInserted = true;
                        } else if (iToInsert.getKind() == Insertion.Kind.CONSTRUCTOR) {
                            ConstructorInsertion ci = (ConstructorInsertion)iToInsert;
                            if (constructorInserted) {
                                ci.setAnnotationsOnly(true);
                            }
                            constructorInserted = true;
                        }
                        String toInsert = iToInsert.getText(comments, abbreviate, gotSeparateLine, pos, (char)precedingChar) + trailingWhitespace;
                        if (seen.contains(toInsert)) continue;
                        seen.add(toInsert);
                        int precedingTextPos = pos - toInsert.length() - 1;
                        if (precedingTextPos >= 0 && (toInsert.equals((precedingTextPlusChar = src.getString().substring(precedingTextPos, pos)).substring(0, toInsert.length())) || toInsert.equals(precedingTextPlusChar.substring(1)))) {
                            dbug.debug("Inserting %s at %d in code of length %d with preceding text '%s'%n", toInsert, pos, src.getString().length(), precedingTextPlusChar);
                            dbug.debug("Already present, skipping%n", new Object[0]);
                            continue;
                        }
                        if (iToInsert.getInserted()) continue;
                        src.insert(pos, toInsert);
                        if (verbose && !debug) {
                            void var19_32;
                            System.out.print(".");
                            if (++var19_32 % 50 == false) {
                                System.out.println();
                            }
                        }
                        dbug.debug("Post-insertion source: %n" + src.getString(), new Object[0]);
                        Set<String> packageNames = iToInsert.getPackageNames();
                        if (packageNames.isEmpty()) continue;
                        dbug.debug("Need import %s%n  due to insertion %s%n", packageNames, toInsert);
                        imports.addAll(packageNames);
                    }
                }
            }
            if (convert_jaifs) {
                for (Map.Entry entry : scenes.entrySet()) {
                    String filename = (String)entry.getKey();
                    AScene scene = (AScene)entry.getValue();
                    try {
                        IndexFileWriter.write(scene, filename + ".converted");
                    }
                    catch (DefException e) {
                        System.err.println(filename + ":  format error in conversion");
                        if (!print_error_stack) continue;
                        e.printStackTrace();
                    }
                }
                return;
            }
            if (dbug.isEnabled()) {
                dbug.debug("%d imports to insert%n", imports.size());
                for (String string : imports) {
                    dbug.debug("  %s%n", string);
                }
            }
            Pattern importPattern = Pattern.compile("(?m)^import\\b");
            Pattern pattern = Pattern.compile("(?m)^package\\b.*;(\\n|\\r\\n?)");
            int importIndex = 0;
            String srcString = src.getString();
            Matcher m3 = importPattern.matcher(srcString);
            TreeSet<String> inSource = new TreeSet<String>();
            if (m3.find()) {
                importIndex = m3.start();
                do {
                    int i = m3.start();
                    int j = srcString.indexOf(System.lineSeparator(), i) + 1;
                    if (j <= 0) {
                        j = srcString.length();
                    }
                    String string = srcString.substring(i, j);
                    inSource.add(string);
                } while (m3.find());
            } else {
                m3 = pattern.matcher(srcString);
                if (m3.find()) {
                    importIndex = m3.end();
                }
            }
            for (String classname : imports) {
                String string = "import " + classname + ";" + fileLineSep;
                if (inSource.contains(string)) continue;
                inSource.add(string);
                src.insert(importIndex, string);
                importIndex += string.length();
            }
            File outfile = null;
            try {
                if (in_place) {
                    boolean bl2;
                    outfile = javafile;
                    if (verbose) {
                        System.out.printf("Renaming %s to %s%n", javafile, unannotated);
                    }
                    if (!(bl2 = javafile.renameTo(unannotated))) {
                        throw new Error(String.format("Failed renaming %s to %s", javafile, unannotated));
                    }
                } else {
                    if (pkg.isEmpty()) {
                        outfile = new File(outdir, javafile.getName());
                    } else {
                        String[] stringArray = pkg.split("\\.");
                        StringBuilder sb = new StringBuilder(outdir);
                        for (int i = 0; i < stringArray.length; ++i) {
                            sb.append(fileSep).append(stringArray[i]);
                        }
                        outfile = new File(sb.toString(), javafile.getName());
                    }
                    outfile.getParentFile().mkdirs();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(outfile);
                if (verbose) {
                    System.out.printf("Writing %s%n", outfile);
                }
                src.write(fileOutputStream);
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                System.err.println("Problem while writing file " + outfile);
                iOException.printStackTrace();
                System.exit(1);
            }
        }
    }

    public static String pathToString(TreePath path) {
        if (path == null) {
            return "null";
        }
        return Main.treeToString(path.getLeaf());
    }

    public static String treeToString(Tree node) {
        String asString = node.toString();
        String oneLine = Main.firstLine(asString);
        return "\"" + oneLine + "\"";
    }

    public static String firstLine(String s2) {
        while (s2.startsWith("\n")) {
            s2 = s2.substring(1);
        }
        int newlineIndex = s2.indexOf(10);
        if (newlineIndex == -1) {
            return s2;
        }
        return s2.substring(0, newlineIndex) + "...";
    }

    public static Pair<String, String> removeArgs(String s2) {
        int pidx = s2.indexOf("(");
        return pidx == -1 ? Pair.of(s2, null) : Pair.of(s2.substring(0, pidx), s2.substring(pidx));
    }

    static {
        convert_jaifs = false;
        help = false;
        debug = false;
        print_error_stack = false;
        classFilter = new ElementVisitor<Void, AElement>(){

            <K, V extends AElement> Void filter(VivifyingMap<K, V> vm0, VivifyingMap<K, V> vm1) {
                for (Map.Entry entry : vm0.entrySet()) {
                    ((AElement)entry.getValue()).accept(this, vm1.vivify(entry.getKey()));
                }
                return null;
            }

            @Override
            public Void visitAnnotationDef(AnnotationDef def, AElement el) {
                return null;
            }

            @Override
            public Void visitBlock(ABlock el0, AElement el) {
                ABlock el1 = (ABlock)el;
                this.filter(el0.locals, el1.locals);
                return this.visitExpression((AExpression)el0, el);
            }

            @Override
            public Void visitClass(AClass el0, AElement el) {
                AClass el1 = (AClass)el;
                this.filter(el0.methods, el1.methods);
                this.filter(el0.fields, el1.fields);
                this.filter(el0.fieldInits, el1.fieldInits);
                this.filter(el0.staticInits, el1.staticInits);
                this.filter(el0.instanceInits, el1.instanceInits);
                return this.visitDeclaration((ADeclaration)el0, el);
            }

            @Override
            public Void visitDeclaration(ADeclaration el0, AElement el) {
                ATypeElement e;
                ASTPath p;
                ADeclaration el1 = (ADeclaration)el;
                VivifyingMap<ASTPath, ATypeElement> insertAnnotations = el1.insertAnnotations;
                VivifyingMap<ASTPath, ATypeElementWithType> insertTypecasts = el1.insertTypecasts;
                for (Map.Entry entry : el0.insertAnnotations.entrySet()) {
                    p = (ASTPath)entry.getKey();
                    e = (ATypeElement)entry.getValue();
                    insertAnnotations.put(p, e);
                }
                for (Map.Entry entry : el0.insertTypecasts.entrySet()) {
                    p = (ASTPath)entry.getKey();
                    e = (ATypeElementWithType)entry.getValue();
                    Type type = ((ATypeElementWithType)e).getType();
                    if (type instanceof DeclaredType && ((DeclaredType)type).getName().isEmpty()) {
                        insertAnnotations.put(p, e);
                        continue;
                    }
                    insertTypecasts.put(p, (ATypeElementWithType)e);
                }
                return null;
            }

            @Override
            public Void visitExpression(AExpression el0, AElement el) {
                AExpression el1 = (AExpression)el;
                this.filter(el0.typecasts, el1.typecasts);
                this.filter(el0.instanceofs, el1.instanceofs);
                this.filter(el0.news, el1.news);
                return null;
            }

            @Override
            public Void visitField(AField el0, AElement el) {
                return this.visitDeclaration((ADeclaration)el0, el);
            }

            @Override
            public Void visitMethod(AMethod el0, AElement el) {
                AMethod el1 = (AMethod)el;
                this.filter(el0.bounds, el1.bounds);
                this.filter(el0.parameters, el1.parameters);
                this.filter(el0.throwsException, el1.throwsException);
                el0.returnType.accept(this, el1.returnType);
                el0.receiver.accept(this, el1.receiver);
                el0.body.accept(this, el1.body);
                return this.visitDeclaration((ADeclaration)el0, el);
            }

            @Override
            public Void visitTypeElement(ATypeElement el0, AElement el) {
                ATypeElement el1 = (ATypeElement)el;
                this.filter(el0.innerTypes, el1.innerTypes);
                return null;
            }

            @Override
            public Void visitTypeElementWithType(ATypeElementWithType el0, AElement el) {
                ATypeElementWithType el1 = (ATypeElementWithType)el;
                el1.setType(el0.getType());
                return this.visitTypeElement((ATypeElement)el0, el);
            }

            @Override
            public Void visitElement(AElement el, AElement arg) {
                return null;
            }
        };
    }
}

