/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.wholeprograminference;

import annotations.el.AClass;
import annotations.el.AField;
import annotations.el.AMethod;
import annotations.el.AScene;
import annotations.el.ATypeElement;
import annotations.el.DefException;
import annotations.el.InnerTypeLocation;
import annotations.io.IndexFileParser;
import annotations.io.IndexFileWriter;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.common.wholeprograminference.AnnotationConverter;
import org.checkerframework.framework.qual.DefaultFor;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import org.checkerframework.framework.qual.ImplicitFor;
import org.checkerframework.framework.qual.InvisibleQualifier;
import org.checkerframework.framework.qual.TypeUseLocation;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.Pair;

public class WholeProgramInferenceScenesHelper {
    private final Map<Pair<String, TypeUseLocation>, Set<String>> annosToIgnore = new HashMap<Pair<String, TypeUseLocation>, Set<String>>();
    public static final String jaifFilesPath = "build" + File.separator + "whole-program-inference" + File.separator;
    private final boolean ignoreNullAssignments;
    private final Map<String, AScene> scenes = new HashMap<String, AScene>();
    private final Set<String> modifiedScenes = new HashSet<String>();

    public WholeProgramInferenceScenesHelper(boolean ignoreNullAssignments) {
        this.ignoreNullAssignments = ignoreNullAssignments;
    }

    public void writeScenesToJaif() {
        File jaifDir = new File(jaifFilesPath);
        if (!jaifDir.exists()) {
            jaifDir.mkdirs();
        }
        for (String jaifPath : this.modifiedScenes) {
            try {
                AScene scene = this.scenes.get(jaifPath).clone();
                this.removeIgnoredAnnosFromScene(scene);
                new File(jaifPath).delete();
                if (scene.prune()) continue;
                IndexFileWriter.write(scene, new FileWriter(jaifPath));
            }
            catch (IOException e) {
                ErrorReporter.errorAbort("Problem while reading file in: " + jaifPath + ". Exception message: " + e.getMessage(), e);
            }
            catch (DefException e) {
                ErrorReporter.errorAbort(e.getMessage(), e);
            }
        }
        this.modifiedScenes.clear();
    }

    protected String getJaifPath(String className) {
        String jaifPath = jaifFilesPath + className + ".jaif";
        return jaifPath;
    }

    protected AScene getScene(String jaifPath) {
        AScene scene;
        if (!this.scenes.containsKey(jaifPath)) {
            File jaifFile = new File(jaifPath);
            scene = new AScene();
            if (jaifFile.exists()) {
                try {
                    IndexFileParser.parseFile(jaifPath, scene);
                }
                catch (IOException e) {
                    ErrorReporter.errorAbort("Problem while reading file in: " + jaifPath + ". Exception message: " + e.getMessage(), e);
                }
            }
            this.scenes.put(jaifPath, scene);
        } else {
            scene = this.scenes.get(jaifPath);
        }
        return scene;
    }

    protected AClass getAClass(String className, String jaifPath) {
        AScene scene = this.getScene(jaifPath);
        return scene.classes.vivify(className);
    }

    protected void updateAnnotationSetInScene(ATypeElement type, AnnotatedTypeFactory atf, String jaifPath, AnnotatedTypeMirror rhsATM, AnnotatedTypeMirror lhsATM, TypeUseLocation defLoc) {
        Set<AnnotationMirror> upperAnnos;
        if (rhsATM instanceof AnnotatedTypeMirror.AnnotatedNullType && this.ignoreNullAssignments) {
            return;
        }
        AnnotatedTypeMirror atmFromJaif = AnnotatedTypeMirror.createType(rhsATM.getUnderlyingType(), atf, false);
        this.typeElementToATM(atmFromJaif, type, atf);
        this.updatesATMWithLUB(atf, rhsATM, atmFromJaif);
        if (lhsATM instanceof AnnotatedTypeMirror.AnnotatedTypeVariable && (upperAnnos = ((AnnotatedTypeMirror.AnnotatedTypeVariable)lhsATM).getUpperBound().getEffectiveAnnotations()).size() == rhsATM.getAnnotations().size() && atf.getQualifierHierarchy().isSubtype(rhsATM.getAnnotations(), upperAnnos)) {
            return;
        }
        this.updateTypeElementFromATM(rhsATM, lhsATM, atf, type, 1, defLoc);
        this.modifiedScenes.add(jaifPath);
    }

    private void removeIgnoredAnnosFromScene(AScene scene) {
        for (AClass aclass : scene.classes.values()) {
            for (AField field : aclass.fields.values()) {
                this.removeIgnoredAnnosFromATypeElement(field.type, TypeUseLocation.FIELD);
            }
            for (AMethod method : aclass.methods.values()) {
                this.removeIgnoredAnnosFromATypeElement(method.returnType, TypeUseLocation.RETURN);
                this.removeIgnoredAnnosFromATypeElement(method.receiver.type, TypeUseLocation.RECEIVER);
                for (AField param : method.parameters.values()) {
                    this.removeIgnoredAnnosFromATypeElement(param.type, TypeUseLocation.PARAMETER);
                }
            }
        }
    }

    private void removeIgnoredAnnosFromATypeElement(ATypeElement typeEl, TypeUseLocation loc) {
        HashSet<annotations.Annotation> annosToRemove = new HashSet<annotations.Annotation>();
        String firstKey = typeEl.description.toString() + typeEl.tlAnnotationsHere.toString();
        Set<String> annosToIgnoreForLocation = this.annosToIgnore.get(Pair.of(firstKey, loc));
        if (annosToIgnoreForLocation == null) {
            return;
        }
        for (annotations.Annotation anno : typeEl.tlAnnotationsHere) {
            if (!annosToIgnoreForLocation.contains(anno.def().toString())) continue;
            annosToRemove.add(anno);
        }
        typeEl.tlAnnotationsHere.removeAll(annosToRemove);
        for (ATypeElement innerType : typeEl.innerTypes.values()) {
            this.removeIgnoredAnnosFromATypeElement(innerType, loc);
        }
    }

    private void updatesATMWithLUB(AnnotatedTypeFactory atf, AnnotatedTypeMirror sourceCodeATM, AnnotatedTypeMirror jaifATM) {
        switch (sourceCodeATM.getKind()) {
            case TYPEVAR: {
                this.updatesATMWithLUB(atf, ((AnnotatedTypeMirror.AnnotatedTypeVariable)sourceCodeATM).getLowerBound(), ((AnnotatedTypeMirror.AnnotatedTypeVariable)jaifATM).getLowerBound());
                this.updatesATMWithLUB(atf, ((AnnotatedTypeMirror.AnnotatedTypeVariable)sourceCodeATM).getUpperBound(), ((AnnotatedTypeMirror.AnnotatedTypeVariable)jaifATM).getUpperBound());
                break;
            }
            case ARRAY: {
                this.updatesATMWithLUB(atf, ((AnnotatedTypeMirror.AnnotatedArrayType)sourceCodeATM).getComponentType(), ((AnnotatedTypeMirror.AnnotatedArrayType)jaifATM).getComponentType());
                break;
            }
        }
        HashSet<AnnotationMirror> annosToReplace = new HashSet<AnnotationMirror>();
        for (AnnotationMirror amSource : sourceCodeATM.getAnnotations()) {
            AnnotationMirror amJaif = jaifATM.getAnnotationInHierarchy(amSource);
            if (amJaif != null) {
                amSource = atf.getQualifierHierarchy().leastUpperBound(amSource, amJaif);
            }
            annosToReplace.add(amSource);
        }
        sourceCodeATM.replaceAnnotations(annosToReplace);
    }

    private boolean shouldIgnore(AnnotationMirror am, TypeUseLocation location, AnnotatedTypeFactory atf, AnnotatedTypeMirror atm) {
        ImplicitFor implicitFor;
        DefaultFor defaultQualForLocation;
        Element elt = am.getAnnotationType().asElement();
        Target target = elt.getAnnotation(Target.class);
        if (target != null && target.value().length == 0) {
            return true;
        }
        if (elt.getAnnotation(InvisibleQualifier.class) != null) {
            return true;
        }
        if (elt.getAnnotation(DefaultQualifierInHierarchy.class) != null) {
            return true;
        }
        DefaultQualifier defaultQual = elt.getAnnotation(DefaultQualifier.class);
        if (defaultQual != null) {
            for (TypeUseLocation loc : defaultQual.locations()) {
                if (loc != TypeUseLocation.ALL && loc != location) continue;
                return true;
            }
        }
        if ((defaultQualForLocation = elt.getAnnotation(DefaultFor.class)) != null) {
            for (TypeUseLocation typeUseLocation : defaultQualForLocation.value()) {
                if (typeUseLocation != TypeUseLocation.ALL && typeUseLocation != location) continue;
                return true;
            }
        }
        if ((implicitFor = elt.getAnnotation(ImplicitFor.class)) != null) {
            TypeKind[] types = implicitFor.types();
            TypeKind atmKind = atm.getUnderlyingType().getKind();
            for (TypeKind tk : types) {
                if (tk != atmKind) continue;
                return true;
            }
            try {
                Class<?>[] classArray;
                for (Class<?> c : classArray = implicitFor.typeNames()) {
                    TypeMirror underlyingtype = atm.getUnderlyingType();
                    while (underlyingtype instanceof ArrayType) {
                        underlyingtype = ((ArrayType)underlyingtype).getComponentType();
                    }
                    if (!c.getCanonicalName().equals(atm.getUnderlyingType().toString())) continue;
                    return true;
                }
            }
            catch (MirroredTypesException mirroredTypesException) {
                // empty catch block
            }
        }
        return false;
    }

    private Set<annotations.Annotation> getSupportedAnnosInSet(Set<annotations.Annotation> annosSet, AnnotatedTypeFactory atf) {
        HashSet<annotations.Annotation> output = new HashSet<annotations.Annotation>();
        Set<Class<? extends Annotation>> supportedAnnos = atf.getSupportedTypeQualifiers();
        for (annotations.Annotation anno : annosSet) {
            for (Class<? extends Annotation> clazz : supportedAnnos) {
                if (!clazz.getName().equals(anno.def.name)) continue;
                output.add(anno);
            }
        }
        return output;
    }

    private void typeElementToATM(AnnotatedTypeMirror atm, ATypeElement type, AnnotatedTypeFactory atf) {
        Set<annotations.Annotation> annos = this.getSupportedAnnosInSet(type.tlAnnotationsHere, atf);
        for (annotations.Annotation anno : annos) {
            AnnotationMirror am = AnnotationConverter.annotationToAnnotationMirror(anno, atf.getProcessingEnv());
            atm.addAnnotation(am);
        }
        if (atm.getKind() == TypeKind.ARRAY) {
            AnnotatedTypeMirror.AnnotatedArrayType aat = (AnnotatedTypeMirror.AnnotatedArrayType)atm;
            for (ATypeElement innerType : type.innerTypes.values()) {
                this.typeElementToATM(aat.getComponentType(), innerType, atf);
            }
        }
        if (atm.getKind() == TypeKind.TYPEVAR) {
            AnnotatedTypeMirror.AnnotatedTypeVariable atv = (AnnotatedTypeMirror.AnnotatedTypeVariable)atm;
            for (ATypeElement innerType : type.innerTypes.values()) {
                this.typeElementToATM(atv.getUpperBound(), innerType, atf);
            }
        }
    }

    private void updateTypeElementFromATM(AnnotatedTypeMirror newATM, AnnotatedTypeMirror curATM, AnnotatedTypeFactory atf, ATypeElement typeToUpdate, int idx, TypeUseLocation defLoc) {
        if (idx == 1) {
            Iterator<AnnotationMirror> annosToRemove = this.getSupportedAnnosInSet(typeToUpdate.tlAnnotationsHere, atf);
            typeToUpdate.tlAnnotationsHere.removeAll((Collection<?>)((Object)annosToRemove));
        }
        if (curATM.getExplicitAnnotations().size() == 0) {
            for (AnnotationMirror am : newATM.getAnnotations()) {
                this.addAnnotationsToATypeElement(newATM, atf, typeToUpdate, defLoc, am, curATM.hasEffectiveAnnotation(am));
            }
        } else if (curATM.getKind() == TypeKind.TYPEVAR) {
            for (AnnotationMirror am : newATM.getAnnotations()) {
                if (curATM.getAnnotationInHierarchy(am) != null) break;
                this.addAnnotationsToATypeElement(newATM, atf, typeToUpdate, defLoc, am, curATM.hasEffectiveAnnotation(am));
            }
        }
        if (newATM.getKind() == TypeKind.ARRAY && curATM.getKind() == TypeKind.ARRAY) {
            AnnotatedTypeMirror.AnnotatedArrayType newAAT = (AnnotatedTypeMirror.AnnotatedArrayType)newATM;
            AnnotatedTypeMirror.AnnotatedArrayType oldAAT = (AnnotatedTypeMirror.AnnotatedArrayType)curATM;
            this.updateTypeElementFromATM(newAAT.getComponentType(), oldAAT.getComponentType(), atf, typeToUpdate.innerTypes.vivify(new InnerTypeLocation(TypeAnnotationPosition.getTypePathFromBinary(Collections.nCopies(2 * idx, 0)))), idx + 1, defLoc);
        }
    }

    private void addAnnotationsToATypeElement(AnnotatedTypeMirror newATM, AnnotatedTypeFactory atf, ATypeElement typeToUpdate, TypeUseLocation defLoc, AnnotationMirror am, boolean isEffectiveAnnotation) {
        annotations.Annotation anno = AnnotationConverter.annotationMirrorToAnnotation(am);
        if (anno != null) {
            typeToUpdate.tlAnnotationsHere.add(anno);
            if (isEffectiveAnnotation || this.shouldIgnore(am, defLoc, atf, newATM)) {
                String firstKey = typeToUpdate.description.toString() + typeToUpdate.tlAnnotationsHere.toString();
                Pair<String, TypeUseLocation> key = Pair.of(firstKey, defLoc);
                Set<String> annosIgnored = this.annosToIgnore.get(key);
                if (annosIgnored == null) {
                    annosIgnored = new HashSet<String>();
                    this.annosToIgnore.put(key, annosIgnored);
                }
                annosIgnored.add(anno.def().toString());
            }
        }
    }
}

