/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.GeneratedJavaParserConstants;
import com.github.javaparser.Range;
import com.github.javaparser.Token;
import com.github.javaparser.TokenRange;
import com.github.javaparser.TokenTypes;
import com.github.javaparser.utils.CodeGenerationUtils;
import com.github.javaparser.utils.Utils;
import java.util.List;
import java.util.Optional;

public class JavaToken {
    public static final JavaToken INVALID = new JavaToken();
    private Range range;
    private int kind;
    private String text;
    private JavaToken previousToken = null;
    private JavaToken nextToken = null;

    private JavaToken() {
        this(null, 0, "INVALID", null, null);
    }

    public JavaToken(int kind, String text) {
        this(null, kind, text, null, null);
    }

    JavaToken(Token token, List<JavaToken> tokens) {
        Range range = Range.range(token.beginLine, token.beginColumn, token.endLine, token.endColumn);
        String text = token.image;
        if (token.kind == 140) {
            range = Range.range(token.beginLine, token.beginColumn, token.endLine, token.beginColumn);
            text = ">";
        } else if (token.kind == 139) {
            range = Range.range(token.beginLine, token.beginColumn, token.endLine, token.beginColumn + 1);
            text = ">>";
        }
        this.range = range;
        this.kind = token.kind;
        this.text = text;
        if (!tokens.isEmpty()) {
            JavaToken previousToken;
            this.previousToken = previousToken = tokens.get(tokens.size() - 1);
            previousToken.nextToken = this;
        } else {
            this.previousToken = null;
        }
    }

    public JavaToken(int kind) {
        String content = GeneratedJavaParserConstants.tokenImage[kind];
        if (content.startsWith("\"")) {
            content = content.substring(1, content.length() - 1);
        }
        if (TokenTypes.isEndOfLineToken(kind)) {
            content = Utils.EOL;
        } else if (TokenTypes.isWhitespace(kind)) {
            content = " ";
        }
        this.kind = kind;
        this.text = content;
    }

    public JavaToken(Range range, int kind, String text, JavaToken previousToken, JavaToken nextToken) {
        Utils.assertNotNull(text);
        this.range = range;
        this.kind = kind;
        this.text = text;
        this.previousToken = previousToken;
        this.nextToken = nextToken;
    }

    public Optional<Range> getRange() {
        return Optional.ofNullable(this.range);
    }

    public int getKind() {
        return this.kind;
    }

    void setKind(int kind) {
        this.kind = kind;
    }

    public String getText() {
        return this.text;
    }

    public Optional<JavaToken> getNextToken() {
        return Optional.ofNullable(this.nextToken);
    }

    public Optional<JavaToken> getPreviousToken() {
        return Optional.ofNullable(this.previousToken);
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String asString() {
        return this.text;
    }

    public TokenRange toTokenRange() {
        return new TokenRange(this.findFirstToken(), this.findLastToken());
    }

    public String toString() {
        String text = this.getText().replace("\n", "\\n").replace("\r", "\\r").replace("\r\n", "\\r\\n").replace("\t", "\\t");
        return CodeGenerationUtils.f("\"%s\"   <%s>   %s", text, this.getKind(), this.getRange().map(Range::toString).orElse("(?)-(?)"));
    }

    public boolean valid() {
        return !this.invalid();
    }

    public boolean invalid() {
        return this == INVALID;
    }

    public Category getCategory() {
        return TokenTypes.getCategory(this.kind);
    }

    public void insert(JavaToken newToken) {
        Utils.assertNotNull(newToken);
        this.getPreviousToken().ifPresent(p -> {
            p.nextToken = newToken;
            javaToken.previousToken = p;
        });
        this.previousToken = newToken;
        newToken.nextToken = this;
    }

    public void insertAfter(JavaToken newToken) {
        Utils.assertNotNull(newToken);
        this.getNextToken().ifPresent(n -> {
            n.previousToken = newToken;
            javaToken.nextToken = n;
        });
        this.nextToken = newToken;
        newToken.previousToken = this;
    }

    public void deleteToken() {
        Optional<JavaToken> nextToken = this.getNextToken();
        Optional<JavaToken> previousToken = this.getPreviousToken();
        previousToken.ifPresent(p -> {
            p.nextToken = nextToken.orElse(null);
        });
        nextToken.ifPresent(n -> {
            n.previousToken = previousToken.orElse(null);
        });
    }

    public void replaceToken(JavaToken newToken) {
        Utils.assertNotNull(newToken);
        this.getPreviousToken().ifPresent(p -> {
            p.nextToken = newToken;
            javaToken.previousToken = p;
        });
        this.getNextToken().ifPresent(n -> {
            n.previousToken = newToken;
            javaToken.nextToken = n;
        });
    }

    public JavaToken findLastToken() {
        JavaToken current = this;
        while (current.getNextToken().isPresent()) {
            current = current.getNextToken().get();
        }
        return current;
    }

    public JavaToken findFirstToken() {
        JavaToken current = this;
        while (current.getPreviousToken().isPresent()) {
            current = current.getPreviousToken().get();
        }
        return current;
    }

    public int hashCode() {
        int result = this.kind;
        result = 31 * result + this.text.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaToken javaToken = (JavaToken)o;
        if (this.kind != javaToken.kind) {
            return false;
        }
        return this.text.equals(javaToken.text);
    }

    public static enum Category {
        WHITESPACE_NO_EOL,
        EOL,
        COMMENT,
        IDENTIFIER,
        KEYWORD,
        LITERAL,
        SEPARATOR,
        OPERATOR;


        public boolean isWhitespaceOrComment() {
            return this.isWhitespace() || this == COMMENT;
        }

        public boolean isWhitespace() {
            return this == WHITESPACE_NO_EOL || this == EOL;
        }

        public boolean isEndOfLine() {
            return this == EOL;
        }

        public boolean isComment() {
            return this == COMMENT;
        }

        public boolean isWhitespaceButNotEndOfLine() {
            return this == WHITESPACE_NO_EOL;
        }

        public boolean isIdentifier() {
            return this == IDENTIFIER;
        }

        public boolean isKeyword() {
            return this == KEYWORD;
        }

        public boolean isLiteral() {
            return this == LITERAL;
        }

        public boolean isSeparator() {
            return this == SEPARATOR;
        }

        public boolean isOperator() {
            return this == OPERATOR;
        }
    }
}

