/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.LinkedList;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.util.HashCodeUtils;
import org.checkerframework.javacutil.TreeUtils;

public class ArrayAccessNode
extends Node {
    protected final Tree tree;
    protected final Node array;
    protected final Node index;

    public ArrayAccessNode(Tree t, Node array, Node index) {
        super(TreeUtils.typeOf(t));
        assert (t instanceof ArrayAccessTree);
        this.tree = t;
        this.array = array;
        this.index = index;
    }

    public Node getArray() {
        return this.array;
    }

    public Node getIndex() {
        return this.index;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitArrayAccess(this, p);
    }

    public String toString() {
        String base = this.getArray().toString() + "[" + this.getIndex().toString() + "]";
        return base;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ArrayAccessNode)) {
            return false;
        }
        ArrayAccessNode other = (ArrayAccessNode)obj;
        return this.getArray().equals(other.getArray()) && this.getIndex().equals(other.getIndex());
    }

    public int hashCode() {
        return HashCodeUtils.hash(this.getArray(), this.getIndex());
    }

    @Override
    public Collection<Node> getOperands() {
        LinkedList<Node> list = new LinkedList<Node>();
        list.add(this.getArray());
        list.add(this.getIndex());
        return list;
    }
}

