/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.LinkedList;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.util.HashCodeUtils;

public class AssertionErrorNode
extends Node {
    protected final Tree tree;
    protected final Node condition;
    protected final Node detail;

    public AssertionErrorNode(Tree tree, Node condition, Node detail, TypeMirror type) {
        super(type);
        assert (tree.getKind() == Tree.Kind.ASSERT);
        this.tree = tree;
        this.condition = condition;
        this.detail = detail;
    }

    public Node getCondition() {
        return this.condition;
    }

    public Node getDetail() {
        return this.detail;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitAssertionError(this, p);
    }

    public String toString() {
        return "AssertionError(" + this.getDetail() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AssertionErrorNode)) {
            return false;
        }
        AssertionErrorNode other = (AssertionErrorNode)obj;
        return this.getCondition().equals(other.getCondition()) && this.getDetail().equals(other.getDetail());
    }

    public int hashCode() {
        return HashCodeUtils.hash(this.getCondition(), this.getDetail());
    }

    @Override
    public Collection<Node> getOperands() {
        LinkedList<Node> list = new LinkedList<Node>();
        list.add(this.getCondition());
        list.add(this.getDetail());
        return list;
    }
}

