/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.util.HashCodeUtils;

public class MarkerNode
extends Node {
    protected final @Nullable Tree tree;
    protected final String message;

    public MarkerNode(@Nullable Tree tree, String message, Types types) {
        super(types.getNoType(TypeKind.NONE));
        this.tree = tree;
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitMarker(this, p);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("marker ");
        sb.append("(" + this.message + ")");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MarkerNode)) {
            return false;
        }
        MarkerNode other = (MarkerNode)obj;
        if (this.tree == null && other.getTree() != null) {
            return false;
        }
        return this.getTree().equals(other.getTree()) && this.getMessage().equals(other.getMessage());
    }

    public int hashCode() {
        int hash = 0;
        if (this.tree != null) {
            hash = HashCodeUtils.hash((Object)this.tree);
        }
        return HashCodeUtils.hash(hash, (Object)this.getMessage());
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.emptyList();
    }
}

