/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.NewClassTree;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.util.HashCodeUtils;
import org.checkerframework.javacutil.TreeUtils;

public class ObjectCreationNode
extends Node {
    protected final NewClassTree tree;
    protected final Node constructor;
    protected final List<Node> arguments;

    public ObjectCreationNode(NewClassTree tree, Node constructor, List<Node> arguments) {
        super(TreeUtils.typeOf(tree));
        this.tree = tree;
        this.constructor = constructor;
        this.arguments = arguments;
    }

    public Node getConstructor() {
        return this.constructor;
    }

    public List<Node> getArguments() {
        return this.arguments;
    }

    public Node getArgument(int i) {
        return this.arguments.get(i);
    }

    @Override
    public NewClassTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitObjectCreation(this, p);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("new " + this.constructor + "(");
        boolean needComma = false;
        for (Node arg : this.arguments) {
            if (needComma) {
                sb.append(", ");
            }
            sb.append(arg);
            needComma = true;
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ObjectCreationNode)) {
            return false;
        }
        ObjectCreationNode other = (ObjectCreationNode)obj;
        if (this.constructor == null && other.getConstructor() != null) {
            return false;
        }
        return this.getConstructor().equals(other.getConstructor()) && this.getArguments().equals(other.getArguments());
    }

    public int hashCode() {
        int hash = HashCodeUtils.hash((Object)this.constructor);
        for (Node arg : this.arguments) {
            hash = HashCodeUtils.hash(hash, arg.hashCode());
        }
        return hash;
    }

    @Override
    public Collection<Node> getOperands() {
        LinkedList<Node> list = new LinkedList<Node>();
        list.add(this.constructor);
        list.addAll(this.arguments);
        return list;
    }
}

