/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.javacutil;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TypeAnnotationUtils;

public final class TypesUtils {
    private TypesUtils() {
        throw new AssertionError((Object)"Class TypesUtils cannot be instantiated.");
    }

    public static Name getQualifiedName(DeclaredType type) {
        TypeElement element = (TypeElement)type.asElement();
        return element.getQualifiedName();
    }

    public static boolean isObject(TypeMirror type) {
        return TypesUtils.isDeclaredOfName(type, "java.lang.Object");
    }

    public static boolean isClass(TypeMirror type) {
        return TypesUtils.isDeclaredOfName(type, "java.lang.Class");
    }

    public static boolean isString(TypeMirror type) {
        return TypesUtils.isDeclaredOfName(type, "java.lang.String");
    }

    public static boolean isBooleanType(TypeMirror type) {
        return TypesUtils.isDeclaredOfName(type, "java.lang.Boolean") || type.getKind().equals((Object)TypeKind.BOOLEAN);
    }

    public static boolean isDeclaredOfName(TypeMirror type, CharSequence qualifiedName) {
        return type.getKind() == TypeKind.DECLARED && TypesUtils.getQualifiedName((DeclaredType)type).contentEquals(qualifiedName);
    }

    public static boolean isBoxedPrimitive(TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return false;
        }
        String qualifiedName = TypesUtils.getQualifiedName((DeclaredType)type).toString();
        return qualifiedName.equals("java.lang.Boolean") || qualifiedName.equals("java.lang.Byte") || qualifiedName.equals("java.lang.Character") || qualifiedName.equals("java.lang.Short") || qualifiedName.equals("java.lang.Integer") || qualifiedName.equals("java.lang.Long") || qualifiedName.equals("java.lang.Double") || qualifiedName.equals("java.lang.Float");
    }

    public static boolean isThrowable(TypeMirror type) {
        while (type != null && type.getKind() == TypeKind.DECLARED) {
            DeclaredType dt = (DeclaredType)type;
            TypeElement elem = (TypeElement)dt.asElement();
            Name name = elem.getQualifiedName();
            if ("java.lang.Throwable".contentEquals(name)) {
                return true;
            }
            type = elem.getSuperclass();
        }
        return false;
    }

    public static boolean isAnonymous(TypeMirror type) {
        return type instanceof DeclaredType && ((TypeElement)((DeclaredType)type).asElement()).getNestingKind().equals((Object)NestingKind.ANONYMOUS);
    }

    public static boolean isPrimitive(TypeMirror type) {
        switch (type.getKind()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                return true;
            }
        }
        return false;
    }

    public static boolean areSameDeclaredTypes(Type.ClassType t1, Type.ClassType t2) {
        if (t1.tsym.name != t2.tsym.name) {
            return false;
        }
        return t1.toString().equals(t1.toString());
    }

    public static boolean areSamePrimitiveTypes(TypeMirror left, TypeMirror right) {
        if (!TypesUtils.isPrimitive(left) || !TypesUtils.isPrimitive(right)) {
            return false;
        }
        return left.getKind() == right.getKind();
    }

    public static boolean isNumeric(TypeMirror type) {
        switch (type.getKind()) {
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIntegral(TypeMirror type) {
        switch (type.getKind()) {
            case BYTE: 
            case CHAR: 
            case INT: 
            case LONG: 
            case SHORT: {
                return true;
            }
        }
        return false;
    }

    public static boolean isFloating(TypeMirror type) {
        switch (type.getKind()) {
            case DOUBLE: 
            case FLOAT: {
                return true;
            }
        }
        return false;
    }

    public static TypeKind widenedNumericType(TypeMirror left, TypeMirror right) {
        if (!TypesUtils.isNumeric(left) || !TypesUtils.isNumeric(right)) {
            return TypeKind.NONE;
        }
        TypeKind leftKind = left.getKind();
        TypeKind rightKind = right.getKind();
        if (leftKind == TypeKind.DOUBLE || rightKind == TypeKind.DOUBLE) {
            return TypeKind.DOUBLE;
        }
        if (leftKind == TypeKind.FLOAT || rightKind == TypeKind.FLOAT) {
            return TypeKind.FLOAT;
        }
        if (leftKind == TypeKind.LONG || rightKind == TypeKind.LONG) {
            return TypeKind.LONG;
        }
        return TypeKind.INT;
    }

    public static TypeMirror upperBound(TypeMirror type) {
        while (true) {
            WildcardType wc;
            if (type instanceof TypeVariable) {
                TypeVariable tvar = (TypeVariable)type;
                if (tvar.getUpperBound() == null) break;
                type = tvar.getUpperBound();
                continue;
            }
            if (!(type instanceof WildcardType) || (wc = (WildcardType)type).getExtendsBound() == null) break;
            type = wc.getExtendsBound();
        }
        return type;
    }

    public static TypeParameterElement wildcardToTypeParam(Type.WildcardType wildcard) {
        Element typeParamElement = wildcard.bound != null ? wildcard.bound.asElement() : null;
        return (TypeParameterElement)typeParamElement;
    }

    public static Type wildUpperBound(TypeMirror tm, ProcessingEnvironment env) {
        Type t = (Type)tm;
        if (t.hasTag(TypeTag.WILDCARD)) {
            Context context = ((JavacProcessingEnvironment)env).getContext();
            Type.WildcardType w = (Type.WildcardType)TypeAnnotationUtils.unannotatedType(t);
            if (w.isSuperBound()) {
                Symtab syms = Symtab.instance(context);
                return w.bound == null ? syms.objectType : w.bound.bound;
            }
            return TypesUtils.wildUpperBound(w.type, env);
        }
        return TypeAnnotationUtils.unannotatedType(t);
    }

    public static Type wildLowerBound(TypeMirror tm, ProcessingEnvironment env) {
        Type t = (Type)tm;
        if (t.hasTag(TypeTag.WILDCARD)) {
            Context context = ((JavacProcessingEnvironment)env).getContext();
            Symtab syms = Symtab.instance(context);
            Type.WildcardType w = (Type.WildcardType)TypeAnnotationUtils.unannotatedType(t);
            return w.isExtendsBound() ? syms.botType : TypesUtils.wildLowerBound(w.type, env);
        }
        return TypeAnnotationUtils.unannotatedType(t);
    }

    public static TypeMirror typeFromClass(Class<?> clazz, Types types, Elements elements) {
        if (clazz == Void.TYPE) {
            return types.getNoType(TypeKind.VOID);
        }
        if (clazz.isPrimitive()) {
            String primitiveName = clazz.getName().toUpperCase();
            TypeKind primitiveKind = TypeKind.valueOf(primitiveName);
            return types.getPrimitiveType(primitiveKind);
        }
        if (clazz.isArray()) {
            TypeMirror componentType = TypesUtils.typeFromClass(clazz.getComponentType(), types, elements);
            return types.getArrayType(componentType);
        }
        TypeElement element = elements.getTypeElement(clazz.getCanonicalName());
        if (element == null) {
            ErrorReporter.errorAbort("Unrecognized class: " + clazz);
            return null;
        }
        return element.asType();
    }

    public static ArrayType createArrayType(TypeMirror componentType, Types types) {
        JavacTypes t = (JavacTypes)types;
        return t.getArrayType(componentType);
    }

    public static boolean isBoxOf(TypeMirror declaredType, TypeMirror primitiveType) {
        if (declaredType.getKind() != TypeKind.DECLARED) {
            return false;
        }
        String qualifiedName = TypesUtils.getQualifiedName((DeclaredType)declaredType).toString();
        switch (primitiveType.getKind()) {
            case BOOLEAN: {
                return qualifiedName.equals("java.lang.Boolean");
            }
            case BYTE: {
                return qualifiedName.equals("java.lang.Byte");
            }
            case CHAR: {
                return qualifiedName.equals("java.lang.Character");
            }
            case DOUBLE: {
                return qualifiedName.equals("java.lang.Double");
            }
            case FLOAT: {
                return qualifiedName.equals("java.lang.Float");
            }
            case INT: {
                return qualifiedName.equals("java.lang.Integer");
            }
            case LONG: {
                return qualifiedName.equals("java.lang.Long");
            }
            case SHORT: {
                return qualifiedName.equals("java.lang.Short");
            }
        }
        return false;
    }

    public static TypeMirror findConcreteUpperBound(TypeMirror boundedType) {
        TypeMirror effectiveUpper = boundedType;
        block4: while (true) {
            switch (effectiveUpper.getKind()) {
                case WILDCARD: {
                    if ((effectiveUpper = ((WildcardType)effectiveUpper).getExtendsBound()) != null) continue block4;
                    return null;
                }
                case TYPEVAR: {
                    effectiveUpper = ((TypeVariable)effectiveUpper).getUpperBound();
                    continue block4;
                }
            }
            break;
        }
        return effectiveUpper;
    }

    public static boolean isErasedSubtype(TypeMirror subtype, TypeMirror supertype, Types types) {
        return types.isSubtype(types.erasure(subtype), types.erasure(supertype));
    }

    public static boolean isCaptured(TypeVariable typeVar) {
        return ((Type.TypeVar)TypeAnnotationUtils.unannotatedType(typeVar)).isCaptured();
    }

    public static WildcardType getCapturedWildcard(TypeVariable typeVar) {
        if (TypesUtils.isCaptured(typeVar)) {
            return ((Type.CapturedType)TypeAnnotationUtils.unannotatedType((TypeMirror)typeVar)).wildcard;
        }
        return null;
    }

    public static boolean isClassType(TypeMirror type) {
        return type instanceof Type.ClassType;
    }

    public static TypeMirror leastUpperBound(TypeMirror tm1, TypeMirror tm2, ProcessingEnvironment processingEnv) {
        Type bound;
        Type t1 = TypeAnnotationUtils.unannotatedType(tm1);
        Type t2 = TypeAnnotationUtils.unannotatedType(tm2);
        JavacProcessingEnvironment javacEnv = (JavacProcessingEnvironment)processingEnv;
        com.sun.tools.javac.code.Types types = com.sun.tools.javac.code.Types.instance(javacEnv.getContext());
        if (types.isSameType(t1, t2)) {
            return t1;
        }
        if (t1.getKind() == TypeKind.NULL) {
            return t2;
        }
        if (t2.getKind() == TypeKind.NULL) {
            return t1;
        }
        if (t1.getKind() == TypeKind.WILDCARD) {
            WildcardType wc1 = (WildcardType)((Object)t1);
            bound = (Type)wc1.getExtendsBound();
            if (bound == null) {
                Elements elements = processingEnv.getElementUtils();
                return elements.getTypeElement("java.lang.Object").asType();
            }
            t1 = bound;
        }
        if (t2.getKind() == TypeKind.WILDCARD) {
            WildcardType wc2 = (WildcardType)((Object)t2);
            bound = (Type)wc2.getExtendsBound();
            if (bound == null) {
                Elements elements = processingEnv.getElementUtils();
                return elements.getTypeElement("java.lang.Object").asType();
            }
            t2 = bound;
        }
        if (TypesUtils.isPrimitive(t1) || TypesUtils.isPrimitive(t2)) {
            if (types.isAssignable(t1, t2)) {
                return t2;
            }
            if (types.isAssignable(t2, t1)) {
                return t1;
            }
            Elements elements = processingEnv.getElementUtils();
            return elements.getTypeElement("java.lang.Object").asType();
        }
        return types.lub(t1, t2);
    }

    public static TypeMirror greatestLowerBound(TypeMirror tm1, TypeMirror tm2, ProcessingEnvironment processingEnv) {
        Type t1 = TypeAnnotationUtils.unannotatedType(tm1);
        Type t2 = TypeAnnotationUtils.unannotatedType(tm2);
        JavacProcessingEnvironment javacEnv = (JavacProcessingEnvironment)processingEnv;
        com.sun.tools.javac.code.Types types = com.sun.tools.javac.code.Types.instance(javacEnv.getContext());
        if (types.isSameType(t1, t2)) {
            return t1;
        }
        if (t1.getKind() == TypeKind.NULL) {
            return t1;
        }
        if (t2.getKind() == TypeKind.NULL) {
            return t2;
        }
        if (TypesUtils.isPrimitive(t1) || TypesUtils.isPrimitive(t2)) {
            if (types.isAssignable(t1, t2)) {
                return t1;
            }
            if (types.isAssignable(t2, t1)) {
                return t2;
            }
            return processingEnv.getTypeUtils().getNoType(TypeKind.NONE);
        }
        if (t1.getKind() == TypeKind.WILDCARD) {
            return t2;
        }
        if (t2.getKind() == TypeKind.WILDCARD) {
            return t1;
        }
        return types.glb(t1, t2);
    }

    public static TypeMirror substituteMethodReturnType(Element methodElement, TypeMirror substitutedReceiverType, ProcessingEnvironment env) {
        com.sun.tools.javac.code.Types types = com.sun.tools.javac.code.Types.instance(InternalUtils.getJavacContext(env));
        Type substitutedMethodType = types.memberType((Type)substitutedReceiverType, (Symbol)methodElement);
        return substitutedMethodType.getReturnType();
    }

    public static TypeElement getTypeElement(TypeMirror type) {
        Symbol.TypeSymbol element = ((Type)type).asElement();
        switch (element.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                return (TypeElement)((Object)element);
            }
        }
        return null;
    }

    public static boolean isFunctionalInterface(TypeMirror type, ProcessingEnvironment env) {
        Context ctx = ((JavacProcessingEnvironment)env).getContext();
        com.sun.tools.javac.code.Types javacTypes = com.sun.tools.javac.code.Types.instance(ctx);
        return javacTypes.isFunctionalInterface((Type)type);
    }
}

