/*
 * Decompiled with CFR 0.152.
 */
package scenelib.annotations.io;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import plume.ArraysMDE;
import plume.FileIOException;
import plume.Pair;
import scenelib.annotations.Annotation;
import scenelib.annotations.AnnotationBuilder;
import scenelib.annotations.AnnotationFactory;
import scenelib.annotations.Annotations;
import scenelib.annotations.ArrayBuilder;
import scenelib.annotations.el.ABlock;
import scenelib.annotations.el.AClass;
import scenelib.annotations.el.ADeclaration;
import scenelib.annotations.el.AElement;
import scenelib.annotations.el.AExpression;
import scenelib.annotations.el.AField;
import scenelib.annotations.el.AMethod;
import scenelib.annotations.el.AScene;
import scenelib.annotations.el.ATypeElement;
import scenelib.annotations.el.ATypeElementWithType;
import scenelib.annotations.el.AnnotationDef;
import scenelib.annotations.el.BoundLocation;
import scenelib.annotations.el.InnerTypeLocation;
import scenelib.annotations.el.LocalLocation;
import scenelib.annotations.el.RelativeLocation;
import scenelib.annotations.el.TypeIndexLocation;
import scenelib.annotations.field.AnnotationAFT;
import scenelib.annotations.field.AnnotationFieldType;
import scenelib.annotations.field.ArrayAFT;
import scenelib.annotations.field.BasicAFT;
import scenelib.annotations.field.ClassTokenAFT;
import scenelib.annotations.field.EnumAFT;
import scenelib.annotations.field.ScalarAFT;
import scenelib.annotations.io.ASTPath;
import scenelib.annotations.io.ParseException;
import scenelib.annotations.util.coll.VivifyingMap;
import scenelib.type.ArrayType;
import scenelib.type.BoundedType;
import scenelib.type.DeclaredType;
import scenelib.type.Type;

public final class IndexFileParser {
    private static final String[] typeSelectors = new String[]{"bound", "identifier", "type", "typeAlternative", "typeArgument", "typeParameter", "underlyingType"};
    private static boolean abbreviate = true;
    private final StreamTokenizer st;
    private final AScene scene;
    private String curPkgPrefix;
    private final HashMap<String, AnnotationDef> defs = new LinkedHashMap<String, AnnotationDef>();
    private static final Set<String> knownKeywords;
    private static final Map<String, Class<?>> primitiveTypes;

    public static void setAbbreviate(boolean b) {
        abbreviate = b;
    }

    private int expectNonNegative(int i) throws ParseException {
        if (i >= 0) {
            return i;
        }
        throw new ParseException("Expected a nonnegative integer, got " + this.st);
    }

    private boolean checkChar(char c) {
        return this.st.ttype == c;
    }

    private boolean checkKeyword(String s2) {
        return this.st.ttype == -3 && this.st.sval.equals(s2);
    }

    private boolean matchChar(char c) throws IOException {
        if (this.checkChar(c)) {
            this.st.nextToken();
            return true;
        }
        return false;
    }

    private boolean matchKeyword(String s2) throws IOException {
        if (this.checkKeyword(s2)) {
            this.st.nextToken();
            return true;
        }
        return false;
    }

    private void expectChar(char c) throws IOException, ParseException {
        if (!this.matchChar(c)) {
            String found;
            switch (this.st.ttype) {
                case -3: {
                    found = this.st.sval;
                    break;
                }
                case -2: {
                    found = "" + this.st.nval;
                    break;
                }
                case 10: {
                    found = "end of line";
                    break;
                }
                case -1: {
                    found = "end of file";
                    break;
                }
                default: {
                    found = "'" + (char)this.st.ttype + "'";
                }
            }
            throw new ParseException("Expected '" + c + "', found " + found);
        }
    }

    private void expectKeyword(String s2) throws IOException, ParseException {
        if (!this.matchKeyword(s2)) {
            throw new ParseException("Expected `" + s2 + "'");
        }
    }

    private boolean isValidIdentifier(String x) {
        if (x.length() == 0 || !Character.isJavaIdentifierStart(x.charAt(0)) || knownKeywords.contains(x)) {
            return false;
        }
        for (int i = 1; i < x.length(); ++i) {
            if (Character.isJavaIdentifierPart(x.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private String checkIdentifier() {
        if (this.st.sval == null) {
            return null;
        }
        String val = this.st.sval;
        if (this.st.ttype == -3 && this.isValidIdentifier(val)) {
            return this.st.sval;
        }
        return null;
    }

    private String matchIdentifier() throws IOException {
        String x = this.checkIdentifier();
        if (x != null) {
            this.st.nextToken();
            return x;
        }
        return null;
    }

    private String expectIdentifier() throws IOException, ParseException {
        String id = this.matchIdentifier();
        if (id == null) {
            throw new ParseException("Expected an identifier");
        }
        return id;
    }

    private String checkPrimitiveType() {
        if (this.st.sval == null) {
            return null;
        }
        String val = this.st.sval;
        if (this.st.ttype == -3 && primitiveTypes.containsKey(val)) {
            return this.st.sval;
        }
        return null;
    }

    private String matchPrimitiveType() throws IOException {
        String x = this.checkPrimitiveType();
        if (x != null) {
            this.st.nextToken();
            return x;
        }
        return null;
    }

    private String expectQualifiedName() throws IOException, ParseException {
        String name = this.expectIdentifier();
        while (this.matchChar('.')) {
            name = name + '.' + this.expectIdentifier();
        }
        return name;
    }

    private int checkNNInteger() {
        int x;
        if (this.st.ttype == -2 && (double)(x = (int)this.st.nval) == this.st.nval && x >= -1) {
            return x;
        }
        return -1;
    }

    private int matchNNInteger() throws IOException {
        int x = this.checkNNInteger();
        if (x >= -1) {
            this.st.nextToken();
            return x;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object parseScalarAFV(ScalarAFT aft) throws IOException, ParseException {
        if (aft instanceof BasicAFT) {
            Object val;
            BasicAFT baft = (BasicAFT)aft;
            Class<?> type = baft.type;
            if (type == Boolean.TYPE) {
                if (this.matchKeyword("true")) {
                    val = true;
                } else {
                    if (!this.matchKeyword("false")) throw new ParseException("Expected `true' or `false'");
                    val = false;
                }
            } else if (type == Character.TYPE) {
                if (this.st.ttype != 39 || this.st.sval.length() != 1) {
                    throw new ParseException("Expected a character literal");
                }
                val = Character.valueOf(this.st.sval.charAt(0));
                this.st.nextToken();
            } else if (type == String.class) {
                if (this.st.ttype != 34) {
                    throw new ParseException("Expected a string literal");
                }
                val = this.st.sval;
                this.st.nextToken();
            } else {
                if (this.st.ttype != -2) throw new ParseException("Expected a number literal");
                double n = this.st.nval;
                if (type == Byte.TYPE) {
                    val = (byte)n;
                } else if (type == Short.TYPE) {
                    val = (short)n;
                } else if (type == Integer.TYPE) {
                    val = (int)n;
                } else if (type == Long.TYPE) {
                    val = (long)n;
                } else if (type == Float.TYPE) {
                    val = Float.valueOf((float)n);
                } else {
                    if (type != Double.TYPE) throw new AssertionError();
                    val = n;
                }
                this.st.nextToken();
            }
            assert (aft.isValidValue(val));
            return val;
        }
        if (aft instanceof ClassTokenAFT) {
            int arrays = 0;
            StringBuilder type = new StringBuilder();
            while (this.matchChar('[')) {
                ++arrays;
            }
            while (!this.matchKeyword("class")) {
                if (this.st.ttype >= 0) {
                    type.append((char)this.st.ttype);
                } else {
                    if (this.st.ttype != -3) throw new ParseException("Found something that doesn't belong in a signature");
                    type.append(this.st.sval);
                }
                this.st.nextToken();
            }
            type.deleteCharAt(type.length() - 1);
            while (arrays-- > 0) {
                type.insert(0, '[');
            }
            try {
                String sttype = type.toString();
                Class<?> tktype = primitiveTypes.containsKey(sttype) ? primitiveTypes.get(sttype) : Class.forName(sttype);
                assert (aft.isValidValue(tktype));
                return tktype;
            }
            catch (ClassNotFoundException e) {
                throw new ParseException("Could not load class: " + type, e);
            }
        }
        if (aft instanceof EnumAFT) {
            String name = this.expectQualifiedName();
            assert (aft.isValidValue(name));
            return name;
        }
        if (!(aft instanceof AnnotationAFT)) throw new AssertionError((Object)"IndexFileParser.parseScalarAFV: unreachable code.");
        AnnotationAFT aaft = (AnnotationAFT)aft;
        AnnotationDef d = this.parseAnnotationHead();
        if (!d.name.equals(aaft.annotationDef.name)) {
            throw new ParseException("Got an " + d.name + " subannotation where an " + aaft.annotationDef.name + " was expected");
        }
        AnnotationBuilder ab = AnnotationFactory.saf.beginAnnotation(d);
        assert (ab != null);
        AnnotationBuilder ab2 = ab;
        Annotation suba = this.parseAnnotationBody(d, ab2);
        assert (aft.isValidValue(suba));
        return suba;
    }

    private void parseAndAddArrayAFV(ArrayAFT aaft, ArrayBuilder arrb) throws IOException, ParseException {
        if (aaft.elementType == null) {
            throw new IllegalArgumentException("array AFT has null elementType");
        }
        ScalarAFT comp = aaft.elementType;
        if (this.matchChar('{')) {
            while (!this.matchChar('}')) {
                arrb.appendElement(this.parseScalarAFV(comp));
                if (this.checkChar('}')) continue;
                this.expectChar(',');
            }
        } else {
            arrb.appendElement(this.parseScalarAFV(comp));
        }
        arrb.finish();
    }

    private void parseAnnotationField(AnnotationDef d, AnnotationBuilder ab) throws IOException, ParseException {
        AnnotationFieldType aft1;
        String fieldName;
        if (d.fieldTypes.size() == 1 && d.fieldTypes.containsKey("value")) {
            fieldName = "value";
            if (this.matchKeyword("value")) {
                this.expectChar('=');
            }
        } else {
            fieldName = this.expectIdentifier();
            this.expectChar('=');
        }
        if ((aft1 = d.fieldTypes.get(fieldName)) == null) {
            throw new ParseException("The annotation type " + d.name + " has no field called " + fieldName);
        }
        AnnotationFieldType aft = aft1;
        if (aft instanceof ArrayAFT) {
            ArrayAFT aaft = (ArrayAFT)aft;
            if (aaft.elementType == null) {
                this.expectChar('{');
                this.expectChar('}');
                ab.addEmptyArrayField(fieldName);
            } else {
                this.parseAndAddArrayAFV(aaft, ab.beginArrayField(fieldName, aaft));
            }
        } else if (aft instanceof ScalarAFT) {
            ScalarAFT saft = (ScalarAFT)aft;
            Object value = this.parseScalarAFV(saft);
            ab.addScalarField(fieldName, saft, value);
        } else {
            throw new AssertionError();
        }
    }

    private AnnotationDef parseAnnotationHead() throws IOException, ParseException {
        this.expectChar('@');
        String name = this.expectQualifiedName();
        AnnotationDef d = this.defs.get(name);
        if (d == null) {
            throw new ParseException("No definition for annotation type " + name);
        }
        return d;
    }

    private Annotation parseAnnotationBody(AnnotationDef d, AnnotationBuilder ab) throws IOException, ParseException {
        if (this.matchChar('(')) {
            this.parseAnnotationField(d, ab);
            while (this.matchChar(',')) {
                this.parseAnnotationField(d, ab);
            }
            this.expectChar(')');
        }
        Annotation ann = ab.finish();
        if (!ann.def.equals(d)) {
            throw new ParseException("parseAnnotationBody: Annotation def isn't as it should be.\n" + d + "\n" + ann.def);
        }
        if (ann.def().fieldTypes.size() != d.fieldTypes.size()) {
            throw new ParseException("At least one annotation field is missing");
        }
        return ann;
    }

    private void parseAnnotations(AElement e) throws IOException, ParseException {
        while (this.checkChar('@')) {
            AnnotationDef d = this.parseAnnotationHead();
            AnnotationBuilder ab = AnnotationFactory.saf.beginAnnotation(d);
            if (ab == null) {
                Annotation annotation = this.parseAnnotationBody(d, AnnotationFactory.saf.beginAnnotation(d));
                continue;
            }
            Annotation a = this.parseAnnotationBody(d, ab);
            for (Annotation other : e.tlAnnotationsHere) {
                if (!a.def.name.equals(other.def.name)) continue;
                System.err.println("WARNING: duplicate annotation of type " + a.def().name);
            }
            Annotation tla = a;
            if (!tla.def.equals(d)) {
                throw new ParseException("Bad def");
            }
            e.tlAnnotationsHere.add(tla);
        }
    }

    private ScalarAFT parseScalarAFT(String annotationFullyQualifiedName) throws IOException, ParseException {
        String name;
        for (BasicAFT baft : BasicAFT.bafts.values()) {
            if (!this.matchKeyword(baft.toString())) continue;
            return baft;
        }
        if (this.matchKeyword("Class")) {
            return ClassTokenAFT.ctaft;
        }
        if (this.matchKeyword("enum")) {
            int i;
            name = this.expectQualifiedName();
            if (abbreviate && (i = name.lastIndexOf(46)) >= 0) {
                String baseName;
                Set<String> importSet = this.scene.imports.get(annotationFullyQualifiedName);
                if (importSet == null) {
                    importSet = new TreeSet<String>();
                    this.scene.imports.put(annotationFullyQualifiedName, importSet);
                }
                importSet.add(name);
                name = baseName = name.substring(i + 1);
            }
            return new EnumAFT(name);
        }
        if (this.matchKeyword("annotation-field")) {
            name = this.expectQualifiedName();
            AnnotationDef ad = this.defs.get(name);
            if (ad == null) {
                throw new ParseException("Annotation type " + name + " used as a field before it is defined");
            }
            return new AnnotationAFT(ad);
        }
        throw new ParseException("Expected the beginning of an annotation field type: a primitive type, `String', `Class', `enum', or `annotation-field'. Got '" + this.st.sval + "'.");
    }

    private AnnotationFieldType parseAFT(String annotationFullyQualifiedName) throws IOException, ParseException {
        if (this.matchKeyword("unknown")) {
            this.expectChar('[');
            this.expectChar(']');
            return new ArrayAFT(null);
        }
        ScalarAFT baseAFT = this.parseScalarAFT(annotationFullyQualifiedName);
        if (this.matchChar('[')) {
            this.expectChar(']');
            return new ArrayAFT(baseAFT);
        }
        return baseAFT;
    }

    private void parseAnnotationDef() throws IOException, ParseException {
        this.expectKeyword("annotation");
        this.expectChar('@');
        String basename = this.expectIdentifier();
        String fullName = this.curPkgPrefix + basename;
        AnnotationDef ad = new AnnotationDef(fullName);
        this.expectChar(':');
        this.parseAnnotations(ad);
        LinkedHashMap<String, AnnotationFieldType> fields = new LinkedHashMap<String, AnnotationFieldType>();
        while (!(this.st.ttype == -1 || this.checkKeyword("annotation") || this.checkKeyword("class") || this.checkKeyword("package"))) {
            AnnotationFieldType type = this.parseAFT(fullName);
            String name = this.expectIdentifier();
            if (fields.containsKey(name)) {
                throw new ParseException("Duplicate definition of field " + name);
            }
            fields.put(name, type);
        }
        ad.setFieldTypes(fields);
        this.addDef(ad, basename);
    }

    public void addDef(AnnotationDef ad) throws ParseException {
        String basename = ad.name;
        int dotPos = basename.lastIndexOf(46);
        if (dotPos != -1) {
            basename = basename.substring(dotPos + 1);
        }
        this.addDef(ad, basename);
    }

    public void addDef(AnnotationDef ad, String basename) throws ParseException {
        if (this.defs.containsKey(ad.name)) {
            System.err.println("Duplicate definition of annotation type " + ad.name);
        }
        this.defs.put(ad.name, ad);
        if (!basename.equals(ad.name)) {
            if (this.defs.containsKey(basename)) {
                this.defs.put(basename, null);
            } else {
                this.defs.put(basename, ad);
            }
        }
    }

    private void parseInnerTypes(ATypeElement e) throws IOException, ParseException {
        this.parseInnerTypes(e, 0);
    }

    private void parseInnerTypes(ATypeElement e, int offset) throws IOException, ParseException {
        while (this.matchKeyword("inner-type")) {
            InnerTypeLocation loc;
            ArrayList<Integer> locNumbers = new ArrayList<Integer>();
            locNumbers.add(offset + this.expectNonNegative(this.matchNNInteger()));
            while (this.matchChar(',')) {
                locNumbers.add(this.expectNonNegative(this.matchNNInteger()));
            }
            try {
                loc = new InnerTypeLocation(TypeAnnotationPosition.getTypePathFromBinary(locNumbers));
            }
            catch (AssertionError ex) {
                throw new ParseException(((Throwable)((Object)ex)).getMessage(), (Throwable)((Object)ex));
            }
            AElement it = e.innerTypes.vivify(loc);
            this.expectChar(':');
            this.parseAnnotations(it);
        }
    }

    private void parseBounds(VivifyingMap<BoundLocation, ATypeElement> bounds) throws IOException, ParseException {
        while (this.checkKeyword("typeparam") || this.checkKeyword("bound")) {
            int paramIndex;
            if (this.matchKeyword("typeparam")) {
                paramIndex = this.expectNonNegative(this.matchNNInteger());
                BoundLocation bl = new BoundLocation(paramIndex, -1);
                ATypeElement b = bounds.vivify(bl);
                this.expectChar(':');
                this.parseAnnotations(b);
                this.parseInnerTypes(b);
                continue;
            }
            if (this.matchKeyword("bound")) {
                paramIndex = this.expectNonNegative(this.matchNNInteger());
                this.expectChar('&');
                int boundIndex = this.expectNonNegative(this.matchNNInteger());
                BoundLocation bl = new BoundLocation(paramIndex, boundIndex);
                ATypeElement b = bounds.vivify(bl);
                this.expectChar(':');
                this.parseAnnotations(b);
                this.parseInnerTypes(b);
                continue;
            }
            throw new Error("impossible");
        }
    }

    private void parseExtends(AClass cls) throws IOException, ParseException {
        this.expectKeyword("extends");
        TypeIndexLocation idx = new TypeIndexLocation(-1);
        ATypeElement ext = cls.extendsImplements.vivify(idx);
        this.expectChar(':');
        this.parseAnnotations(ext);
        this.parseInnerTypes(ext);
    }

    private void parseImplements(AClass cls) throws IOException, ParseException {
        this.expectKeyword("implements");
        int implIndex = this.expectNonNegative(this.matchNNInteger());
        TypeIndexLocation idx = new TypeIndexLocation(implIndex);
        ATypeElement impl = cls.extendsImplements.vivify(idx);
        this.expectChar(':');
        this.parseAnnotations(impl);
        this.parseInnerTypes(impl);
    }

    private void parseField(AClass c) throws IOException, ParseException {
        this.expectKeyword("field");
        String name = this.expectIdentifier();
        AField f = c.fields.vivify(name);
        this.expectChar(':');
        this.parseAnnotations(f);
        if (this.checkKeyword("type") && this.matchKeyword("type")) {
            this.expectChar(':');
            this.parseAnnotations(f.type);
            this.parseInnerTypes(f.type);
        }
        f.init = c.fieldInits.vivify(name);
        this.parseExpression(f.init);
        this.parseASTInsertions(f);
    }

    private void parseStaticInit(AClass c) throws IOException, ParseException {
        this.expectKeyword("staticinit");
        this.expectChar('*');
        int blockIndex = this.expectNonNegative(this.matchNNInteger());
        this.expectChar(':');
        ABlock staticinit = c.staticInits.vivify(blockIndex);
        this.parseBlock(staticinit);
    }

    private void parseInstanceInit(AClass c) throws IOException, ParseException {
        this.expectKeyword("instanceinit");
        this.expectChar('*');
        int blockIndex = this.expectNonNegative(this.matchNNInteger());
        this.expectChar(':');
        ABlock instanceinit = c.instanceInits.vivify(blockIndex);
        this.parseBlock(instanceinit);
    }

    private void parseMethod(AClass c) throws IOException, ParseException {
        String key;
        this.expectKeyword("method");
        if (this.matchChar('<')) {
            String basename = this.expectIdentifier();
            if (!basename.equals("init") && !basename.equals("clinit")) {
                throw new ParseException("The only special methods allowed are <init> and <clinit>");
            }
            this.expectChar('>');
            key = "<" + basename + ">";
        } else {
            key = this.expectIdentifier();
            if (Pattern.matches("AClass: (?:[^. ]+\\.)*" + key, c.toString())) {
                key = "<init>";
            }
        }
        this.expectChar('(');
        key = key + '(';
        while (!this.matchChar(':')) {
            if (this.st.ttype >= 0) {
                key = key + (this.st.ttype == 46 ? (char)'/' : (char)this.st.ttype);
            } else if (this.st.ttype == -3) {
                key = key + this.st.sval;
            } else {
                throw new ParseException("Found something that doesn't belong in a signature");
            }
            this.st.nextToken();
        }
        AMethod m3 = c.methods.vivify(key);
        this.parseAnnotations(m3);
        this.parseMethod(m3);
    }

    private void parseMethod(AMethod m3) throws IOException, ParseException {
        this.parseBounds(m3.bounds);
        while (this.checkKeyword("return") || this.checkKeyword("receiver") || this.checkKeyword("parameter")) {
            if (this.matchKeyword("return")) {
                this.expectChar(':');
                this.parseAnnotations(m3.returnType);
                this.parseInnerTypes(m3.returnType);
                continue;
            }
            if (this.matchKeyword("parameter")) {
                if (this.checkChar('#')) {
                    this.matchChar('#');
                }
                int idx = this.expectNonNegative(this.matchNNInteger());
                AField p = m3.parameters.vivify(idx);
                this.expectChar(':');
                this.parseAnnotations(p);
                if (!this.checkKeyword("type") || !this.matchKeyword("type")) continue;
                this.expectChar(':');
                this.parseAnnotations(p.type);
                this.parseInnerTypes(p.type);
                continue;
            }
            if (this.matchKeyword("receiver")) {
                this.expectChar(':');
                this.parseAnnotations(m3.receiver.type);
                this.parseInnerTypes(m3.receiver.type);
                continue;
            }
            throw new Error("This can't happen");
        }
        this.parseBlock(m3.body);
        this.parseASTInsertions(m3);
    }

    private void parseLambda(AMethod m3) throws IOException, ParseException {
        while (this.checkKeyword("parameter")) {
            this.matchKeyword("parameter");
            if (this.checkChar('#')) {
                this.matchChar('#');
            }
            int idx = this.expectNonNegative(this.matchNNInteger());
            AField p = m3.parameters.vivify(idx);
            this.expectChar(':');
            this.parseAnnotations(p);
            if (!this.checkKeyword("type") || !this.matchKeyword("type")) continue;
            this.expectChar(':');
            this.parseAnnotations(p.type);
            this.parseInnerTypes(p.type);
        }
        this.parseASTInsertions(m3);
    }

    private void parseBlock(ABlock bl) throws IOException, ParseException {
        boolean matched = true;
        while (matched) {
            matched = false;
            while (this.checkKeyword("local")) {
                LocalLocation loc;
                this.matchKeyword("local");
                matched = true;
                if (this.checkNNInteger() != -1) {
                    int index = this.expectNonNegative(this.matchNNInteger());
                    this.expectChar('#');
                    int scopeStart = this.expectNonNegative(this.matchNNInteger());
                    this.expectChar('+');
                    int scopeLength = this.expectNonNegative(this.matchNNInteger());
                    loc = new LocalLocation(index, scopeStart, scopeLength);
                } else {
                    int varIndex;
                    String lvar = this.expectIdentifier();
                    if (this.checkChar('*')) {
                        this.expectChar('*');
                        varIndex = this.expectNonNegative(this.matchNNInteger());
                    } else {
                        varIndex = 0;
                    }
                    loc = new LocalLocation(lvar, varIndex);
                }
                AField l = bl.locals.vivify(loc);
                this.expectChar(':');
                this.parseAnnotations(l);
                if (!this.checkKeyword("type") || !this.matchKeyword("type")) continue;
                this.expectChar(':');
                this.parseAnnotations(l.type);
                this.parseInnerTypes(l.type);
            }
            matched = this.parseExpression(bl) || matched;
        }
    }

    private boolean parseExpression(AExpression exp) throws IOException, ParseException {
        boolean matched = true;
        boolean evermatched = false;
        while (matched) {
            RelativeLocation loc;
            int type_index;
            matched = false;
            while (this.checkKeyword("typecast")) {
                this.matchKeyword("typecast");
                matched = true;
                evermatched = true;
                if (this.checkChar('#')) {
                    this.expectChar('#');
                    int offset = this.expectNonNegative(this.matchNNInteger());
                    type_index = 0;
                    if (this.checkChar(',')) {
                        this.expectChar(',');
                        type_index = this.expectNonNegative(this.matchNNInteger());
                    }
                    loc = RelativeLocation.createOffset(offset, type_index);
                } else {
                    this.expectChar('*');
                    int index = this.expectNonNegative(this.matchNNInteger());
                    type_index = 0;
                    if (this.checkChar(',')) {
                        this.expectChar(',');
                        type_index = this.expectNonNegative(this.matchNNInteger());
                    }
                    loc = RelativeLocation.createIndex(index, type_index);
                }
                ATypeElement t = exp.typecasts.vivify(loc);
                this.expectChar(':');
                this.parseAnnotations(t);
                this.parseInnerTypes(t);
            }
            while (this.checkKeyword("instanceof")) {
                this.matchKeyword("instanceof");
                matched = true;
                evermatched = true;
                if (this.checkChar('#')) {
                    this.expectChar('#');
                    int offset = this.expectNonNegative(this.matchNNInteger());
                    loc = RelativeLocation.createOffset(offset, 0);
                } else {
                    this.expectChar('*');
                    int index = this.expectNonNegative(this.matchNNInteger());
                    loc = RelativeLocation.createIndex(index, 0);
                }
                ATypeElement i = exp.instanceofs.vivify(loc);
                this.expectChar(':');
                this.parseAnnotations(i);
                this.parseInnerTypes(i);
            }
            while (this.checkKeyword("new")) {
                this.matchKeyword("new");
                matched = true;
                evermatched = true;
                if (this.checkChar('#')) {
                    this.expectChar('#');
                    int offset = this.expectNonNegative(this.matchNNInteger());
                    loc = RelativeLocation.createOffset(offset, 0);
                } else {
                    this.expectChar('*');
                    int index = this.expectNonNegative(this.matchNNInteger());
                    loc = RelativeLocation.createIndex(index, 0);
                }
                ATypeElement n = exp.news.vivify(loc);
                this.expectChar(':');
                this.parseAnnotations(n);
                this.parseInnerTypes(n);
            }
            while (this.checkKeyword("call")) {
                this.matchKeyword("call");
                matched = true;
                evermatched = true;
                boolean isOffset = this.checkChar('#');
                this.expectChar(isOffset ? (char)'#' : '*');
                int i = this.expectNonNegative(this.matchNNInteger());
                this.expectChar(':');
                while (this.checkKeyword("typearg")) {
                    this.matchKeyword("typearg");
                    if (this.checkChar('#')) {
                        this.matchChar('#');
                    }
                    type_index = this.expectNonNegative(this.matchNNInteger());
                    RelativeLocation loc2 = isOffset ? RelativeLocation.createOffset(i, type_index) : RelativeLocation.createIndex(i, type_index);
                    ATypeElement t = exp.calls.vivify(loc2);
                    this.expectChar(':');
                    this.parseAnnotations(t);
                    this.parseInnerTypes(t);
                }
            }
            while (this.checkKeyword("reference")) {
                RelativeLocation loc3;
                int i;
                this.matchKeyword("reference");
                matched = true;
                evermatched = true;
                boolean isOffset = this.checkChar('#');
                if (isOffset) {
                    this.expectChar('#');
                    i = this.expectNonNegative(this.matchNNInteger());
                    loc3 = RelativeLocation.createOffset(i, 0);
                } else {
                    this.expectChar('*');
                    i = this.expectNonNegative(this.matchNNInteger());
                    loc3 = RelativeLocation.createIndex(i, 0);
                }
                this.expectChar(':');
                ATypeElement t = exp.refs.vivify(loc3);
                this.parseAnnotations(t);
                this.parseInnerTypes(t);
                while (this.checkKeyword("typearg")) {
                    this.matchKeyword("typearg");
                    if (this.checkChar('#')) {
                        this.matchChar('#');
                    }
                    int type_index2 = this.expectNonNegative(this.matchNNInteger());
                    loc3 = isOffset ? RelativeLocation.createOffset(i, type_index2) : RelativeLocation.createIndex(i, type_index2);
                    t = exp.refs.vivify(loc3);
                    this.expectChar(':');
                    this.parseAnnotations(t);
                    this.parseInnerTypes(t);
                }
            }
            while (this.checkKeyword("lambda")) {
                RelativeLocation loc4;
                this.matchKeyword("lambda");
                matched = true;
                evermatched = true;
                if (this.checkChar('#')) {
                    this.expectChar('#');
                    int offset = this.expectNonNegative(this.matchNNInteger());
                    type_index = 0;
                    if (this.checkChar(',')) {
                        this.expectChar(',');
                        type_index = this.expectNonNegative(this.matchNNInteger());
                    }
                    loc4 = RelativeLocation.createOffset(offset, type_index);
                } else {
                    this.expectChar('*');
                    int index = this.expectNonNegative(this.matchNNInteger());
                    type_index = 0;
                    if (this.checkChar(',')) {
                        this.expectChar(',');
                        type_index = this.expectNonNegative(this.matchNNInteger());
                    }
                    loc4 = RelativeLocation.createIndex(index, type_index);
                }
                AMethod m3 = exp.funs.vivify(loc4);
                this.expectChar(':');
                this.parseLambda(m3);
            }
        }
        return evermatched;
    }

    private static boolean isTypeSelector(String selector) {
        return Arrays.binarySearch(typeSelectors, selector, Collator.getInstance()) >= 0;
    }

    private static boolean selectsExpression(ASTPath astPath) {
        int n = astPath.size();
        if (--n >= 0) {
            ASTPath.ASTEntry entry = (ASTPath.ASTEntry)astPath.get(n);
            while (--n >= 0 && entry.getTreeKind() == Tree.Kind.MEMBER_SELECT && entry.childSelectorIs("expression")) {
                entry = (ASTPath.ASTEntry)astPath.get(n);
            }
            return !IndexFileParser.isTypeSelector(entry.getChildSelector());
        }
        return false;
    }

    private boolean parseASTInsertions(ADeclaration decl) throws IOException, ParseException {
        ATypeElementWithType i;
        ASTPath astPath;
        boolean matched = false;
        while (this.checkKeyword("insert-annotation")) {
            ATypeElement i2;
            matched = true;
            this.matchKeyword("insert-annotation");
            astPath = this.parseASTPath();
            this.expectChar(':');
            if (IndexFileParser.selectsExpression(astPath)) {
                i = decl.insertTypecasts.vivify(astPath);
                this.parseAnnotations(i);
                i.setType(new DeclaredType());
                this.parseInnerTypes(i);
                continue;
            }
            int offset = 0;
            Pair<ASTPath, InnerTypeLocation> pair = this.splitNewArrayType(astPath);
            if (pair == null) {
                i2 = decl.insertAnnotations.vivify(astPath);
            } else {
                i2 = decl.insertAnnotations.vivify((ASTPath)pair.a);
                if (pair.b != null) {
                    i2 = i2.innerTypes.vivify((InnerTypeLocation)pair.b);
                    offset = ((InnerTypeLocation)pair.b).location.size();
                }
            }
            this.parseAnnotations(i2);
            this.parseInnerTypes(i2, offset);
        }
        while (this.checkKeyword("insert-typecast")) {
            matched = true;
            this.matchKeyword("insert-typecast");
            astPath = this.parseASTPath();
            this.expectChar(':');
            i = decl.insertTypecasts.vivify(astPath);
            this.parseAnnotations(i);
            Type type = this.parseType();
            i.setType(type);
            this.parseInnerTypes(i);
        }
        return matched;
    }

    private Pair<ASTPath, InnerTypeLocation> splitNewArrayType(ASTPath astPath) {
        int a;
        ASTPath.ASTEntry entry;
        ASTPath outerPath = astPath;
        InnerTypeLocation loc = null;
        int last = astPath.size() - 1;
        if (last > 0 && (entry = (ASTPath.ASTEntry)astPath.get(last)).getTreeKind() == Tree.Kind.NEW_ARRAY && entry.childSelectorIs("type") && (a = entry.getArgument()) > 0) {
            outerPath = astPath.getParentPath().extend(new ASTPath.ASTEntry(Tree.Kind.NEW_ARRAY, "type", 0));
            loc = new InnerTypeLocation(TypeAnnotationPosition.getTypePathFromBinary(Collections.nCopies(2 * a, 0)));
        }
        return Pair.of(outerPath, loc);
    }

    private ASTPath fixNewArrayType(ASTPath astPath) {
        ASTPath.ASTEntry entry;
        ASTPath outerPath = astPath;
        int last = astPath.size() - 1;
        if (last > 0 && (entry = (ASTPath.ASTEntry)astPath.get(last)).getTreeKind() == Tree.Kind.NEW_ARRAY && entry.childSelectorIs("type")) {
            int a = entry.getArgument();
            outerPath = astPath.getParentPath().extend(new ASTPath.ASTEntry(Tree.Kind.NEW_ARRAY, "type", 0));
            while (--a >= 0) {
                outerPath = outerPath.extend(new ASTPath.ASTEntry(Tree.Kind.ARRAY_TYPE, "type"));
            }
        }
        return outerPath;
    }

    private ASTPath parseASTPath() throws IOException, ParseException {
        ASTPath astPath = ASTPath.empty().extend(this.parseASTEntry());
        while (this.matchChar(',')) {
            astPath = astPath.extend(this.parseASTEntry());
        }
        return astPath;
    }

    private ASTPath.ASTEntry parseASTEntry() throws IOException, ParseException {
        ASTPath.ASTEntry entry;
        if (this.matchKeyword("AnnotatedType")) {
            entry = this.newASTEntry(Tree.Kind.ANNOTATED_TYPE, new String[]{"annotation", "underlyingType"}, new String[]{"annotation"});
        } else if (this.matchKeyword("ArrayAccess")) {
            entry = this.newASTEntry(Tree.Kind.ARRAY_ACCESS, new String[]{"expression", "index"});
        } else if (this.matchKeyword("ArrayType")) {
            entry = this.newASTEntry(Tree.Kind.ARRAY_TYPE, new String[]{"type"});
        } else if (this.matchKeyword("Assert")) {
            entry = this.newASTEntry(Tree.Kind.ASSERT, new String[]{"condition", "detail"});
        } else if (this.matchKeyword("Assignment")) {
            entry = this.newASTEntry(Tree.Kind.ASSIGNMENT, new String[]{"variable", "expression"});
        } else if (this.matchKeyword("Binary")) {
            entry = this.newASTEntry(Tree.Kind.PLUS, new String[]{"leftOperand", "rightOperand"});
        } else if (this.matchKeyword("Block")) {
            entry = this.newASTEntry(Tree.Kind.BLOCK, new String[]{"statement"}, new String[]{"statement"});
        } else if (this.matchKeyword("Case")) {
            entry = this.newASTEntry(Tree.Kind.CASE, new String[]{"expression", "statement"}, new String[]{"statement"});
        } else if (this.matchKeyword("Catch")) {
            entry = this.newASTEntry(Tree.Kind.CATCH, new String[]{"parameter", "block"});
        } else if (this.matchKeyword("Class")) {
            entry = this.newASTEntry(Tree.Kind.CLASS, new String[]{"bound", "initializer", "typeParameter"}, new String[]{"bound", "initializer", "typeParameter"});
        } else if (this.matchKeyword("CompoundAssignment")) {
            entry = this.newASTEntry(Tree.Kind.PLUS_ASSIGNMENT, new String[]{"variable", "expression"});
        } else if (this.matchKeyword("ConditionalExpression")) {
            entry = this.newASTEntry(Tree.Kind.CONDITIONAL_EXPRESSION, new String[]{"condition", "trueExpression", "falseExpression"});
        } else if (this.matchKeyword("DoWhileLoop")) {
            entry = this.newASTEntry(Tree.Kind.DO_WHILE_LOOP, new String[]{"condition", "statement"});
        } else if (this.matchKeyword("EnhancedForLoop")) {
            entry = this.newASTEntry(Tree.Kind.ENHANCED_FOR_LOOP, new String[]{"variable", "expression", "statement"});
        } else if (this.matchKeyword("ExpressionStatement")) {
            entry = this.newASTEntry(Tree.Kind.EXPRESSION_STATEMENT, new String[]{"expression"});
        } else if (this.matchKeyword("ForLoop")) {
            entry = this.newASTEntry(Tree.Kind.FOR_LOOP, new String[]{"initializer", "condition", "update", "statement"}, new String[]{"initializer", "update"});
        } else if (this.matchKeyword("If")) {
            entry = this.newASTEntry(Tree.Kind.IF, new String[]{"condition", "thenStatement", "elseStatement"});
        } else if (this.matchKeyword("InstanceOf")) {
            entry = this.newASTEntry(Tree.Kind.INSTANCE_OF, new String[]{"expression", "type"});
        } else if (this.matchKeyword("LabeledStatement")) {
            entry = this.newASTEntry(Tree.Kind.LABELED_STATEMENT, new String[]{"statement"});
        } else if (this.matchKeyword("LambdaExpression")) {
            entry = this.newASTEntry(Tree.Kind.LAMBDA_EXPRESSION, new String[]{"parameter", "body"}, new String[]{"parameter"});
        } else if (this.matchKeyword("MemberReference")) {
            entry = this.newASTEntry(Tree.Kind.MEMBER_REFERENCE, new String[]{"qualifierExpression", "typeArgument"}, new String[]{"typeArgument"});
        } else if (this.matchKeyword("MemberSelect")) {
            entry = this.newASTEntry(Tree.Kind.MEMBER_SELECT, new String[]{"expression"});
        } else if (this.matchKeyword("Method")) {
            entry = this.newASTEntry(Tree.Kind.METHOD, new String[]{"body", "type", "parameter", "typeParameter"}, new String[]{"parameter", "typeParameter"});
        } else if (this.matchKeyword("MethodInvocation")) {
            entry = this.newASTEntry(Tree.Kind.METHOD_INVOCATION, new String[]{"typeArgument", "methodSelect", "argument"}, new String[]{"typeArgument", "argument"});
        } else if (this.matchKeyword("NewArray")) {
            entry = this.newASTEntry(Tree.Kind.NEW_ARRAY, new String[]{"type", "dimension", "initializer"}, new String[]{"type", "dimension", "initializer"});
        } else if (this.matchKeyword("NewClass")) {
            entry = this.newASTEntry(Tree.Kind.NEW_CLASS, new String[]{"enclosingExpression", "typeArgument", "identifier", "argument", "classBody"}, new String[]{"typeArgument", "argument"});
        } else if (this.matchKeyword("ParameterizedType")) {
            entry = this.newASTEntry(Tree.Kind.PARAMETERIZED_TYPE, new String[]{"type", "typeArgument"}, new String[]{"typeArgument"});
        } else if (this.matchKeyword("Parenthesized")) {
            entry = this.newASTEntry(Tree.Kind.PARENTHESIZED, new String[]{"expression"});
        } else if (this.matchKeyword("Return")) {
            entry = this.newASTEntry(Tree.Kind.RETURN, new String[]{"expression"});
        } else if (this.matchKeyword("Switch")) {
            entry = this.newASTEntry(Tree.Kind.SWITCH, new String[]{"expression", "case"}, new String[]{"case"});
        } else if (this.matchKeyword("Synchronized")) {
            entry = this.newASTEntry(Tree.Kind.SYNCHRONIZED, new String[]{"expression", "block"});
        } else if (this.matchKeyword("Throw")) {
            entry = this.newASTEntry(Tree.Kind.THROW, new String[]{"expression"});
        } else if (this.matchKeyword("Try")) {
            entry = this.newASTEntry(Tree.Kind.TRY, new String[]{"block", "catch", "finallyBlock"}, new String[]{"catch"});
        } else if (this.matchKeyword("TypeCast")) {
            entry = this.newASTEntry(Tree.Kind.TYPE_CAST, new String[]{"type", "expression"});
        } else if (this.matchKeyword("TypeParameter")) {
            entry = this.newASTEntry(Tree.Kind.TYPE_PARAMETER, new String[]{"bound"}, new String[]{"bound"});
        } else if (this.matchKeyword("Unary")) {
            entry = this.newASTEntry(Tree.Kind.UNARY_PLUS, new String[]{"expression"});
        } else if (this.matchKeyword("UnionType")) {
            entry = this.newASTEntry(Tree.Kind.UNION_TYPE, new String[]{"typeAlternative"}, new String[]{"typeAlternative"});
        } else if (this.matchKeyword("Variable")) {
            entry = this.newASTEntry(Tree.Kind.VARIABLE, new String[]{"type", "initializer"});
        } else if (this.matchKeyword("WhileLoop")) {
            entry = this.newASTEntry(Tree.Kind.WHILE_LOOP, new String[]{"condition", "statement"});
        } else if (this.matchKeyword("Wildcard")) {
            entry = this.newASTEntry(Tree.Kind.UNBOUNDED_WILDCARD, new String[]{"bound"});
        } else {
            throw new ParseException("Invalid AST path type: " + this.st.sval);
        }
        return entry;
    }

    private ASTPath.ASTEntry newASTEntry(Tree.Kind kind, String[] legalChildSelectors) throws IOException, ParseException {
        return this.newASTEntry(kind, legalChildSelectors, null);
    }

    private ASTPath.ASTEntry newASTEntry(Tree.Kind kind, String[] legalChildSelectors, String[] argumentChildSelectors) throws IOException, ParseException {
        this.expectChar('.');
        for (String arg : legalChildSelectors) {
            if (!this.matchKeyword(arg)) continue;
            if (argumentChildSelectors != null && ArraysMDE.indexOf(argumentChildSelectors, (Object)arg) >= 0) {
                int index = this.matchNNInteger();
                return new ASTPath.ASTEntry(kind, arg, index);
            }
            return new ASTPath.ASTEntry(kind, arg);
        }
        throw new ParseException("Invalid argument for " + (Object)((Object)kind) + " (legal arguments - " + Arrays.toString(legalChildSelectors) + "): " + this.st.sval);
    }

    private Type parseType() throws IOException, ParseException {
        DeclaredType declaredType = this.matchChar('?') ? new DeclaredType("?") : this.parseDeclaredType();
        if (this.checkKeyword("extends") || this.checkKeyword("super")) {
            return this.parseBoundedType(declaredType);
        }
        Type type = declaredType;
        while (this.matchChar('[')) {
            this.expectChar(']');
            type = new ArrayType(type);
        }
        return type;
    }

    private DeclaredType parseDeclaredType() throws IOException, ParseException {
        String type = this.matchIdentifier();
        if (type == null && (type = this.matchPrimitiveType()) == null) {
            throw new ParseException("Expected identifier or primitive type");
        }
        return this.parseDeclaredType(type);
    }

    private DeclaredType parseDeclaredType(String name) throws IOException, ParseException {
        DeclaredType type = new DeclaredType(name);
        if (this.matchChar('<')) {
            type.addTypeParameter(this.parseType());
            while (this.matchChar(',')) {
                type.addTypeParameter(this.parseType());
            }
            this.expectChar('>');
        }
        if (this.matchChar('.')) {
            type.setInnerType(this.parseDeclaredType());
        }
        return type;
    }

    private BoundedType parseBoundedType(DeclaredType type) throws IOException, ParseException {
        BoundedType.BoundKind kind;
        if (this.matchKeyword("extends")) {
            kind = BoundedType.BoundKind.EXTENDS;
        } else if (this.matchKeyword("super")) {
            kind = BoundedType.BoundKind.SUPER;
        } else {
            throw new ParseException("Illegal bound kind: " + this.st.sval);
        }
        return new BoundedType(type, kind, this.parseDeclaredType());
    }

    private void parseClass() throws IOException, ParseException {
        this.expectKeyword("class");
        String basename = this.expectIdentifier();
        String fullName = this.curPkgPrefix + basename;
        AClass c = this.scene.classes.vivify(fullName);
        this.expectChar(':');
        this.parseAnnotations(c);
        this.parseBounds(c.bounds);
        while (this.checkKeyword("extends")) {
            this.parseExtends(c);
        }
        while (this.checkKeyword("implements")) {
            this.parseImplements(c);
        }
        this.parseASTInsertions(c);
        while (this.checkKeyword("field")) {
            this.parseField(c);
        }
        while (this.checkKeyword("staticinit")) {
            this.parseStaticInit(c);
        }
        while (this.checkKeyword("instanceinit")) {
            this.parseInstanceInit(c);
        }
        while (this.checkKeyword("method")) {
            this.parseMethod(c);
        }
        c.methods.prune();
    }

    private void parse() throws ParseException, IOException {
        this.st.nextToken();
        while (this.st.ttype != -1) {
            String pkg;
            this.expectKeyword("package");
            if (this.checkIdentifier() == null) {
                pkg = null;
                this.matchChar(':');
            } else {
                pkg = this.expectQualifiedName();
                AClass p = this.scene.classes.vivify(pkg + ".package-info");
                this.expectChar(':');
                p = this.scene.classes.vivify(pkg + ".package-info");
                this.parseAnnotations(p);
            }
            this.curPkgPrefix = pkg != null ? pkg + "." : "";
            while (true) {
                if (this.checkKeyword("annotation")) {
                    this.parseAnnotationDef();
                    continue;
                }
                if (!this.checkKeyword("class")) break;
                this.parseClass();
            }
            if (this.checkKeyword("package") || this.st.ttype == -1) continue;
            throw new ParseException("Expected: `annotation', `class', or `package'. Found: `" + this.st.sval + "', ttype:" + this.st.ttype);
        }
    }

    private IndexFileParser(Reader in, AScene scene) {
        for (AnnotationDef ad : Annotations.standardDefs) {
            try {
                this.addDef(ad);
            }
            catch (ParseException e) {
                throw new Error(e);
            }
        }
        this.st = new StreamTokenizer(in);
        this.st.slashSlashComments(true);
        this.st.ordinaryChar(46);
        this.st.ordinaryChar(47);
        this.st.wordChars(45, 45);
        this.st.wordChars(48, 57);
        this.st.wordChars(95, 95);
        this.st.wordChars(36, 36);
        this.scene = scene;
    }

    public static Map<String, AnnotationDef> parse(LineNumberReader in, AScene scene) throws IOException, ParseException {
        IndexFileParser parser = new IndexFileParser(in, scene);
        return IndexFileParser.parseAndReturnAnnotationDefs(null, in, parser);
    }

    public static Map<String, AnnotationDef> parseFile(String filename, AScene scene) throws IOException {
        LineNumberReader in = new LineNumberReader(new FileReader(filename));
        IndexFileParser parser = new IndexFileParser(in, scene);
        return IndexFileParser.parseAndReturnAnnotationDefs(filename, in, parser);
    }

    public static Map<String, AnnotationDef> parseString(String fileContents, AScene scene) throws IOException {
        String filename = "While parsing string: \n----------------BEGIN----------------\n" + fileContents + "----------------END----------------\n";
        LineNumberReader in = new LineNumberReader(new StringReader(fileContents));
        IndexFileParser parser = new IndexFileParser(in, scene);
        return IndexFileParser.parseAndReturnAnnotationDefs(filename, in, parser);
    }

    private static Map<String, AnnotationDef> parseAndReturnAnnotationDefs(String filename, LineNumberReader in, IndexFileParser parser) throws IOException {
        try {
            parser.parse();
            return Collections.unmodifiableMap(parser.defs);
        }
        catch (IOException e) {
            throw filename == null ? new FileIOException(in, (Throwable)e) : new FileIOException(in, filename, (Throwable)e);
        }
        catch (ParseException e) {
            throw filename == null ? new FileIOException(in, (Throwable)e) : new FileIOException(in, filename, (Throwable)e);
        }
    }

    public static Type parseType(String text) {
        StringReader in = new StringReader(text);
        IndexFileParser parser = new IndexFileParser(in, null);
        try {
            parser.st.nextToken();
            return parser.parseType();
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing type from: '" + text + "'", e);
        }
    }

    static {
        String[] knownKeywords_array = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "if", "goto", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
        knownKeywords = new LinkedHashSet<String>();
        Collections.addAll(knownKeywords, knownKeywords_array);
        LinkedHashMap pt = new LinkedHashMap();
        pt.put("byte", Byte.TYPE);
        pt.put("short", Short.TYPE);
        pt.put("int", Integer.TYPE);
        pt.put("long", Long.TYPE);
        pt.put("float", Float.TYPE);
        pt.put("double", Double.TYPE);
        pt.put("char", Character.TYPE);
        pt.put("boolean", Boolean.TYPE);
        pt.put("void", Void.TYPE);
        primitiveTypes = pt;
    }
}

