/*
 * Decompiled with CFR 0.152.
 */
package scenelib.annotations.io.classfile;

import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.TypeAnnotationVisitor;
import scenelib.annotations.io.classfile.InvalidTypeAnnotationException;

public class SafeTypeAnnotationVisitor
implements TypeAnnotationVisitor {
    private final TypeAnnotationVisitor xav;
    private final List<Integer> xIndexArgs;
    private final List<Integer> xLengthArgs;
    private final List<TypeAnnotationPosition.TypePathEntry> xLocationArgs;
    private final List<Integer> xLocationLengthArgs;
    private final List<Integer> xOffsetArgs;
    private final List<Integer> xStartPcArgs;
    private final List<Integer> xTargetTypeArgs;
    private final List<Integer> xParamIndexArgs;
    private final List<Integer> xBoundIndexArgs;
    private final List<Integer> xTypeIndexArgs;
    private int xNameAndArgsCount;

    public SafeTypeAnnotationVisitor(TypeAnnotationVisitor xav) {
        this.xav = xav;
        this.xIndexArgs = new ArrayList<Integer>(1);
        this.xLengthArgs = new ArrayList<Integer>(1);
        this.xLocationArgs = new ArrayList<TypeAnnotationPosition.TypePathEntry>();
        this.xLocationLengthArgs = new ArrayList<Integer>(1);
        this.xOffsetArgs = new ArrayList<Integer>(1);
        this.xStartPcArgs = new ArrayList<Integer>(1);
        this.xTargetTypeArgs = new ArrayList<Integer>(1);
        this.xParamIndexArgs = new ArrayList<Integer>(1);
        this.xBoundIndexArgs = new ArrayList<Integer>(1);
        this.xTypeIndexArgs = new ArrayList<Integer>(1);
        this.xNameAndArgsCount = 0;
    }

    @Override
    public void visit(String name, Object value) {
        this.xav.visit(name, value);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        return this.xav.visitAnnotation(name, desc);
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        return this.xav.visitArray(name);
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        this.xav.visitEnum(name, desc, value);
    }

    @Override
    public void visitXIndex(int index) {
        this.xIndexArgs.add(index);
        this.xav.visitXIndex(index);
    }

    @Override
    public void visitXLength(int length) {
        this.xLengthArgs.add(length);
        this.xav.visitXLength(length);
    }

    @Override
    public void visitXLocation(TypeAnnotationPosition.TypePathEntry location) {
        this.xLocationArgs.add(location);
        this.xav.visitXLocation(location);
    }

    @Override
    public void visitXLocationLength(int location_length) {
        this.xLocationLengthArgs.add(location_length);
        this.xav.visitXLocationLength(location_length);
    }

    @Override
    public void visitXOffset(int offset) {
        this.xOffsetArgs.add(offset);
        this.xav.visitXOffset(offset);
    }

    @Override
    public void visitXNumEntries(int num_entries) {
    }

    @Override
    public void visitXStartPc(int start_pc) {
        this.xStartPcArgs.add(start_pc);
        this.xav.visitXStartPc(start_pc);
    }

    @Override
    public void visitXTargetType(int target_type) {
        this.xTargetTypeArgs.add(target_type);
        this.xav.visitXTargetType(target_type);
    }

    @Override
    public void visitXParamIndex(int param_index) {
        this.xParamIndexArgs.add(param_index);
        this.xav.visitXParamIndex(param_index);
    }

    @Override
    public void visitXBoundIndex(int bound_index) {
        if (bound_index != -1) {
            this.xBoundIndexArgs.add(bound_index);
            this.xav.visitXBoundIndex(bound_index);
        }
    }

    @Override
    public void visitXTypeIndex(int type_index) {
        this.xTypeIndexArgs.add(type_index);
        this.xav.visitXTypeIndex(type_index);
    }

    @Override
    public void visitXExceptionIndex(int exception_index) {
    }

    @Override
    public void visitXNameAndArgsSize() {
        ++this.xNameAndArgsCount;
        this.xav.visitXNameAndArgsSize();
    }

    @Override
    public void visitEnd() {
        if (this.xTargetTypeArgs.size() > 0) {
            this.checkX();
        } else if (this.xIndexArgs.size() != 0 || this.xLengthArgs.size() != 0 || this.xLocationArgs.size() != 0 || this.xLocationLengthArgs.size() != 0 || this.xOffsetArgs.size() != 0 || this.xStartPcArgs.size() != 0) {
            throw new InvalidTypeAnnotationException("No target type was specified, yet other visitX* methods were still called.");
        }
        this.xav.visitEnd();
    }

    private void checkX() {
        if (this.xTargetTypeArgs.size() != 1) {
            throw new InvalidTypeAnnotationException("More than one target type visited.");
        }
        if (this.xNameAndArgsCount != 1) {
            throw new InvalidTypeAnnotationException("Name and args count should  be visited 1 time, actually visited " + this.xNameAndArgsCount + " times.");
        }
        int c = 0;
        if (this.xLocationLengthArgs.size() > 0) {
            c = this.xLocationLengthArgs.get(0);
        }
        switch (TargetType.fromTargetTypeValue(this.xTargetTypeArgs.get(0))) {
            case CAST: {
                this.checkListSize(0, 0, c, 1, 1, 0, 0, 0, 1, "Invalid typecast annotation:");
                break;
            }
            case INSTANCEOF: {
                this.checkListSize(0, 0, c, 1, 1, 0, 0, 0, 0, "Invalid type test annotation:");
                break;
            }
            case NEW: {
                this.checkListSize(0, 0, c, 1, 1, 0, 0, 0, 0, "Invalid object creation annotation:");
                break;
            }
            case METHOD_RECEIVER: {
                this.checkListSize(0, 0, c, 1, 0, 0, 0, 0, 0, "Invalid method receiver annotation:");
                break;
            }
            case LOCAL_VARIABLE: {
                this.checkListSize(1, 1, c, 1, 0, 1, 0, 0, 0, "Invalid local variable annotation:");
                break;
            }
            case METHOD_RETURN: {
                this.checkListSize(0, 0, c, 1, 0, 0, 0, 0, 0, "Invalid method return type annotation:");
                break;
            }
            case METHOD_FORMAL_PARAMETER: {
                this.checkListSize(0, 0, c, 1, 0, 0, 1, 0, 0, "Invalid method parameter annotation:");
                break;
            }
            case FIELD: {
                this.checkListSize(0, 0, c, 1, 0, 0, 0, 0, 0, "Invalid field annotation:");
                break;
            }
            case CLASS_TYPE_PARAMETER: {
                this.checkListSize(0, 0, c, 1, 0, 0, 1, 0, 0, "Invalid class type parameter annotation:");
                break;
            }
            case CLASS_TYPE_PARAMETER_BOUND: {
                this.checkListSize(0, 0, c, 1, 0, 0, 1, 1, 0, "Invalid class type parameter bound annotation:");
                break;
            }
            case METHOD_TYPE_PARAMETER: {
                this.checkListSize(0, 0, c, 1, 0, 0, 1, 0, 0, "Invalid method type parameter annotation:");
                break;
            }
            case METHOD_TYPE_PARAMETER_BOUND: {
                this.checkListSize(0, 0, c, 1, 0, 0, 1, 1, 0, "Invalid method type parameter bound annotation:");
                break;
            }
            case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
            case METHOD_INVOCATION_TYPE_ARGUMENT: 
            case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: 
            case METHOD_REFERENCE_TYPE_ARGUMENT: {
                break;
            }
            case CLASS_EXTENDS: {
                this.checkListSize(0, 0, c, 1, 0, 0, 0, 0, 1, "Invalid class extends/implements annotation:");
                break;
            }
            case THROWS: {
                this.checkListSize(0, 0, c, 1, 0, 0, 0, 0, 1, "Invalid exception type in throws annotation:");
                break;
            }
            default: {
                throw new InvalidTypeAnnotationException("Unknown target type given: " + this.xTargetTypeArgs.get(0));
            }
        }
    }

    private void appendMessage(List<?> list, int idealLength, String methodName, StringBuilder sb) {
        if (list.size() != idealLength) {
            sb.append("\nInvalid method calls: ");
            sb.append(methodName);
            sb.append(" was called ");
            sb.append(list.size());
            sb.append(" times, but should have only been called ");
            sb.append(idealLength);
            sb.append(" times");
        }
    }

    private void checkListSize(int correctLengthIndex, int correctLengthLength, int correctLengthLocation, int correctLengthLocationLength, int correctLengthOffset, int correctLengthStartPc, int correctLengthParamIndex, int correctLengthBoundIndex, int correctLengthTypeIndex, String msg) {
        StringBuilder sb = new StringBuilder();
        this.appendMessage(this.xIndexArgs, correctLengthIndex, "visitXIndex", sb);
        this.appendMessage(this.xLengthArgs, correctLengthLength, "visitXLength", sb);
        this.appendMessage(this.xLocationArgs, correctLengthLocation, "visitXLocation", sb);
        this.appendMessage(this.xLocationLengthArgs, correctLengthLocationLength, "visitXLocationLength", sb);
        this.appendMessage(this.xOffsetArgs, correctLengthOffset, "visitXOffset", sb);
        this.appendMessage(this.xStartPcArgs, correctLengthStartPc, "visitXStartPc", sb);
        this.appendMessage(this.xParamIndexArgs, correctLengthParamIndex, "visitXParamIndex", sb);
        this.appendMessage(this.xBoundIndexArgs, correctLengthBoundIndex, "visitXBoundIndex", sb);
        this.appendMessage(this.xTypeIndexArgs, correctLengthTypeIndex, "VisitXTypeIndex", sb);
        String s2 = sb.toString();
        if (s2.length() > 0) {
            throw new InvalidTypeAnnotationException(msg + s2);
        }
    }
}

