/*
 * Decompiled with CFR 0.152.
 */
package scenelib.annotations.tools;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import plume.FileIOException;
import scenelib.annotations.el.AScene;
import scenelib.annotations.el.DefException;
import scenelib.annotations.io.IndexFileParser;
import scenelib.annotations.io.IndexFileWriter;
import scenelib.annotations.io.JavapParser;
import scenelib.annotations.io.classfile.ClassFileReader;
import scenelib.annotations.io.classfile.ClassFileWriter;

public class Anncat {
    private static void usage() {
        System.err.print("anncat, part of the Annotation File Utilities\n(https://checkerframework.org/annotation-file-utilities/)\nusage: anncat <inspec>* [ --out <outspec> ], where:\n    <inspec> ::=\n        ( --javap <in.javap> )\n        | ( --index <in.jaif> )\n        | ( --class <in.class> )\n    <outspec> ::=\n        ( --index <out.jaif> )\n        | ( --class [ --overwrite ] <orig.class> [ --to <out.class> ] )\nIf outspec is omitted, default is index file to stdout.\n");
    }

    private static void usageAssert(boolean b) {
        if (!b) {
            System.err.println("*** Usage error ***");
            Anncat.usage();
            System.exit(3);
        }
    }

    public static void main(String[] args) {
        Anncat.usageAssert(0 < args.length);
        if (args[0].equals("--help")) {
            Anncat.usage();
            System.exit(0);
        }
        try {
            int idx = 0;
            AScene theScene = new AScene();
            while (idx < args.length && !args[idx].equals("--out")) {
                String infile;
                if (args[idx].equals("--javap")) {
                    Anncat.usageAssert(++idx < args.length);
                    infile = args[idx++];
                    System.out.println("Reading javap file " + infile + "...");
                    JavapParser.parse(infile, theScene);
                    System.out.println("Finished.");
                    continue;
                }
                if (args[idx].equals("--index")) {
                    Anncat.usageAssert(++idx < args.length);
                    infile = args[idx++];
                    System.err.println("Reading index file " + infile + "...");
                    IndexFileParser.parseFile(infile, theScene);
                    System.err.println("Finished.");
                    continue;
                }
                if (args[idx].equals("--class")) {
                    Anncat.usageAssert(++idx < args.length);
                    infile = args[idx++];
                    System.err.println("Reading class file " + infile + "...");
                    ClassFileReader.read(theScene, infile);
                    System.err.println("Finished.");
                    continue;
                }
                Anncat.usageAssert(false);
            }
            if (idx == args.length) {
                System.err.println("Writing index file to standard output...");
                IndexFileWriter.write(theScene, new OutputStreamWriter(System.out));
                System.err.println("Finished.");
            } else {
                Anncat.usageAssert(++idx < args.length);
                if (args[idx].equals("--index")) {
                    Anncat.usageAssert(++idx < args.length);
                    String outfile = args[idx];
                    Anncat.usageAssert(++idx == args.length);
                    System.err.println("Writing index file to " + outfile + "...");
                    IndexFileWriter.write(theScene, new FileWriter(outfile));
                    System.err.println("Finished.");
                } else if (args[idx].equals("--class")) {
                    boolean overwrite;
                    Anncat.usageAssert(++idx < args.length);
                    if (args[idx].equals("--overwrite")) {
                        System.err.println("Overwrite mode enabled.");
                        overwrite = true;
                        Anncat.usageAssert(++idx < args.length);
                    } else {
                        overwrite = false;
                    }
                    String origfile = args[idx];
                    if (++idx < args.length) {
                        Anncat.usageAssert(args[idx].equals("--to"));
                        Anncat.usageAssert(++idx < args.length);
                        String outfile = args[idx];
                        Anncat.usageAssert(++idx == args.length);
                        System.err.println("Reading original class file " + origfile);
                        System.err.println("and writing annotated version to " + outfile + "...");
                        ClassFileWriter.insert(theScene, new FileInputStream(origfile), new FileOutputStream(outfile), overwrite);
                        System.err.println("Finished.");
                    } else {
                        System.err.println("Rewriting class file " + origfile + " with annotations...");
                        ClassFileWriter.insert(theScene, origfile, overwrite);
                        System.err.println("Finished.");
                    }
                } else {
                    Anncat.usageAssert(false);
                }
            }
        }
        catch (FileIOException e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            System.exit(2);
        }
        catch (DefException e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
        System.exit(0);
    }
}

