/*
 * Decompiled with CFR 0.152.
 */
package annotator.find;

import annotator.find.Criterion;
import com.sun.source.tree.IntersectionTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.List;
import scenelib.annotations.el.RelativeLocation;
import scenelib.annotations.io.ASTPath;

public class IntersectionTypeLocationCriterion
implements Criterion {
    private final int typeIndex;

    public IntersectionTypeLocationCriterion(RelativeLocation relativeLocation) {
        this.typeIndex = relativeLocation.type_index;
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath, Tree tree) {
        if (treePath == null) {
            return false;
        }
        assert (treePath.getLeaf() == tree);
        return this.isSatisfiedBy(treePath);
    }

    @Override
    public boolean isSatisfiedBy(TreePath treePath) {
        Object object;
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 != null && (object = treePath2.getLeaf()).getKind() == Tree.Kind.INTERSECTION_TYPE) {
            IntersectionTypeTree intersectionTypeTree = (IntersectionTypeTree)object;
            List<? extends Tree> list = intersectionTypeTree.getBounds();
            Tree tree = treePath.getLeaf();
            if (this.typeIndex < list.size() && tree == list.get(this.typeIndex)) {
                return true;
            }
        }
        if (ASTPath.isTypeKind((Tree.Kind)((Object)(object = treePath.getLeaf().getKind()))) || object == Tree.Kind.MEMBER_SELECT) {
            return this.isSatisfiedBy(treePath.getParentPath());
        }
        return false;
    }

    @Override
    public Criterion.Kind getKind() {
        return Criterion.Kind.INTERSECT_LOCATION;
    }

    public String toString() {
        return "IntersectionTypeLocation: at type index: " + this.typeIndex;
    }
}

