/*
 * Decompiled with CFR 0.152.
 */
package annotator.scanner;

import annotator.scanner.CommonScanner;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LocalVariableScanner
extends CommonScanner {
    private int index = -1;
    private boolean done = false;
    private final Tree varTree;
    private final String varName;
    private static Map<Pair<String, Pair<Integer, Integer>>, String> methodNameIndexMap = new HashMap<Pair<String, Pair<Integer, Integer>>, String>();
    private static Map<String, Map<String, List<Integer>>> methodNameCounter = new HashMap<String, Map<String, List<Integer>>>();

    public static int indexOfVarTree(TreePath treePath, Tree tree, String string) {
        TreePath treePath2 = LocalVariableScanner.findCountingContext(treePath);
        if (treePath2 == null) {
            return -1;
        }
        LocalVariableScanner localVariableScanner = new LocalVariableScanner(tree, string);
        try {
            localVariableScanner.scan(treePath2, null);
        }
        catch (Throwable throwable) {
            System.out.println("LocalVariableScanner: can't locate: " + tree);
            return -2;
        }
        return localVariableScanner.index;
    }

    private LocalVariableScanner(Tree tree, String string) {
        this.varTree = tree;
        this.varName = string;
    }

    @Override
    public Void visitVariable(VariableTree variableTree, Void void_) {
        if (this.varName.equals(variableTree.getName().toString())) {
            if (!this.done) {
                ++this.index;
            }
            if (this.varTree == variableTree) {
                this.done = true;
            }
        }
        return void_;
    }

    public static void addToMethodNameIndexMap(Pair<String, Pair<Integer, Integer>> pair, String string) {
        methodNameIndexMap.put(pair, string);
    }

    public static String getFromMethodNameIndexMap(Pair<String, Pair<Integer, Integer>> pair) {
        return methodNameIndexMap.get(pair);
    }

    public static void addToMethodNameCounter(String string, String string2, Integer n) {
        List<Integer> list;
        Map<String, List<Integer>> map = methodNameCounter.get(string);
        if (map == null) {
            map = new HashMap<String, List<Integer>>();
            methodNameCounter.put(string, map);
        }
        if ((list = map.get(string2)) == null) {
            list = new ArrayList<Integer>();
            map.put(string2, list);
        }
        list.add(n);
    }

    public static List<Integer> getFromMethodNameCounter(String string, String string2) {
        return methodNameCounter.get(string).get(string2);
    }
}

