/*
 * Decompiled with CFR 0.152.
 */
package annotator.scanner;

import annotator.scanner.CommonScanner;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MethodCallScanner
extends CommonScanner {
    private int index = -1;
    private boolean done = false;
    private final Tree tree;
    private static Map<String, List<Integer>> methodNameToMethodCallOffsets = new HashMap<String, List<Integer>>();

    public static int indexOfMethodCallTree(TreePath treePath, Tree tree) {
        TreePath treePath2 = MethodCallScanner.findCountingContext(treePath);
        if (treePath2 == null) {
            return -1;
        }
        MethodCallScanner methodCallScanner = new MethodCallScanner(tree);
        methodCallScanner.scan(treePath2, null);
        return methodCallScanner.index;
    }

    private MethodCallScanner(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, Void void_) {
        if (!this.done) {
            ++this.index;
        }
        if (this.tree == methodInvocationTree) {
            this.done = true;
        }
        return (Void)super.visitMethodInvocation(methodInvocationTree, void_);
    }

    public static void addMethodCallToMethod(String string, Integer n) {
        List<Integer> list = methodNameToMethodCallOffsets.get(string);
        if (list == null) {
            list = new ArrayList<Integer>();
            methodNameToMethodCallOffsets.put(string, list);
        }
        list.add(n);
    }

    public static Integer getMethodCallIndex(String string, Integer n) {
        List<Integer> list = methodNameToMethodCallOffsets.get(string);
        if (list == null) {
            return -1;
        }
        return list.indexOf(n);
    }
}

