/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.guieffect;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import org.checkerframework.checker.guieffect.Effect;
import org.checkerframework.checker.guieffect.GuiEffectTypeFactory;
import org.checkerframework.checker.guieffect.qual.AlwaysSafe;
import org.checkerframework.checker.guieffect.qual.PolyUI;
import org.checkerframework.checker.guieffect.qual.PolyUIEffect;
import org.checkerframework.checker.guieffect.qual.PolyUIType;
import org.checkerframework.checker.guieffect.qual.SafeEffect;
import org.checkerframework.checker.guieffect.qual.UI;
import org.checkerframework.checker.guieffect.qual.UIEffect;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.AnnotatedTypes;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.Pair;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class GuiEffectVisitor
extends BaseTypeVisitor<GuiEffectTypeFactory> {
    protected final boolean debugSpew;
    protected final ArrayDeque<Effect> effStack;
    protected final ArrayDeque<MethodTree> currentMethods;

    public GuiEffectVisitor(BaseTypeChecker checker) {
        super(checker);
        this.debugSpew = checker.getLintOption("debugSpew", false);
        if (this.debugSpew) {
            System.err.println("Running GuiEffectVisitor");
        }
        this.effStack = new ArrayDeque();
        this.currentMethods = new ArrayDeque();
    }

    @Override
    protected GuiEffectTypeFactory createTypeFactory() {
        return new GuiEffectTypeFactory(this.checker, this.debugSpew);
    }

    @Override
    protected void checkMethodInvocability(AnnotatedTypeMirror.AnnotatedExecutableType method, MethodInvocationTree node) {
    }

    @Override
    protected BaseTypeVisitor.OverrideChecker createOverrideChecker(Tree overriderTree, AnnotatedTypeMirror.AnnotatedExecutableType overrider, AnnotatedTypeMirror overridingType, AnnotatedTypeMirror overridingReturnType, AnnotatedTypeMirror.AnnotatedExecutableType overridden, AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType, AnnotatedTypeMirror overriddenReturnType) {
        return new GuiEffectOverrideChecker(overriderTree, overrider, overridingType, overridingReturnType, overridden, overriddenType, overriddenReturnType);
    }

    @Override
    protected Set<? extends AnnotationMirror> getExceptionParameterLowerBoundAnnotations() {
        return Collections.singleton(AnnotationBuilder.fromClass(this.elements, AlwaysSafe.class));
    }

    @Override
    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedDeclaredType declarationType, AnnotatedTypeMirror.AnnotatedDeclaredType useType, Tree tree) {
        boolean ret;
        boolean bl = ret = useType.hasAnnotation(AlwaysSafe.class) || useType.hasAnnotation(PolyAll.class) || useType.hasAnnotation(PolyUI.class) || ((GuiEffectTypeFactory)this.atypeFactory).isPolymorphicType((TypeElement)declarationType.getUnderlyingType().asElement()) || useType.hasAnnotation(UI.class) && declarationType.hasAnnotation(UI.class);
        if (this.debugSpew && !ret) {
            System.err.println("use: " + useType);
            System.err.println("use safe: " + useType.hasAnnotation(AlwaysSafe.class));
            System.err.println("use poly: " + useType.hasAnnotation(PolyUI.class));
            System.err.println("use ui: " + useType.hasAnnotation(UI.class));
            System.err.println("declaration safe: " + declarationType.hasAnnotation(AlwaysSafe.class));
            System.err.println("declaration poly: " + ((GuiEffectTypeFactory)this.atypeFactory).isPolymorphicType((TypeElement)declarationType.getUnderlyingType().asElement()));
            System.err.println("declaration ui: " + declarationType.hasAnnotation(UI.class));
            System.err.println("declaration: " + declarationType);
        }
        return ret;
    }

    @Override
    public Void visitLambdaExpression(LambdaExpressionTree node, Void p) {
        Void v = super.visitLambdaExpression(node, p);
        if (((GuiEffectTypeFactory)this.atypeFactory).isDirectlyMarkedUIThroughInference(node)) {
            TreePath path = this.visitorState.getPath();
            while (path.getLeaf() != node) {
                assert (!path.getLeaf().getKind().equals((Object)Tree.Kind.COMPILATION_UNIT));
                path = path.getParentPath();
            }
            this.scanUp(path);
        }
        return v;
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        Tree callerTree;
        if (this.debugSpew) {
            System.err.println("For invocation " + node + " in " + this.currentMethods.peek().getName());
        }
        ExecutableElement methodElt = TreeUtils.elementFromUse(node);
        if (this.debugSpew) {
            System.err.println("methodElt found");
        }
        if ((callerTree = TreeUtils.enclosingMethodOrLambda(this.getCurrentPath())) == null) {
            if (this.debugSpew) {
                System.err.println("No enclosing method: likely static initializer");
            }
            return super.visitMethodInvocation(node, p);
        }
        if (this.debugSpew) {
            System.err.println("callerTree found: " + (Object)((Object)callerTree.getKind()));
        }
        Effect targetEffect = ((GuiEffectTypeFactory)this.atypeFactory).getComputedEffectAtCallsite(node, this.visitorState.getMethodReceiver(), methodElt);
        Effect callerEffect = null;
        if (callerTree.getKind() == Tree.Kind.METHOD) {
            ExecutableElement callerElt = TreeUtils.elementFromDeclaration((MethodTree)callerTree);
            if (this.debugSpew) {
                System.err.println("callerElt found");
            }
            callerEffect = ((GuiEffectTypeFactory)this.atypeFactory).getDeclaredEffect(callerElt);
            DeclaredType callerReceiverType = this.visitorState.getClassType().getUnderlyingType();
            assert (callerReceiverType != null);
            TypeElement callerReceiverElt = (TypeElement)callerReceiverType.asElement();
            if (TypesUtils.isAnonymous(callerReceiverType) && !this.effStack.peek().isUI() && !((GuiEffectTypeFactory)this.atypeFactory).fromElement(callerReceiverElt).hasAnnotation(AlwaysSafe.class) && !((GuiEffectTypeFactory)this.atypeFactory).fromElement(callerReceiverElt).hasAnnotation(UI.class)) {
                boolean overridesPolymorphic = false;
                Map<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> overriddenMethods = AnnotatedTypes.overriddenMethods(this.elements, this.atypeFactory, callerElt);
                for (Map.Entry<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> pair : overriddenMethods.entrySet()) {
                    AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType = pair.getKey();
                    AnnotatedTypeMirror.AnnotatedExecutableType overriddenMethod = AnnotatedTypes.asMemberOf(this.types, (AnnotatedTypeFactory)this.atypeFactory, (AnnotatedTypeMirror)overriddenType, pair.getValue());
                    if (((GuiEffectTypeFactory)this.atypeFactory).getDeclAnnotation(overriddenMethod.getElement(), PolyUIEffect.class) == null || ((GuiEffectTypeFactory)this.atypeFactory).getDeclAnnotation(overriddenType.getUnderlyingType().asElement(), PolyUIType.class) == null) continue;
                    overridesPolymorphic = true;
                    break;
                }
                if (overridesPolymorphic && targetEffect.isUI()) {
                    ((GuiEffectTypeFactory)this.atypeFactory).constrainAnonymousClassToUI(callerReceiverElt);
                    callerEffect = ((GuiEffectTypeFactory)this.atypeFactory).getDeclaredEffect(callerElt);
                    this.effStack.pop();
                    this.effStack.push(callerEffect);
                }
            }
            assert (this.currentMethods.peek() == null || callerEffect.equals(this.effStack.peek()));
        } else if (callerTree.getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
            callerEffect = ((GuiEffectTypeFactory)this.atypeFactory).getInferedEffectForLambdaExpression((LambdaExpressionTree)callerTree);
            if (targetEffect.isUI() && callerEffect.isPoly()) {
                ((GuiEffectTypeFactory)this.atypeFactory).constrainLambdaToUI((LambdaExpressionTree)callerTree);
                callerEffect = new Effect(UIEffect.class);
            }
        }
        assert (callerEffect != null);
        if (!Effect.lessThanOrEqualTo(targetEffect, callerEffect)) {
            this.checker.report(Result.failure("call.invalid.ui", targetEffect, callerEffect), node);
            if (this.debugSpew) {
                System.err.println("Issuing error for node: " + node);
            }
        }
        if (this.debugSpew) {
            System.err.println("Successfully finished main non-recursive checkinv of invocation " + node);
        }
        return super.visitMethodInvocation(node, p);
    }

    @Override
    public Void visitMethod(MethodTree node, Void p) {
        ExecutableElement methElt = TreeUtils.elementFromDeclaration(node);
        if (this.debugSpew) {
            System.err.println("\nVisiting method " + methElt);
        }
        assert (methElt != null);
        AnnotationMirror targetUIP = ((GuiEffectTypeFactory)this.atypeFactory).getDeclAnnotation(methElt, UIEffect.class);
        AnnotationMirror targetSafeP = ((GuiEffectTypeFactory)this.atypeFactory).getDeclAnnotation(methElt, SafeEffect.class);
        AnnotationMirror targetPolyP = ((GuiEffectTypeFactory)this.atypeFactory).getDeclAnnotation(methElt, PolyUIEffect.class);
        TypeElement targetClassElt = (TypeElement)methElt.getEnclosingElement();
        if (targetUIP != null && (targetSafeP != null || targetPolyP != null) || targetSafeP != null && targetPolyP != null) {
            this.checker.report(Result.failure("annotations.conflicts", new Object[0]), node);
        }
        if (targetPolyP != null && !((GuiEffectTypeFactory)this.atypeFactory).isPolymorphicType(targetClassElt)) {
            this.checker.report(Result.failure("polymorphism.invalid", new Object[0]), node);
        }
        if (targetUIP != null && ((GuiEffectTypeFactory)this.atypeFactory).isUIType(targetClassElt)) {
            this.checker.report(Result.warning("effects.redundant.uitype", new Object[0]), node);
        }
        Effect.EffectRange range = ((GuiEffectTypeFactory)this.atypeFactory).findInheritedEffectRange((TypeElement)methElt.getEnclosingElement(), methElt, true, node);
        this.currentMethods.addFirst(node);
        this.effStack.addFirst(((GuiEffectTypeFactory)this.atypeFactory).getDeclaredEffect(methElt));
        if (this.debugSpew) {
            System.err.println("Pushing " + this.effStack.peek() + " onto the stack when checking " + methElt);
        }
        Void ret = super.visitMethod(node, p);
        this.currentMethods.removeFirst();
        this.effStack.removeFirst();
        return ret;
    }

    @Override
    public Void visitNewClass(NewClassTree node, Void p) {
        Void v = super.visitNewClass(node, p);
        if (((GuiEffectTypeFactory)this.atypeFactory).isDirectlyMarkedUIThroughInference(node)) {
            TreePath path = this.visitorState.getPath();
            while (path.getLeaf() != node) {
                assert (!path.getLeaf().getKind().equals((Object)Tree.Kind.COMPILATION_UNIT));
                path = path.getParentPath();
            }
            this.scanUp(this.visitorState.getPath().getParentPath());
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanUp(TreePath path) {
        Tree tree = path.getLeaf();
        switch (tree.getKind()) {
            case ASSIGNMENT: {
                AssignmentTree assignmentTree = (AssignmentTree)tree;
                this.commonAssignmentCheck(((GuiEffectTypeFactory)this.atypeFactory).getAnnotatedType(assignmentTree.getVariable()), ((GuiEffectTypeFactory)this.atypeFactory).getAnnotatedType(assignmentTree.getExpression()), assignmentTree.getExpression(), "assignment.type.incompatible");
                break;
            }
            case VARIABLE: {
                VariableTree variableTree = (VariableTree)tree;
                this.commonAssignmentCheck(((GuiEffectTypeFactory)this.atypeFactory).getAnnotatedType(variableTree), ((GuiEffectTypeFactory)this.atypeFactory).getAnnotatedType(variableTree.getInitializer()), variableTree.getInitializer(), "assignment.type.incompatible");
                break;
            }
            case METHOD_INVOCATION: {
                MethodInvocationTree invocationTree = (MethodInvocationTree)tree;
                List<? extends ExpressionTree> args = invocationTree.getArguments();
                AnnotatedTypeFactory.ParameterizedExecutableType mType = ((GuiEffectTypeFactory)this.atypeFactory).methodFromUse(invocationTree);
                AnnotatedTypeMirror.AnnotatedExecutableType invokedMethod = mType.executableType;
                List<AnnotatedTypeMirror> argsTypes = AnnotatedTypes.expandVarArgs(this.atypeFactory, invokedMethod, invocationTree.getArguments());
                for (int i = 0; i < args.size(); ++i) {
                    if (args.get(i).getKind() != Tree.Kind.NEW_CLASS && args.get(i).getKind() != Tree.Kind.LAMBDA_EXPRESSION) continue;
                    this.commonAssignmentCheck(argsTypes.get(i), ((GuiEffectTypeFactory)this.atypeFactory).getAnnotatedType(args.get(i)), args.get(i), "argument.type.incompatible");
                }
                break;
            }
            case RETURN: {
                ReturnTree returnTree = (ReturnTree)tree;
                if (returnTree.getExpression().getKind() != Tree.Kind.NEW_CLASS && returnTree.getExpression().getKind() != Tree.Kind.LAMBDA_EXPRESSION) break;
                Tree enclosing = TreeUtils.enclosingMethodOrLambda(path);
                AnnotatedTypeMirror ret = null;
                if (enclosing.getKind() == Tree.Kind.METHOD) {
                    MethodTree enclosingMethod = (MethodTree)enclosing;
                    boolean valid = this.validateTypeOf(enclosing);
                    if (valid) {
                        ret = ((GuiEffectTypeFactory)this.atypeFactory).getMethodReturnType(enclosingMethod, returnTree);
                    }
                } else {
                    ret = ((AnnotatedTypeMirror.AnnotatedExecutableType)((GuiEffectTypeFactory)this.atypeFactory).getFnInterfaceFromTree((LambdaExpressionTree)((LambdaExpressionTree)enclosing)).second).getReturnType();
                }
                if (ret == null) break;
                Pair<Tree, AnnotatedTypeMirror> preAssCtxt = this.visitorState.getAssignmentContext();
                try {
                    this.visitorState.setAssignmentContext(Pair.of(returnTree, ret));
                    this.commonAssignmentCheck(ret, ((GuiEffectTypeFactory)this.atypeFactory).getAnnotatedType(returnTree.getExpression()), returnTree.getExpression(), "return.type.incompatible");
                    break;
                }
                finally {
                    this.visitorState.setAssignmentContext(preAssCtxt);
                }
            }
            case METHOD: {
                return;
            }
            case CLASS: {
                assert (false);
                return;
            }
            default: {
                this.scanUp(path.getParentPath());
            }
        }
    }

    protected class GuiEffectOverrideChecker
    extends BaseTypeVisitor.OverrideChecker {
        @Override
        protected boolean checkReceiverOverride() {
            AnnotatedTypeMirror.AnnotatedDeclaredType overriddenReceiver = this.overrider.getReceiverType().getErased().shallowCopy(false);
            overriddenReceiver.addAnnotations(this.overridden.getReceiverType().getAnnotations());
            if (!((GuiEffectTypeFactory)GuiEffectVisitor.this.atypeFactory).getTypeHierarchy().isSubtype(overriddenReceiver, this.overrider.getReceiverType().getErased())) {
                boolean safeReceiverOverride;
                boolean safeParent = this.overriddenType.getAnnotation(AlwaysSafe.class) != null;
                boolean polyParentDecl = ((GuiEffectTypeFactory)GuiEffectVisitor.this.atypeFactory).getDeclAnnotation(this.overriddenType.getUnderlyingType().asElement(), PolyUIType.class) != null;
                boolean bl = safeReceiverOverride = this.overrider.getReceiverType().getAnnotation(AlwaysSafe.class) != null;
                if (safeParent && polyParentDecl && safeReceiverOverride) {
                    return true;
                }
                GuiEffectVisitor.this.checker.report(Result.failure("override.receiver.invalid", this.overriderMeth, this.overriderTyp, this.overriddenMeth, this.overriddenTyp, this.overrider.getReceiverType(), this.overridden.getReceiverType()), this.overriderTree);
                return false;
            }
            return true;
        }

        public GuiEffectOverrideChecker(Tree overriderTree, AnnotatedTypeMirror.AnnotatedExecutableType overrider, AnnotatedTypeMirror overridingType, AnnotatedTypeMirror overridingReturnType, AnnotatedTypeMirror.AnnotatedExecutableType overridden, AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType, AnnotatedTypeMirror overriddenReturnType) {
            super(GuiEffectVisitor.this, overriderTree, overrider, overridingType, overridingReturnType, overridden, overriddenType, overriddenReturnType);
        }
    }
}

