/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.units;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.Elements;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.units.qual.Prefix;
import org.checkerframework.checker.units.qual.UnknownUnits;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;

public class UnitsRelationsTools {
    public static @Nullable AnnotationMirror buildAnnoMirrorWithSpecificPrefix(ProcessingEnvironment env, CharSequence annoClass, Prefix p) {
        AnnotationBuilder builder = new AnnotationBuilder(env, annoClass);
        builder.setValue((CharSequence)"value", p);
        return builder.build();
    }

    public static @Nullable AnnotationMirror buildAnnoMirrorWithNoPrefix(ProcessingEnvironment env, CharSequence annoClass) {
        return AnnotationBuilder.fromName(env.getElementUtils(), annoClass);
    }

    public static @Nullable Prefix getPrefix(AnnotatedTypeMirror annoType) {
        Prefix result = null;
        for (AnnotationMirror mirror : annoType.getAnnotations()) {
            result = UnitsRelationsTools.getPrefix(mirror);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    public static @Nullable Prefix getPrefix(AnnotationMirror unitsAnnotation) {
        AnnotationValue annotationValue = UnitsRelationsTools.getAnnotationMirrorPrefix(unitsAnnotation);
        if (UnitsRelationsTools.hasNoPrefix(annotationValue)) {
            return null;
        }
        String prefixString = annotationValue.getValue().toString();
        for (Prefix prefix : Prefix.values()) {
            if (!prefixString.equals(prefix.toString())) continue;
            return prefix;
        }
        return null;
    }

    public static boolean hasNoPrefix(AnnotatedTypeMirror annoType) {
        for (AnnotationMirror mirror : annoType.getAnnotations()) {
            if (UnitsRelationsTools.hasNoPrefix(mirror)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasNoPrefix(AnnotationMirror unitsAnnotation) {
        AnnotationValue annotationValue = UnitsRelationsTools.getAnnotationMirrorPrefix(unitsAnnotation);
        return UnitsRelationsTools.hasNoPrefix(annotationValue);
    }

    private static boolean hasNoPrefix(AnnotationValue annotationValue) {
        return annotationValue == null;
    }

    private static @Nullable AnnotationValue getAnnotationMirrorPrefix(AnnotationMirror unitsAnnotation) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = unitsAnnotation.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals("value")) continue;
            return entry.getValue();
        }
        return null;
    }

    public static @Nullable AnnotationMirror removePrefix(Elements elements, AnnotationMirror unitsAnnotation) {
        if (UnitsRelationsTools.hasNoPrefix(unitsAnnotation)) {
            return unitsAnnotation;
        }
        return AnnotationBuilder.fromName(elements, unitsAnnotation.getAnnotationType().toString());
    }

    public static AnnotatedTypeMirror removePrefix(Elements elements, AnnotatedTypeMirror annoType) {
        AnnotatedTypeMirror result = annoType.deepCopy(false);
        Set<AnnotationMirror> annos = annoType.getAnnotations();
        for (AnnotationMirror anno : annos) {
            AnnotationMirror cleanedMirror = UnitsRelationsTools.removePrefix(elements, anno);
            if (cleanedMirror != null) {
                result.addAnnotation(cleanedMirror);
                continue;
            }
            result.addAnnotation(anno);
        }
        return result;
    }

    public static boolean hasNoUnits(AnnotatedTypeMirror annoType) {
        return annoType.getAnnotation(UnknownUnits.class) != null;
    }

    public static boolean hasSpecificUnit(AnnotatedTypeMirror annoType, AnnotationMirror unitsAnnotation) {
        return AnnotationUtils.containsSame(annoType.getAnnotations(), unitsAnnotation);
    }

    public static boolean hasSpecificUnitIgnoringPrefix(AnnotatedTypeMirror annoType, AnnotationMirror unitsAnnotation) {
        return AnnotationUtils.containsSameByName(annoType.getAnnotations(), unitsAnnotation);
    }

    public static @Nullable AnnotationMirror buildAnnoMirrorWithSpecificPrefix(ProcessingEnvironment env, Class<? extends Annotation> annoClass, Prefix p) {
        AnnotationBuilder builder = new AnnotationBuilder(env, annoClass.getCanonicalName());
        builder.setValue((CharSequence)"value", p);
        return builder.build();
    }

    public static @Nullable AnnotationMirror buildAnnoMirrorWithDefaultPrefix(ProcessingEnvironment env, Class<? extends Annotation> annoClass) {
        return UnitsRelationsTools.buildAnnoMirrorWithSpecificPrefix(env, annoClass, Prefix.one);
    }

    static @Nullable AnnotationMirror buildAnnoMirrorWithNoPrefix(ProcessingEnvironment env, Class<? extends Annotation> annoClass) {
        return AnnotationBuilder.fromClass(env.getElementUtils(), annoClass);
    }
}

