/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.common.value.util;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Range {
    public final long from;
    public final long to;
    public static boolean ignoreOverflow = false;
    public static final Range EVERYTHING = new Range(Long.MIN_VALUE, Long.MAX_VALUE);
    public static final Range INT_EVERYTHING = new Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
    public static final Range SHORT_EVERYTHING = new Range(-32768L, 32767L);
    public static final Range CHAR_EVERYTHING = new Range(0L, 65535L);
    public static final Range BYTE_EVERYTHING = new Range(-128L, 127L);
    public static final Range NOTHING = new Range();
    private static long integerWidth = 0x100000000L;
    private static long shortWidth = 65536L;
    private static long charWidth = 65536L;
    private static long byteWidth = 256L;
    private static final BigInteger longWidth = BigInteger.valueOf(Long.MAX_VALUE).subtract(BigInteger.valueOf(Long.MIN_VALUE)).add(BigInteger.ONE);

    public Range(long from, long to) {
        if (from > to) {
            throw new IllegalArgumentException(String.format("Invalid Range: %s %s", from, to));
        }
        this.from = from;
        this.to = to;
    }

    private Range() {
        this.from = Long.MAX_VALUE;
        this.to = Long.MIN_VALUE;
    }

    private Range createRangeOrNothing(long from, long to) {
        if (from <= to) {
            return new Range(from, to);
        }
        return NOTHING;
    }

    public String toString() {
        if (this.isNothing()) {
            return "[]";
        }
        return String.format("[%s..%s]", this.from, this.to);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Range) {
            Range range = (Range)obj;
            return this.from == range.from && this.to == range.to;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to);
    }

    public boolean isLongEverything() {
        return this.from == Long.MIN_VALUE && this.to == Long.MAX_VALUE;
    }

    public boolean isIntEverything() {
        return this.from == Integer.MIN_VALUE && this.to == Integer.MAX_VALUE;
    }

    public boolean isShortEverything() {
        return this.from == -32768L && this.to == 32767L;
    }

    public boolean isCharEverything() {
        return this.from == 0L && this.to == 65535L;
    }

    public boolean isByteEverything() {
        return this.from == -128L && this.to == 127L;
    }

    public boolean isNothing() {
        return this == NOTHING;
    }

    public Range intRange() {
        if (this.isNothing()) {
            return this;
        }
        if (ignoreOverflow) {
            return new Range(Math.max(this.from, Integer.MIN_VALUE), Math.min(this.to, Integer.MAX_VALUE));
        }
        if (this.isWiderThan(integerWidth)) {
            return INT_EVERYTHING;
        }
        int intFrom = (int)this.from;
        int intTo = (int)this.to;
        if (intFrom <= intTo) {
            return new Range(intFrom, intTo);
        }
        return INT_EVERYTHING;
    }

    public Range shortRange() {
        if (this.isNothing()) {
            return this;
        }
        if (ignoreOverflow) {
            return new Range(Math.max(this.from, -32768L), Math.min(this.to, 32767L));
        }
        if (this.isWiderThan(shortWidth)) {
            return SHORT_EVERYTHING;
        }
        short shortFrom = (short)this.from;
        short shortTo = (short)this.to;
        if (shortFrom <= shortTo) {
            return new Range(shortFrom, shortTo);
        }
        return SHORT_EVERYTHING;
    }

    public Range charRange() {
        if (this.isNothing()) {
            return this;
        }
        if (ignoreOverflow) {
            return new Range(Math.max(this.from, 0L), Math.min(this.to, 65535L));
        }
        if (this.isWiderThan(charWidth)) {
            return CHAR_EVERYTHING;
        }
        char charFrom = (char)this.from;
        char charTo = (char)this.to;
        if (charFrom <= charTo) {
            return new Range(charFrom, charTo);
        }
        return CHAR_EVERYTHING;
    }

    public Range byteRange() {
        if (this.isNothing()) {
            return this;
        }
        if (ignoreOverflow) {
            return new Range(Math.max(this.from, -128L), Math.min(this.to, 127L));
        }
        if (this.isWiderThan(byteWidth)) {
            return BYTE_EVERYTHING;
        }
        byte byteFrom = (byte)this.from;
        byte byteTo = (byte)this.to;
        if (byteFrom <= byteTo) {
            return new Range(byteFrom, byteTo);
        }
        return BYTE_EVERYTHING;
    }

    public boolean contains(long element) {
        return this.from <= element && element <= this.to;
    }

    public boolean contains(Range other) {
        return this.from <= other.from && other.to <= this.to;
    }

    public Range union(Range right) {
        if (this.isNothing()) {
            return right;
        }
        if (right.isNothing()) {
            return this;
        }
        long resultFrom = Math.min(this.from, right.from);
        long resultTo = Math.max(this.to, right.to);
        return new Range(resultFrom, resultTo);
    }

    public Range intersect(Range right) {
        if (this.isNothing() || right.isNothing()) {
            return NOTHING;
        }
        long resultFrom = Math.max(this.from, right.from);
        long resultTo = Math.min(this.to, right.to);
        return this.createRangeOrNothing(resultFrom, resultTo);
    }

    public Range plus(Range right) {
        if (this.isNothing() || right.isNothing()) {
            return NOTHING;
        }
        if (this.isWithinHalfLong() && right.isWithinHalfLong()) {
            long resultFrom = this.from + right.from;
            long resultTo = this.to + right.to;
            if (this.from > this.to) {
                return EVERYTHING;
            }
            return new Range(resultFrom, resultTo);
        }
        BigInteger bigFrom = BigInteger.valueOf(this.from).add(BigInteger.valueOf(right.from));
        BigInteger bigTo = BigInteger.valueOf(this.to).add(BigInteger.valueOf(right.to));
        return this.bigRangeToLongRange(bigFrom, bigTo);
    }

    public Range minus(Range right) {
        if (this.isNothing() || right.isNothing()) {
            return NOTHING;
        }
        if (this.isWithinHalfLong() && right.isWithinHalfLong()) {
            long resultFrom = this.from - right.to;
            long resultTo = this.to - right.from;
            return new Range(resultFrom, resultTo);
        }
        BigInteger bigFrom = BigInteger.valueOf(this.from).subtract(BigInteger.valueOf(right.to));
        BigInteger bigTo = BigInteger.valueOf(this.to).subtract(BigInteger.valueOf(right.from));
        return this.bigRangeToLongRange(bigFrom, bigTo);
    }

    public Range times(Range right) {
        if (this.isNothing() || right.isNothing()) {
            return NOTHING;
        }
        if (this.isWithinInteger() && right.isWithinInteger()) {
            List<Long> possibleValues = Arrays.asList(this.from * right.from, this.from * right.to, this.to * right.from, this.to * right.to);
            return new Range(Collections.min(possibleValues), Collections.max(possibleValues));
        }
        List<BigInteger> bigPossibleValues = Arrays.asList(BigInteger.valueOf(this.from).multiply(BigInteger.valueOf(right.from)), BigInteger.valueOf(this.from).multiply(BigInteger.valueOf(right.to)), BigInteger.valueOf(this.to).multiply(BigInteger.valueOf(right.from)), BigInteger.valueOf(this.to).multiply(BigInteger.valueOf(right.to)));
        BigInteger bigFrom = Collections.min(bigPossibleValues);
        BigInteger bigTo = Collections.max(bigPossibleValues);
        return this.bigRangeToLongRange(bigFrom, bigTo);
    }

    public Range divide(Range right) {
        long resultTo;
        long resultFrom;
        if (this.isNothing() || right.isNothing()) {
            return NOTHING;
        }
        if (right.from == 0L && right.to == 0L) {
            return NOTHING;
        }
        if (this.from == Long.MIN_VALUE && right.contains(-1L)) {
            if (this.from != this.to) {
                return EVERYTHING;
            }
            if (right.from != right.to) {
                return new Range(Long.MIN_VALUE, 0x4000000000000000L);
            }
            return new Range(Long.MIN_VALUE, Long.MIN_VALUE);
        }
        if (this.from > 0L) {
            if (right.from >= 0L) {
                resultFrom = this.from / Math.max(right.to, 1L);
                resultTo = this.to / Math.max(right.from, 1L);
            } else if (right.to <= 0L) {
                resultFrom = this.to / Math.min(right.to, -1L);
                resultTo = this.from / Math.min(right.from, -1L);
            } else {
                resultFrom = -this.to;
                resultTo = this.to;
            }
        } else if (this.to < 0L) {
            if (right.from >= 0L) {
                resultFrom = this.from / Math.max(right.from, 1L);
                resultTo = this.to / Math.max(right.to, 1L);
            } else if (right.to <= 0L) {
                resultFrom = this.to / Math.min(right.from, -1L);
                resultTo = this.from / Math.min(right.to, -1L);
            } else {
                resultFrom = this.from;
                resultTo = -this.from;
            }
        } else if (right.from >= 0L) {
            resultFrom = this.from / Math.max(right.from, 1L);
            resultTo = this.to / Math.max(right.from, 1L);
        } else if (right.to <= 0L) {
            resultFrom = this.to / Math.min(right.to, -1L);
            resultTo = this.from / Math.min(right.to, -1L);
        } else {
            resultFrom = Math.min(this.from, -this.to);
            resultTo = Math.max(-this.from, this.to);
        }
        return new Range(resultFrom, resultTo);
    }

    public Range remainder(Range right) {
        if (this.isNothing() || right.isNothing()) {
            return NOTHING;
        }
        if (right.from == 0L && right.to == 0L) {
            return NOTHING;
        }
        if (right.from == Long.MIN_VALUE) {
            Range range = this.from == Long.MIN_VALUE ? (this.to == Long.MIN_VALUE ? new Range(0L, 0L) : new Range(this.from + 1L, this.to).union(new Range(0L, 0L))) : this;
            if (right.to > Long.MIN_VALUE) {
                Range rangeAdditional = this.remainder(new Range(right.from + 1L, right.to));
                range = range.union(rangeAdditional);
            }
            return range;
        }
        Range range1 = new Range(Math.max(-9223372036854775807L, this.from), Math.max(-9223372036854775807L, this.to)).union(new Range(0L, 0L));
        long maxAbsolute = Math.max(Math.abs(right.from), Math.abs(right.to));
        Range range2 = new Range(-maxAbsolute + 1L, maxAbsolute - 1L);
        return range1.intersect(range2);
    }

    public Range shiftLeft(Range right) {
        if (this.isNothing() || right.isNothing()) {
            return NOTHING;
        }
        if (right.isWithin(0L, 31L)) {
            if (this.isWithinInteger()) {
                long resultFrom = this.from << (int)(this.from >= 0L ? right.from : right.to);
                long resultTo = this.to << (int)(this.to >= 0L ? right.to : right.from);
                return new Range(resultFrom, resultTo);
            }
            BigInteger bigFrom = BigInteger.valueOf(this.from).shiftLeft(this.from >= 0L ? (int)right.from : (int)right.to);
            BigInteger bigTo = BigInteger.valueOf(this.to).shiftLeft(this.to >= 0L ? (int)right.to : (int)right.from);
            return this.bigRangeToLongRange(bigFrom, bigTo);
        }
        return EVERYTHING;
    }

    public Range signedShiftRight(Range right) {
        if (this.isNothing() || right.isNothing()) {
            return NOTHING;
        }
        if (this.isWithinInteger() && right.isWithin(0L, 31L)) {
            long resultFrom = this.from >> (int)(this.from >= 0L ? right.to : right.from);
            long resultTo = this.to >> (int)(this.to >= 0L ? right.from : right.to);
            return new Range(resultFrom, resultTo);
        }
        return EVERYTHING;
    }

    public Range unsignedShiftRight(Range right) {
        if (this.from >= 0L) {
            return this.signedShiftRight(right);
        }
        if (this.isNothing() || right.isNothing()) {
            return NOTHING;
        }
        return EVERYTHING;
    }

    public Range bitwiseAnd(Range right) {
        if (this.isNothing() || right.isNothing()) {
            return NOTHING;
        }
        if (right.isConstant()) {
            long mask = right.from;
            if (mask >= 0L) {
                if (this.from >= 0L) {
                    return new Range(0L, Math.min(mask, this.to));
                }
                if (this.to < 0L) {
                    return new Range(0L, Math.min(mask, this.noSignBit(this.to)));
                }
                return new Range(0L, mask);
            }
            if (this.from >= 0L) {
                return new Range(0L, Math.min(this.noSignBit(mask), this.to));
            }
            if (this.to < 0L) {
                return new Range(Long.MIN_VALUE, Math.min(mask, this.to));
            }
            return new Range(Long.MIN_VALUE, Math.min(this.noSignBit(mask), this.to));
        }
        return EVERYTHING;
    }

    private long noSignBit(Long mask) {
        return mask & Long.MAX_VALUE;
    }

    public Range bitwiseOr(Range right) {
        if (this.isNothing() || right.isNothing()) {
            return NOTHING;
        }
        return EVERYTHING;
    }

    public Range bitwiseXor(Range right) {
        if (this.isNothing() || right.isNothing()) {
            return NOTHING;
        }
        return EVERYTHING;
    }

    public Range unaryPlus() {
        return this;
    }

    public Range unaryMinus() {
        if (this.isNothing()) {
            return NOTHING;
        }
        if (this.from == Long.MIN_VALUE && this.from != this.to) {
            return EVERYTHING;
        }
        return new Range(-this.to, -this.from);
    }

    public Range bitwiseComplement() {
        if (this.isNothing()) {
            return NOTHING;
        }
        return new Range(this.to ^ 0xFFFFFFFFFFFFFFFFL, this.from ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public Range refineLessThan(Range right) {
        if (this.isNothing() || right.isNothing()) {
            return NOTHING;
        }
        if (right.to == Long.MIN_VALUE) {
            return NOTHING;
        }
        long resultTo = Math.min(this.to, right.to - 1L);
        return this.createRangeOrNothing(this.from, resultTo);
    }

    public Range refineLessThanEq(Range right) {
        if (this.isNothing() || right.isNothing()) {
            return NOTHING;
        }
        long resultTo = Math.min(this.to, right.to);
        return this.createRangeOrNothing(this.from, resultTo);
    }

    public Range refineGreaterThan(Range right) {
        if (this.isNothing() || right.isNothing()) {
            return NOTHING;
        }
        if (right.from == Long.MAX_VALUE) {
            return NOTHING;
        }
        long resultFrom = Math.max(this.from, right.from + 1L);
        return this.createRangeOrNothing(resultFrom, this.to);
    }

    public Range refineGreaterThanEq(Range right) {
        if (this.isNothing() || right.isNothing()) {
            return NOTHING;
        }
        long resultFrom = Math.max(this.from, right.from);
        return this.createRangeOrNothing(resultFrom, this.to);
    }

    public Range refineEqualTo(Range right) {
        return this.intersect(right);
    }

    public Range refineNotEqualTo(Range right) {
        if (right.isConstant()) {
            if (this.to == right.to) {
                return new Range(this.from, this.to - 1L);
            }
            if (this.from == right.from) {
                return new Range(this.from + 1L, this.to);
            }
        }
        return this;
    }

    public boolean isWiderThan(long value) {
        if (this.isWithin(-4611686018427387903L, 0x3FFFFFFFFFFFFFFFL)) {
            return this.to - this.from + 1L > value;
        }
        return BigInteger.valueOf(this.to).subtract(BigInteger.valueOf(this.from)).add(BigInteger.ONE).compareTo(BigInteger.valueOf(value)) > 0;
    }

    public boolean isConstant() {
        return this.from == this.to;
    }

    public boolean isWithin(long lb, long ub) {
        return this.from >= lb && this.to <= ub;
    }

    private boolean isWithinHalfLong() {
        return this.isWithin(-4611686018427387904L, 0x3FFFFFFFFFFFFFFFL);
    }

    private boolean isWithinInteger() {
        return this.isWithin(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private Range bigRangeToLongRange(BigInteger bigFrom, BigInteger bigTo) {
        long resultTo;
        long resultFrom;
        BigInteger numValues = bigTo.subtract(bigFrom).add(BigInteger.ONE);
        if (ignoreOverflow) {
            BigInteger longMin = BigInteger.valueOf(Long.MIN_VALUE);
            resultFrom = bigFrom.max(longMin).longValue();
            BigInteger longMax = BigInteger.valueOf(Long.MAX_VALUE);
            resultTo = bigTo.min(longMax).longValue();
        } else {
            if (numValues.compareTo(longWidth) > 0) {
                return EVERYTHING;
            }
            resultFrom = bigFrom.longValue();
            resultTo = bigTo.longValue();
        }
        if (resultFrom <= resultTo) {
            return new Range(resultFrom, resultTo);
        }
        return EVERYTHING;
    }
}

