/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.cfg.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.checkerframework.errorprone.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.errorprone.dataflow.cfg.block.Block;
import org.checkerframework.errorprone.org.plumelib.util.ArraySet;

public abstract class BlockImpl
implements Block {
    protected final Block.BlockType type;
    protected final Set<BlockImpl> predecessors;
    static final AtomicLong nextUid = new AtomicLong(0L);
    final long uid = nextUid.getAndIncrement();

    @Override
    public long getUid(@UnknownInitialization BlockImpl this) {
        return this.uid;
    }

    protected BlockImpl(Block.BlockType type) {
        this.type = type;
        this.predecessors = new ArraySet<BlockImpl>(2);
    }

    @Override
    public Block.BlockType getType() {
        return this.type;
    }

    @Override
    public List<Block> getPredecessors() {
        return new ArrayList<Block>(this.predecessors);
    }

    public void addPredecessor(BlockImpl pred) {
        this.predecessors.add(pred);
    }

    public void removePredecessor(BlockImpl pred) {
        this.predecessors.remove(pred);
    }
}

