/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.cfg.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.cfg.block.Block;
import org.checkerframework.errorprone.dataflow.cfg.block.BlockImpl;
import org.checkerframework.errorprone.dataflow.cfg.block.ExceptionBlock;
import org.checkerframework.errorprone.dataflow.cfg.block.SingleSuccessorBlockImpl;
import org.checkerframework.errorprone.dataflow.cfg.node.Node;
import org.checkerframework.errorprone.javacutil.BugInCF;
import org.checkerframework.errorprone.org.plumelib.util.ArrayMap;
import org.checkerframework.errorprone.org.plumelib.util.ArraySet;
import org.checkerframework.errorprone.org.plumelib.util.CollectionsPlume;

public class ExceptionBlockImpl
extends SingleSuccessorBlockImpl
implements ExceptionBlock {
    protected @Nullable Node node;
    protected final Map<TypeMirror, Set<Block>> exceptionalSuccessors = new ArrayMap<TypeMirror, Set<Block>>(2);

    public ExceptionBlockImpl() {
        super(Block.BlockType.EXCEPTION_BLOCK);
    }

    public void setNode(Node c) {
        this.node = c;
        c.setBlock(this);
    }

    @Override
    public Node getNode() {
        if (this.node == null) {
            throw new BugInCF("Requested node for exception block before initialization");
        }
        return this.node;
    }

    @Override
    public List<Node> getNodes() {
        return Collections.singletonList(this.getNode());
    }

    @Override
    public @Nullable Node getLastNode() {
        return null;
    }

    public void addExceptionalSuccessor(BlockImpl b, TypeMirror cause) {
        Set blocks = this.exceptionalSuccessors.computeIfAbsent(cause, __ -> new ArraySet(2));
        blocks.add(b);
        b.addPredecessor(this);
    }

    @Override
    public Map<TypeMirror, Set<Block>> getExceptionalSuccessors() {
        if (this.exceptionalSuccessors == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.exceptionalSuccessors);
    }

    @Override
    public List<Block> getSuccessors() {
        ArrayList<Block> result = new ArrayList<Block>(super.getSuccessors());
        for (Set<Block> blocks : this.getExceptionalSuccessors().values()) {
            CollectionsPlume.adjoinAll(result, blocks);
        }
        return result;
    }

    public String toString() {
        return "ExceptionBlock(" + this.node + ")";
    }
}

