/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.javacutil;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.TreeSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.errorprone.checker.interning.qual.CompareToMethod;
import org.checkerframework.errorprone.checker.interning.qual.EqualsMethod;
import org.checkerframework.errorprone.checker.interning.qual.Interned;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.checker.signature.qual.BinaryName;
import org.checkerframework.errorprone.checker.signature.qual.CanonicalName;
import org.checkerframework.errorprone.javacutil.AnnotationBuilder;
import org.checkerframework.errorprone.javacutil.AnnotationMirrorSet;
import org.checkerframework.errorprone.javacutil.BugInCF;
import org.checkerframework.errorprone.javacutil.DefaultAnnotationFormatter;
import org.checkerframework.errorprone.javacutil.ElementUtils;
import org.checkerframework.errorprone.javacutil.TreeUtils;
import org.checkerframework.errorprone.javacutil.TypesUtils;
import org.checkerframework.errorprone.org.plumelib.util.ArrayMap;
import org.checkerframework.errorprone.org.plumelib.util.CollectionsPlume;

public class AnnotationUtils {
    private AnnotationUtils() {
        throw new AssertionError((Object)"Class AnnotationUtils cannot be instantiated.");
    }

    public static final @CanonicalName String annotationName(AnnotationMirror annotation) {
        if (annotation instanceof AnnotationBuilder.CheckerFrameworkAnnotationMirror) {
            return ((AnnotationBuilder.CheckerFrameworkAnnotationMirror)annotation).annotationName;
        }
        DeclaredType annoType = annotation.getAnnotationType();
        TypeElement elm = (TypeElement)annoType.asElement();
        @CanonicalName String name = elm.getQualifiedName().toString();
        return name;
    }

    public static final @BinaryName String annotationBinaryName(AnnotationMirror annotation) {
        DeclaredType annoType = annotation.getAnnotationType();
        TypeElement elm = (TypeElement)annoType.asElement();
        return ElementUtils.getBinaryName(elm);
    }

    @EqualsMethod
    public static boolean areSame(AnnotationMirror a1, AnnotationMirror a2) {
        if (a1 == a2) {
            return true;
        }
        if (!AnnotationUtils.areSameByName(a1, a2)) {
            return false;
        }
        return AnnotationUtils.sameElementValues(a1, a2);
    }

    @EqualsMethod
    public static int compareByName(AnnotationMirror a1, AnnotationMirror a2) {
        if (a1 == a2) {
            return 0;
        }
        if (a1 == null || a2 == null) {
            throw new BugInCF("Unexpected null argument:  compareByName(%s, %s)", a1, a2);
        }
        if (a1 instanceof AnnotationBuilder.CheckerFrameworkAnnotationMirror && a2 instanceof AnnotationBuilder.CheckerFrameworkAnnotationMirror) {
            @Interned @CanonicalName String name1 = ((AnnotationBuilder.CheckerFrameworkAnnotationMirror)a1).annotationName;
            @Interned @CanonicalName String name2 = ((AnnotationBuilder.CheckerFrameworkAnnotationMirror)a2).annotationName;
            if (name1 == name2) {
                return 0;
            }
            return name1.compareTo(name2);
        }
        return AnnotationUtils.annotationName(a1).compareTo(AnnotationUtils.annotationName(a2));
    }

    @EqualsMethod
    public static boolean areSameByName(AnnotationMirror a1, AnnotationMirror a2) {
        return AnnotationUtils.compareByName(a1, a2) == 0;
    }

    public static boolean areSameByName(AnnotationMirror am, String aname) {
        return aname.equals(AnnotationUtils.annotationName(am));
    }

    @Deprecated
    public static boolean areSameByClass(AnnotationMirror am, Class<? extends Annotation> annoClass) {
        String canonicalName = annoClass.getCanonicalName();
        assert (canonicalName != null) : "@AssumeAssertion(nullness): assumption";
        return AnnotationUtils.areSameByName(am, canonicalName);
    }

    public static boolean areSame(Collection<? extends AnnotationMirror> c1, Collection<? extends AnnotationMirror> c2) {
        if (c1.size() != c2.size()) {
            return false;
        }
        if (c1.size() == 1) {
            return AnnotationUtils.areSame(c1.iterator().next(), c2.iterator().next());
        }
        AnnotationMirrorSet s1 = new AnnotationMirrorSet();
        AnnotationMirrorSet s2 = new AnnotationMirrorSet();
        s1.addAll(c1);
        s2.addAll(c2);
        Iterator<AnnotationMirror> iter1 = s1.iterator();
        Iterator<AnnotationMirror> iter2 = s2.iterator();
        while (iter1.hasNext()) {
            AnnotationMirror anno2;
            AnnotationMirror anno1 = iter1.next();
            if (AnnotationUtils.areSame(anno1, anno2 = iter2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsSame(Collection<? extends AnnotationMirror> c, AnnotationMirror anno) {
        return AnnotationUtils.getSame(c, anno) != null;
    }

    public static @Nullable AnnotationMirror getSame(Collection<? extends AnnotationMirror> c, AnnotationMirror anno) {
        for (AnnotationMirror annotationMirror : c) {
            if (!AnnotationUtils.areSame(annotationMirror, anno)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean containsSameByClass(Collection<? extends AnnotationMirror> c, Class<? extends Annotation> anno) {
        return AnnotationUtils.getAnnotationByClass(c, anno) != null;
    }

    public static @Nullable AnnotationMirror getAnnotationByClass(Collection<? extends AnnotationMirror> c, Class<? extends Annotation> anno) {
        for (AnnotationMirror annotationMirror : c) {
            if (!AnnotationUtils.areSameByClass(annotationMirror, anno)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean containsSameByName(Collection<? extends AnnotationMirror> c, String anno) {
        return AnnotationUtils.getAnnotationByName(c, anno) != null;
    }

    public static @Nullable AnnotationMirror getAnnotationByName(Collection<? extends AnnotationMirror> c, String anno) {
        for (AnnotationMirror annotationMirror : c) {
            if (!AnnotationUtils.areSameByName(annotationMirror, anno)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean containsSameByName(Collection<? extends AnnotationMirror> c, AnnotationMirror anno) {
        return AnnotationUtils.getSameByName(c, anno) != null;
    }

    public static @Nullable AnnotationMirror getSameByName(Collection<? extends AnnotationMirror> c, AnnotationMirror anno) {
        for (AnnotationMirror annotationMirror : c) {
            if (!AnnotationUtils.areSameByName(annotationMirror, anno)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static int compareAnnotationMirrors(AnnotationMirror a1, AnnotationMirror a2) {
        int nameComparison = AnnotationUtils.compareByName(a1, a2);
        if (nameComparison != 0) {
            return nameComparison;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> vals1 = a1.getElementValues();
        Map<? extends ExecutableElement, ? extends AnnotationValue> vals2 = a2.getElementValues();
        TreeSet<ExecutableElement> sortedElements = new TreeSet<ExecutableElement>(Comparator.comparing(ElementUtils::getSimpleSignature));
        sortedElements.addAll(ElementFilter.methodsIn(a1.getAnnotationType().asElement().getEnclosedElements()));
        for (ExecutableElement meth : sortedElements) {
            int result;
            AnnotationValue aval2;
            AnnotationValue aval1 = vals1.get(meth);
            if (aval1 == null) {
                aval1 = meth.getDefaultValue();
            }
            if ((aval2 = vals2.get(meth)) == null) {
                aval2 = meth.getDefaultValue();
            }
            if ((result = AnnotationUtils.compareAnnotationValue(aval1, aval2)) == 0) continue;
            return result;
        }
        return 0;
    }

    @CompareToMethod
    private static int compareAnnotationValue(AnnotationValue av1, AnnotationValue av2) {
        if (av1 == av2) {
            return 0;
        }
        if (av1 == null) {
            return -1;
        }
        if (av2 == null) {
            return 1;
        }
        return AnnotationUtils.compareAnnotationValueValue(av1.getValue(), av2.getValue());
    }

    @CompareToMethod
    private static int compareAnnotationValueValue(@Nullable Object val1, @Nullable Object val2) {
        if (val1 == val2) {
            return 0;
        }
        if (val1 == null) {
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        if (val1 instanceof List && val2 instanceof List) {
            List list1 = (List)val1;
            List list2 = (List)val2;
            if (list1.size() != list2.size()) {
                return list1.size() - list2.size();
            }
            for (int i = 0; i < list1.size(); ++i) {
                Object v2;
                Object v1 = list1.get(i);
                int result = AnnotationUtils.compareAnnotationValueValue(v1, v2 = list2.get(i));
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
        if (val1 instanceof AnnotationMirror && val2 instanceof AnnotationMirror) {
            return AnnotationUtils.compareAnnotationMirrors((AnnotationMirror)val1, (AnnotationMirror)val2);
        }
        if (val1 instanceof AnnotationValue && val2 instanceof AnnotationValue) {
            return AnnotationUtils.compareAnnotationValue((AnnotationValue)val1, (AnnotationValue)val2);
        }
        if (val1 instanceof Type.ClassType && val2 instanceof Type.ClassType && TypesUtils.areSameDeclaredTypes((Type.ClassType)val1, (Type.ClassType)val2)) {
            return 0;
        }
        if (Objects.equals(val1, val2)) {
            return 0;
        }
        int result = val1.toString().compareTo(val2.toString());
        if (result == 0) {
            result = -1;
        }
        return result;
    }

    public static boolean hasInheritedMeta(AnnotationMirror anno) {
        return anno.getAnnotationType().asElement().getAnnotation(Inherited.class) != null;
    }

    public static EnumSet<ElementKind> getElementKindsForTarget(@Nullable Target target) {
        if (target == null) {
            return EnumSet.allOf(ElementKind.class);
        }
        EnumSet<ElementKind> eleKinds = EnumSet.noneOf(ElementKind.class);
        for (ElementType elementType : target.value()) {
            eleKinds.addAll(AnnotationUtils.getElementKindsForElementType(elementType));
        }
        return eleKinds;
    }

    public static EnumSet<ElementKind> getElementKindsForElementType(ElementType elementType) {
        switch (elementType) {
            case TYPE: {
                return EnumSet.copyOf(ElementUtils.typeElementKinds());
            }
            case FIELD: {
                return EnumSet.of(ElementKind.FIELD, ElementKind.ENUM_CONSTANT);
            }
            case METHOD: {
                return EnumSet.of(ElementKind.METHOD);
            }
            case PARAMETER: {
                return EnumSet.of(ElementKind.PARAMETER);
            }
            case CONSTRUCTOR: {
                return EnumSet.of(ElementKind.CONSTRUCTOR);
            }
            case LOCAL_VARIABLE: {
                return EnumSet.of(ElementKind.LOCAL_VARIABLE, ElementKind.RESOURCE_VARIABLE, ElementKind.EXCEPTION_PARAMETER);
            }
            case ANNOTATION_TYPE: {
                return EnumSet.of(ElementKind.ANNOTATION_TYPE);
            }
            case PACKAGE: {
                return EnumSet.of(ElementKind.PACKAGE);
            }
            case TYPE_PARAMETER: {
                return EnumSet.of(ElementKind.TYPE_PARAMETER);
            }
            case TYPE_USE: {
                return EnumSet.noneOf(ElementKind.class);
            }
        }
        if (elementType.name().equals("MODULE")) {
            return EnumSet.of(ElementKind.valueOf("MODULE"));
        }
        if (elementType.name().equals("RECORD_COMPONENT")) {
            return EnumSet.of(ElementKind.valueOf("RECORD_COMPONENT"));
        }
        throw new BugInCF("Unrecognized ElementType: " + (Object)((Object)elementType));
    }

    @Deprecated
    public static Map<? extends ExecutableElement, ? extends AnnotationValue> getElementValuesWithDefaults(AnnotationMirror ad) {
        ArrayMap<? extends ExecutableElement, ? extends AnnotationValue> valMap = new ArrayMap<ExecutableElement, AnnotationValue>(0);
        if (ad.getElementValues() != null) {
            valMap.putAll(ad.getElementValues());
        }
        for (ExecutableElement meth : ElementFilter.methodsIn(ad.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue defaultValue = meth.getDefaultValue();
            if (defaultValue == null) continue;
            valMap.putIfAbsent(meth, defaultValue);
        }
        return valMap;
    }

    @Deprecated
    public static boolean hasElementValue(AnnotationMirror anno, CharSequence elementName) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> valmap = anno.getElementValues();
        for (ExecutableElement executableElement : valmap.keySet()) {
            if (!executableElement.getSimpleName().contentEquals(elementName)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static <T> T getElementValue(AnnotationMirror anno, CharSequence elementName, Class<T> expectedType, boolean useDefaults) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> valmap;
        if (useDefaults) {
            Map<? extends ExecutableElement, ? extends AnnotationValue> valmapTmp = AnnotationUtils.getElementValuesWithDefaults(anno);
            valmap = valmapTmp;
        } else {
            valmap = anno.getElementValues();
        }
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : valmap.entrySet()) {
            ExecutableElement elem = entry.getKey();
            if (!elem.getSimpleName().contentEquals(elementName)) continue;
            AnnotationValue val = entry.getValue();
            try {
                return expectedType.cast(val.getValue());
            }
            catch (ClassCastException e) {
                throw new BugInCF("getElementValue(%s, %s, %s, %s): val=%s, val.getValue()=%s [%s]", anno, elementName, expectedType, useDefaults, val, val.getValue(), val.getValue().getClass());
            }
        }
        throw new NoSuchElementException(String.format("No element with name '%s' in annotation %s; useDefaults=%s, valmap.keySet()=%s", elementName, anno, useDefaults, valmap.keySet()));
    }

    public static <T> @Nullable T getElementValueOrNull(AnnotationMirror anno, CharSequence elementName, Class<T> expectedType, boolean useDefaults) {
        try {
            return AnnotationUtils.getElementValue(anno, elementName, expectedType, useDefaults);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public static <T> @Nullable List<T> getElementValueArrayOrNull(AnnotationMirror anno, CharSequence elementName, Class<T> expectedType, boolean useDefaults) {
        try {
            return AnnotationUtils.getElementValueArray(anno, elementName, expectedType, useDefaults);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Deprecated
    public static <T extends Enum<T>> T getElementValueEnum(AnnotationMirror anno, CharSequence elementName, Class<T> expectedType, boolean useDefaults) {
        Symbol.VarSymbol vs = AnnotationUtils.getElementValue(anno, elementName, Symbol.VarSymbol.class, useDefaults);
        T value = Enum.valueOf(expectedType, ((Name)vs.getSimpleName()).toString());
        return value;
    }

    @Deprecated
    public static <T> List<T> getElementValueArray(AnnotationMirror anno, CharSequence elementName, Class<T> expectedType, boolean useDefaults) {
        List la = AnnotationUtils.getElementValue(anno, elementName, List.class, useDefaults);
        ArrayList<T> result = new ArrayList<T>(la.size());
        for (AnnotationValue a : la) {
            try {
                result.add(expectedType.cast(a.getValue()));
            }
            catch (Throwable t2) {
                String err1 = String.format("getElementValueArray(%n  anno=%s,%n  elementName=%s,%n  expectedType=%s,%n  useDefaults=%s)%n", anno, elementName, expectedType, useDefaults);
                String err2 = String.format("Error in cast:%n  expectedType=%s%n  a=%s [%s]%n  a.getValue()=%s [%s]", expectedType, a, a.getClass(), a.getValue(), a.getValue().getClass());
                throw new BugInCF(err1 + "; " + err2, t2);
            }
        }
        return result;
    }

    @Deprecated
    public static <T extends Enum<T>> T[] getElementValueEnumArray(AnnotationMirror anno, CharSequence elementName, Class<T> expectedType, boolean useDefaults) {
        List la = AnnotationUtils.getElementValue(anno, elementName, List.class, useDefaults);
        return AnnotationUtils.annotationValueListToEnumArray((List)la, expectedType);
    }

    @Deprecated
    public static @CanonicalName javax.lang.model.element.Name getElementValueClassName(AnnotationMirror anno, CharSequence elementName, boolean useDefaults) {
        Type.ClassType ct = AnnotationUtils.getElementValue(anno, elementName, Type.ClassType.class, useDefaults);
        @CanonicalName Name result = ((Symbol)ct.asElement()).getQualifiedName();
        return result;
    }

    @Deprecated
    public static List<@CanonicalName javax.lang.model.element.Name> getElementValueClassNames(AnnotationMirror anno, CharSequence annoElement, boolean useDefaults) {
        List<Type.ClassType> la = AnnotationUtils.getElementValueArray(anno, annoElement, Type.ClassType.class, useDefaults);
        return CollectionsPlume.mapList(classType -> ((Symbol)classType.asElement()).getQualifiedName(), la);
    }

    public static <T> @Nullable T getElementValue(AnnotationMirror anno, ExecutableElement element, Class<T> expectedType) {
        AnnotationValue av = anno.getElementValues().get(element);
        if (av == null) {
            throw new BugInCF("getElementValue(%s, %s, ...)", anno, element);
        }
        return expectedType.cast(av.getValue());
    }

    public static <T> @Nullable T getElementValue(AnnotationMirror anno, ExecutableElement element, Class<T> expectedType, T defaultValue) {
        AnnotationValue av = anno.getElementValues().get(element);
        if (av == null) {
            return defaultValue;
        }
        return expectedType.cast(av.getValue());
    }

    public static boolean getElementValueBoolean(AnnotationMirror anno, ExecutableElement element, boolean defaultValue) {
        AnnotationValue av = anno.getElementValues().get(element);
        if (av == null) {
            return defaultValue;
        }
        return (Boolean)av.getValue();
    }

    public static int getElementValueInt(AnnotationMirror anno, ExecutableElement element) {
        AnnotationValue av = anno.getElementValues().get(element);
        if (av == null) {
            throw new BugInCF("getElementValueInt(%s, %s, ...)", anno, element);
        }
        return (Integer)av.getValue();
    }

    public static int getElementValueInt(AnnotationMirror anno, ExecutableElement element, int defaultValue) {
        AnnotationValue av = anno.getElementValues().get(element);
        if (av == null) {
            return defaultValue;
        }
        return (Integer)av.getValue();
    }

    public static long getElementValueLong(AnnotationMirror anno, ExecutableElement element, long defaultValue) {
        AnnotationValue av = anno.getElementValues().get(element);
        if (av == null) {
            return defaultValue;
        }
        return (Long)av.getValue();
    }

    public static <T extends Enum<T>> T getElementValueEnum(AnnotationMirror anno, ExecutableElement element, Class<T> expectedType) {
        AnnotationValue av = anno.getElementValues().get(element);
        if (av == null) {
            throw new BugInCF("getElementValueEnum(%s, %s, ...)", anno, element);
        }
        VariableElement ve = (VariableElement)av.getValue();
        return Enum.valueOf(expectedType, ve.getSimpleName().toString());
    }

    public static <T extends Enum<T>> T getElementValueEnum(AnnotationMirror anno, ExecutableElement element, Class<T> expectedType, T defaultValue) {
        AnnotationValue av = anno.getElementValues().get(element);
        if (av == null) {
            return defaultValue;
        }
        VariableElement ve = (VariableElement)av.getValue();
        return Enum.valueOf(expectedType, ve.getSimpleName().toString());
    }

    public static <T extends Enum<T>> T[] getElementValueEnumArray(AnnotationMirror anno, ExecutableElement element, Class<T> expectedType) {
        AnnotationValue av = anno.getElementValues().get(element);
        if (av == null) {
            throw new BugInCF("getElementValueEnumArray(%s, %s, ...)", anno, element);
        }
        return AnnotationUtils.annotationValueListToEnumArray((AnnotationValue)av, expectedType);
    }

    public static <T extends Enum<T>> T[] getElementValueEnumArray(AnnotationMirror anno, ExecutableElement element, Class<T> expectedType, T[] defaultValue) {
        AnnotationValue av = anno.getElementValues().get(element);
        if (av == null) {
            return defaultValue;
        }
        return AnnotationUtils.annotationValueListToEnumArray((AnnotationValue)av, expectedType);
    }

    public static <T> List<T> getElementValueArray(AnnotationMirror anno, ExecutableElement element, Class<T> expectedType) {
        AnnotationValue av = anno.getElementValues().get(element);
        if (av == null) {
            throw new BugInCF("getElementValueArray(%s, %s, ...)", anno, element);
        }
        return AnnotationUtils.annotationValueToList(av, expectedType);
    }

    public static <T> List<T> getElementValueArray(AnnotationMirror anno, ExecutableElement element, Class<T> expectedType, List<T> defaultValue) {
        AnnotationValue av = anno.getElementValues().get(element);
        if (av == null) {
            return defaultValue;
        }
        return AnnotationUtils.annotationValueToList(av, expectedType);
    }

    public static <T extends Enum<T>> T[] annotationValueListToEnumArray(AnnotationValue avList, Class<T> expectedType) {
        List list = (List)avList.getValue();
        return AnnotationUtils.annotationValueListToEnumArray((List)list, expectedType);
    }

    public static <T extends Enum<T>> T[] annotationValueListToEnumArray(List<AnnotationValue> la, Class<T> expectedType) {
        int size = la.size();
        Enum[] result = (Enum[])Array.newInstance(expectedType, size);
        for (int i = 0; i < size; ++i) {
            AnnotationValue a = la.get(i);
            T value = Enum.valueOf(expectedType, a.getValue().toString());
            result[i] = value;
        }
        return result;
    }

    public static @CanonicalName javax.lang.model.element.Name getElementValueClassName(AnnotationMirror anno, ExecutableElement element) {
        Type.ClassType ct = AnnotationUtils.getElementValue(anno, element, Type.ClassType.class);
        if (ct == null) {
            throw new BugInCF("getElementValueClassName(%s, %s, ...)", anno, element);
        }
        @CanonicalName Name result = ((Symbol)ct.asElement()).getQualifiedName();
        return result;
    }

    public static List<@CanonicalName javax.lang.model.element.Name> getElementValueClassNames(AnnotationMirror anno, ExecutableElement element) {
        List<Type.ClassType> la = AnnotationUtils.getElementValueArray(anno, element, Type.ClassType.class);
        return CollectionsPlume.mapList(classType -> ((Symbol)classType.asElement()).getQualifiedName(), la);
    }

    @EqualsMethod
    public static boolean sameElementValues(AnnotationMirror am1, AnnotationMirror am2) {
        if (am1 == am2) {
            return true;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> vals1 = am1.getElementValues();
        Map<? extends ExecutableElement, ? extends AnnotationValue> vals2 = am2.getElementValues();
        for (ExecutableElement meth : ElementFilter.methodsIn(am1.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue aval2;
            AnnotationValue aval1 = vals1.get(meth);
            boolean identical = aval1 == (aval2 = vals2.get(meth));
            if (identical) continue;
            if (aval1 == null) {
                aval1 = meth.getDefaultValue();
            }
            if (aval2 == null) {
                aval2 = meth.getDefaultValue();
            }
            if (AnnotationUtils.sameAnnotationValue(aval1, aval2)) continue;
            return false;
        }
        return true;
    }

    public static boolean sameAnnotationValue(AnnotationValue av1, AnnotationValue av2) {
        return AnnotationUtils.compareAnnotationValue(av1, av2) == 0;
    }

    public static boolean annotationValueContains(@Nullable AnnotationValue avList, String s2) {
        if (avList == null) {
            return false;
        }
        List list = (List)avList.getValue();
        return AnnotationUtils.annotationValueContains(list, s2);
    }

    public static boolean annotationValueContains(List<? extends AnnotationValue> avList, String s2) {
        for (AnnotationValue annotationValue : avList) {
            if (!annotationValue.getValue().equals(s2)) continue;
            return true;
        }
        return false;
    }

    public static boolean annotationValueContainsToString(@Nullable AnnotationValue avList, String s2) {
        if (avList == null) {
            return false;
        }
        List list = (List)avList.getValue();
        return AnnotationUtils.annotationValueContainsToString(list, s2);
    }

    public static boolean annotationValueContainsToString(List<? extends AnnotationValue> avList, String s2) {
        for (AnnotationValue annotationValue : avList) {
            if (!annotationValue.getValue().toString().equals(s2)) continue;
            return true;
        }
        return false;
    }

    public static <T> List<T> annotationValueToList(AnnotationValue avList, Class<T> expectedType) {
        List list = (List)avList.getValue();
        return AnnotationUtils.annotationValueToList(list, expectedType);
    }

    public static <T> List<T> annotationValueToList(List<? extends AnnotationValue> avList, Class<T> expectedType) {
        ArrayList<T> result = new ArrayList<T>(avList.size());
        for (AnnotationValue annotationValue : avList) {
            try {
                result.add(expectedType.cast(annotationValue.getValue()));
            }
            catch (Throwable t2) {
                String err1 = String.format("annotationValueToList(%s, %s)", avList, expectedType);
                String err2 = String.format("a=%s [%s]%n  a.getValue()=%s [%s]", annotationValue, annotationValue.getClass(), annotationValue.getValue(), annotationValue.getValue().getClass());
                throw new BugInCF(err1 + " " + err2, t2);
            }
        }
        return result;
    }

    public static <T> void updateMappingToImmutableSet(Map<T, AnnotationMirrorSet> map, T key, AnnotationMirrorSet newQual) {
        AnnotationMirrorSet result = new AnnotationMirrorSet();
        if (!map.containsKey(key)) {
            result.addAll(newQual);
        } else {
            result.addAll(map.get(key));
            result.addAll(newQual);
        }
        result.makeUnmodifiable();
        map.put(key, result);
    }

    public static AnnotationMirrorSet getExplicitAnnotationsOnConstructorResult(MethodTree constructorDeclaration) {
        AnnotationMirrorSet annotationSet = new AnnotationMirrorSet();
        ModifiersTree modifiersTree = constructorDeclaration.getModifiers();
        if (modifiersTree != null) {
            List<? extends AnnotationTree> annotationTrees = modifiersTree.getAnnotations();
            annotationSet.addAll((Collection<? extends AnnotationMirror>)TreeUtils.annotationsFromTypeAnnotationTrees(annotationTrees));
        }
        return annotationSet;
    }

    public static boolean isDeclarationAnnotation(AnnotationMirror anno) {
        TypeElement elem = (TypeElement)anno.getAnnotationType().asElement();
        Target t2 = elem.getAnnotation(Target.class);
        if (t2 == null) {
            return true;
        }
        for (ElementType elementType : t2.value()) {
            if (elementType != ElementType.TYPE_USE) continue;
            return false;
        }
        return true;
    }

    public static boolean hasTypeQualifierElementTypes(ElementType[] elements, Class<?> cls) {
        boolean hasTypeUse = false;
        ElementType otherElementType = null;
        for (ElementType element : elements) {
            if (element == ElementType.TYPE_USE) {
                hasTypeUse = true;
            } else if (element != ElementType.TYPE_PARAMETER) {
                otherElementType = element;
            }
            if (!hasTypeUse || otherElementType == null) continue;
            throw new BugInCF("@Target meta-annotation should not contain both TYPE_USE and " + (Object)((Object)otherElementType) + ", for annotation " + cls.getName());
        }
        return hasTypeUse;
    }

    @SideEffectFree
    public static String toStringSimple(AnnotationMirrorSet annos) {
        DefaultAnnotationFormatter defaultAnnotationFormatter = new DefaultAnnotationFormatter();
        StringJoiner result = new StringJoiner(" ");
        for (AnnotationMirror am : annos) {
            result.add(defaultAnnotationFormatter.formatAnnotationMirror(am));
        }
        return result.toString();
    }

    public static Class<?> annotationMirrorToClass(AnnotationMirror am) {
        try {
            return Class.forName(AnnotationUtils.annotationBinaryName(am));
        }
        catch (ClassNotFoundException e) {
            throw new BugInCF(e);
        }
    }

    private static class NoSuchElementException
    extends BugInCF {
        @Pure
        public NoSuchElementException(String message) {
            super(message);
        }
    }
}

