/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.CaseTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.plumelib.util.StringsPlume;

public class CaseNode
extends Node {
    protected final CaseTree tree;
    protected final Node switchExpr;
    protected final List<Node> caseExprs;

    public CaseNode(CaseTree tree, Node switchExpr, List<Node> caseExprs, Types types) {
        super(types.getNoType(TypeKind.NONE));
        assert (tree.getKind() == Tree.Kind.CASE);
        this.tree = tree;
        this.switchExpr = switchExpr;
        this.caseExprs = caseExprs;
    }

    public Node getSwitchOperand() {
        return this.switchExpr;
    }

    public List<Node> getCaseOperands() {
        return this.caseExprs;
    }

    @Override
    public CaseTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitCase(this, p);
    }

    public String toString() {
        return "case " + StringsPlume.join((CharSequence)", ", this.getCaseOperands()) + ":";
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof CaseNode)) {
            return false;
        }
        CaseNode other = (CaseNode)obj;
        return this.getSwitchOperand().equals(other.getSwitchOperand()) && this.getCaseOperands().equals(other.getCaseOperands());
    }

    public int hashCode() {
        return Objects.hash(this.getSwitchOperand(), this.getCaseOperands());
    }

    @Override
    public Collection<Node> getOperands() {
        ArrayList<Node> operands = new ArrayList<Node>();
        operands.add(this.getSwitchOperand());
        operands.addAll(this.getCaseOperands());
        return operands;
    }
}

