/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.expression;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.dataflow.expression.ArrayAccess;
import org.checkerframework.dataflow.expression.ArrayCreation;
import org.checkerframework.dataflow.expression.BinaryOperation;
import org.checkerframework.dataflow.expression.ClassName;
import org.checkerframework.dataflow.expression.FieldAccess;
import org.checkerframework.dataflow.expression.FormalParameter;
import org.checkerframework.dataflow.expression.JavaExpression;
import org.checkerframework.dataflow.expression.JavaExpressionVisitor;
import org.checkerframework.dataflow.expression.LocalVariable;
import org.checkerframework.dataflow.expression.MethodCall;
import org.checkerframework.dataflow.expression.ThisReference;
import org.checkerframework.dataflow.expression.UnaryOperation;
import org.checkerframework.dataflow.expression.Unknown;
import org.checkerframework.dataflow.expression.ValueLiteral;
import org.plumelib.util.CollectionsPlume;

public abstract class JavaExpressionConverter
extends JavaExpressionVisitor<JavaExpression, Void> {
    public JavaExpression convert(JavaExpression javaExpr) {
        return (JavaExpression)super.visit(javaExpr, null);
    }

    public List<@PolyNull JavaExpression> convert(List<@PolyNull JavaExpression> list) {
        return CollectionsPlume.mapList(expression -> {
            if (expression == null) {
                return null;
            }
            return this.convert((JavaExpression)expression);
        }, list);
    }

    @Override
    protected JavaExpression visitArrayAccess(ArrayAccess arrayAccessExpr, Void unused) {
        JavaExpression array = this.convert(arrayAccessExpr.getArray());
        JavaExpression index = this.convert(arrayAccessExpr.getIndex());
        return new ArrayAccess(arrayAccessExpr.type, array, index);
    }

    @Override
    protected JavaExpression visitArrayCreation(ArrayCreation arrayCreationExpr, Void unused) {
        List<@Nullable JavaExpression> dims = this.convert(arrayCreationExpr.getDimensions());
        List<JavaExpression> inits = this.convert(arrayCreationExpr.getInitializers());
        return new ArrayCreation(arrayCreationExpr.getType(), dims, inits);
    }

    @Override
    protected JavaExpression visitBinaryOperation(BinaryOperation binaryOpExpr, Void unused) {
        JavaExpression left = this.convert(binaryOpExpr.getLeft());
        JavaExpression right = this.convert(binaryOpExpr.getRight());
        return new BinaryOperation(binaryOpExpr.getType(), binaryOpExpr.getOperationKind(), left, right);
    }

    @Override
    protected JavaExpression visitClassName(ClassName classNameExpr, Void unused) {
        return classNameExpr;
    }

    @Override
    protected JavaExpression visitFieldAccess(FieldAccess fieldAccessExpr, Void unused) {
        JavaExpression receiver = this.convert(fieldAccessExpr.getReceiver());
        return new FieldAccess(receiver, fieldAccessExpr.getType(), fieldAccessExpr.getField());
    }

    @Override
    protected JavaExpression visitFormalParameter(FormalParameter parameterExpr, Void unused) {
        return parameterExpr;
    }

    @Override
    protected JavaExpression visitLocalVariable(LocalVariable localVarExpr, Void unused) {
        return localVarExpr;
    }

    @Override
    protected JavaExpression visitMethodCall(MethodCall methodCallExpr, Void unused) {
        JavaExpression receiver = this.convert(methodCallExpr.getReceiver());
        List<JavaExpression> args = this.convert(methodCallExpr.getArguments());
        return new MethodCall(methodCallExpr.getType(), methodCallExpr.getElement(), receiver, args);
    }

    @Override
    protected JavaExpression visitThisReference(ThisReference thisExpr, Void unused) {
        return thisExpr;
    }

    @Override
    protected JavaExpression visitUnaryOperation(UnaryOperation unaryOpExpr, Void unused) {
        JavaExpression operand = this.convert(unaryOpExpr.getOperand());
        return new UnaryOperation(unaryOpExpr.getType(), unaryOpExpr.getOperationKind(), operand);
    }

    @Override
    protected JavaExpression visitUnknown(Unknown unknownExpr, Void unused) {
        return unknownExpr;
    }

    @Override
    protected JavaExpression visitValueLiteral(ValueLiteral literalExpr, Void unused) {
        return literalExpr;
    }
}

