/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.cfg.node.MethodAccessNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.javacutil.TreeUtils;
import org.plumelib.util.StringsPlume;

public class MethodInvocationNode
extends Node {
    protected final @Nullable MethodInvocationTree tree;
    protected final MethodAccessNode target;
    protected final List<Node> arguments;
    protected final TreePath treePath;
    protected @Nullable ExpressionTree iterableExpression;

    public MethodInvocationNode(@Nullable MethodInvocationTree tree, MethodAccessNode target, List<Node> arguments, TreePath treePath) {
        super(tree != null ? TreeUtils.typeOf((Tree)tree) : target.getMethod().getReturnType());
        this.tree = tree;
        this.target = target;
        this.arguments = arguments;
        this.treePath = treePath;
    }

    public MethodInvocationNode(MethodAccessNode target, List<Node> arguments, TreePath treePath) {
        this(null, target, arguments, treePath);
    }

    public MethodAccessNode getTarget() {
        return this.target;
    }

    public List<Node> getArguments() {
        return this.arguments;
    }

    public Node getArgument(int i) {
        return this.arguments.get(i);
    }

    public TreePath getTreePath() {
        return this.treePath;
    }

    public @Nullable ExpressionTree getIterableExpression() {
        return this.iterableExpression;
    }

    public void setIterableExpression(@Nullable ExpressionTree iterableExpression) {
        this.iterableExpression = iterableExpression;
    }

    @Override
    public @Nullable MethodInvocationTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitMethodInvocation(this, p);
    }

    public String toString() {
        return this.target + "(" + StringsPlume.join((CharSequence)", ", this.arguments) + ")";
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof MethodInvocationNode)) {
            return false;
        }
        MethodInvocationNode other = (MethodInvocationNode)obj;
        return this.getTarget().equals(other.getTarget()) && this.getArguments().equals(other.getArguments());
    }

    public int hashCode() {
        return Objects.hash(this.target, this.arguments);
    }

    @Override
    @SideEffectFree
    public Collection<Node> getOperands() {
        ArrayList<Node> list = new ArrayList<Node>(1 + this.arguments.size());
        list.add(this.target);
        list.addAll(this.arguments);
        return list;
    }
}

