/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferFunction;
import org.checkerframework.dataflow.cfg.AbstractCFGVisualizer;
import org.checkerframework.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.dataflow.cfg.block.Block;
import org.checkerframework.dataflow.cfg.block.ConditionalBlock;
import org.checkerframework.dataflow.cfg.block.SpecialBlock;

public class StringCFGVisualizer<V extends AbstractValue<V>, S extends Store<S>, T extends TransferFunction<V, S>>
extends AbstractCFGVisualizer<V, S, T> {
    @Override
    public Map<String, Object> visualize(ControlFlowGraph cfg, Block entry, @Nullable Analysis<V, S, T> analysis) {
        String stringGraph = this.visualizeGraph(cfg, entry, analysis);
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("stringGraph", stringGraph);
        return res;
    }

    @Override
    public String visualizeNodes(Set<Block> blocks, ControlFlowGraph cfg, @Nullable Analysis<V, S, T> analysis) {
        StringJoiner sjStringNodes = new StringJoiner(this.lineSeparator, this.lineSeparator, "");
        IdentityHashMap<Block, List<Integer>> processOrder = this.getProcessOrder(cfg);
        for (Block v : blocks) {
            sjStringNodes.add(v.getId() + ":");
            if (this.verbose) {
                sjStringNodes.add(this.getProcessOrderSimpleString(processOrder.get(v)));
            }
            sjStringNodes.add(this.visualizeBlock(v, analysis));
        }
        String stringNodes = sjStringNodes.toString();
        if (stringNodes.endsWith(this.lineSeparator)) {
            stringNodes = stringNodes.substring(0, stringNodes.length() - this.lineSeparator.length());
        }
        return stringNodes;
    }

    @Override
    protected String addEdge(Object sId, Object eId, String flowRule) {
        if (this.verbose) {
            return sId + " -> " + eId + " " + flowRule + this.lineSeparator;
        }
        return sId + " -> " + eId + this.lineSeparator;
    }

    @Override
    public String visualizeBlock(Block bb, @Nullable Analysis<V, S, T> analysis) {
        return super.visualizeBlockHelper(bb, analysis, this.lineSeparator);
    }

    @Override
    public String visualizeSpecialBlock(SpecialBlock sbb) {
        return super.visualizeSpecialBlockHelper(sbb, this.lineSeparator);
    }

    @Override
    public String visualizeConditionalBlock(ConditionalBlock cbb) {
        return "ConditionalBlock: then: " + cbb.getThenSuccessor().getId() + ", else: " + cbb.getElseSuccessor().getId() + this.lineSeparator;
    }

    @Override
    public String visualizeBlockTransferInputBefore(Block bb, Analysis<V, S, T> analysis) {
        return super.visualizeBlockTransferInputBeforeHelper(bb, analysis, this.lineSeparator);
    }

    @Override
    public String visualizeBlockTransferInputAfter(Block bb, Analysis<V, S, T> analysis) {
        return super.visualizeBlockTransferInputAfterHelper(bb, analysis, this.lineSeparator);
    }

    @Override
    protected String format(Object obj) {
        return obj.toString();
    }

    @Override
    public String visualizeStoreThisVal(V value) {
        return "  this > " + value + this.lineSeparator;
    }

    @Override
    public String visualizeStoreLocalVar(FlowExpressions.LocalVariable localVar, V value) {
        return "  " + localVar + " > " + value + this.lineSeparator;
    }

    @Override
    public String visualizeStoreFieldVals(FlowExpressions.FieldAccess fieldAccess, V value) {
        return "  " + fieldAccess + " > " + value + this.lineSeparator;
    }

    @Override
    public String visualizeStoreArrayVal(FlowExpressions.ArrayAccess arrayValue, V value) {
        return "  " + arrayValue + " > " + value + this.lineSeparator;
    }

    @Override
    public String visualizeStoreMethodVals(FlowExpressions.MethodCall methodCall, V value) {
        return "  " + methodCall + " > " + value + this.lineSeparator;
    }

    @Override
    public String visualizeStoreClassVals(FlowExpressions.ClassName className, V value) {
        return "  " + className + " > " + value + this.lineSeparator;
    }

    @Override
    public String visualizeStoreKeyVal(String keyName, Object value) {
        return "  " + keyName + " = " + value + this.lineSeparator;
    }

    @Override
    public String visualizeStoreHeader(String classCanonicalName) {
        return classCanonicalName + " (" + this.lineSeparator;
    }

    @Override
    public String visualizeStoreFooter() {
        return ")" + this.lineSeparator;
    }

    @Override
    public void shutdown() {
    }

    @Override
    protected String visualizeGraphHeader() {
        return "";
    }

    @Override
    protected String visualizeGraphFooter() {
        return "";
    }
}

