/*
 * Decompiled with CFR 0.152.
 */
package org.chenile.configuration.security;

import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import org.chenile.security.KeycloakConnectionDetails;
import org.chenile.security.interceptor.SecurityInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationManagerResolver;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.oauth2.client.CommonOAuth2Provider;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationProvider;
import org.springframework.security.oauth2.server.resource.authentication.JwtBearerTokenAuthenticationConverter;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
public class SecurityConfiguration {
    @Autowired
    KeycloakConnectionDetails connectionDetails;
    private final Map<String, ClientRegistrationRepository> repositories = new HashMap<String, ClientRegistrationRepository>();
    Map<String, JwtDecoder> jwtDecoderMap = new HashMap<String, JwtDecoder>();

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        http.authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.anyRequest()).authenticated()).oauth2Login(auth -> auth.authorizationEndpoint().authorizationRequestResolver(this.resolver())).oauth2Client(Customizer.withDefaults()).oauth2ResourceServer(oauth2 -> oauth2.authenticationManagerResolver(this.authenticationManagerResolver()));
        return (SecurityFilterChain)http.build();
    }

    private OAuth2AuthorizationRequestResolver resolver() {
        return new OAuth2AuthorizationRequestResolver(){

            public OAuth2AuthorizationRequest resolve(HttpServletRequest request) {
                String tenantId = request.getHeader("x-chenile-tenant-id");
                String authBaseUri = "http://" + SecurityConfiguration.this.connectionDetails.host + ":" + SecurityConfiguration.this.connectionDetails.httpPort + "/realms" + tenantId + "/protocol/openid-connect/auth";
                DefaultOAuth2AuthorizationRequestResolver resolver = new DefaultOAuth2AuthorizationRequestResolver(SecurityConfiguration.this.clientRegistrationRepository(tenantId), authBaseUri);
                return resolver.resolve(request);
            }

            public OAuth2AuthorizationRequest resolve(HttpServletRequest request, String clientRegistrationId) {
                System.out.println("Hi there at the resolve method with clientRegistrationId");
                return null;
            }
        };
    }

    @Bean
    public ClientRegistrationRepository clientRegistrationRepository() {
        InMemoryClientRegistrationRepository repo = new InMemoryClientRegistrationRepository(new ClientRegistration[]{this.client()});
        return repo;
    }

    private ClientRegistrationRepository clientRegistrationRepository(String tenantId) {
        return this.repositories.computeIfAbsent(tenantId, tenant -> new InMemoryClientRegistrationRepository(new ClientRegistration[]{this.client((String)tenant)}));
    }

    @Bean
    public OAuth2AuthorizedClientService authorizedClientService(ClientRegistrationRepository clientRegistrationRepository) {
        return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
    }

    public ClientRegistration client() {
        return this.client(this.connectionDetails.baseRealm);
    }

    @Bean
    public ClientRegistration client(String realm) {
        ClientRegistration.Builder builder = CommonOAuth2Provider.OKTA.getBuilder("authz_servlet");
        builder.clientId("authz-servlet");
        builder.clientSecret("secret");
        builder.issuerUri(this.keycloakBaseUrl(realm));
        builder.authorizationUri(this.keycloakOpenIdUrl(realm) + "auth");
        builder.tokenUri(this.keycloakOpenIdUrl(realm) + "token");
        builder.jwkSetUri(this.keycloakOpenIdUrl(realm) + "certs");
        builder.userInfoUri(this.keycloakOpenIdUrl(realm) + "userinfo");
        builder.scope(new String[]{"openid", "profile", "email"});
        return builder.build();
    }

    private AuthenticationManagerResolver<HttpServletRequest> authenticationManagerResolver() {
        return request -> {
            String tenantId = request.getHeader("x-chenile-tenant-id");
            return this.jwt(tenantId);
        };
    }

    private AuthenticationManager jwt(String tenantId) {
        JwtAuthenticationProvider authenticationProvider = new JwtAuthenticationProvider(this.jwtDecoder(tenantId));
        authenticationProvider.setJwtAuthenticationConverter(this.jwtBearerTokenAuthenticationConverter());
        return new ProviderManager(new AuthenticationProvider[]{authenticationProvider});
    }

    private Converter<Jwt, ? extends AbstractAuthenticationToken> jwtBearerTokenAuthenticationConverter() {
        return new JwtBearerTokenAuthenticationConverter();
    }

    private String keycloakBaseUrl(String realm) {
        return "http://" + this.connectionDetails.host + ":" + this.connectionDetails.httpPort + "/realms/" + realm + "/";
    }

    private String keycloakOpenIdUrl(String realm) {
        return this.keycloakBaseUrl(realm) + "protocol/openid-connect/";
    }

    JwtDecoder jwtDecoder(String tenantId) {
        return this.jwtDecoderMap.computeIfAbsent(tenantId, tenant -> {
            String uri = this.keycloakOpenIdUrl(tenantId) + "certs";
            return NimbusJwtDecoder.withJwkSetUri((String)uri).build();
        });
    }

    @Bean
    public SecurityInterceptor securityInterceptor() {
        return new SecurityInterceptor();
    }
}

