/*
 * Decompiled with CFR 0.152.
 */
package org.chenile.security.interceptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.chenile.base.exception.ErrorNumException;
import org.chenile.core.context.ChenileExchange;
import org.chenile.core.interceptors.BaseChenileInterceptor;
import org.chenile.security.AuthoritiesSupplier;
import org.chenile.security.SecurityConfig;
import org.chenile.security.errorcodes.ErrorCodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;

public class SecurityInterceptor
extends BaseChenileInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(SecurityInterceptor.class);
    @Autowired
    ApplicationContext applicationContext;
    public static final String SCOPE_PREFIX = "SCOPE_";

    protected void doPreProcessing(ChenileExchange exchange) {
        String[] guardingAuthorities = this.getGuardingAuthorities(exchange);
        if (guardingAuthorities == null) {
            return;
        }
        Collection<GrantedAuthority> currentAuthorities = this.getAuthorities();
        logger.debug("Authorities are : {}", currentAuthorities);
        if (currentAuthorities == null) {
            throw new ErrorNumException(HttpStatus.UNAUTHORIZED.value(), ErrorCodes.UNAUTHENTICATED.getSubError(), new Object[0]);
        }
        if (this.guardingAuthoritiesNotFoundInCurrentAuthorities(guardingAuthorities, currentAuthorities)) {
            throw new ErrorNumException(HttpStatus.FORBIDDEN.value(), ErrorCodes.FORBIDDEN.getSubError(), new Object[0]);
        }
    }

    private boolean guardingAuthoritiesNotFoundInCurrentAuthorities(String[] guardingAuthorities, Collection<GrantedAuthority> currentAuthorities) {
        for (GrantedAuthority ca : currentAuthorities) {
            if (!Arrays.stream(guardingAuthorities).anyMatch(ga -> (SCOPE_PREFIX + ga).equalsIgnoreCase(ca.getAuthority()))) continue;
            return false;
        }
        return true;
    }

    private String[] getGuardingAuthorities(ChenileExchange exchange) {
        SecurityConfig config = (SecurityConfig)this.getExtensionByAnnotation(SecurityConfig.class, exchange);
        if (config == null) {
            return null;
        }
        if (config.authorities().length != 0) {
            return config.authorities();
        }
        if (!config.authoritiesSupplier().isEmpty()) {
            Object supplier = this.applicationContext.getBean(config.authoritiesSupplier());
            return this.executeAuthoritiesSupplier(supplier, exchange);
        }
        return null;
    }

    private String[] executeAuthoritiesSupplier(Object obj, ChenileExchange exchange) {
        String[] auths = null;
        if (obj instanceof AuthoritiesSupplier) {
            AuthoritiesSupplier as = (AuthoritiesSupplier)obj;
            auths = as.getAuthorities(exchange);
        }
        if (obj instanceof Function) {
            Function f1;
            Function f2 = f1 = (Function)obj;
            auths = (String[])f2.apply(exchange);
        }
        return auths;
    }

    private Collection<GrantedAuthority> getAuthorities() {
        SecurityContext context = SecurityContextHolder.getContext();
        if (context == null) {
            logger.info("Security Context is empty.");
            return null;
        }
        Authentication authentication = context.getAuthentication();
        if (authentication == null) {
            logger.info("Did not find authentication in security context");
            return null;
        }
        Object principal = authentication.getPrincipal();
        Collection authorities = authentication.getAuthorities();
        ArrayList<GrantedAuthority> auths = new ArrayList<GrantedAuthority>(authorities);
        logger.debug("=============== start of security context holder");
        logger.debug("User name is " + authentication.getName());
        logger.debug("Principal class is " + principal.getClass().getName());
        if (principal instanceof DefaultOidcUser) {
            DefaultOidcUser oidcUser = (DefaultOidcUser)principal;
            auths.addAll(oidcUser.getAuthorities());
        }
        logger.debug("Principal is " + String.valueOf(principal));
        logger.debug("authorities = " + String.valueOf(auths));
        logger.debug("details = " + String.valueOf(authentication.getDetails()));
        logger.debug("credentials = " + String.valueOf(authentication.getCredentials()));
        logger.debug("=============== end of security context holder");
        return auths;
    }

    protected boolean bypassInterception(ChenileExchange exchange) {
        SecurityConfig config = (SecurityConfig)this.getExtensionByAnnotation(SecurityConfig.class, exchange);
        return config == null || config.value() == SecurityConfig.ProtectionStatus.UNPROTECTED;
    }
}

