/*
 * Decompiled with CFR 0.152.
 */
package org.chenile.utils.region;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.chenile.core.context.ChenileExchange;
import org.chenile.core.interceptors.BaseChenileInterceptor;

public class RegionToTrajectoryConverter
extends BaseChenileInterceptor {
    public static final String REGION_HEADER = "x-region";
    public static final String TRAJECTORY_HEADER = "chenile-trajectory-id";
    public static final String ACCEPT_LANG_HEADER = "accept-language";
    private Map<String, Locale> locales = new HashMap<String, Locale>();

    protected void doPreProcessing(ChenileExchange exchange) {
        String acceptLang;
        String regionCode = (String)exchange.getHeader(REGION_HEADER);
        String trajectoryId = (String)exchange.getHeader(TRAJECTORY_HEADER);
        if (regionCode != null && trajectoryId == null) {
            exchange.setHeader(TRAJECTORY_HEADER, (Object)regionCode);
        }
        if ((acceptLang = (String)exchange.getHeader(ACCEPT_LANG_HEADER)) != null) {
            return;
        }
        if (this.locales.get(regionCode) != null) {
            exchange.setLocale(this.locales.get(regionCode));
        }
    }
}

